/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.scrolling;

import com.jme.image.Image;
import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.turborilla.TransformationProvider;
import com.turborilla.Updatable;
import com.turborilla.utils.ImageUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Layer
extends Node
implements Updatable {
    private static final Logger logger = Logger.getLogger(Layer.class.getName());
    private Node mainNode;
    private Node normalNode;
    private Node flippedNode;
    private Node extrasNode;
    private int cols;
    private int rows;
    private int[] colWidths;
    private int[] rowHeights;
    private int totalWidth;
    private int totalHeight;
    private int maxTextureWidth;
    private int maxTextureHeight;
    private int imageWidth;
    private int imageHeight;
    private Quad[] quads;
    private Texture[] textures;
    private TransformationProvider transformationProvider;
    private float transformationFactor;
    private boolean wholePixels;
    private float defaultY = 0.0f;
    private float yTransformationFactor = 0.0f;
    private float yTransformationBias = 0.0f;
    private boolean stretch = false;
    private Wrap wrapMode;
    private DisplaySystem display;
    private ArrayList<Extra> extras;
    private Vector3f thisNodeTranslation;
    private Vector3f normalNodeTranslation;
    private Vector3f flippedNodeTranslation;
    boolean paused = false;

    public Layer(String string, int n, TransformationProvider transformationProvider) {
        this(string, n, n, transformationProvider, true, Wrap.NORMAL, true);
    }

    public Layer(String string, int n, int n2, TransformationProvider transformationProvider, boolean bl, Wrap wrap, boolean bl2) {
        this(string, n, n2, transformationProvider, bl, wrap, bl2, false);
    }

    public Layer(String string, int n, int n2, TransformationProvider transformationProvider, boolean bl, Wrap wrap, boolean bl2, boolean bl3) {
        super(string);
        AlphaState alphaState;
        this.maxTextureWidth = n;
        this.maxTextureHeight = n2;
        this.transformationProvider = transformationProvider;
        this.wrapMode = wrap;
        this.wholePixels = bl2;
        this.stretch = bl3;
        this.normalNode = null;
        this.flippedNode = null;
        this.display = DisplaySystem.getDisplaySystem();
        this.extras = new ArrayList();
        this.transformationFactor = 3.0f;
        this.setRenderQueueMode(4);
        if (bl) {
            alphaState = this.display.getRenderer().createAlphaState();
            alphaState.setBlendEnabled(true);
            alphaState.setSrcFunction(4);
            alphaState.setDstFunction(5);
            this.setRenderState(alphaState);
        }
        this.setLightCombineMode(0);
        this.mainNode = new Node("regular node");
        if (wrap == Wrap.NORMAL) {
            this.normalNode = new Node("normal wrapping node");
            this.normalNodeTranslation = new Vector3f();
            this.normalNode.setLocalTranslation(this.normalNodeTranslation);
        } else if (wrap == Wrap.FLIPPED) {
            this.normalNode = new Node("normal wrapping node");
            this.normalNodeTranslation = new Vector3f();
            this.normalNode.setLocalTranslation(this.normalNodeTranslation);
            this.flippedNode = new Node("flipped wrapping node");
            this.flippedNodeTranslation = new Vector3f();
            this.flippedNode.setLocalTranslation(this.flippedNodeTranslation);
        }
        this.extrasNode = new Node("extras node");
        alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        this.extrasNode.setRenderState(alphaState);
        this.extrasNode.updateRenderState();
        this.thisNodeTranslation = new Vector3f();
        this.setLocalTranslation(this.thisNodeTranslation);
    }

    public void update(float f) {
        float f2;
        if (this.paused) {
            return;
        }
        if (this.transformationProvider == null) {
            return;
        }
        float f3 = f2 = (float)(-this.transformationProvider.getLocalTranslation().x) * this.transformationFactor;
        if (this.wrapMode == Wrap.NORMAL) {
            float f4 = FastMath.floor(f2 / (float)this.totalWidth);
            if (f4 < -0.1f) {
                f4 += 1.0f;
            }
            this.normalNodeTranslation.x = (f2 -= (float)this.totalWidth * f4) < 0.0f ? (float)this.totalWidth : (float)(-this.totalWidth);
            this.normalNode.setLocalTranslation(this.normalNodeTranslation);
        } else if (this.wrapMode == Wrap.FLIPPED) {
            float f5 = FastMath.floor(f2 / (float)(this.totalWidth * 2));
            if (f5 < -0.1f) {
                f5 += 1.0f;
            }
            if ((f2 -= (float)this.totalWidth * f5 * 2.0f) < 0.0f) {
                this.flippedNodeTranslation.x = this.totalWidth;
                this.normalNodeTranslation.x = this.totalWidth * 2;
            } else {
                this.flippedNodeTranslation.x = -this.totalWidth;
                this.normalNodeTranslation.x = -this.totalWidth * 2;
            }
            this.normalNode.setLocalTranslation(this.normalNodeTranslation);
            this.flippedNode.setLocalTranslation(this.flippedNodeTranslation);
        }
        if (this.wholePixels) {
            f2 = FastMath.floor(f2);
        }
        this.thisNodeTranslation.x = f2;
        if (this.yTransformationFactor > 1.0E-4f) {
            float f6 = (float)this.transformationProvider.getLocalTranslation().y;
            float f7 = -(f6 - this.yTransformationBias) * this.yTransformationFactor;
            this.thisNodeTranslation.y = this.defaultY + (f7 *= (float)DisplaySystem.getDisplaySystem().getHeight() / 600.0f);
        }
        this.updateExtras(f3, f2);
        this.setLocalTranslation(this.thisNodeTranslation);
    }

    private void updateExtras(float f, float f2) {
        for (int i = 0; i < this.extras.size(); ++i) {
            this.extras.get(i).setPosition(f, f2);
        }
    }

    public void init(Image image) {
        int n;
        if (image == null) {
            logger.severe("Image is null");
            return;
        }
        this.imageWidth = image.getWidth();
        this.imageHeight = image.getHeight();
        ImageUtils.flipVertically(image);
        this.cols = this.imageWidth / this.maxTextureWidth;
        if (this.imageWidth % this.maxTextureWidth != 0) {
            ++this.cols;
        }
        this.colWidths = new int[this.cols];
        for (n = 0; n < this.cols; ++n) {
            this.colWidths[n] = this.maxTextureWidth;
        }
        if (this.imageWidth % this.maxTextureWidth != 0) {
            this.colWidths[this.cols - 1] = this.imageWidth % this.maxTextureWidth;
        }
        this.rows = this.imageHeight / this.maxTextureHeight;
        if (this.imageHeight % this.maxTextureHeight != 0) {
            ++this.rows;
        }
        this.rowHeights = new int[this.rows];
        for (n = 0; n < this.rows; ++n) {
            this.rowHeights[n] = this.maxTextureHeight;
        }
        if (this.imageHeight % this.maxTextureHeight != 0) {
            this.rowHeights[this.rows - 1] = this.imageHeight % this.maxTextureHeight;
        }
        this.totalWidth = this.stretch && DisplaySystem.getDisplaySystem().getWidth() > this.imageWidth ? DisplaySystem.getDisplaySystem().getWidth() : this.imageWidth;
        this.totalHeight = this.imageHeight;
        float f = (float)this.totalWidth / (float)this.imageWidth;
        Image[] imageArray = ImageUtils.split(image, this.maxTextureWidth, this.maxTextureHeight, true);
        image.setData(null);
        for (int i = 0; i < imageArray.length; ++i) {
            if (imageArray[i] != null && imageArray[i].getData() != null) continue;
            logger.severe("Layer: image " + i + " is NULL");
        }
        this.textures = new Texture[imageArray.length];
        this.quads = new Quad[imageArray.length];
        for (int i = 0; i < imageArray.length; ++i) {
            int n2;
            int n3 = i / this.cols;
            int n4 = i % this.cols;
            this.quads[i] = new Quad("layerQuad" + i, (float)this.colWidths[n4] * f, this.rowHeights[n3]);
            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            Texture texture = ImageUtils.loadTexture(imageArray[i], 1, 1, false);
            textureState.setTexture(texture);
            this.quads[i].setRenderState(textureState);
            this.textures[i] = texture;
            FloatBuffer floatBuffer = this.quads[i].getTextureBuffer(0, 0);
            floatBuffer.rewind();
            floatBuffer.put(0.0f).put(1.0f * ((float)this.rowHeights[n3] / (float)this.maxTextureHeight));
            floatBuffer.put(0.0f).put(0.0f);
            floatBuffer.put(1.0f * ((float)this.colWidths[n4] / (float)this.maxTextureWidth)).put(0.0f);
            floatBuffer.put(1.0f * ((float)this.colWidths[n4] / (float)this.maxTextureWidth)).put(1.0f * ((float)this.rowHeights[n3] / (float)this.maxTextureHeight));
            floatBuffer.flip();
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (n2 = 0; n2 < n4; ++n2) {
                f2 += (float)this.colWidths[n2] * f;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                f3 += (float)this.rowHeights[n2];
            }
            this.quads[i].setLocalTranslation(new Vector3f(f2 + (float)this.colWidths[n4] * f * 0.5f, f3 + (float)this.rowHeights[n3] * 0.5f, 0.0f));
            SharedMesh sharedMesh = new SharedMesh("sharedQuad", this.quads[i]);
            this.mainNode.attachChild(sharedMesh);
            if (this.wrapMode == Wrap.NONE) continue;
            sharedMesh = new SharedMesh("sharedQuad", this.quads[i]);
            this.normalNode.attachChild(sharedMesh);
            this.normalNodeTranslation.x = this.totalWidth;
            this.normalNode.setLocalTranslation(this.normalNodeTranslation);
            if (this.wrapMode != Wrap.FLIPPED) continue;
            Quad quad = new Quad("layerQuad" + i, (float)this.colWidths[n4] * f, this.rowHeights[n3]);
            quad.setRenderState(textureState);
            floatBuffer = quad.getTextureBuffer(0, 0);
            floatBuffer.rewind();
            floatBuffer.put(1.0f * ((float)this.colWidths[n4] / (float)this.maxTextureWidth)).put(1.0f * ((float)this.rowHeights[n3] / (float)this.maxTextureHeight));
            floatBuffer.put(1.0f * ((float)this.colWidths[n4] / (float)this.maxTextureWidth)).put(0.0f);
            floatBuffer.put(0.0f).put(0.0f);
            floatBuffer.put(0.0f).put(1.0f * ((float)this.rowHeights[n3] / (float)this.maxTextureHeight));
            floatBuffer.flip();
            quad.setLocalTranslation(new Vector3f((float)this.totalWidth - (f2 + (float)this.colWidths[n4] * f * 0.5f), f3 + (float)this.rowHeights[n3] * 0.5f, 0.0f));
            this.flippedNode.attachChild(quad);
            this.flippedNodeTranslation.x = this.totalWidth;
            this.flippedNode.setLocalTranslation(this.flippedNodeTranslation);
        }
        if (this.flippedNode != null) {
            this.attachChild(this.flippedNode);
        }
        if (this.normalNode != null) {
            this.attachChild(this.normalNode);
        }
        this.attachChild(this.mainNode);
        this.attachChild(this.extrasNode);
        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
        cullState.setEnabled(true);
        cullState.setCullMode(0);
        this.setRenderState(cullState);
        this.setNormalsMode(4);
        this.updateRenderState();
    }

    public void setVerticalPos(float f) {
        this.thisNodeTranslation.y = (float)DisplaySystem.getDisplaySystem().getHeight() * (1.0f - f) - (float)this.totalHeight;
        this.setLocalTranslation(this.thisNodeTranslation);
        this.defaultY = this.thisNodeTranslation.y;
    }

    public int getMaxTextureHeight() {
        return this.maxTextureHeight;
    }

    public int getMaxTextureWidth() {
        return this.maxTextureWidth;
    }

    public float getTransformationFactor() {
        return this.transformationFactor;
    }

    public void setTransformationFactor(float f) {
        this.transformationFactor = f;
    }

    public TransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(TransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public void setZOrder(int n) {
        this.setZOrderOnBranch(this, n);
    }

    private void setZOrderOnBranch(Spatial spatial, int n) {
        block4: {
            block3: {
                super.setZOrder(n);
                if (!(spatial instanceof Node)) break block3;
                Node node = (Node)spatial;
                if (node.getChildren() == null) break block4;
                for (Spatial spatial2 : node.getChildren()) {
                    this.setZOrderOnBranch(spatial2, n);
                }
                break block4;
            }
            if (spatial instanceof Geometry) {
                Geometry geometry = (Geometry)spatial;
                int n2 = geometry.getBatchCount();
                while (--n2 >= 0) {
                    geometry.getBatch(n2).setZOrder(n);
                }
            }
        }
    }

    public boolean isWholePixels() {
        return this.wholePixels;
    }

    public void setWholePixels(boolean bl) {
        this.wholePixels = bl;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public void cleanup() {
        if (this.textures == null) {
            return;
        }
        for (int i = 0; i < this.textures.length; ++i) {
            if (this.textures[i] == null) continue;
            TextureManager.releaseTexture(this.textures[i]);
        }
        this.detachAllChildren();
    }

    public float getYTransformationFactor() {
        return this.yTransformationFactor;
    }

    public void setYTransformationFactor(float f) {
        this.yTransformationFactor = f;
    }

    public float getYTransformationBias() {
        return this.yTransformationBias;
    }

    public void setYTransformationBias(float f) {
        this.yTransformationBias = f;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void addExtra(Quad quad, Vector2f vector2f, float f) {
        this.extras.add(new Extra(quad, vector2f, f));
        this.extrasNode.attachChild(quad);
        quad.setZOrder(this.getZOrder());
        quad.updateRenderState();
    }

    public void clearExtras() {
        this.extrasNode.detachAllChildren();
        this.extras.clear();
    }

    private class Extra {
        Quad quad;
        Vector2f initialPosition;
        float repeatInterval;
        public Vector2f tempScreenPos = new Vector2f();

        public Extra(Quad quad, Vector2f vector2f, float f) {
            this.quad = quad;
            this.initialPosition = vector2f;
            this.repeatInterval = f;
            quad.setLocalTranslation(vector2f.x, vector2f.y, quad.getLocalTranslation().z);
        }

        public void setPosition(float f, float f2) {
            this.tempScreenPos = this.getPositionOnScreen(f, f2);
            this.quad.setLocalTranslation(this.tempScreenPos.x - f2, this.tempScreenPos.y, this.quad.getLocalTranslation().z);
        }

        private Vector2f getPositionOnScreen(float f, float f2) {
            if (this.repeatInterval <= 0.0f) {
                this.tempScreenPos.x = this.initialPosition.x + f;
                this.tempScreenPos.y = this.initialPosition.y;
            } else {
                float f3 = -f - this.initialPosition.x;
                float f4 = f3 / this.repeatInterval;
                int n = Math.round(f4);
                this.tempScreenPos.x = this.initialPosition.x + (float)n * this.repeatInterval + f;
                this.tempScreenPos.y = this.initialPosition.y;
            }
            return this.tempScreenPos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Wrap {
        NONE,
        NORMAL,
        FLIPPED;

    }
}

