/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.replay;

import com.jme.util.geom.BufferUtils;
import com.turborilla.TransformationProvider;
import com.turborilla.replay.IReplayFrame;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayFrameTransformationProvider
implements IReplayFrame {
    protected double time = 0.0;
    protected double[] values;
    public static final int providerSize = 10;
    private static ByteBuffer buffer;

    public ReplayFrameTransformationProvider(double d, ArrayList<TransformationProvider> arrayList) {
        this.time = d;
        this.values = new double[arrayList.size() * 10];
    }

    public ReplayFrameTransformationProvider(ArrayList<TransformationProvider> arrayList) {
        this(0.0, arrayList);
    }

    protected IReplayFrame save(ArrayList<TransformationProvider> arrayList) {
        int n = 0;
        for (TransformationProvider transformationProvider : arrayList) {
            Vector3d vector3d = transformationProvider.getLocalTranslation();
            Quaternion quaternion = transformationProvider.getLocalRotation();
            Vector3d vector3d2 = transformationProvider.getLocalScale();
            this.values[n * 10 + 0] = vector3d.x;
            this.values[n * 10 + 1] = vector3d.y;
            this.values[n * 10 + 2] = vector3d.z;
            this.values[n * 10 + 3] = quaternion.x;
            this.values[n * 10 + 4] = quaternion.y;
            this.values[n * 10 + 5] = quaternion.z;
            this.values[n * 10 + 6] = quaternion.w;
            this.values[n * 10 + 7] = vector3d2.x;
            this.values[n * 10 + 8] = vector3d2.y;
            this.values[n * 10 + 9] = vector3d2.z;
            ++n;
        }
        return this;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public void setTime(double d) {
        this.time = d;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        if (buffer == null || buffer.capacity() != this.values.length * 64 + 64) {
            buffer = BufferUtils.createByteBuffer(this.values.length * 64 + 64);
        }
        buffer.clear();
        buffer.putDouble(this.time);
        for (int i = 0; i < this.values.length; ++i) {
            buffer.putDouble(this.values[i]);
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public boolean fromFileChannel(FileChannel fileChannel) throws IOException {
        if (buffer == null || buffer.capacity() != this.values.length * 64 + 64) {
            buffer = BufferUtils.createByteBuffer(this.values.length * 64 + 64);
        }
        buffer.clear();
        int n = fileChannel.read(buffer);
        if (n < buffer.capacity()) {
            return false;
        }
        buffer.flip();
        this.time = buffer.getDouble();
        for (int i = 0; buffer.hasRemaining() && i < this.values.length; ++i) {
            this.values[i] = buffer.getDouble();
        }
        return true;
    }
}

