/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.replay;

import com.turborilla.replay.IReplay;
import com.turborilla.replay.IReplayFrame;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class BaseReplay
implements IReplay {
    private static final Logger logger = Logger.getLogger(BaseReplay.class.getName());
    private boolean recording = false;
    private boolean replaying = false;
    private boolean started = false;
    private double currentTime = 0.0;
    protected ArrayList<IReplayFrame> frames;
    IReplayFrame frame1 = null;
    IReplayFrame frame2 = null;

    public abstract void applyFrames(double var1, IReplayFrame var3, IReplayFrame var4);

    public abstract IReplayFrame getSnapshot();

    public void update(double d) {
        if (this.replaying) {
            this.currentTime += d;
            boolean bl = this.replay(this.currentTime);
            if (!bl) {
                this.pauseReplay();
            }
        } else if (this.recording) {
            this.currentTime += d;
            this.record(this.currentTime);
        }
    }

    protected void record(double d) {
        IReplayFrame iReplayFrame = this.getSnapshot();
        iReplayFrame.setTime(d);
        this.frames.add(iReplayFrame);
    }

    public boolean replay(double d) {
        assert (d >= 0.0);
        double d2 = -1.0;
        if (this.frame1 == null || this.frame2 == null || !(d >= this.frame1.getTime()) || !(d <= this.frame2.getTime())) {
            this.frame2 = null;
            this.frame1 = null;
            for (IReplayFrame iReplayFrame : this.frames) {
                if (iReplayFrame.getTime() > d) {
                    this.frame2 = iReplayFrame;
                    break;
                }
                this.frame1 = iReplayFrame;
            }
            if (this.frame1 == null) {
                if (this.frame2 != null) {
                    this.applyFrames(0.0, this.frame2, this.frame2);
                    return true;
                }
                return false;
            }
            if (this.frame2 == null) {
                this.applyFrames(0.0, this.frame1, this.frame1);
                return false;
            }
        }
        d2 = (d - this.frame1.getTime()) / (this.frame2.getTime() - this.frame1.getTime());
        this.applyFrames(d2, this.frame1, this.frame2);
        return true;
    }

    public void startRecording() {
        this.recording = true;
        this.replaying = false;
        this.started = true;
        this.currentTime = 0.0;
        if (this.frames == null) {
            this.frames = new ArrayList();
        } else {
            this.frames.clear();
        }
    }

    public void stopRecording() {
        this.recording = false;
    }

    public void startReplaying() {
        this.recording = false;
        this.replaying = true;
        this.started = true;
        this.currentTime = 0.0;
        this.frame2 = null;
        this.frame1 = null;
    }

    public void pauseReplay() {
        this.replaying = false;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(double d) {
        if (this.recording) {
            logger.warning("Cannot set current time when still recording, only when replaying");
            return;
        }
        this.currentTime = d;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isReplaying() {
        return this.replaying;
    }

    public boolean isStarted() {
        return this.started;
    }
}

