/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.preferences;

import com.jme.system.PreferencesGameSettings;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class PreferencesGameSettingsWithDefaults
extends PreferencesGameSettings {
    private static Logger logger = Logger.getLogger(PreferencesGameSettingsWithDefaults.class.getName());
    protected Preferences preferences;
    protected String path = null;
    protected String defaultFile = null;
    protected String overrideFile = null;

    public PreferencesGameSettingsWithDefaults(Preferences preferences, String string, String string2, String string3) {
        super(preferences);
        this.preferences = preferences;
        this.path = string != null ? string : "";
        this.defaultFile = string2 != null ? string2 : "default.txt";
        this.overrideFile = string3;
        try {
            this.fillInBlanksWithDefaultsFile(string2);
        }
        catch (Exception exception) {
            logger.severe("Could not load defaults due to " + Utils.getStackTrace(exception));
        }
        if (string3 != null) {
            try {
                this.importSettings(string3);
            }
            catch (Exception exception) {
                logger.info("No override settings file found.");
            }
        }
    }

    public String toString() {
        String string = "";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.preferences.exportSubtree(byteArrayOutputStream);
            string = byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        return string;
    }

    public void revertToDefaults() {
        try {
            this.importSettings(this.defaultFile);
        }
        catch (IOException iOException) {
            logger.severe("Could not revert to defaults: " + iOException);
        }
        catch (BackingStoreException backingStoreException) {
            logger.severe("Could not revert to defaults: " + backingStoreException);
        }
    }

    public void importSettings(String string) throws IOException, BackingStoreException {
        URL uRL = PreferencesGameSettingsWithDefaults.class.getClassLoader().getResource(this.path + "/" + string);
        InputStream inputStream = uRL.openStream();
        Properties properties = new Properties();
        properties.load(inputStream);
        this.fromProperties(properties);
    }

    public void exportSettings(String string) {
        File file = null;
        try {
            file = new File(ResourceManager.findUrl(this.path).toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.severe("Settings directory error. Exception: " + uRISyntaxException);
        }
        File file2 = new File(file, string);
        file2.delete();
        FileOutputStream fileOutputStream = null;
        try {
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            this.toProperties().store(fileOutputStream, null);
        }
        catch (Exception exception) {
            logger.severe("Could not export settings. Exception: " + exception);
        }
    }

    protected Properties toProperties() throws BackingStoreException {
        Properties properties = new Properties();
        for (String string : this.preferences.keys()) {
            String string2 = this.preferences.get(string, null);
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    protected void fillInBlanksWithDefaultsFile(String string) throws IOException, BackingStoreException {
        URL uRL = PreferencesGameSettingsWithDefaults.class.getClassLoader().getResource(this.path + "/" + string);
        InputStream inputStream = uRL.openStream();
        Properties properties = new Properties();
        properties.load(inputStream);
        this.defaultsFromProperties(properties);
    }

    protected void fromProperties(Properties properties) throws BackingStoreException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string2 == null || string == null) continue;
            this.preferences.put(string, string2);
        }
        this.preferences.flush();
    }

    protected void defaultsFromProperties(Properties properties) throws BackingStoreException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string;
            String string2;
            String string3 = (String)entry.getKey();
            if (string3 == "") {
                string3 = null;
            }
            if ((string2 = (String)entry.getValue()) == "") {
                string2 = null;
            }
            if ((string = this.preferences.get(string3, null)) == "") {
                string = null;
            }
            if (string2 == null || string3 == null || string != null) continue;
            this.preferences.put(string3, string2);
        }
        this.preferences.flush();
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.preferences.addPreferenceChangeListener(preferenceChangeListener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.preferences.removePreferenceChangeListener(preferenceChangeListener);
    }
}

