/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.jme.image.Texture;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.TriMesh;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.geom.BufferUtils;
import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.utils.math.Matrix4d;
import com.turborilla.utils.math.Vector3d;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class ParticleObjectEffect
extends ParticleObject {
    private int numParticles;
    private Particle[] particleArray;
    private double[] timeToLive;
    private Particle emitterBase;
    private Particle emitterTowards;
    private Vector3d emitterBaseVect;
    private Vector3d emitterTowardsVect;
    protected double emitInterval = 0.1;
    private double initialSpeed = 0.005;
    private double numberToEmit = 0.0;
    protected double lifeTime = 1.0;
    protected double initialAge = 0.0;
    protected double directionRandomizer = 0.1;
    private boolean emitting = true;
    private static Vector3d direction = new Vector3d();
    private static Vector3d random = new Vector3d();
    private static Vector3d oldBase;
    private static Vector3d base;
    private static Vector3d towards;
    private FloatBuffer vertexBuffer;
    private IntBuffer indexBuffer;
    private FloatBuffer textureBuffer;
    private FloatBuffer colorBuffer;
    private TriMesh mesh;
    private Node node;
    private Texture texture;
    private float[] startColor = new float[]{0.45f, 0.3f, 0.3f, 1.0f};
    private float[] endColor = new float[]{1.0f, 0.9f, 0.9f, 0.2f};
    private double startSize = 0.6f;
    private double endSize = 0.3f;
    protected Vector3d temp = new Vector3d();
    private static Vector3d v1;
    private static Vector3d v2;
    private static Vector3d v3;
    private static ColorRGBA color;
    private float randomColor = 0.0f;

    public ParticleObjectEffect(String string, int n, Texture texture) {
        super(string);
        this.particleArray = new Particle[n];
        this.timeToLive = new double[n];
        this.numParticles = n;
        for (int i = 0; i < n; ++i) {
            this.particleArray[i] = new Particle();
            this.particleArray[i].alive = false;
            this.timeToLive[i] = 0.0;
            super.addParticle(this.particleArray[i]);
        }
        this.emitterBase = null;
        this.emitterTowards = null;
        this.emitterBaseVect = new Vector3d();
        this.emitterTowardsVect = new Vector3d(0.0, 1.0, 0.0);
        this.setupNode(texture);
    }

    public void integrate(double d) {
        if (this.isEmitting()) {
            this.numberToEmit += d / this.emitInterval;
            int n = (int)this.numberToEmit;
            this.numberToEmit -= (double)n;
            this.emit(n, d);
        }
        double d2 = d * d;
        for (int i = 0; i < this.numParticles; ++i) {
            int n = i;
            this.timeToLive[n] = this.timeToLive[n] - d;
            if (this.timeToLive[i] < 0.0) {
                this.particleArray[i].alive = false;
                continue;
            }
            if (!this.particleArray[i].alive) continue;
            this.temp.set(this.particleArray[i].position);
            this.particleArray[i].position.x += this.damp * this.particleArray[i].position.x - this.damp * this.particleArray[i].oldPosition.x + this.gravity.x * d2;
            this.particleArray[i].position.y += this.damp * this.particleArray[i].position.y - this.damp * this.particleArray[i].oldPosition.y + this.gravity.y * d2;
            this.particleArray[i].position.z += this.damp * this.particleArray[i].position.z - this.damp * this.particleArray[i].oldPosition.z + this.gravity.z * d2;
            this.particleArray[i].oldPosition.set(this.temp);
        }
        this.visualize();
    }

    public void emit(int n, double d) {
        int n2;
        oldBase = null;
        if (this.emitterBase != null) {
            base = this.emitterBase.position;
            oldBase = this.emitterBase.oldPosition;
        }
        if (this.emitterTowards != null) {
            towards = this.emitterTowards.position;
        }
        if (this.emitterBaseVect != null) {
            base = this.emitterBaseVect;
        }
        if (this.emitterTowardsVect != null) {
            towards = this.emitterTowardsVect;
        }
        if (oldBase == null) {
            oldBase = base;
        }
        direction.set(towards).subtractLocal(base).normalizeLocal();
        for (int i = 0; i < n && (n2 = this.getIndexOfFirstDead()) != -1; ++i) {
            double d2 = this.initialSpeed * 1000.0 * d;
            Particle particle = this.particleArray[n2];
            particle.position.set(base);
            random.set(0.5 - Math.random(), 0.5 - Math.random(), 0.5 - Math.random());
            random.multLocal(this.directionRandomizer * this.initialSpeed);
            particle.oldPosition.set(oldBase).subtractLocal(direction.multLocal(d2)).addLocal(random);
            direction.multLocal(1.0 / d2);
            this.particleArray[n2].alive = true;
            this.timeToLive[n2] = this.lifeTime - this.initialAge;
        }
    }

    private void setupNode(Texture texture) {
        this.texture = texture;
        if (texture != null) {
            this.textureBuffer = BufferUtils.createVector2Buffer(this.numParticles * 3);
            for (int i = 0; i < this.numParticles; ++i) {
                this.textureBuffer.put(0.5f).put(2.0f);
                this.textureBuffer.put(-1.0f).put(-1.0f);
                this.textureBuffer.put(2.0f).put(-1.0f);
            }
        } else {
            this.textureBuffer = null;
        }
        this.vertexBuffer = BufferUtils.createVector3Buffer(this.numParticles * 3);
        this.indexBuffer = BufferUtils.createIntBuffer(this.numParticles * 3);
        this.colorBuffer = BufferUtils.createColorBuffer(this.numParticles * 3);
        this.mesh = new TriMesh("spray", this.vertexBuffer, null, this.colorBuffer, this.textureBuffer, this.indexBuffer);
        if (texture != null) {
            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            textureState.setTexture(texture);
            texture.setWrap(5);
            this.mesh.setRenderState(textureState);
            AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
            alphaState.setBlendEnabled(true);
            alphaState.setSrcFunction(4);
            alphaState.setTestEnabled(true);
            alphaState.setTestFunction(4);
            alphaState.setDstFunction(5);
            this.mesh.setRenderState(alphaState);
        }
        this.mesh.setLightCombineMode(0);
        this.node = new Node("sprayNode");
        this.node.attachChild(this.mesh);
        this.node.setCullMode(0);
        if (texture != null) {
            this.node.setRenderQueueMode(3);
        }
        this.node.updateRenderState();
    }

    private void visualize() {
        if (this.node != null) {
            int n = 0;
            this.vertexBuffer.clear();
            this.indexBuffer.clear();
            this.colorBuffer.clear();
            for (int i = 0; i < this.numParticles; ++i) {
                if (!this.particleArray[i].alive) continue;
                double d = (this.lifeTime - this.timeToLive[i]) / this.lifeTime;
                double d2 = this.startSize + (this.endSize - this.startSize) * d;
                float f = (float)d;
                ParticleObjectEffect.color.r = this.startColor[0] + (this.endColor[0] - this.startColor[0]) * (f + (float)Math.random() * this.randomColor - this.randomColor * 0.5f);
                ParticleObjectEffect.color.g = this.startColor[1] + (this.endColor[1] - this.startColor[1]) * (f + (float)Math.random() * this.randomColor - this.randomColor * 0.5f);
                ParticleObjectEffect.color.b = this.startColor[2] + (this.endColor[2] - this.startColor[2]) * (f + (float)Math.random() * this.randomColor - this.randomColor * 0.5f);
                ParticleObjectEffect.color.a = this.startColor[3] + (this.endColor[3] - this.startColor[3]) * (f + (float)Math.random() * this.randomColor - this.randomColor * 0.5f);
                color.clamp();
                v1.set(this.particleArray[i].position).addLocal(0.0, 1.0 * d2, 0.0);
                v2.set(this.particleArray[i].position).addLocal(-1.0 * d2, -1.0 * d2, 0.0);
                v3.set(this.particleArray[i].position).addLocal(1.0 * d2, -1.0 * d2, 0.0);
                this.vertexBuffer.put((float)ParticleObjectEffect.v1.x).put((float)ParticleObjectEffect.v1.y).put((float)ParticleObjectEffect.v1.z);
                this.vertexBuffer.put((float)ParticleObjectEffect.v2.x).put((float)ParticleObjectEffect.v2.y).put((float)ParticleObjectEffect.v2.z);
                this.vertexBuffer.put((float)ParticleObjectEffect.v3.x).put((float)ParticleObjectEffect.v3.y).put((float)ParticleObjectEffect.v3.z);
                this.colorBuffer.put(ParticleObjectEffect.color.r).put(ParticleObjectEffect.color.g).put(ParticleObjectEffect.color.b).put(ParticleObjectEffect.color.a);
                this.colorBuffer.put(ParticleObjectEffect.color.r).put(ParticleObjectEffect.color.g).put(ParticleObjectEffect.color.b).put(ParticleObjectEffect.color.a);
                this.colorBuffer.put(ParticleObjectEffect.color.r).put(ParticleObjectEffect.color.g).put(ParticleObjectEffect.color.b).put(ParticleObjectEffect.color.a);
                this.indexBuffer.put(i * 3 + 0);
                this.indexBuffer.put(i * 3 + 1);
                this.indexBuffer.put(i * 3 + 2);
                ++n;
            }
            this.vertexBuffer.flip();
            this.indexBuffer.flip();
            this.colorBuffer.flip();
            this.mesh.getBatch(0).setTriangleQuantity(n);
            if (n <= 0) {
                this.mesh.getBatch(0).setEnabled(false);
            } else {
                this.mesh.getBatch(0).setEnabled(true);
            }
        }
    }

    public Particle addParticle(double d, double d2, double d3, double d4) {
        int n = this.getIndexOfFirstDead();
        if (n == -1) {
            return null;
        }
        this.particleArray[n].position.set(d, d2, d3);
        this.particleArray[n].oldPosition.set(d, d2, d3);
        this.particleArray[n].setWeight(d4);
        return this.particleArray[n];
    }

    public Particle addParticle(Particle particle) {
        int n = this.getIndexOfFirstDead();
        if (n == -1) {
            return null;
        }
        super.removeParticle(this.particleArray[n]);
        super.addParticle(particle);
        this.particleArray[n] = particle;
        return particle;
    }

    public Particle addParticle(Vector3d vector3d, double d) {
        return this.addParticle(vector3d.x, vector3d.y, vector3d.z, d);
    }

    public void removeParticle(Particle particle) {
        int n = this.getIndex(particle);
        if (n == -1) {
            return;
        }
        this.particleArray[n].alive = false;
    }

    private int getIndexOfFirstDead() {
        int n;
        double d = 1000.0;
        int n2 = -1;
        for (n = 0; n < this.numParticles && this.particleArray[n].alive; ++n) {
            if (!(this.timeToLive[n] < d)) continue;
            d = this.timeToLive[n];
            n2 = n;
        }
        return n == this.numParticles ? n2 : n;
    }

    private int getIndex(Particle particle) {
        int n;
        for (n = 0; n < this.numParticles && particle != this.particleArray[n]; ++n) {
        }
        return n == this.numParticles ? -1 : n;
    }

    public Particle getEmitterBase() {
        return this.emitterBase;
    }

    public Vector3d getEmitterBaseVect() {
        return this.emitterBaseVect;
    }

    public void setEmitterBase(Particle particle) {
        this.emitterBase = particle;
        this.emitterBaseVect = null;
    }

    public void setEmitterBase(Vector3d vector3d) {
        this.emitterBaseVect.set(vector3d);
        this.emitterBase = null;
    }

    public Particle getEmitterTowards() {
        return this.emitterTowards;
    }

    public Vector3d getEmitterTowardsVect() {
        return this.emitterTowardsVect;
    }

    public void setEmitterTowards(Particle particle) {
        this.emitterTowards = particle;
        this.emitterTowardsVect = null;
    }

    public void setEmitterTowards(Vector3d vector3d) {
        this.emitterTowards = null;
        this.emitterTowardsVect.set(vector3d);
    }

    public boolean isEmitting() {
        return this.emitting;
    }

    public void setEmitting(boolean bl) {
        this.emitting = bl;
    }

    public double getEmitInterval() {
        return this.emitInterval;
    }

    public void setEmitInterval(double d) {
        this.emitInterval = d;
    }

    public double getInitialSpeed() {
        return this.initialSpeed;
    }

    public void setInitialSpeed(double d) {
        this.initialSpeed = d;
    }

    public double getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(double d) {
        this.lifeTime = d;
    }

    public double getDirectionRandomizer() {
        return this.directionRandomizer;
    }

    public void setDirectionRandomizer(double d) {
        this.directionRandomizer = d;
    }

    public Node getNode() {
        return this.node;
    }

    public Matrix4d updateCoordinateFrame() {
        return this.getCoordinateFrame();
    }

    public Vector3d getCenterOfMass(Vector3d vector3d) {
        return vector3d != null ? vector3d.set(0.0, 0.0, 0.0) : new Vector3d(0.0, 0.0, 0.0);
    }

    public double getMass() {
        return 0.0;
    }

    public float[] getEndColor() {
        return this.endColor;
    }

    public void setEndColor(float[] fArray) {
        this.endColor = fArray;
    }

    public double getEndSize() {
        return this.endSize;
    }

    public void setEndSize(double d) {
        this.endSize = d;
    }

    public double getInitialAge() {
        return this.initialAge;
    }

    public void setInitialAge(double d) {
        this.initialAge = d;
    }

    public float[] getStartColor() {
        return this.startColor;
    }

    public void setStartColor(float[] fArray) {
        this.startColor = fArray;
    }

    public double getStartSize() {
        return this.startSize;
    }

    public void setStartSize(double d) {
        this.startSize = d;
    }

    public double[] getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(double[] dArray) {
        this.timeToLive = dArray;
    }

    public int getNumParticles() {
        return this.numParticles;
    }

    public Texture getTexture() {
        return this.texture;
    }

    static {
        base = new Vector3d();
        towards = new Vector3d();
        v1 = new Vector3d();
        v2 = new Vector3d();
        v3 = new Vector3d();
        color = new ColorRGBA();
    }
}

