/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.ConstraintParallel;
import com.turborilla.physics.particle.ConstraintSpring;
import com.turborilla.physics.particle.ForceTorque;
import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;

public class ParticleObjectCar
extends ParticleObject {
    Particle[] wheelCenter;
    Particle[] wheelAxis;
    Particle[] body;
    double leftRearRadius;
    double rightRearRadius;
    double leftFrontRadius;
    double rightFrontRadius;
    double bodyWidth;
    double bodyLength;
    double bodyHeight;
    double wheelWeight;
    double bodyWeight;
    int nrSpokes;

    public ParticleObjectCar(String string) {
        super(string);
        this.init();
    }

    public void init() {
        double d = 0.7f;
        this.init(d, d, d, d, 2.0, 3.5, 0.7f, 2.5, 5.0, 15, 1.3f);
    }

    public void init(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, double d10) {
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        ConstraintSpring[] constraintSpringArray = new ConstraintSpring[2];
        this.body = new Particle[8];
        this.wheelAxis = new Particle[4];
        this.body[0] = this.addParticle(d11 - d6 / 2.0, d12 + d7 / 2.0, d13 + d5 / 2.0, d9 / 8.0);
        this.body[1] = this.addParticle(d11 + d6 / 2.0, d12 + d7 / 2.0, d13 + d5 / 2.0, d9 / 8.0);
        this.body[2] = this.addParticle(d11 + d6 / 2.0, d12 + d7 / 2.0, d13 - d5 / 2.0, d9 / 8.0);
        this.body[3] = this.addParticle(d11 - d6 / 2.0, d12 + d7 / 2.0, d13 - d5 / 2.0, d9 / 8.0);
        this.wheelAxis[0] = this.body[4] = this.addParticle(d11 - d6 / 2.0, d12 - d7 / 2.0, d13 + d5 / 2.0, d9 / 8.0);
        this.wheelAxis[1] = this.body[5] = this.addParticle(d11 + d6 / 2.0, d12 - d7 / 2.0, d13 + d5 / 2.0, d9 / 8.0);
        this.wheelAxis[2] = this.body[6] = this.addParticle(d11 + d6 / 2.0, d12 - d7 / 2.0, d13 - d5 / 2.0, d9 / 8.0);
        this.wheelAxis[3] = this.body[7] = this.addParticle(d11 - d6 / 2.0, d12 - d7 / 2.0, d13 - d5 / 2.0, d9 / 8.0);
        this.addConstraint(this.body[0], this.body[1]);
        this.addConstraint(this.body[1], this.body[2]);
        this.addConstraint(this.body[2], this.body[3]);
        this.addConstraint(this.body[3], this.body[0]);
        this.addConstraint(this.body[4], this.body[5]);
        constraintSpringArray[0] = this.addConstraint(this.body[5], this.body[6]);
        this.addConstraint(this.body[6], this.body[7]);
        constraintSpringArray[1] = this.addConstraint(this.body[7], this.body[4]);
        this.addConstraint(this.body[0], this.body[4]);
        this.addConstraint(this.body[1], this.body[5]);
        this.addConstraint(this.body[2], this.body[6]);
        this.addConstraint(this.body[3], this.body[7]);
        this.addConstraint(this.body[0], this.body[5]);
        this.addConstraint(this.body[1], this.body[6]);
        this.addConstraint(this.body[2], this.body[7]);
        this.addConstraint(this.body[3], this.body[4]);
        this.addConstraint(this.body[0], this.body[2]);
        this.addConstraint(this.body[5], this.body[7]);
        double d14 = 2 + n * 2;
        double d15 = d8 / d14;
        this.wheelCenter = new Particle[8];
        this.wheelCenter[0] = this.wheelAxis[0];
        this.wheelCenter[1] = this.wheelAxis[1];
        this.wheelCenter[2] = this.wheelAxis[2];
        this.wheelCenter[3] = this.wheelAxis[3];
        this.wheelCenter[4] = this.addParticle(this.wheelCenter[0].position.x, this.wheelCenter[0].position.y, this.wheelCenter[0].position.z + d10, d15);
        this.wheelCenter[5] = this.addParticle(this.wheelCenter[1].position.x, this.wheelCenter[1].position.y, this.wheelCenter[1].position.z + d10, d15);
        this.wheelCenter[6] = this.addParticle(this.wheelCenter[2].position.x, this.wheelCenter[2].position.y, this.wheelCenter[2].position.z - d10, d15);
        this.wheelCenter[7] = this.addParticle(this.wheelCenter[3].position.x, this.wheelCenter[3].position.y, this.wheelCenter[3].position.z - d10, d15);
        ConstraintParallel constraintParallel = new ConstraintParallel();
        constraintParallel.init(this.wheelCenter[4], this.wheelCenter[0], constraintSpringArray[1]);
        this.addConstraint(constraintParallel);
        constraintParallel = new ConstraintParallel();
        constraintParallel.init(this.wheelCenter[5], this.wheelCenter[1], constraintSpringArray[1]);
        this.addConstraint(constraintParallel);
        constraintParallel = new ConstraintParallel();
        constraintParallel.init(this.wheelCenter[6], this.wheelCenter[2], constraintSpringArray[0]);
        this.addConstraint(constraintParallel);
        constraintParallel = new ConstraintParallel();
        constraintParallel.init(this.wheelCenter[7], this.wheelCenter[3], constraintSpringArray[1]);
        this.addConstraint(constraintParallel);
        ConstraintSpring[] constraintSpringArray2 = new ConstraintSpring[]{this.addConstraint(this.wheelCenter[4], this.wheelCenter[0]), this.addConstraint(this.wheelCenter[5], this.wheelCenter[1]), this.addConstraint(this.wheelCenter[2], this.wheelCenter[6]), this.addConstraint(this.wheelCenter[3], this.wheelCenter[7])};
        Particle[] particleArray = new Particle[2];
        Particle[] particleArray2 = new Particle[2];
        for (int i = 0; i < 4; ++i) {
            double d16;
            double d17;
            switch (i) {
                case 0: {
                    d17 = d4;
                    d16 = d10;
                    break;
                }
                case 1: {
                    d17 = d2;
                    d16 = d10;
                    break;
                }
                case 2: {
                    d17 = d3;
                    d16 = -d10;
                    break;
                }
                case 3: {
                    d17 = d;
                    d16 = -d10;
                    break;
                }
                default: {
                    d17 = 0.5;
                    d16 = -d10;
                }
            }
            d11 = this.wheelCenter[i].position.x;
            d12 = this.wheelCenter[i].position.y;
            d13 = this.wheelCenter[i].position.z;
            particleArray2[0] = this.addParticle(d11, d12 + d17, d13, d15);
            Particle[] particleArray3 = new Particle[]{particleArray2[0], particleArray2[1] = this.addParticle(d11, d12 + d17, d13 + d16, d15)};
            this.addConstraint(particleArray2[0], this.wheelCenter[i]);
            this.addConstraint(particleArray2[1], this.wheelCenter[i + 4]);
            this.addConstraint(particleArray2[1], this.wheelCenter[i]);
            this.addConstraint(particleArray2[0], this.wheelCenter[i + 4]);
            this.addConstraint(particleArray2[0], particleArray2[1]);
            ForceTorque forceTorque = new ForceTorque();
            forceTorque.init(particleArray2[0], this.wheelCenter[i], constraintSpringArray2[i], 1.1f);
            this.addForce(forceTorque);
            forceTorque = new ForceTorque();
            forceTorque.init(particleArray2[1], this.wheelCenter[i + 4], constraintSpringArray2[i], 1.1f);
            this.addForce(forceTorque);
            for (int j = 1; j < n; ++j) {
                double d18 = (double)6.28312f * ((double)j / (double)n);
                particleArray[0] = this.addParticle(d11 + d17 * Math.sin(d18), d12 + d17 * Math.cos(d18), d13, d15);
                particleArray[1] = this.addParticle(d11 + d17 * Math.sin(d18), d12 + d17 * Math.cos(d18), d13 + d16, d15);
                this.addConstraint(particleArray[0], particleArray[1]);
                this.addConstraint(particleArray[0], this.wheelCenter[i]);
                this.addConstraint(particleArray[1], this.wheelCenter[i + 4]);
                this.addConstraint(particleArray2[1], this.wheelCenter[i]);
                this.addConstraint(particleArray2[0], this.wheelCenter[i + 4]);
                this.addConstraint(particleArray2[0], particleArray[0]);
                this.addConstraint(particleArray2[1], particleArray[1]);
                this.addConstraint(particleArray2[0], particleArray[1]);
                forceTorque = new ForceTorque();
                forceTorque.init(particleArray[0], this.wheelCenter[i], constraintSpringArray2[i], 1.1f);
                this.addForce(forceTorque);
                forceTorque = new ForceTorque();
                forceTorque.init(particleArray[1], this.wheelCenter[i + 4], constraintSpringArray2[i], 1.1f);
                this.addForce(forceTorque);
                particleArray2[0] = particleArray[0];
                particleArray2[1] = particleArray[1];
            }
            this.addConstraint(particleArray3[0], particleArray[0]);
            this.addConstraint(particleArray3[1], particleArray[1]);
            this.addConstraint(particleArray3[0], particleArray[1]);
        }
    }
}

