/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.Point;
import com.jme.util.geom.BufferUtils;
import com.turborilla.TransformationProvider;
import com.turborilla.Updatable;
import com.turborilla.physics.particle.ConstraintDamper;
import com.turborilla.physics.particle.ConstraintSpring;
import com.turborilla.physics.particle.ConstraintSpringDamped;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.IForce;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Matrix4d;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleObject
implements Updatable,
TransformationProvider {
    protected boolean collidable = true;
    protected Matrix4d frame;
    protected Matrix4d previousFrame;
    protected Particle[] frameParticles;
    protected Particle originParticle = null;
    protected Vector3d localTranslation;
    protected Quaternion localRotation;
    protected Vector3d localScale;
    protected Vector3d gravity;
    private double maximumTimeStep = 0.001f;
    private boolean lockedZ = false;
    private double lockedZvalue = 0.0;
    private String name;
    protected double damp = 0.999999;
    private double oldTpf = -1.0;
    private Vector3d temp = new Vector3d();
    protected Vector3d framex = new Vector3d();
    protected Vector3d framey = new Vector3d();
    protected Vector3d framez = new Vector3d();
    protected Vector3d velocity = new Vector3d();
    private Vector3d massTempVec3d = new Vector3d();
    private boolean taken = false;
    private Collection dummy = new Vector();
    protected ArrayList<Particle> particles;
    protected ArrayList<IConstraint> constraints;
    protected ArrayList<IConstraint> collisionConstraints;
    protected ArrayList<IForce> forces;
    protected ArrayList<IForce> impulses;
    private boolean paused;
    private Node debugNode;
    private Line debugSticks;
    private Line debugForces;
    private Point debugParticles;
    private Point debugCenterOfMass;
    private boolean shouldUpdateDebugNode = false;
    private Vector3f tempVec = new Vector3f();
    private Vector3d debugTempVec3d = new Vector3d();

    public double getLockedZvalue() {
        return this.lockedZvalue;
    }

    public void setLockedZvalue(double d) {
        this.lockedZvalue = d;
        for (Particle particle : this.particles) {
            particle.position.z = d;
        }
    }

    public ParticleObject(String string) {
        this.particles = new ArrayList();
        this.constraints = new ArrayList();
        this.collisionConstraints = new ArrayList();
        this.forces = new ArrayList();
        this.impulses = new ArrayList();
        this.frame = new Matrix4d();
        this.previousFrame = new Matrix4d();
        this.frameParticles = new Particle[3];
        this.gravity = new Vector3d(0.0, -9.81f, 0.0);
        this.localTranslation = new Vector3d();
        this.localRotation = new Quaternion();
        this.localScale = new Vector3d(1.0, 1.0, 1.0);
        this.name = string;
    }

    public void satisfyConstraints(double d) {
        for (int i = 0; i < this.constraints.size(); ++i) {
            this.constraints.get(i).satisfy(d);
        }
    }

    public void satisfyCollisionConstraints(double d) {
        for (int i = 0; i < this.collisionConstraints.size(); ++i) {
            this.collisionConstraints.get(i).satisfy(d);
        }
    }

    public void applyForces() {
        for (int i = 0; i < this.forces.size(); ++i) {
            IForce iForce = this.forces.get(i);
            iForce.apply();
            if (!iForce.once()) continue;
            iForce.setMagnitude(0.0);
        }
    }

    public void applyImpulses(double d) {
        if (!this.impulses.isEmpty()) {
            Iterator<IForce> iterator = this.impulseIterator();
            while (iterator.hasNext()) {
                IForce iForce = iterator.next();
                iForce.setMagnitude(iForce.getMagnitude() / d);
                iForce.apply();
                iterator.remove();
            }
        }
    }

    public void setAccelerationOnAllParticles(Vector3d vector3d) {
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            particle.acceleration.set(vector3d);
            if (!this.lockedZ) continue;
            particle.position.z = this.lockedZvalue;
            particle.oldPosition.z = this.lockedZvalue;
        }
    }

    public void integrate(double d) {
        double d2 = d * d;
        if (this.oldTpf <= 0.0) {
            for (int i = 0; i < this.particles.size(); ++i) {
                Particle particle = this.particles.get(i);
                this.temp.set(particle.position);
                particle.position.x += this.damp * particle.position.x - this.damp * particle.oldPosition.x + particle.acceleration.x * d2;
                particle.position.y += this.damp * particle.position.y - this.damp * particle.oldPosition.y + particle.acceleration.y * d2;
                particle.position.z += this.damp * particle.position.z - this.damp * particle.oldPosition.z + particle.acceleration.z * d2;
                particle.oldPosition.set(this.temp);
            }
        } else {
            double d3 = d / this.oldTpf;
            for (int i = 0; i < this.particles.size(); ++i) {
                Particle particle = this.particles.get(i);
                this.temp.set(particle.position);
                particle.position.x += (particle.position.x - particle.oldPosition.x) * d3 * this.damp + particle.acceleration.x * d2;
                particle.position.y += (particle.position.y - particle.oldPosition.y) * d3 * this.damp + particle.acceleration.y * d2;
                particle.position.z += (particle.position.z - particle.oldPosition.z) * d3 * this.damp + particle.acceleration.z * d2;
                particle.oldPosition.set(this.temp);
            }
        }
        if (this.originParticle != null) {
            this.velocity.set(this.originParticle.position).subtractLocal(this.originParticle.oldPosition).divideLocal(d);
        }
        this.oldTpf = d;
    }

    private void debug() {
    }

    public Matrix4d getCoordinateFrame() {
        return this.frame;
    }

    public Matrix4d getPreviousCoordinateFrame() {
        return this.previousFrame;
    }

    public Matrix4d updateCoordinateFrame() {
        if (this.frameParticles[0] != null && this.frameParticles[1] != null && this.frameParticles[2] != null && this.originParticle != null) {
            this.previousFrame.copy(this.frame);
            this.framey.set(this.frameParticles[1].position).subtractLocal(this.frameParticles[0].position);
            this.framex.set(this.frameParticles[1].position).subtractLocal(this.frameParticles[2].position);
            this.framey.cross(this.framex, this.framez);
            this.framey.cross(this.framez, this.framex);
            this.framey.normalizeLocal();
            this.framez.normalizeLocal();
            this.framex.normalizeLocal();
            this.frame.m00 = this.framex.x;
            this.frame.m01 = this.framex.y;
            this.frame.m02 = this.framex.z;
            this.frame.m10 = this.framey.x;
            this.frame.m11 = this.framey.y;
            this.frame.m12 = this.framey.z;
            this.frame.m20 = this.framez.x;
            this.frame.m21 = this.framez.y;
            this.frame.m22 = this.framez.z;
            this.frame.m33 = 1.0;
            this.localTranslation.set(this.originParticle.position);
            this.localRotation.fromAxes(this.framex, this.framey, this.framez);
        }
        return this.frame;
    }

    public Vector3d getCenterOfMass(Vector3d vector3d) {
        Vector3d vector3d2 = vector3d != null ? vector3d.set(0.0, 0.0, 0.0) : new Vector3d();
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            this.massTempVec3d.set(particle.position).multLocal(particle.getWeight());
            vector3d2.addLocal(this.massTempVec3d);
        }
        return vector3d2.multLocal(1.0 / this.getMass());
    }

    public double getMass() {
        double d = 0.0;
        for (int i = 0; i < this.particles.size(); ++i) {
            d += this.particles.get(i).getWeight();
        }
        return d;
    }

    public IForce addForce(IForce iForce) {
        this.forces.add(iForce);
        return iForce;
    }

    public boolean removeForce(IForce iForce) {
        return this.forces.remove(iForce);
    }

    public IForce addImpulse(IForce iForce) {
        this.impulses.add(iForce);
        return iForce;
    }

    public boolean removeImpulse(IForce iForce) {
        return this.impulses.remove(iForce);
    }

    public IConstraint addConstraint(IConstraint iConstraint) {
        this.constraints.add(iConstraint);
        return iConstraint;
    }

    public IConstraint addCollisionConstraint(IConstraint iConstraint) {
        this.collisionConstraints.add(iConstraint);
        return iConstraint;
    }

    public ConstraintSpring addConstraint(Particle particle, Particle particle2) {
        ConstraintSpring constraintSpring = new ConstraintSpring(particle, particle2);
        this.constraints.add(constraintSpring);
        return constraintSpring;
    }

    public ConstraintSpring addConstraint(Particle particle, Particle particle2, double d) {
        ConstraintSpring constraintSpring = new ConstraintSpring(particle, particle2);
        constraintSpring.stiffness = d;
        this.constraints.add(constraintSpring);
        return constraintSpring;
    }

    public boolean removeConstraint(IConstraint iConstraint) {
        return this.constraints.remove(iConstraint) || this.collisionConstraints.remove(iConstraint);
    }

    public Particle addParticle(Particle particle) {
        this.particles.add(particle);
        return particle;
    }

    public Particle addParticle(Vector3d vector3d, double d) {
        Particle particle = new Particle(vector3d, d);
        this.particles.add(particle);
        return particle;
    }

    public Particle addParticle(double d, double d2, double d3, double d4) {
        Vector3d vector3d = new Vector3d();
        vector3d.set(d, d2, d3);
        Particle particle = new Particle(vector3d, d4);
        this.particles.add(particle);
        return particle;
    }

    public void removeParticle(Particle particle) {
        this.particles.remove(particle);
    }

    public Iterator<Particle> particleIterator() {
        return this.particles.iterator();
    }

    public Iterator<IConstraint> constraintIterator() {
        return this.constraints.iterator();
    }

    public Iterator<IConstraint> collisionConstraintIterator() {
        return this.collisionConstraints.iterator();
    }

    public Iterator<IForce> forceIterator() {
        return this.forces.iterator();
    }

    public Iterator<IForce> impulseIterator() {
        return this.impulses.iterator();
    }

    public void leaveIterator() {
        this.taken = false;
    }

    public Particle[] particleArray() {
        return this.particles.toArray(new Particle[0]);
    }

    public IConstraint[] constraintArray() {
        return this.particles.toArray(new ConstraintSpring[0]);
    }

    public IForce[] forceArray() {
        return this.particles.toArray(new IForce[0]);
    }

    @Override
    public void update(float f) {
        this.setAccelerationOnAllParticles(this.gravity);
        this.applyForces();
        this.applyImpulses(f);
        while ((double)f > this.maximumTimeStep) {
            this.integrate(this.maximumTimeStep);
            this.satisfyConstraints(this.maximumTimeStep);
            f = (float)((double)f - this.maximumTimeStep);
        }
        this.integrate(f);
        this.satisfyConstraints(f);
        this.updateCoordinateFrame();
        this.updateDebugNode();
    }

    public void multiplyConstraintStiffness(double d) {
        for (IConstraint iConstraint : this.constraints) {
            if (!(iConstraint instanceof ConstraintSpring)) continue;
            ((ConstraintSpring)iConstraint).setStiffness(((ConstraintSpring)iConstraint).getStiffness() * d);
        }
    }

    public void multiplyConstraintDamping(double d) {
        for (IConstraint iConstraint : this.constraints) {
            if (iConstraint instanceof ConstraintDamper) {
                ((ConstraintDamper)iConstraint).setStiffness(((ConstraintDamper)iConstraint).getStiffness() * d);
            }
            if (!(iConstraint instanceof ConstraintSpringDamped)) continue;
            ((ConstraintSpringDamped)iConstraint).setDamping(((ConstraintSpringDamped)iConstraint).getDamping() * d);
        }
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public Vector3d getGravity() {
        return this.gravity;
    }

    public void setGravity(Vector3d vector3d) {
        this.gravity = vector3d;
    }

    @Override
    public Vector3d getLocalTranslation() {
        return this.localTranslation;
    }

    @Override
    public Quaternion getLocalRotation() {
        return this.localRotation;
    }

    @Override
    public Vector3d getLocalScale() {
        return this.localScale;
    }

    @Override
    public Vector3d getWorldTranslation() {
        return this.getLocalTranslation();
    }

    @Override
    public Quaternion getWorldRotation() {
        return this.getLocalRotation();
    }

    @Override
    public Vector3d getWorldScale() {
        return this.getLocalScale();
    }

    public Node getDebugNode() {
        this.shouldUpdateDebugNode = true;
        this.updateDebugNode();
        return this.debugNode;
    }

    public void releaseDebugNode() {
        this.shouldUpdateDebugNode = false;
    }

    public void updateDebugNode() {
        if (!this.shouldUpdateDebugNode) {
            return;
        }
        if (this.debugNode == null) {
            this.debugNode = new Node("debugNode");
            this.debugNode.setLightCombineMode(0);
            this.debugSticks = new Line("debugSticks", this.fillVertexBufferForStickConstraints(), null, this.fillColorBufferForStickConstraints(), null);
            this.debugForces = new Line("debugForces", this.fillVertexBufferForForces(), null, null, null);
            this.debugParticles = new Point("debugParticles", this.fillVertexBufferForParticles(), null, null, null);
            this.debugCenterOfMass = new Point("debugCenterOfMass", BufferUtils.createVector3Buffer(1), null, null, null);
            BufferUtils.setInBuffer(this.getCenterOfMass(this.debugTempVec3d).toVector3f(this.tempVec), this.debugCenterOfMass.getVertexBuffer(0), 0);
            this.debugNode.attachChild(this.debugSticks);
            this.debugNode.attachChild(this.debugForces);
            this.debugNode.attachChild(this.debugParticles);
            this.debugNode.attachChild(this.debugCenterOfMass);
            this.debugSticks.setLineWidth(1.0f);
            this.debugForces.setDefaultColor(new ColorRGBA(0.0f, 0.7f, 0.0f, 1.0f));
            this.debugParticles.setPointSize(2.0f);
            this.debugParticles.setDefaultColor(new ColorRGBA(0.7f, 0.0f, 0.0f, 1.0f));
            this.debugCenterOfMass.setPointSize(3.0f);
            this.debugCenterOfMass.setDefaultColor(new ColorRGBA(0.0f, 0.0f, 0.75f, 1.0f));
        } else {
            this.fillVertexBufferForStickConstraints(this.debugSticks.getVertexBuffer(0));
            this.fillColorBufferForStickConstraints(this.debugSticks.getColorBuffer(0));
            this.fillVertexBufferForForces(this.debugForces.getVertexBuffer(0));
            this.fillVertexBufferForParticles(this.debugParticles.getVertexBuffer(0));
            BufferUtils.setInBuffer(this.getCenterOfMass(null).toVector3f(this.tempVec), this.debugCenterOfMass.getVertexBuffer(0), 0);
        }
        if (this.debugNode.hasChild(this.debugSticks)) {
            if (!this.debugSticks.getVertexBuffer(0).hasRemaining()) {
                this.debugNode.detachChild(this.debugSticks);
            }
        } else if (this.debugSticks.getVertexBuffer(0).hasRemaining()) {
            this.debugNode.attachChild(this.debugSticks);
        }
        if (this.debugNode.hasChild(this.debugForces)) {
            if (!this.debugForces.getVertexBuffer(0).hasRemaining()) {
                this.debugNode.detachChild(this.debugForces);
            }
        } else if (this.debugForces.getVertexBuffer(0).hasRemaining()) {
            this.debugNode.attachChild(this.debugForces);
        }
        if (this.debugNode.hasChild(this.debugParticles)) {
            if (!this.debugParticles.getVertexBuffer(0).hasRemaining()) {
                this.debugNode.detachChild(this.debugParticles);
            }
        } else if (this.debugParticles.getVertexBuffer(0).hasRemaining()) {
            this.debugNode.attachChild(this.debugParticles);
        }
        if (this.debugNode.hasChild(this.debugCenterOfMass)) {
            if (!this.debugCenterOfMass.getVertexBuffer(0).hasRemaining()) {
                this.debugNode.detachChild(this.debugCenterOfMass);
            }
        } else if (this.debugCenterOfMass.getVertexBuffer(0).hasRemaining()) {
            this.debugNode.attachChild(this.debugCenterOfMass);
        }
    }

    public FloatBuffer fillVertexBufferForParticles(FloatBuffer floatBuffer) {
        if ((float)this.particles.size() <= (float)floatBuffer.capacity() / 3.0f) {
            floatBuffer.clear();
        } else {
            floatBuffer = BufferUtils.createVector3Buffer(this.particles.size());
        }
        for (Particle particle : this.particles) {
            particle.position.toVector3f(this.tempVec);
            floatBuffer.put(this.tempVec.x).put(this.tempVec.y).put(this.tempVec.z);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public FloatBuffer fillVertexBufferForParticles() {
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(this.particles.size());
        return this.fillVertexBufferForParticles(floatBuffer);
    }

    public FloatBuffer fillVertexBufferForStickConstraints(FloatBuffer floatBuffer) {
        if ((float)this.constraints.size() <= (float)floatBuffer.capacity() / 6.0f) {
            floatBuffer.clear();
        } else {
            floatBuffer = BufferUtils.createVector3Buffer(this.constraints.size() * 2);
        }
        for (IConstraint iConstraint : this.constraints) {
            if (!(iConstraint instanceof ConstraintStick)) continue;
            ConstraintStick constraintStick = (ConstraintStick)iConstraint;
            if (constraintStick.particles[0] == null || constraintStick.particles[1] == null || !constraintStick.active) continue;
            constraintStick.particles[0].position.toVector3f(this.tempVec);
            floatBuffer.put(this.tempVec.x).put(this.tempVec.y).put(this.tempVec.z);
            constraintStick.particles[1].position.toVector3f(this.tempVec);
            floatBuffer.put(this.tempVec.x).put(this.tempVec.y).put(this.tempVec.z);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public FloatBuffer fillVertexBufferForStickConstraints() {
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(this.constraints.size() * 2);
        return this.fillVertexBufferForStickConstraints(floatBuffer);
    }

    public FloatBuffer fillColorBufferForStickConstraints(FloatBuffer floatBuffer) {
        if ((float)this.constraints.size() <= (float)floatBuffer.capacity() / 8.0f) {
            floatBuffer.clear();
        } else {
            floatBuffer = BufferUtils.createColorBuffer(this.constraints.size() * 2);
        }
        for (IConstraint iConstraint : this.constraints) {
            if (!(iConstraint instanceof ConstraintStick)) continue;
            ConstraintStick constraintStick = (ConstraintStick)iConstraint;
            if (constraintStick.particles[0] == null || constraintStick.particles[1] == null || !constraintStick.active) continue;
            ColorRGBA colorRGBA = constraintStick.getDebugColor();
            if (colorRGBA != null) {
                floatBuffer.put(colorRGBA.r).put(colorRGBA.g).put(colorRGBA.b).put(colorRGBA.a);
                floatBuffer.put(colorRGBA.r).put(colorRGBA.g).put(colorRGBA.b).put(colorRGBA.a);
                continue;
            }
            floatBuffer.put(0.7f).put(0.0f).put(0.7f).put(1.0f).put(0.7f).put(0.0f).put(0.7f).put(1.0f);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public FloatBuffer fillColorBufferForStickConstraints() {
        FloatBuffer floatBuffer = BufferUtils.createColorBuffer(this.constraints.size() * 2);
        return this.fillVertexBufferForStickConstraints(floatBuffer);
    }

    public FloatBuffer fillVertexBufferForForces(FloatBuffer floatBuffer) {
        if ((float)this.forces.size() <= (float)floatBuffer.capacity() / 6.0f) {
            floatBuffer.clear();
        } else {
            floatBuffer = BufferUtils.createVector3Buffer(this.forces.size() * 2);
        }
        for (IForce iForce : this.forces) {
            Vector3d vector3d = iForce.getTarget().position;
            Vector3d vector3d2 = iForce.getDirection();
            double d = iForce.getMagnitude();
            if (vector3d == null || vector3d2 == null) continue;
            Vector3d vector3d3 = vector3d.add(vector3d2.normalize().mult(Math.abs(d) / 10.0));
            vector3d.toVector3f(this.tempVec);
            floatBuffer.put(this.tempVec.x).put(this.tempVec.y).put(this.tempVec.z);
            vector3d3.toVector3f(this.tempVec);
            floatBuffer.put(this.tempVec.x).put(this.tempVec.y).put(this.tempVec.z);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public FloatBuffer fillVertexBufferForForces() {
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(this.forces.size() * 2);
        return this.fillVertexBufferForForces(floatBuffer);
    }

    public double getMaximumTimeStep() {
        return this.maximumTimeStep;
    }

    public void setMaximumTimeStep(double d) {
        this.maximumTimeStep = d;
    }

    public boolean isLockedZ() {
        return this.lockedZ;
    }

    public void setLockedZ(boolean bl) {
        this.lockedZ = bl;
    }

    public ArrayList<Particle> getParticles() {
        return this.particles;
    }

    public double getDamp() {
        return this.damp;
    }

    public void setDamp(double d) {
        this.damp = d;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }
}

