/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.jme.scene.Node;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.physics.particle.ParticleObjectEffect;
import com.turborilla.physics.particle.ParticleSystem;

public class ParticleEffectsSystem
extends ParticleSystem {
    private Node node;
    private float wantedTimeStep = 0.01666f;
    private float elapsedTime = 0.0f;

    public ParticleEffectsSystem(String string) {
        this.node = new Node(string + ":node");
    }

    public void update(float f) {
        if (this.paused) {
            return;
        }
        this.elapsedTime += f;
        if (this.elapsedTime >= this.wantedTimeStep) {
            this.elapsedTime -= this.wantedTimeStep;
            for (int i = 0; i < this.getParticleObjects().size(); ++i) {
                ParticleObject particleObject = this.getParticleObjects().get(i);
                if (particleObject.isPaused()) continue;
                particleObject.integrate(this.wantedTimeStep);
                particleObject.satisfyConstraints(this.wantedTimeStep);
            }
        }
    }

    public void addParticleObject(ParticleObjectEffect particleObjectEffect) {
        this.node.attachChild(particleObjectEffect.getNode());
        this.getParticleObjects().add(particleObjectEffect);
    }

    public void removeAll() {
        this.node.detachAllChildren();
        super.removeAll();
    }

    public boolean removeParticleObject(ParticleObjectEffect particleObjectEffect) {
        this.node.detachChild(particleObjectEffect.getNode());
        return super.removeParticleObject(particleObjectEffect);
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public float getWantedTimeStep() {
        return this.wantedTimeStep;
    }

    public void setWantedTimeStep(float f) {
        this.wantedTimeStep = f;
    }
}

