/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.IForce;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;

public class ForceTorqueVector
implements IForce {
    Particle target;
    Vector3d axis;
    Particle center;
    protected Vector3d forceVector = new Vector3d();
    private static Vector3d radiusVector = new Vector3d();
    private static Vector3d tempVector = new Vector3d();
    protected double magnitude;
    boolean once = false;

    public void init(Particle particle, Particle particle2, Vector3d vector3d, double d) {
        this.target = particle;
        this.center = particle2;
        this.axis = vector3d;
        this.magnitude = d;
    }

    public void apply() {
        radiusVector.set(this.center.position).subtractLocal(this.target.position);
        tempVector.set(this.axis).normalizeLocal();
        this.forceVector.set(radiusVector).crossLocal(tempVector);
        this.forceVector.normalizeLocal();
        this.forceVector.multLocal(this.magnitude);
        this.target.applyForce(this.forceVector);
    }

    public Vector3d getAxis() {
        return this.axis;
    }

    public void setAxis(Vector3d vector3d) {
        this.axis = vector3d;
    }

    public Particle getCenter() {
        return this.center;
    }

    public void setCenter(Particle particle) {
        this.center = particle;
    }

    public Particle getTarget() {
        return this.target;
    }

    public void setTarget(Particle particle) {
        this.target = particle;
    }

    public Vector3d getForceVector() {
        return this.forceVector;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(double d) {
        this.magnitude = d;
    }

    public boolean once() {
        return this.once;
    }

    public void setOnce(boolean bl) {
        this.once = bl;
    }

    public Vector3d getDirection() {
        return this.forceVector;
    }
}

