/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.jme.renderer.ColorRGBA;
import com.turborilla.TransformationProvider;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.util.concurrent.Callable;

public class ConstraintStick
implements IConstraint,
TransformationProvider {
    protected Particle[] particles;
    protected double currentLength = -1.0;
    protected double restLength;
    private ColorRGBA debugColor = null;
    protected static final double ZERO = 1.0E-8;
    protected static final double ZERO2 = 1.0000000000000001E-16;
    private String name;
    protected double threshold;
    protected Callable callWhenStressed = null;
    protected static Vector3d scratch = new Vector3d();
    protected static Vector3d scratch2 = new Vector3d();
    protected boolean active = true;
    protected Quaternion localRotation;
    protected static Vector3d xAxis;
    protected static Vector3d yAxis;
    protected static Vector3d zAxis;
    protected Vector3d localTranslation = new Vector3d();

    public ConstraintStick() {
        this.particles = new Particle[2];
    }

    public ConstraintStick(Particle particle, Particle particle2) {
        this.particles = new Particle[2];
        this.init(particle, particle2);
    }

    public void satisfy(double d) {
        if (this.active) {
            scratch.set(this.particles[1].position).subtractLocal(this.particles[0].position);
            if (scratch.lengthSquared() < 1.0E-8) {
                return;
            }
            this.currentLength = scratch.length();
            double d2 = (this.currentLength - this.restLength) / (this.currentLength * (this.particles[0].invWeight + this.particles[1].invWeight));
            scratch2.set(scratch).multLocal(this.particles[0].invWeight * d2);
            this.particles[0].position.addLocal(scratch2);
            this.particles[1].position.subtractLocal(scratch.multLocal(this.particles[1].invWeight * d2));
            this.checkStress();
        }
    }

    public void init(Particle particle, Particle particle2) {
        this.particles[0] = particle;
        this.particles[1] = particle2;
        scratch.set(this.particles[0].position).subtractLocal(this.particles[1].position);
        this.restLength = scratch.length();
    }

    public void initStressCall(double d, Callable callable) {
        this.threshold = d;
        this.callWhenStressed = callable;
    }

    protected void checkStress() {
        double d;
        if (this.callWhenStressed != null && Math.abs(d = (this.currentLength - this.restLength) / this.restLength) > this.threshold) {
            try {
                this.callWhenStressed.call();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public double getCurrentLength() {
        return this.currentLength >= 0.0 ? this.currentLength : scratch.set(this.particles[1].position).subtractLocal(this.particles[0].position).length();
    }

    public double getRestLength() {
        return this.restLength;
    }

    public void setRestLength(double d) {
        this.restLength = d;
    }

    public Particle[] getParticles() {
        return this.particles;
    }

    public void setParticles(Particle[] particleArray) {
        this.particles = particleArray;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getActive() {
        return this.active;
    }

    public Vector3d getLocalTranslation() {
        this.localTranslation.set(this.particles[1].position).addLocal(this.particles[0].position).multLocal(0.5);
        return this.localTranslation;
    }

    public Quaternion getLocalRotation() {
        if (this.localRotation == null) {
            this.localRotation = new Quaternion();
            xAxis = new Vector3d();
            yAxis = new Vector3d();
            zAxis = new Vector3d(0.0, 0.0, 1.0);
        }
        yAxis.set(this.particles[1].position).subtractLocal(this.particles[0].position).normalizeLocal();
        xAxis.set(yAxis).crossLocal(zAxis).normalizeLocal();
        this.localRotation.fromAxes(xAxis, yAxis, zAxis);
        return this.localRotation;
    }

    public Vector3d getLocalScale() {
        return scratch.set(1.0, this.getCurrentLength() / this.restLength, 1.0);
    }

    public Vector3d getWorldTranslation() {
        return this.getLocalTranslation();
    }

    public Quaternion getWorldRotation() {
        return this.getLocalRotation();
    }

    public Vector3d getWorldScale() {
        return this.getLocalScale();
    }

    public Callable getCallWhenStressed() {
        return this.callWhenStressed;
    }

    public void setCallWhenStressed(Callable callable) {
        this.callWhenStressed = callable;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public ColorRGBA getDebugColor() {
        return this.debugColor;
    }

    public void setDebugColor(ColorRGBA colorRGBA) {
        this.debugColor = colorRGBA;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

