/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.ConstraintSpringDamped;
import com.turborilla.physics.particle.Particle;

public class ConstraintPullingSpringDamped
extends ConstraintSpringDamped {
    public ConstraintPullingSpringDamped(Particle particle, Particle particle2) {
        super(particle, particle2);
    }

    public ConstraintPullingSpringDamped(Particle particle, Particle particle2, double d) {
        this(particle, particle2);
        this.setDamping(d);
    }

    public void satisfy(double d) {
        if (this.active) {
            scratch.set(this.particles[1].position).subtractLocal(this.particles[0].position);
            this.currentLength = scratch.length();
            double d2 = this.currentLength - this.restLength;
            if (d2 > 0.0) {
                d2 = d2 * this.stiffness * d / (this.currentLength * (this.particles[0].invWeight + this.particles[1].invWeight));
                scratch2.set(scratch).multLocal(this.particles[0].invWeight * d2);
                this.particles[0].position.addLocal(scratch2);
                scratch.multLocal(-this.particles[1].invWeight * d2);
                this.particles[1].position.addLocal(scratch);
                v0.set(this.particles[0].position).subtractLocal(this.particles[0].oldPosition);
                v1.set(this.particles[1].position).subtractLocal(this.particles[1].oldPosition);
                dampAxis.set(this.particles[1].position).subtractLocal(this.particles[0].position);
                dampAxis.normalizeLocal();
                relVel.set(v1).subtractLocal(v0);
                relVel.set(dampAxis.multLocal(relVel.dot(dampAxis) * this.damping * d));
                if (relVel.lengthSquared() > 1.0000000000000001E-16) {
                    v0.set(relVel).multLocal(this.particles[0].invWeight);
                    this.particles[0].position.addLocal(v0);
                    this.particles[1].position.subtractLocal(relVel.multLocal(this.particles[1].invWeight));
                }
                this.checkStress();
            }
        }
    }
}

