/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.turborilla.physics.particle.ConstraintSpring;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;

public class ConstraintParallel
implements IConstraint {
    Particle target;
    Particle secondary;
    Particle axis1;
    Particle axis2;
    private static Vector3d tempVector = new Vector3d();
    private static Vector3d tempVector2 = new Vector3d();
    protected double stiffness = 70.0;
    boolean active = true;

    public ConstraintParallel() {
    }

    public ConstraintParallel(Particle particle, Particle particle2, ConstraintSpring constraintSpring) {
        this.init(particle, particle2, constraintSpring);
    }

    public ConstraintParallel(Particle particle, Particle particle2, Particle particle3, Particle particle4) {
        this.init(particle, particle2, particle3, particle4);
    }

    public void init(Particle particle, Particle particle2, ConstraintSpring constraintSpring) {
        this.target = particle;
        this.secondary = particle2;
        this.axis1 = constraintSpring.particles[0];
        this.axis2 = constraintSpring.particles[1];
    }

    public void init(Particle particle, Particle particle2, Particle particle3, Particle particle4) {
        this.target = particle;
        this.secondary = particle2;
        this.axis1 = particle3;
        this.axis2 = particle4;
    }

    public void satisfy(double d) {
        if (this.active) {
            tempVector.set(this.axis1.position).subtractLocal(this.axis2.position);
            tempVector.normalizeLocal();
            tempVector2.set(this.target.position).subtractLocal(this.secondary.position);
            double d2 = tempVector2.length();
            tempVector.multLocal(d2);
            if (tempVector.dot(tempVector2) < 0.0) {
                tempVector.multLocal(-1.0);
            }
            tempVector.subtractLocal(tempVector2);
            this.target.position.addLocal(tempVector.mult(this.stiffness * d));
        }
    }

    public void setStiffness(double d) {
        this.stiffness = d;
    }

    public double getStiffness() {
        return this.stiffness;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getActive() {
        return this.active;
    }
}

