/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.particle;

import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class ConstraintMesh
implements IConstraint {
    private TriMesh mesh;
    private Particle particle;
    private double stiffness = 1.0;
    private int batchIndex;
    private boolean interpolateNormals;
    private Vector3f tempVec1;
    private Vector3f tempVec2;
    private Vector3f triNormal;
    private boolean penetrating = false;
    private Vector3d penetrationNormal;
    boolean active = true;

    public ConstraintMesh(Particle particle, TriMesh triMesh, int n) {
        this.particle = particle;
        this.mesh = triMesh;
        this.batchIndex = n;
        this.interpolateNormals = false;
        this.tempVec1 = new Vector3f();
        this.tempVec2 = new Vector3f();
        this.triNormal = new Vector3f();
    }

    public void satisfy(double d) {
        if (!this.active) {
            return;
        }
        int[] nArray = new int[3];
        Vector3d vector3d = this.particle.position;
        Vector3d vector3d2 = this.particle.oldPosition;
        Vector3d vector3d3 = vector3d;
        Vector3d vector3d4 = !this.penetrating ? vector3d2.subtract(vector3d).normalizeLocal() : this.penetrationNormal;
        Ray ray = new Ray(vector3d3.toVector3f(null), vector3d4.toVector3f(null));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.mesh.findTrianglePick(ray, arrayList, this.batchIndex);
        TriangleBatch triangleBatch = this.mesh.getBatch(this.batchIndex);
        if (!arrayList.isEmpty()) {
            Vector3f[] vector3fArray = new Vector3f[3];
            int n = arrayList.get(0);
            triangleBatch.getTriangle(n, vector3fArray);
            vector3fArray[0] = this.mesh.getWorldRotation().mult(vector3fArray[0]);
            vector3fArray[1] = this.mesh.getWorldRotation().mult(vector3fArray[1]);
            vector3fArray[2] = this.mesh.getWorldRotation().mult(vector3fArray[2]);
            vector3fArray[0] = this.mesh.getWorldTranslation().add(vector3fArray[0]);
            vector3fArray[1] = this.mesh.getWorldTranslation().add(vector3fArray[1]);
            vector3fArray[2] = this.mesh.getWorldTranslation().add(vector3fArray[2]);
            Vector3d vector3d5 = new Vector3d(0.0, 0.0, 0.0);
            boolean bl = ray.intersectWherePlanar(vector3fArray[0], vector3fArray[1], vector3fArray[2], vector3d5.toVector3f(null));
            if (!bl) {
                this.penetrating = false;
                this.penetrationNormal = null;
            } else {
                if (!this.penetrating && vector3d5.x * vector3d5.x < vector3d2.subtract(vector3d).lengthSquared()) {
                    this.penetrating = true;
                }
                if (this.penetrating) {
                    triangleBatch.getTriangle(n, nArray);
                    if (this.interpolateNormals) {
                        this.triNormal.set(this.getNormalAtPointOnTriangle(nArray, triangleBatch.getNormalBuffer(), vector3d5.y, vector3d5.z));
                    } else {
                        vector3fArray[0].subtract(vector3fArray[1], this.tempVec1);
                        vector3fArray[0].subtract(vector3fArray[2], this.tempVec2);
                        this.tempVec1.cross(this.tempVec2, this.triNormal);
                        this.triNormal.normalizeLocal();
                    }
                    this.penetrationNormal = new Vector3d(this.triNormal);
                    this.particle.position.set(this.particle.oldPosition);
                }
            }
        }
    }

    private Vector3f getNormalAtPointOnTriangle(int[] nArray, FloatBuffer floatBuffer, double d, double d2) {
        Vector3f[] vector3fArray = new Vector3f[3];
        for (int i = 0; i < 3; ++i) {
            vector3fArray[i] = new Vector3f();
            BufferUtils.populateFromBuffer(vector3fArray[i], floatBuffer, nArray[i]);
        }
        float f = 1.0f - (float)d - (float)d2;
        float f2 = (float)d;
        float f3 = (float)d2;
        return vector3fArray[0].mult(f).add(vector3fArray[1].mult(f2).add(vector3fArray[2].mult(f3)));
    }

    public void setStiffness(double d) {
        this.stiffness = d;
    }

    public double getStiffness() {
        return this.stiffness;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getActive() {
        return this.active;
    }

    public TriMesh getMesh() {
        return this.mesh;
    }

    public void setMesh(TriMesh triMesh) {
        this.mesh = triMesh;
    }

    public boolean isInterpolateNormals() {
        return this.interpolateNormals;
    }

    public void setInterpolateNormals(boolean bl) {
        this.interpolateNormals = bl;
    }
}

