/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.collision;

import com.jme.math.Vector3f;
import com.turborilla.physics.collision.CollisionPrimitive;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.physics.collision.Plane;
import com.turborilla.utils.math.Vector3d;

public class Triangle
implements CollisionPrimitive {
    Plane plane;
    Plane edgePlaneBC;
    Plane edgePlaneCA;
    private static Vector3d tempVec = new Vector3d();
    private static final double ZERO = 0.001;

    public Triangle(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.init(vector3d, vector3d2, vector3d3);
    }

    public Triangle(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Vector3d vector3d = new Vector3d(vector3f);
        Vector3d vector3d2 = new Vector3d(vector3f2);
        Vector3d vector3d3 = new Vector3d(vector3f3);
        this.init(vector3d, vector3d2, vector3d3);
    }

    private void init(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Vector3d vector3d4 = vector3d2.subtract(vector3d).crossLocal(vector3d3.subtract(vector3d)).normalizeLocal();
        this.plane = new Plane(vector3d4, vector3d);
        this.edgePlaneBC = new Plane(vector3d4.cross(vector3d3.subtract(vector3d2)), vector3d2);
        this.edgePlaneCA = new Plane(vector3d4.cross(vector3d.subtract(vector3d3)), vector3d3);
        this.edgePlaneBC.multLocal(1.0 / (vector3d.dot(this.edgePlaneBC.normal) - this.edgePlaneBC.d));
        this.edgePlaneCA.multLocal(1.0 / (vector3d2.dot(this.edgePlaneCA.normal) - this.edgePlaneCA.d));
    }

    public boolean intersectSegment(Vector3d vector3d, Vector3d vector3d2, IntersectionResult intersectionResult) {
        double d = vector3d2.dot(this.plane.normal) - this.plane.d;
        if (d >= 0.001) {
            return false;
        }
        double d2 = vector3d.dot(this.plane.normal) - this.plane.d;
        if (d2 < -0.001) {
            return false;
        }
        double d3 = d2 - d;
        intersectionResult.t = d2 / d3;
        intersectionResult.s.set(vector3d).addLocal(tempVec.set(vector3d2).subtractLocal(vector3d).multLocal(intersectionResult.t));
        intersectionResult.u = intersectionResult.s.dot(this.edgePlaneBC.normal) - this.edgePlaneBC.d;
        if (intersectionResult.u < -0.001 || intersectionResult.u > 1.001) {
            return false;
        }
        intersectionResult.v = intersectionResult.s.dot(this.edgePlaneCA.normal) - this.edgePlaneCA.d;
        if (intersectionResult.v < -0.001) {
            return false;
        }
        intersectionResult.w = 1.0 - intersectionResult.u - intersectionResult.v;
        if (intersectionResult.w < -0.001) {
            return false;
        }
        intersectionResult.normal.set(this.plane.normal);
        return true;
    }
}

