/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.collision;

import com.turborilla.physics.collision.CollisionPrimitive;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.utils.math.BoundingBox;
import com.turborilla.utils.math.Vector3d;

public class Plane
implements CollisionPrimitive {
    public Vector3d normal;
    public double d;
    private static Vector3d tempVec = new Vector3d();
    private static final double ZERO = 0.001;

    public Plane(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.normal = vector3d2.subtract(vector3d).crossLocal(vector3d3.subtract(vector3d)).normalizeLocal();
        this.d = this.normal.dot(vector3d);
    }

    public Plane(Vector3d vector3d, Vector3d vector3d2) {
        this.normal = vector3d;
        this.d = vector3d.dot(vector3d2);
    }

    public Plane(Vector3d vector3d, double d) {
        this.normal = vector3d;
        this.d = d;
    }

    public void set(Vector3d vector3d, Vector3d vector3d2) {
        this.normal.x = vector3d.x;
        this.normal.y = vector3d.y;
        this.normal.z = vector3d.z;
        this.d = vector3d.dot(vector3d2);
    }

    public boolean intersectAABB(BoundingBox boundingBox) {
        double d = boundingBox.xExtent * Math.abs(this.normal.x) + boundingBox.yExtent * Math.abs(this.normal.y) + boundingBox.zExtent * Math.abs(this.normal.z);
        double d2 = this.normal.dot(boundingBox.getCenter()) - this.d;
        return d2 <= d && d2 >= -d;
    }

    public boolean intersectSegment(Vector3d vector3d, Vector3d vector3d2, IntersectionResult intersectionResult) {
        double d = vector3d2.dot(this.normal) - this.d;
        if (d >= 0.001) {
            return false;
        }
        double d2 = vector3d.dot(this.normal) - this.d;
        if (d2 < -0.001) {
            return false;
        }
        double d3 = d2 - d;
        intersectionResult.t = d2 / d3;
        intersectionResult.s.set(vector3d).addLocal(tempVec.set(vector3d2).subtractLocal(vector3d).multLocal(intersectionResult.t));
        intersectionResult.normal.set(this.normal);
        return true;
    }

    public void normalizeLocal() {
        double d = 1.0 / this.normal.length();
        this.normal.multLocal(d);
        this.d *= d;
    }

    public void multLocal(double d) {
        this.normal.multLocal(d);
        this.d *= d;
    }

    public Plane() {
        this.normal = new Vector3d();
        this.d = 0.0;
    }

    public double getD() {
        return this.d;
    }

    public void setD(double d) {
        this.d = d;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public void setNormal(Vector3d vector3d) {
        this.normal = vector3d;
    }
}

