/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.physics.collision;

import com.turborilla.TransformationProvider;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.util.ArrayList;

public abstract class AbstractCollisionStructure
implements CollisionStructure {
    private TransformationProvider transformationProvider = null;
    private ArrayList<CollisionStructure> childGrids = new ArrayList();
    private static Vector3d tempP = new Vector3d();
    private static Vector3d tempQ = new Vector3d();
    private static Quaternion invRot = new Quaternion();
    private static Vector3d invScale = new Vector3d();

    public abstract boolean intersectSegmentLocal(Vector3d var1, Vector3d var2, IntersectionResult var3);

    public boolean intersectSegment(Vector3d vector3d, Vector3d vector3d2, IntersectionResult intersectionResult) {
        if (this.transformationProvider != null) {
            invRot.set(this.transformationProvider.getWorldRotation()).inverseLocal();
            invScale.set(this.transformationProvider.getWorldScale());
            AbstractCollisionStructure.invScale.x = 1.0 / AbstractCollisionStructure.invScale.x;
            AbstractCollisionStructure.invScale.y = 1.0 / AbstractCollisionStructure.invScale.y;
            AbstractCollisionStructure.invScale.z = 1.0 / AbstractCollisionStructure.invScale.z;
            vector3d.subtract(this.transformationProvider.getWorldTranslation(), tempP).multLocal(invScale);
            invRot.mult(tempP, tempP);
            vector3d2.subtract(this.transformationProvider.getWorldTranslation(), tempQ).multLocal(invScale);
            invRot.mult(tempQ, tempQ);
            if (this.intersectSegmentLocal(tempP, tempQ, intersectionResult)) {
                Vector3d vector3d3 = intersectionResult.normal;
                this.transformationProvider.getWorldRotation().mult(vector3d3, vector3d3);
                this.transformationProvider.getWorldRotation().mult(intersectionResult.s.multLocal(this.transformationProvider.getWorldScale()), intersectionResult.s).addLocal(this.transformationProvider.getWorldTranslation());
                return true;
            }
        } else if (this.intersectSegmentLocal(vector3d, vector3d2, intersectionResult)) {
            return true;
        }
        if (this.childGrids != null) {
            for (int i = 0; i < this.childGrids.size(); ++i) {
                if (!this.childGrids.get(i).intersectSegment(vector3d, vector3d2, intersectionResult)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean addChild(CollisionStructure collisionStructure) {
        return this.childGrids.add(collisionStructure);
    }

    public void clearChildren() {
        this.childGrids.clear();
    }

    public boolean removeChild(CollisionStructure collisionStructure) {
        return this.childGrids.remove(collisionStructure);
    }

    public TransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(TransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
    }
}

