/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.utils;

import com.catnapgames.winfolders.WinFoldersJava;
import com.turborilla.utils.folders.SystemFolder;
import java.io.File;
import java.util.logging.Logger;
import org.lwjgl.LWJGLUtil;

public class SystemFolderGetter
implements com.turborilla.utils.folders.SystemFolderGetter {
    private static Logger logger = Logger.getLogger(SystemFolderGetter.class.getCanonicalName());
    private String gameName;
    private boolean windowsSpecialFolderFailed = false;
    private boolean careAboutWindows = true;

    public SystemFolderGetter(String string) {
        this.gameName = string;
        SystemFolder.setFolderFactory(this);
        if (this.isWindows()) {
            System.load(new File("").getAbsolutePath() + File.separator + "lib" + File.separator + "WinFoldersJava-1.0.dll");
        }
    }

    public String getSavegameFolder(String string) {
        return this.appendGameNameAndPath(this.getApplicationData(), "profiles" + File.separator + (string != null ? string : ""));
    }

    public String getScreenshotFolder(String string) {
        return this.appendGameNameAndPath(this.getMyDocuments(), "screenshots" + File.separator + (string != null ? string : ""));
    }

    public String getUserCreatedContentFolder(String string) {
        return this.appendGameNameAndPath(this.getMyDocuments(), string != null ? string : "");
    }

    public String getReplayFolder(String string) {
        return this.appendGameNameAndPath(this.getApplicationData(), "replays" + File.separator + (string != null ? string : ""));
    }

    public String getTempFolder(String string) {
        return this.appendGameNameAndPath(this.getTempDir(), "msm-" + this.getUserName() + File.separator + (string != null ? string : ""));
    }

    public String getApplicationDataFolder(String string) {
        return this.appendGameNameAndPath(this.getApplicationData(), string != null ? string : "");
    }

    private String getMyDocuments() {
        String string = null;
        string = this.isWindows() ? this.getSpecialFolderPath(5) : this.getUserHome();
        return string;
    }

    private boolean isWindows() {
        return LWJGLUtil.getPlatform() == 3 && this.careAboutWindows && !this.windowsSpecialFolderFailed;
    }

    private String getApplicationData() {
        String string = null;
        string = this.isWindows() ? this.getSpecialFolderPath(28) : this.getUserHome();
        return string;
    }

    private String getTempDir() {
        String string = null;
        string = System.getProperty("java.io.tmpdir");
        return string;
    }

    private String getUserHome() {
        return System.getProperty("user.home");
    }

    private String getUserName() {
        return System.getProperty("user.name");
    }

    private String getSpecialFolderPath(int n) {
        String string = null;
        try {
            string = WinFoldersJava.getSpecialFolderPath(n);
        }
        catch (Exception exception) {
            this.windowsSpecialFolderFailed = true;
            logger.severe("WinFoldersJava.getSpecialFolderPath(" + n + ") failed. Reverting back to \"user.home\".");
            string = this.getUserHome();
        }
        return string;
    }

    private String appendGameNameAndPath(String string, String string2) {
        String string3 = null;
        String string4 = File.separator;
        String string5 = File.separator;
        if (string2 == null) {
            string5 = "";
            string2 = "";
        }
        if (string2.length() <= 0 || string2.charAt(string2.length() - 1) == File.separatorChar) {
            string5 = "";
        }
        string3 = this.isWindows() ? string + string4 + this.gameName + string4 + string2 + string5 : string + string4 + this.gameName + string4 + string2 + string5;
        return string3;
    }

    public boolean isCareAboutWindows() {
        return this.careAboutWindows;
    }

    public void setCareAboutWindows(boolean bl) {
        this.careAboutWindows = bl;
    }
}

