/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.utils;

import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.CameraNode;
import com.turborilla.TransformationProvider;

public class ProviderFollowingCameraNode
extends CameraNode {
    protected TransformationProvider transformationProvider;
    protected Vector3f cameraSpeed;
    protected Vector3f cameraSlackMax;
    protected Vector3f cameraSlackMin;
    protected Vector3f translationBias;
    protected Vector3f preferredPosWhileInsideSlack;
    protected Vector3f speedForPreferredPos;
    protected Vector3f providerMaximum;
    protected Vector3f providerMinimum;
    protected float delay = 1.0f;
    private static Vector3f cameraToProvider = new Vector3f();
    private static Vector3f cameraToPreferred = new Vector3f();

    public ProviderFollowingCameraNode(TransformationProvider transformationProvider, Vector3f vector3f) {
        this.setCameraSpeed(vector3f);
        this.setTransformationProvider(transformationProvider);
        this.translationBias = null;
        this.cameraSlackMin = null;
        this.cameraSlackMax = null;
        this.preferredPosWhileInsideSlack = null;
        this.speedForPreferredPos = null;
        this.providerMinimum = null;
        this.providerMaximum = null;
    }

    public ProviderFollowingCameraNode(String string, Camera camera, TransformationProvider transformationProvider, Vector3f vector3f) {
        super(string, camera);
        this.setCameraSpeed(vector3f);
        this.setTransformationProvider(transformationProvider);
        this.translationBias = null;
        this.cameraSlackMin = null;
        this.cameraSlackMax = null;
        this.preferredPosWhileInsideSlack = null;
        this.speedForPreferredPos = new Vector3f();
        this.providerMinimum = null;
        this.providerMaximum = null;
    }

    public ProviderFollowingCameraNode(String string, Camera camera) {
        this(string, camera, null, null);
    }

    public void updateWorldData(float f) {
        if (this.transformationProvider != null && this.cameraSpeed != null) {
            this.transformationProvider.getWorldTranslation().toVector3f(cameraToProvider);
            if (this.providerMaximum != null) {
                ProviderFollowingCameraNode.cameraToProvider.x = Math.min(ProviderFollowingCameraNode.cameraToProvider.x, this.providerMaximum.x);
                ProviderFollowingCameraNode.cameraToProvider.y = Math.min(ProviderFollowingCameraNode.cameraToProvider.y, this.providerMaximum.y);
                ProviderFollowingCameraNode.cameraToProvider.z = Math.min(ProviderFollowingCameraNode.cameraToProvider.z, this.providerMaximum.z);
            }
            if (this.providerMinimum != null) {
                ProviderFollowingCameraNode.cameraToProvider.x = Math.max(ProviderFollowingCameraNode.cameraToProvider.x, this.providerMinimum.x);
                ProviderFollowingCameraNode.cameraToProvider.y = Math.max(ProviderFollowingCameraNode.cameraToProvider.y, this.providerMinimum.y);
                ProviderFollowingCameraNode.cameraToProvider.z = Math.max(ProviderFollowingCameraNode.cameraToProvider.z, this.providerMinimum.z);
            }
            cameraToProvider.subtractLocal(this.localTranslation);
            cameraToPreferred.set(0.0f, 0.0f, 0.0f);
            if (this.translationBias != null) {
                cameraToProvider.addLocal(this.translationBias);
            }
            if (this.cameraSlackMin != null) {
                if (this.cameraSpeed.x > 1.0E-4f) {
                    if (ProviderFollowingCameraNode.cameraToProvider.x >= this.cameraSlackMax.x) {
                        ProviderFollowingCameraNode.cameraToProvider.x -= this.cameraSlackMax.x;
                    } else if (ProviderFollowingCameraNode.cameraToProvider.x <= this.cameraSlackMin.x) {
                        ProviderFollowingCameraNode.cameraToProvider.x -= this.cameraSlackMin.x;
                    } else {
                        if (this.speedForPreferredPos.x > 1.0E-4f) {
                            ProviderFollowingCameraNode.cameraToPreferred.x = this.preferredPosWhileInsideSlack.x - this.localTranslation.x;
                            ProviderFollowingCameraNode.cameraToPreferred.x *= this.speedForPreferredPos.x * f;
                            ProviderFollowingCameraNode.cameraToProvider.x -= ProviderFollowingCameraNode.cameraToPreferred.x;
                            if (ProviderFollowingCameraNode.cameraToProvider.x >= this.cameraSlackMax.x) {
                                ProviderFollowingCameraNode.cameraToPreferred.x += ProviderFollowingCameraNode.cameraToProvider.x - this.cameraSlackMax.x;
                            } else if (ProviderFollowingCameraNode.cameraToProvider.x <= this.cameraSlackMin.x) {
                                ProviderFollowingCameraNode.cameraToPreferred.x += ProviderFollowingCameraNode.cameraToProvider.x - this.cameraSlackMin.x;
                            }
                        }
                        ProviderFollowingCameraNode.cameraToProvider.x = 0.0f;
                    }
                }
                if (this.cameraSpeed.y > 1.0E-4f) {
                    if (ProviderFollowingCameraNode.cameraToProvider.y >= this.cameraSlackMax.y) {
                        ProviderFollowingCameraNode.cameraToProvider.y -= this.cameraSlackMax.y;
                    } else if (ProviderFollowingCameraNode.cameraToProvider.y <= this.cameraSlackMin.y) {
                        ProviderFollowingCameraNode.cameraToProvider.y -= this.cameraSlackMin.y;
                    } else {
                        if (this.speedForPreferredPos.y > 1.0E-4f) {
                            ProviderFollowingCameraNode.cameraToPreferred.y = this.preferredPosWhileInsideSlack.y - this.localTranslation.y;
                            ProviderFollowingCameraNode.cameraToPreferred.y *= this.speedForPreferredPos.y * f;
                            ProviderFollowingCameraNode.cameraToProvider.y -= ProviderFollowingCameraNode.cameraToPreferred.y;
                            if (ProviderFollowingCameraNode.cameraToProvider.y >= this.cameraSlackMax.y) {
                                ProviderFollowingCameraNode.cameraToPreferred.y += ProviderFollowingCameraNode.cameraToProvider.y - this.cameraSlackMax.y;
                            } else if (ProviderFollowingCameraNode.cameraToProvider.y <= this.cameraSlackMin.y) {
                                ProviderFollowingCameraNode.cameraToPreferred.y += ProviderFollowingCameraNode.cameraToProvider.y - this.cameraSlackMin.y;
                            }
                        }
                        ProviderFollowingCameraNode.cameraToProvider.y = 0.0f;
                    }
                }
                if (this.cameraSpeed.z > 1.0E-4f) {
                    if (ProviderFollowingCameraNode.cameraToProvider.z >= this.cameraSlackMax.z) {
                        ProviderFollowingCameraNode.cameraToProvider.z -= this.cameraSlackMax.z;
                    } else if (ProviderFollowingCameraNode.cameraToProvider.z <= this.cameraSlackMin.z) {
                        ProviderFollowingCameraNode.cameraToProvider.z -= this.cameraSlackMin.z;
                    } else {
                        if (this.speedForPreferredPos.z > 1.0E-4f) {
                            ProviderFollowingCameraNode.cameraToPreferred.z = this.preferredPosWhileInsideSlack.z - this.localTranslation.z;
                            ProviderFollowingCameraNode.cameraToPreferred.z *= this.speedForPreferredPos.z * f;
                            ProviderFollowingCameraNode.cameraToProvider.z -= ProviderFollowingCameraNode.cameraToPreferred.z;
                            if (ProviderFollowingCameraNode.cameraToProvider.z >= this.cameraSlackMax.z) {
                                ProviderFollowingCameraNode.cameraToPreferred.z += ProviderFollowingCameraNode.cameraToProvider.z - this.cameraSlackMax.z;
                            } else if (ProviderFollowingCameraNode.cameraToProvider.z <= this.cameraSlackMin.z) {
                                ProviderFollowingCameraNode.cameraToPreferred.z += ProviderFollowingCameraNode.cameraToProvider.z - this.cameraSlackMin.z;
                            }
                        }
                        ProviderFollowingCameraNode.cameraToProvider.z = 0.0f;
                    }
                }
            }
            cameraToProvider.multLocal(this.cameraSpeed).multLocal(f);
            this.localTranslation.addLocal(cameraToProvider);
            this.localTranslation.addLocal(cameraToPreferred);
        }
        super.updateWorldData(f);
    }

    public Vector3f getCameraSpeed() {
        return this.cameraSpeed;
    }

    public void setCameraSpeed(Vector3f vector3f) {
        this.cameraSpeed = vector3f;
    }

    public TransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(TransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
    }

    public Vector3f getTranslationBias() {
        return this.translationBias;
    }

    public void setTranslationBias(Vector3f vector3f) {
        this.translationBias = vector3f;
    }

    public Vector3f getPreferredPosWhileInsideSlack() {
        return this.preferredPosWhileInsideSlack;
    }

    public void setPreferredPosWhileInsideSlack(Vector3f vector3f) {
        this.preferredPosWhileInsideSlack = vector3f;
    }

    public Vector3f getSpeedForPreferredPos() {
        return this.speedForPreferredPos;
    }

    public void setSpeedForPreferredPos(Vector3f vector3f) {
        this.speedForPreferredPos = vector3f;
    }

    public Vector3f getProviderMaximum() {
        return this.providerMaximum;
    }

    public void setProviderMaximum(Vector3f vector3f) {
        this.providerMaximum = vector3f;
    }

    public Vector3f getProviderMinimum() {
        return this.providerMinimum;
    }

    public void setProviderMinimum(Vector3f vector3f) {
        this.providerMinimum = vector3f;
    }

    public Vector3f getCameraSlackMax() {
        return this.cameraSlackMax;
    }

    public void setCameraSlackMax(Vector3f vector3f) {
        this.cameraSlackMax = vector3f;
    }

    public Vector3f getCameraSlackMin() {
        return this.cameraSlackMin;
    }

    public void setCameraSlackMin(Vector3f vector3f) {
        this.cameraSlackMin = vector3f;
    }

    public void setCameraSlack(Vector3f vector3f) {
        this.cameraSlackMin = new Vector3f();
        this.cameraSlackMax = new Vector3f();
        this.cameraSlackMin.set(vector3f);
        this.cameraSlackMin.multLocal(-1.0f);
        this.cameraSlackMax.set(vector3f);
    }
}

