/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.track.challenges;

import com.turborilla.msm.rewards.stats.BackflipStat;
import com.turborilla.msm.track.challenges.AbstractChallenge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackflipChallenge
extends AbstractChallenge<Integer> {
    private int flips;
    private int seconds;

    public BackflipChallenge(int n, int n2) {
        this.flips = n;
        this.seconds = n2;
        this.name = "Backflip Challenge";
        String string = "";
        if (n > 1) {
            string = "s";
        }
        if (n2 > 0) {
            this.description = "You must do " + n + " backflip" + string + " in " + n2 + " seconds";
        } else {
            this.description = "You must do " + n + " backflip" + string + " during the race";
            this.seconds = Integer.MAX_VALUE;
        }
    }

    @Override
    protected void initChallenge() {
        this.setChallengeWatcher(new BackflipStat(1.5f, this.bike.getBikeParticleSystem(), (float)this.seconds / ((float)this.flips - 1.0f)));
    }

    @Override
    public void onFinalize(Comparable<Integer> comparable, Comparable<Integer> comparable2) {
        if (comparable2.compareTo(new Integer(this.flips)) >= 0) {
            this.setAchieved();
        }
    }
}

