/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.track;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.physics.collision.Collision1DHeightMap;
import com.turborilla.msm.physics.collision.CollisionGrid;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.track.Track;
import com.turborilla.msm.track.challenges.IChallenge;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.terrain.ImageHeightMap;
import com.turborilla.utils.math.Vector3d;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Track1D
extends Track
implements Externalizable,
Savable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger(Track1D.class.getName());
    private ImageHeightMap collisionHeightMap;
    private ImageHeightMap featureMap;
    private ImageHeightMap originalHeightMap;
    private ImageHeightMap originalFeatureMap;
    private int originalHeightMapStartsAt = -1;
    private float forceWidthAdder = 0.0f;
    private float lastRowAdder = 160.0f;
    private Collision1DHeightMap collisionStructure;
    private ArrayList<com.turborilla.msm.states.editor.challenge.IChallenge> challengeDescriptions;
    private ArrayList<IChallenge> challenges;
    private int driveAreaBeginYIndex = 0;
    private int extendX;
    private float originalLength;
    private Runnable allChallengesAchievedListener = null;
    private CollisionGrid[] collisionGrids;
    private int version = 1;

    public Track1D() {
        super("");
    }

    public Track1D(String string, ImageHeightMap imageHeightMap, ImageHeightMap imageHeightMap2, Vector3f vector3f, Vector2f vector2f, int n, Vector2f vector2f2) {
        super(string);
        this.stepScale = vector3f;
        vector3f.z = 0.7f;
        this.offset = vector2f;
        this.offsetAmount = n;
        this.textureScale = vector2f2;
        this.reconstruct(imageHeightMap, imageHeightMap2);
    }

    public void reconstruct(ImageHeightMap imageHeightMap, ImageHeightMap imageHeightMap2) {
        this.reconstruct(imageHeightMap, imageHeightMap2, 1);
    }

    public void reconstruct(ImageHeightMap imageHeightMap, ImageHeightMap imageHeightMap2, int n) {
        int n2;
        this.unlock();
        try {
            this.originalHeightMap = imageHeightMap.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        try {
            this.originalFeatureMap = imageHeightMap2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        int n3 = this.originalHeightMap.getXsize() - this.originalFeatureMap.getXsize();
        if (n3 > 0) {
            this.originalFeatureMap.extendHeightMap(0, n3, 0, 0);
        } else if (n3 < 0) {
            this.originalFeatureMap.cutHeightMap(-n3);
        }
        this.extendX = (int)(7.5f / this.stepScale.x);
        if (n > 1) {
            imageHeightMap.loopHoriz(n);
            imageHeightMap2.loopHoriz(n);
        }
        imageHeightMap.extendHeightMap(this.extendX * 6, this.extendX * 60, 0, 0, 0);
        imageHeightMap2.extendHeightMap(this.extendX * 6, this.extendX * 60, 0, 0);
        this.originalHeightMapStartsAt = this.extendX * 6;
        this.collisionHeightMap = imageHeightMap;
        this.collisionHeightMap.setStepScale(this.stepScale);
        this.featureMap = imageHeightMap2;
        ImageHeightMap imageHeightMap3 = new ImageHeightMap();
        int[] nArray = new int[imageHeightMap.getXsize() * 2];
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n4 = n2 < imageHeightMap.getXsize() ? n2 : n2 - imageHeightMap.getXsize();
            nArray[n2] = imageHeightMap.getHeightMap()[n4];
        }
        imageHeightMap3.setHeightData(nArray, imageHeightMap.getXsize(), 2);
        imageHeightMap3.extendHeightMap(0, 0, 1, 1);
        n2 = 10;
        int n5 = 20;
        imageHeightMap3.extendHeightMap(0, 0, n2, (int)((float)n5 * 0.5f), 0);
        this.driveAreaBeginYIndex = 1 + n2;
        this.forceWidth = 58.0f;
        this.makeJaggedWallEdge(imageHeightMap3, 500);
        this.xsize = imageHeightMap3.getXsize();
        this.ysize = imageHeightMap3.getYsize();
        if (this.mesh != null) {
            this.detachChild(this.mesh);
        }
        this.buildVertices(imageHeightMap3);
        this.attachChild(this.mesh);
        this.actualWidth = this.forceWidth;
        this.actualLength = (float)this.xsize * this.stepScale.x;
        this.originalLength = (float)(this.extendX * 6 + this.originalHeightMap.getXsize()) * this.stepScale.x;
        this.setModelBound(new BoundingBox());
        this.updateModelBound();
        this.updateWorldBound();
        this.updateWorldData(0.0f);
        this.lock();
    }

    public void reconstructChallenges() {
        if (this.challengeDescriptions != null) {
            if (this.challenges == null) {
                this.challenges = new ArrayList();
            }
            this.challenges.clear();
            for (int i = 0; i < this.challengeDescriptions.size(); ++i) {
                this.challenges.add(this.challengeDescriptions.get(i).getChallenge());
            }
        }
    }

    public void initChallenges(GameState gameState, BikeGameObject bikeGameObject) {
        this.reconstructChallenges();
        if (this.challenges != null) {
            for (int i = 0; i < this.challenges.size(); ++i) {
                this.challenges.get(i).init(gameState, this, bikeGameObject);
            }
        }
    }

    public Runnable getAllChallengesAchievedListener() {
        return this.allChallengesAchievedListener;
    }

    public void setAllChallengesAchievedListener(Runnable runnable) {
        this.allChallengesAchievedListener = runnable;
    }

    public void updateChallenges(float f) {
        if (this.challenges != null && this.challenges.size() > 0) {
            boolean bl = true;
            for (int i = 0; i < this.challenges.size(); ++i) {
                IChallenge iChallenge = this.challenges.get(i);
                iChallenge.update(f);
                if (iChallenge.isAchieved()) continue;
                bl = false;
            }
            if (bl && this.getAllChallengesAchievedListener() != null) {
                this.getAllChallengesAchievedListener().run();
                this.setAllChallengesAchievedListener(null);
            }
        }
    }

    public Iterator<IChallenge> getChallengeIterator() {
        if (this.challenges == null) {
            return null;
        }
        return this.challenges.iterator();
    }

    public void setChallenges(com.turborilla.msm.states.editor.challenge.IChallenge[] iChallengeArray) {
        if (iChallengeArray == null) {
            return;
        }
        if (this.challengeDescriptions == null) {
            this.challengeDescriptions = new ArrayList();
        }
        this.challengeDescriptions.clear();
        for (com.turborilla.msm.states.editor.challenge.IChallenge iChallenge : iChallengeArray) {
            this.challengeDescriptions.add(iChallenge);
        }
    }

    public com.turborilla.msm.states.editor.challenge.IChallenge[] getChallenges() {
        if (this.challengeDescriptions == null) {
            return new com.turborilla.msm.states.editor.challenge.IChallenge[0];
        }
        return this.challengeDescriptions.toArray(new com.turborilla.msm.states.editor.challenge.IChallenge[0]);
    }

    public com.turborilla.msm.states.editor.challenge.IChallenge findChallenge(Class<? extends com.turborilla.msm.states.editor.challenge.IChallenge> clazz) {
        if (this.challengeDescriptions == null) {
            return null;
        }
        for (int i = 0; i < this.challengeDescriptions.size(); ++i) {
            if (!clazz.isInstance(this.challengeDescriptions.get(i))) continue;
            return this.challengeDescriptions.get(i);
        }
        return null;
    }

    public float getFinishPosition() {
        return this.actualLength - (float)(this.extendX * 60) * this.stepScale.x + 1.0f;
    }

    public float getLapLinePosition(int n, int n2) {
        return (float)n * ((this.getFinishPosition() - (float)(this.extendX * 6) * this.stepScale.x) / (float)n2) + (float)(this.extendX * 6) * this.stepScale.x;
    }

    protected void makeJaggedWallEdge(ImageHeightMap imageHeightMap, int n) {
        int[] nArray = imageHeightMap.getHeightMap();
        int n2 = imageHeightMap.getXsize();
        Random random = new Random(n2);
        for (int i = 0; i < n2; ++i) {
            int n3;
            nArray[i] = n3 = (int)(random.nextDouble() * (double)n * (double)this.stepScale.y);
        }
    }

    @Override
    protected void buildVertices(ImageHeightMap imageHeightMap) {
        int n;
        Object object;
        int n2;
        if (this.mesh == null) {
            this.mesh = new TriMesh("Track1D:mesh");
        }
        this.mesh.clearBatches();
        if (this.boostArrowNode == null) {
            this.boostArrowNode = new Node(this.getName() + ":boostArrowNode");
        } else {
            this.boostArrowNode.detachAllChildren();
        }
        int n3 = (int)(this.batchLength / this.stepScale.x);
        if (n3 % 2 != 0) {
            ++n3;
        }
        int[] nArray = imageHeightMap.getHeightMap();
        Vector3f vector3f = new Vector3f();
        int n4 = 0;
        this.forceWidthAdder = 0.0f;
        if (this.forceWidth > 0.0f) {
            this.forceWidthAdder = this.forceWidth - (float)this.ysize * this.stepScale.z;
        }
        this.offset.x += (float)((int)((float)this.offsetAmount * this.stepScale.x));
        this.offset.y += (float)((int)((float)this.offsetAmount * this.stepScale.z));
        float f = this.textureScale.x;
        float f2 = this.textureScale.y;
        if (this.forceTextureRepeatAlongWidth > 0.0f) {
            f2 = (float)this.ysize / this.forceTextureRepeatAlongWidth;
        }
        for (n2 = 0; n2 < this.xsize / n3 + 1; ++n2) {
            int n5;
            TriangleBatch triangleBatch;
            if (n2 >= this.mesh.getBatchCount()) {
                triangleBatch = new TriangleBatch();
                this.mesh.addBatch(triangleBatch);
            } else {
                triangleBatch = this.mesh.getBatch(n2);
            }
            if (n2 == 0) {
                triangleBatch.setVertexCount((n3 + 2) * this.ysize);
            } else if (n2 + 1 < this.xsize / n3 + 1) {
                triangleBatch.setVertexCount((n3 + 3) * this.ysize);
            } else {
                triangleBatch.setVertexCount((this.xsize % n3 + 1) * this.ysize);
            }
            triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), triangleBatch.getVertexCount()));
            object = triangleBatch.getVertexBuffer();
            ((FloatBuffer)object).clear();
            FloatBuffer floatBuffer = BufferUtils.createVector2Buffer(triangleBatch.getTextureBuffers().get(0), triangleBatch.getVertexCount());
            triangleBatch.getTextureBuffers().set(0, floatBuffer);
            floatBuffer.clear();
            n = 0;
            for (n5 = n2 * n3 - 1; n5 < (n2 + 1) * n3 + 2; ++n5) {
                if (n5 < 0) continue;
                if (n5 >= this.xsize) break;
                for (int i = 0; i < this.ysize; ++i) {
                    n4 = i * this.xsize;
                    if (i > this.driveAreaBeginYIndex) {
                        if (i == this.ysize - 1) {
                            vector3f.set((float)n5 * this.stepScale.x, (float)nArray[n5 + n4] * this.stepScale.y, (float)i * this.stepScale.z + this.forceWidthAdder + this.lastRowAdder);
                        } else {
                            vector3f.set((float)n5 * this.stepScale.x, (float)nArray[n5 + n4] * this.stepScale.y, (float)i * this.stepScale.z + this.forceWidthAdder);
                        }
                    } else {
                        vector3f.set((float)n5 * this.stepScale.x, (float)nArray[n5 + n4] * this.stepScale.y, (float)i * this.stepScale.z);
                    }
                    ((FloatBuffer)object).put(vector3f.x).put(vector3f.y).put(vector3f.z);
                    floatBuffer.put((vector3f.x + this.offset.x) / (f * 20.0f));
                    floatBuffer.put((vector3f.z + this.offset.y) / f2);
                    ++n;
                }
            }
            ((FloatBuffer)object).flip();
            floatBuffer.flip();
            triangleBatch.setVertexCount(((Buffer)object).limit() / 3);
            n5 = ((Buffer)object).limit() / (3 * this.ysize);
            if (n2 == 0) {
                n = 0;
                triangleBatch.setTriangleQuantity((this.ysize - 1) * (n5 - 2) * 2);
            } else {
                n = this.ysize;
                triangleBatch.setTriangleQuantity((this.ysize - 1) * (n5 - 3) * 2);
            }
            if (triangleBatch.getTriangleCount() * 3 < 0) {
                this.mesh.removeBatch(triangleBatch);
                break;
            }
            triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getIndexBuffer(), triangleBatch.getTriangleCount() * 3));
            IntBuffer intBuffer = triangleBatch.getIndexBuffer();
            while (n < this.ysize * (n5 - 2)) {
                if ((n + 1) % this.ysize != 0) {
                    intBuffer.put(n);
                    intBuffer.put(n + 1 + this.ysize);
                    intBuffer.put(n + this.ysize);
                    intBuffer.put(n);
                    intBuffer.put(n + 1);
                    intBuffer.put(n + 1 + this.ysize);
                }
                ++n;
            }
            intBuffer.flip();
            FloatBuffer floatBuffer2 = BufferUtils.createVector3Buffer(triangleBatch.getNormalBuffer(), triangleBatch.getVertexCount());
            this.buildNormals(triangleBatch.getVertexBuffer(), floatBuffer2, n5);
            triangleBatch.setNormalBuffer(floatBuffer2);
            triangleBatch.setModelBound(new BoundingBox());
            triangleBatch.updateModelBound();
        }
        n2 = 0;
        object = new ArrayList();
        for (int i = 0; i < this.xsize; ++i) {
            n = 0;
            if (i < this.featureMap.getXsize()) {
                n = this.featureMap.getTrueHeightAtPoint(i, 0);
            }
            if (n != 255) continue;
            n2 = 1;
            while (i + n2 < this.featureMap.getXsize() && this.featureMap.getTrueHeightAtPoint(i + n2, 0) == 255) {
                ++n2;
            }
            if (n2 <= 1) continue;
            TriMesh triMesh = this.makeBoostArrow(this.collisionHeightMap, i, this.stepScale, this.actualWidth * 0.9f, n2);
            this.boostArrowNode.attachChild(triMesh);
            ((ArrayList)object).add(new CollisionGrid(triMesh, 2, n2));
            i += n2;
        }
        this.otherMeshes.attachChild(this.boostArrowNode);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(false);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(6);
        alphaState.setReference(0.9f);
        this.boostArrowNode.setRenderState(alphaState);
        this.boostArrowNode.setLightCombineMode(0);
        this.collisionGrids = ((ArrayList)object).toArray(new CollisionGrid[0]);
    }

    protected TriMesh makeBoostArrow(ImageHeightMap imageHeightMap, int n, Vector3f vector3f, float f, int n2) {
        float f2 = f * 0.05f;
        float f3 = 8.0f;
        float f4 = f - f3;
        float f5 = 0.08f;
        if (f4 <= 0.001f) {
            f4 = 0.5f;
        }
        int n3 = n2 * 2;
        int n4 = n3 - 2;
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(n3);
        FloatBuffer floatBuffer2 = BufferUtils.createVector2Buffer(n3);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n4 * 3);
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        int n5 = 0;
        float f6 = 0.0f;
        if (n2 % 2 == 0) {
            f6 = 0.5f;
        }
        for (int i = n; i < n + n2; ++i) {
            float f7 = f2;
            for (float f8 = 0.0f; f8 < 1.0f; f8 += 1.0f) {
                vector3f2.set((float)(i - n) * vector3f.x, (float)imageHeightMap.getTrueHeightAtPoint(i, 0) * vector3f.y + f5, f7 += f3 / 2.0f);
                vector3f3.set((float)(i - n) * vector3f.x, (float)imageHeightMap.getTrueHeightAtPoint(i, 0) * vector3f.y + f5, f7 += f4);
                f7 += f3 / 2.0f;
                BufferUtils.setInBuffer(vector3f2, floatBuffer, n5);
                BufferUtils.setInBuffer(vector3f3, floatBuffer, n5 + 1);
                if (i > n) {
                    int n6 = n5 - 2;
                    intBuffer.put(n5 + 1).put(n5).put(n6 + 1);
                    intBuffer.put(n6).put(n6 + 1).put(n5);
                }
                floatBuffer2.put(f6).put(1.0f);
                floatBuffer2.put(f6).put(0.0f);
                f6 += 0.5f;
                n5 += 2;
            }
        }
        TriMesh triMesh = new TriMesh("boostArrowMesh");
        triMesh.setLocalTranslation((float)n * vector3f.x, 0.0f, 0.0f);
        TriangleBatch triangleBatch = triMesh.getBatch(0);
        triangleBatch.setVertexBuffer(floatBuffer);
        triangleBatch.setIndexBuffer(intBuffer);
        triangleBatch.setTextureBuffer(floatBuffer2, 0);
        this.computeNormals(triangleBatch);
        triangleBatch.setModelBound(new BoundingBox());
        triangleBatch.updateModelBound();
        try {
            Texture texture = (Texture)ResourceManager.getInstance().load("texture", "boost", null);
            texture.setWrap(3);
            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            textureState.setTexture(texture);
            triangleBatch.setRenderState(textureState);
            triangleBatch.updateRenderState();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        triMesh.updateRenderState();
        return triMesh;
    }

    @Override
    protected void buildTextureCoordinates(TriangleBatch triangleBatch) {
        this.offset.x += (float)((int)((float)this.offsetAmount * this.stepScale.x));
        this.offset.y += (float)((int)((float)this.offsetAmount * this.stepScale.z));
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer(triangleBatch.getTextureBuffers().get(0), triangleBatch.getVertexCount());
        triangleBatch.getTextureBuffers().set(0, floatBuffer);
        floatBuffer.clear();
        float f = this.textureScale.x;
        float f2 = this.textureScale.y;
        if (this.forceTextureRepeatAlongWidth > 0.0f) {
            f2 = (float)this.ysize / this.forceTextureRepeatAlongWidth;
        }
        triangleBatch.getVertexBuffer().rewind();
        for (int i = 0; i < triangleBatch.getVertexCount(); ++i) {
            floatBuffer.put((triangleBatch.getVertexBuffer().get() + this.offset.x) / (this.stepScale.x * f));
            triangleBatch.getVertexBuffer().get();
            floatBuffer.put((triangleBatch.getVertexBuffer().get() + this.offset.y) / ((this.stepScale.z + this.forceWidthAdder) * f2));
        }
    }

    @Override
    protected void buildNormals(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int n) {
        floatBuffer.rewind();
        floatBuffer2.rewind();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.ysize; ++j) {
                if (j == this.ysize / 2 || j == this.ysize / 2 + 1) {
                    // empty if block
                }
                if (j == this.ysize - 1) {
                    if (i == n - 1) {
                        n2 = n4 - this.ysize;
                        n3 = n4 - 1;
                    } else {
                        n2 = n4 - 1;
                        n3 = n4 + this.ysize;
                    }
                } else if (i == n - 1) {
                    n3 = n4 - 1;
                    n2 = n4 - this.ysize;
                } else {
                    n2 = n4 + this.ysize;
                    n3 = n4 + 1;
                }
                BufferUtils.populateFromBuffer(vector3f3, floatBuffer, n4);
                BufferUtils.populateFromBuffer(vector3f2, floatBuffer, n2);
                BufferUtils.populateFromBuffer(vector3f, floatBuffer, n3);
                vector3f4.set(vector3f2).subtractLocal(vector3f3).crossLocal(vector3f.subtractLocal(vector3f3)).multLocal(-1.0f).normalizeLocal();
                BufferUtils.setInBuffer(vector3f4, floatBuffer2, n4);
                ++n4;
            }
        }
        floatBuffer2.position(n4 * 3);
        floatBuffer2.flip();
    }

    public Track1D(String string, ImageHeightMap imageHeightMap) {
        super(string, imageHeightMap);
    }

    @Override
    public CollisionStructure constructCollisionStructure() {
        Collision1DHeightMap collision1DHeightMap = new Collision1DHeightMap(this.collisionHeightMap);
        collision1DHeightMap.init();
        this.collisionStructure = collision1DHeightMap;
        return collision1DHeightMap;
    }

    public CollisionStructure reconstructCollisionStructure() {
        return this.reconstructCollisionStructure(this.collisionStructure);
    }

    public CollisionStructure reconstructCollisionStructure(CollisionStructure collisionStructure) {
        if (collisionStructure != null && collisionStructure instanceof Collision1DHeightMap) {
            Collision1DHeightMap collision1DHeightMap = (Collision1DHeightMap)collisionStructure;
            collision1DHeightMap.setHmap(this.collisionHeightMap);
            collision1DHeightMap.setStepScale(this.stepScale);
            collision1DHeightMap.init();
            return collisionStructure;
        }
        this.constructCollisionStructure();
        return this.collisionStructure;
    }

    public double getHeightAt(int n) {
        if (n >= this.getXsize() || n < 0) {
            return 0.0;
        }
        return (float)this.collisionHeightMap.getTrueHeightAtPoint(n, 0) * this.stepScale.y;
    }

    public double getInterpolatedHeightAt(double d) {
        if (d + (double)this.stepScale.x >= (double)this.actualLength) {
            return 0.0;
        }
        int n = this.getColumn(d);
        int n2 = n + 1;
        if (n < 0 || n2 > this.xsize) {
            return 0.0;
        }
        double d2 = (d - (double)((float)n * this.stepScale.x)) / (double)this.stepScale.x;
        double d3 = (float)this.collisionHeightMap.getTrueHeightAtPoint(n, 0) * this.stepScale.y;
        double d4 = (float)this.collisionHeightMap.getTrueHeightAtPoint(n2, 0) * this.stepScale.y;
        return d3 + (d4 - d3) * d2;
    }

    public int getColumn(double d) {
        return (int)(d / (double)this.stepScale.x);
    }

    public double getXPosition(int n) {
        return this.stepScale.x * (float)n;
    }

    public ImageHeightMap getOriginalHeightMap() {
        return this.originalHeightMap;
    }

    public int getOriginalHeightMapStartsAt() {
        return this.originalHeightMapStartsAt;
    }

    public ImageHeightMap getOriginalFeatureMap() {
        return this.originalFeatureMap;
    }

    public int getHeightMapNumberOfColumns() {
        return this.collisionHeightMap.getXsize();
    }

    public Vector3d findGoodResetSpot(double d, double d2, double d3, Vector3d vector3d) {
        int n = (int)(d / (double)this.stepScale.x);
        if (n < 0) {
            n = 0;
        }
        if (vector3d == null) {
            vector3d = new Vector3d();
        }
        int n2 = -1;
        int n3 = (int)(d2 / (double)this.stepScale.x) + 1;
        int n4 = 0;
        double d4 = d3 / (double)n3;
        double d5 = n < this.collisionHeightMap.getXsize() ? (double)((float)this.collisionHeightMap.getTrueHeightAtPoint(n, 0) * this.stepScale.y) : 0.0;
        double d6 = -1000000.0;
        for (int i = n + 1; i < this.collisionHeightMap.getXsize(); ++i) {
            double d7 = (float)this.collisionHeightMap.getTrueHeightAtPoint(i, 0) * this.stepScale.y;
            double d8 = Math.abs(d7 - d5);
            if (d8 > d4) {
                n4 = 0;
                d6 = -1000000.0;
            } else {
                ++n4;
                if (this.getHeightAt(i) > d6) {
                    d6 = this.getHeightAt(i);
                }
                if (n4 >= n3) {
                    n2 = i;
                    break;
                }
            }
            d5 = d7;
        }
        if (n2 == -1) {
            n2 = n;
        }
        vector3d.x = (float)n2 * this.stepScale.x;
        vector3d.y = d6;
        return vector3d;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.stepScale);
        objectOutput.writeObject(this.offset);
        objectOutput.writeInt(this.offsetAmount);
        objectOutput.writeObject(this.textureScale);
        objectOutput.writeObject(this.originalHeightMap);
        objectOutput.writeObject(this.originalFeatureMap);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.stepScale = (Vector3f)objectInput.readObject();
        this.offset = (Vector2f)objectInput.readObject();
        this.offsetAmount = objectInput.readInt();
        this.textureScale = (Vector2f)objectInput.readObject();
        this.reconstruct((ImageHeightMap)objectInput.readObject(), (ImageHeightMap)objectInput.readObject());
    }

    public ImageHeightMap getCollisionHeightMap() {
        return this.collisionHeightMap;
    }

    public float getOriginalLength() {
        return this.originalLength;
    }

    @Override
    public Class getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.setName(inputCapsule.readString("name", "noname"));
                this.stepScale = (Vector3f)inputCapsule.readSavable("stepScale", null);
                this.offset = (Vector2f)inputCapsule.readSavable("offset", null);
                this.offsetAmount = inputCapsule.readInt("offsetAmount", 0);
                this.textureScale = (Vector2f)inputCapsule.readSavable("textureScale", null);
                this.challengeDescriptions = inputCapsule.readSavableArrayList("challengeDescriptions", null);
                if (!DisplaySystem.getDisplaySystem().isCreated()) break;
                this.reconstruct((ImageHeightMap)inputCapsule.readSavable("originalHeightMap", null), (ImageHeightMap)inputCapsule.readSavable("originalFeatureMap", null));
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.getName(), "name", "noname");
        outputCapsule.write(this.stepScale, "stepScale", null);
        outputCapsule.write(this.offset, "offset", null);
        outputCapsule.write(this.offsetAmount, "offsetAmount", 0);
        outputCapsule.write(this.textureScale, "textureScale", null);
        outputCapsule.write(this.originalHeightMap, "originalHeightMap", null);
        outputCapsule.write(this.originalFeatureMap, "originalFeatureMap", null);
        outputCapsule.writeSavableArrayList(this.challengeDescriptions, "challengeDescriptions", null);
    }

    public CollisionGrid[] getBoostArrowCollisionGrids() {
        return this.collisionGrids;
    }

    public String getHash() {
        Object object;
        int n;
        byte[] byArray = new byte[this.getOriginalHeightMap().getHeightMap().length * 2 + this.getOriginalFeatureMap().getHeightMap().length * 2];
        for (n = 0; n < this.getOriginalHeightMap().getHeightMap().length; ++n) {
            byArray[n * 2 + 0] = (byte)this.getOriginalHeightMap().getHeightMap()[n];
            byArray[n * 2 + 1] = (byte)Integer.reverseBytes(this.getOriginalHeightMap().getHeightMap()[n]);
        }
        for (n = this.getOriginalHeightMap().getHeightMap().length; n < this.getOriginalHeightMap().getHeightMap().length + this.getOriginalFeatureMap().getHeightMap().length; ++n) {
            byArray[n * 2 + 0] = (byte)this.getOriginalFeatureMap().getHeightMap()[n - this.getOriginalHeightMap().getHeightMap().length];
            byArray[n * 2 + 1] = (byte)Integer.reverseBytes(this.getOriginalFeatureMap().getHeightMap()[n - this.getOriginalHeightMap().getHeightMap().length]);
        }
        try {
            object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).update(byArray);
            byArray = ((MessageDigest)object).digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.severe("Could not compute hash due to " + noSuchAlgorithmException);
        }
        object = "";
        for (int i = 0; i < Math.min(32, byArray.length); ++i) {
            object = (String)object + Integer.toHexString(byArray[i]);
        }
        return object;
    }
}

