/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.track;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.geom.BufferUtils;
import com.turborilla.msm.track.Track1D;
import com.turborilla.physics.particle.Particle;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class SimpleShadow
extends TriMesh {
    private Track1D track;
    private Particle[] particles;
    private float length;
    private float width;
    private int lengthSlices;
    private int widthSlices;
    private float invLengthSlices;
    private float invWidthSlices;
    private Vector3f offset;
    private Texture texture;
    private float stepZ;

    public SimpleShadow(String string, Track1D track1D, Particle[] particleArray, float f, float f2, int n, int n2, Vector3f vector3f, Texture texture) {
        super(string);
        this.track = track1D;
        this.particles = particleArray;
        this.length = f;
        this.width = f2;
        this.lengthSlices = n;
        this.widthSlices = n2;
        this.invLengthSlices = 1.0f / (float)n;
        this.invWidthSlices = 1.0f / (float)n2;
        this.offset = vector3f;
        this.texture = texture;
        this.stepZ = f2 * this.invWidthSlices;
        this.init();
    }

    private void init() {
        int n;
        int n2;
        int n3;
        int n4 = (this.lengthSlices + 1) * (this.widthSlices + 1);
        int n5 = 2 * this.widthSlices * this.lengthSlices;
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(n4);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n5 * 3);
        FloatBuffer floatBuffer2 = BufferUtils.createVector2Buffer(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            floatBuffer.put(0.0f).put(0.0f).put(0.0f);
        }
        floatBuffer.flip();
        for (n3 = 0; n3 < this.lengthSlices; ++n3) {
            for (int i = 0; i < this.widthSlices; ++i) {
                n2 = n3 * (this.widthSlices + 1);
                n = n2 + (this.widthSlices + 1);
                intBuffer.put(n2 + i).put(n2 + i + 1).put(n + i);
                intBuffer.put(n2 + i + 1).put(n + i + 1).put(n + i);
            }
        }
        intBuffer.flip();
        float f = 0.0f;
        float f2 = 0.0f;
        for (n2 = 0; n2 < this.lengthSlices + 1; ++n2) {
            f2 = (float)n2 * this.invLengthSlices;
            for (n = 0; n < this.widthSlices + 1; ++n) {
                f = (float)n * this.invWidthSlices;
                floatBuffer2.put(f).put(f2);
            }
        }
        floatBuffer2.flip();
        this.reconstruct(floatBuffer, null, null, floatBuffer2, intBuffer);
        if (this.texture != null) {
            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            this.texture.setWrap(5);
            textureState.setTexture(this.texture);
            this.setRenderState(textureState);
        }
        this.setLightCombineMode(0);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.setRenderState(alphaState);
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setFunction(7);
        this.setRenderState(zBufferState);
        this.setRenderQueueMode(3);
        this.updateRenderState();
    }

    public void updateGeometricState(float f, boolean bl) {
        double d = 1.0E8;
        double d2 = -1.0;
        for (int i = 0; i < this.particles.length; ++i) {
            double d3 = this.particles[i].getPosition().x;
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        float f2 = (float)d - this.length * 0.5f + this.offset.x;
        float f3 = (float)d2 + this.length * 0.5f + this.offset.x;
        float f4 = f3 - f2;
        float f5 = f4 * this.invLengthSlices;
        float f6 = (float)this.particles[0].getPosition().z - this.width * 0.5f + this.offset.z;
        FloatBuffer floatBuffer = this.getVertexBuffer(0);
        floatBuffer.clear();
        float f7 = f2;
        float f8 = 0.0f;
        for (int i = 0; i < this.lengthSlices + 1; ++i) {
            f8 = this.offset.y + (float)this.track.getInterpolatedHeightAt(f7);
            float f9 = f6;
            for (int j = 0; j < this.widthSlices + 1; ++j) {
                floatBuffer.put(f7).put(f8).put(f9);
                f9 += this.stepZ;
            }
            f7 += f5;
        }
        floatBuffer.flip();
        super.updateGeometricState(f, bl);
    }
}

