/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.track;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.turborilla.TransformationProvider;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gameobject.IComponent;
import com.turborilla.utils.math.Vector3d;
import java.util.ArrayList;

public class FinishLine
extends Node
implements IComponent,
IEventListener {
    protected float width = 0.2f;
    protected float ypos = 0.01f;
    protected float startz = 0.0f;
    protected float endz = 10.0f;
    protected ArrayList<GameObjectToProvidersMapping> gameObjectsToCheck;
    protected Event event = new Event("PassedFinishline", new String[][]{{"gameObject", "time"}, {"", "0"}});
    private boolean paused = false;
    private GameObject gameObject = null;

    public FinishLine(float f, float f2) {
        super("FinishLine");
        this.gameObjectsToCheck = new ArrayList();
        this.startz = f;
        this.endz = f2;
        this.init();
    }

    public void init() {
        this.detachAllChildren();
        Quad quad = new Quad("FinishLine:Quad", this.width, this.endz - this.startz);
        quad.getLocalRotation().fromAngles(-1.5707964f, 0.0f, 0.0f);
        quad.setLocalTranslation(0.0f, this.ypos, this.startz + (this.endz - this.startz) / 2.0f);
        quad.setModelBound(new BoundingBox());
        quad.updateModelBound();
        this.attachChild(quad);
        Texture texture = TextureManager.loadTexture(FinishLine.class.getClassLoader().getResource("textures/finishline.tga"), 1, 1, 0.0f, true);
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setTexture(texture);
        this.setRenderState(textureState);
        this.updateRenderState();
        this.updateGeometricState(0.0f, true);
    }

    public boolean checkIfFinished(Vector3d vector3d, float f) {
        return vector3d.x * (double)f >= (double)this.getWorldTranslation().x;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
        this.init();
    }

    public float getYpos() {
        return this.ypos;
    }

    public void setYpos(float f) {
        this.ypos = f;
        this.init();
    }

    public float getEndz() {
        return this.endz;
    }

    public void setEndz(float f) {
        this.endz = f;
        this.init();
    }

    public float getStartz() {
        return this.startz;
    }

    public void setStartz(float f) {
        this.startz = f;
        this.init();
    }

    public void addGameObjectToCheck(GameObject gameObject, TransformationProvider[] transformationProviderArray, float f) {
        GameObjectToProvidersMapping gameObjectToProvidersMapping = new GameObjectToProvidersMapping(gameObject, transformationProviderArray, f);
        gameObjectToProvidersMapping.passedFinishline = true;
        this.gameObjectsToCheck.add(gameObjectToProvidersMapping);
    }

    public void clearGameObjectsToCheck() {
        this.gameObjectsToCheck.clear();
    }

    public int getPriority() {
        return 100000;
    }

    public void setGameObject(GameObject gameObject) {
        this.gameObject = gameObject;
        gameObject.getEventManager().registerListener("RaceStarted", this);
    }

    public int compareTo(IComponent iComponent) {
        return this.getPriority() < iComponent.getPriority() ? -1 : 1;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public void update(float f) {
        if (this.gameObject.getEventManager() != null) {
            this.gameObject.getEventManager().handleEvents(this);
        }
        if (this.paused) {
            return;
        }
        if (this.gameObjectsToCheck == null) {
            return;
        }
        for (GameObjectToProvidersMapping gameObjectToProvidersMapping : this.gameObjectsToCheck) {
            if (gameObjectToProvidersMapping.passedFinishline) continue;
            TransformationProvider[] transformationProviderArray = gameObjectToProvidersMapping.providers;
            String string = gameObjectToProvidersMapping.gameObject;
            for (TransformationProvider transformationProvider : transformationProviderArray) {
                if (!this.checkIfFinished(transformationProvider.getWorldTranslation(), gameObjectToProvidersMapping.scale)) continue;
                gameObjectToProvidersMapping.passedFinishline = true;
                this.event.setArgument("gameObject", string);
                this.gameObject.getEventManager().fireEvent(this.event);
            }
        }
    }

    public void onDetach() {
        if (this.gameObject != null && this.gameObject.getEventManager() != null) {
            this.gameObject.getEventManager().unregisterListener(this);
        }
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.getName().equals("RaceStarted")) {
            for (int i = 0; i < this.gameObjectsToCheck.size(); ++i) {
                this.gameObjectsToCheck.get((int)i).passedFinishline = false;
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isRemoveMeFromEventmanager() {
        return false;
    }

    protected class GameObjectToProvidersMapping {
        TransformationProvider[] providers;
        String gameObject;
        boolean passedFinishline = false;
        float scale;

        public GameObjectToProvidersMapping(GameObject gameObject, TransformationProvider[] transformationProviderArray, float f) {
            this.providers = transformationProviderArray;
            this.gameObject = gameObject.getName();
            this.scale = f;
        }
    }
}

