/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus.special;

import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.TextLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.Image;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.BorderPanel;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.utils.Font;
import java.io.IOException;
import java.util.Iterator;

public class MessagePanel
extends BaseMenuPanel {
    private MenuButton okButton;
    private BaseLayout imageLayout;
    private TextLayout textLayout;
    private BorderPanel textPanel;
    private String text;
    private Image image;

    public MessagePanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("Message", f, f2, guiHandler, gameSettings);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.0f, 5.0f, 1.0f);
        this.setLayout(variableRowLayout);
        variableRowLayout.add(null);
        this.initGUI(guiHandler);
    }

    private void initGUI(GuiHandler guiHandler) {
        this.textPanel = new BorderPanel("MessageBorderPanel", 800.0f, 600.0f, guiHandler, "corner", "edge", "combobox", 0.25f);
        this.addWidget(this.textPanel);
        this.getLayout().add(this.textPanel);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.0f, 4.0f, 4.0f, 2.0f);
        variableRowLayout.add(null);
        this.textPanel.setLayout(variableRowLayout);
        Font font = null;
        try {
            font = (Font)ResourceManager.getInstance().load("font", "italic_small_black", null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.textLayout = new TextLayout(font, "", 25.0f, 0.05f, 10);
        Iterator<Label> iterator = this.textLayout.getLabelIterator();
        while (iterator.hasNext()) {
            this.textPanel.addWidget(iterator.next());
        }
        variableRowLayout.add(this.textLayout);
        this.imageLayout = new BaseLayout();
        this.imageLayout.setPadding(0.1f, 0.2f);
        variableRowLayout.add(this.imageLayout);
        VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
        variableColumnLayout.setColumns(3.0f, 1.5f, 3.0f);
        variableColumnLayout.setPadding(0.0f, 0.08f);
        variableRowLayout.add(variableColumnLayout);
        variableColumnLayout.add(null);
        this.okButton = new MenuButton("OkButton", "Ok", 1.0f, 1.0f);
        variableColumnLayout.add(this.okButton);
        this.textPanel.addWidget(this.okButton);
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.textLayout.setText(string);
        this.textPanel.doLayout();
    }

    public void setImage(Image image) {
        if (this.image != null) {
            this.textPanel.removeWidget(this.image);
        }
        this.imageLayout.clear();
        this.image = image;
        if (image != null) {
            image.setRestrictHeight(true);
            this.imageLayout.add(image);
            this.textPanel.addWidget(image);
        }
        this.textPanel.doLayout();
    }

    public TextLayout getTextLayout() {
        return this.textLayout;
    }

    public BaseLayout getImageLayout() {
        return this.imageLayout;
    }

    public MenuButton getOkButton() {
        if (this.okButton != null) {
            this.okButton.clearListeners();
        }
        return this.okButton;
    }

    public void onActivate() {
        super.onActivate();
        this.getGuiHandler().focusWidget(this.okButton);
    }
}

