/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus.special;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.gameobjects.WidgetFXGameObject;
import com.turborilla.msm.gui.turbogui.Image;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.statemachine.ChooseTrack;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.utils.controllers.IControllerListener;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseTrackPanel
extends BaseMenuPanel {
    private ColumnLayout tracksLayout;
    private ArrayList<BaseWidget> widgetsToRemove;
    private Image divisionLogo;
    private ArrayList<Integer> tracksToAccomplish;
    private ArrayList<Integer> tracksToUnlock;
    private int divisionIndex;
    private DivisionDescriptor divisionDescriptor;
    private Profile profile;
    private BaseLayout[] accomplishedLayouts;
    private ChooseTrack.ChooseTrackMode chooseTrackMode = ChooseTrack.ChooseTrackMode.Career;
    private float effectTime = 0.5f;
    private IChosenTrackListener chosenTrackListener;
    private MenuButton[] trackButtons;
    private Image[] accomplishedImages;
    private WidgetFXGameObject trackAccomplishedFX;
    private WidgetFXGameObject trackUnlockedFX;

    public ChooseTrackPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("ChooseTrack", f, f2, guiHandler, gameSettings);
        this.widgetsToRemove = new ArrayList();
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.1f, 2.55f, 0.45f);
        this.setLayout(variableRowLayout);
        this.initGUI();
    }

    private void initGUI() {
        this.divisionLogo = new Image("DivisionLogo");
        this.addWidget(this.divisionLogo);
        BaseLayout baseLayout = new BaseLayout();
        baseLayout.add(this.divisionLogo);
        baseLayout.setPadding(0.6f, 0.0f);
        this.getLayout().add(baseLayout);
        this.tracksLayout = new ColumnLayout();
        this.getLayout().add(this.tracksLayout);
        RowLayout rowLayout = new RowLayout();
        rowLayout.setPadding(0.05f, 0.2f);
        MenuButton menuButton = new MenuButton("backToMainMenuButton", "Main menu", 1.0f, 1.0f);
        this.addWidget(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ChooseTrackPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {menuButton.getName()}});
            }
        });
        rowLayout.add(menuButton);
        menuButton = new MenuButton("gotoDivisionsButton", "Change division", 1.0f, 1.0f);
        this.addWidget(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ChooseTrackPanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ChooseDivision"}});
            }
        });
        rowLayout.add(menuButton);
        this.getLayout().add(rowLayout);
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
        this.trackUnlockedFX = new WidgetFXGameObject("trackUnlockedFX", menuButton, WidgetFXGameObject.ResizeMode.WidthOfWidget);
        try {
            this.trackUnlockedFX.load("button_unlocked");
            this.trackUnlockedFX.setDetachWhenDone(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.trackAccomplishedFX = new WidgetFXGameObject("trackAccomplishedFX", menuButton, WidgetFXGameObject.ResizeMode.WidthOfWidget);
        try {
            this.trackAccomplishedFX.load("track_accomplished");
            this.trackAccomplishedFX.setDetachWhenDone(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void buildTrackButtons(int n, DivisionDescriptor divisionDescriptor, Profile profile, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2, ChooseTrack.ChooseTrackMode chooseTrackMode) {
        this.divisionIndex = n;
        this.divisionDescriptor = divisionDescriptor;
        this.profile = profile;
        this.tracksToAccomplish = arrayList != null ? (ArrayList)arrayList.clone() : null;
        this.tracksToUnlock = arrayList != null ? (ArrayList)arrayList2.clone() : null;
        this.chooseTrackMode = chooseTrackMode;
        if (this.isEnabled()) {
            this.buildTrackButtonsNow(n, divisionDescriptor, profile, arrayList, arrayList2, chooseTrackMode);
        }
    }

    private void buildTrackButtonsNow(int n, DivisionDescriptor divisionDescriptor, Profile profile, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2, ChooseTrack.ChooseTrackMode chooseTrackMode) {
        this.divisionLogo.setImage(divisionDescriptor.getImage(n));
        int n2 = divisionDescriptor.getNumberOfTracks(n);
        ProgressData.Division.Track[] trackArray = profile.getData().getProgressData().getDivisions()[n].getTracks();
        TrackButton trackButton = null;
        this.removeButtons();
        this.trackButtons = new MenuButton[n2];
        this.accomplishedImages = new Image[n2];
        this.accomplishedLayouts = new BaseLayout[n2];
        for (int i = 0; i < n2; ++i) {
            VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
            variableColumnLayout.setColumns(3.0f, 6.0f, 0.3f, 1.7f, 1.0f);
            variableColumnLayout.add(null);
            this.tracksLayout.add(variableColumnLayout);
            TrackButton trackButton2 = new TrackButton(divisionDescriptor.getTrack(n, i), i, Boolean.parseBoolean(divisionDescriptor.getTrackProperty(n, i, "challenge", "false")));
            this.addWidget(trackButton2);
            this.widgetsToRemove.add(trackButton2);
            variableColumnLayout.add(trackButton2);
            boolean bl = false;
            boolean bl2 = false;
            if (i < trackArray.length) {
                bl = trackArray[i].isAccomplished();
                bl2 = trackArray[i].isUnlocked();
            }
            if (chooseTrackMode == ChooseTrack.ChooseTrackMode.Career) {
                if (!bl2 || arrayList2 != null && arrayList2.contains(i)) {
                    trackButton2.setEnabled(false);
                } else {
                    trackButton = trackButton2;
                }
            } else if (!bl || arrayList != null && arrayList.contains(i)) {
                trackButton2.setEnabled(false);
            } else {
                trackButton = trackButton2;
            }
            this.trackButtons[i] = trackButton2;
            BaseLayout baseLayout = new BaseLayout();
            variableColumnLayout.add(baseLayout);
            baseLayout.setPadding(-1.7f, 0.0f);
            this.accomplishedLayouts[i] = baseLayout;
            Image image = new Image("Accomplished", "checkbuttonchecked", 1.0f);
            if (bl && (arrayList == null || !arrayList.contains(i))) {
                this.addWidget(image);
                this.widgetsToRemove.add(image);
                baseLayout.add(image);
            }
            this.accomplishedImages[i] = image;
        }
        if (trackButton != null) {
            this.getGuiHandler().focusWidget(trackButton);
        }
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    @Override
    public void onActivate() {
        super.onActivate();
        if (this.divisionDescriptor != null) {
            this.profile = Profile.getCurrentProfile(this.getSettings());
            this.buildTrackButtonsNow(this.divisionIndex, this.divisionDescriptor, this.profile, this.tracksToAccomplish, this.tracksToUnlock, this.chooseTrackMode);
        }
    }

    public void startEffects(IControllerListener iControllerListener) {
        IControllerListener iControllerListener2 = iControllerListener;
        if (!(this.tracksToUnlock != null && this.tracksToUnlock.size() > 0 || this.tracksToAccomplish != null && this.tracksToAccomplish.size() > 0 || iControllerListener2 == null)) {
            iControllerListener2.controllerTaskFinished(null);
        } else {
            BaseWidget baseWidget;
            int n;
            int n2;
            if (this.tracksToAccomplish != null && this.accomplishedImages != null) {
                for (n2 = 0; n2 < this.tracksToAccomplish.size(); ++n2) {
                    n = this.tracksToAccomplish.get(n2);
                    if (n < this.accomplishedImages.length) {
                        baseWidget = this.accomplishedImages[n];
                        this.addWidget(baseWidget);
                        this.widgetsToRemove.add(baseWidget);
                        this.accomplishedLayouts[n].add((IResizableWidget)((Object)baseWidget));
                        this.accomplishedLayouts[n].doLayout();
                        baseWidget.getFader().setColor(1.0f, 1.0f, 1.0f, 0.0f);
                        baseWidget.getFader().fadeTo(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f), 1.0f);
                        this.trackAccomplishedFX.setWidget(baseWidget);
                        this.getGameObjectHandler().addGameObject(this.trackAccomplishedFX);
                        this.trackAccomplishedFX.attachToNode(this);
                        this.trackAccomplishedFX.start();
                        if (iControllerListener != null && (this.tracksToUnlock == null || this.tracksToUnlock.size() <= 0)) {
                            iControllerListener.controllerTaskFinished(null);
                        }
                    }
                    if (n >= this.trackButtons.length) continue;
                    this.trackButtons[n].setEnabled(true);
                }
            }
            if (this.tracksToUnlock != null && this.trackButtons != null) {
                for (n2 = 0; n2 < this.tracksToUnlock.size(); ++n2) {
                    n = this.tracksToUnlock.get(n2);
                    if (n >= this.trackButtons.length) continue;
                    baseWidget = this.trackButtons[n];
                    this.getGuiHandler().focusWidget(null);
                    baseWidget.setEnabled(false);
                    float f = 0.01f;
                    if (this.tracksToAccomplish != null && this.tracksToAccomplish.size() > 0) {
                        f = 1.0f;
                    }
                    ChooseTrackPanel chooseTrackPanel = this;
                    if (this.chooseTrackMode == ChooseTrack.ChooseTrackMode.Career) {
                        this.getTaskManager().add(new Runnable((MenuButton)baseWidget, chooseTrackPanel){
                            final /* synthetic */ MenuButton val$button;
                            final /* synthetic */ ChooseTrackPanel val$fThis;
                            {
                                this.val$button = menuButton;
                                this.val$fThis = chooseTrackPanel2;
                            }

                            public void run() {
                                ChooseTrackPanel.this.trackUnlockedFX.setWidget(this.val$button);
                                ChooseTrackPanel.this.getGameObjectHandler().addGameObject(ChooseTrackPanel.this.trackUnlockedFX);
                                ChooseTrackPanel.this.trackUnlockedFX.attachToNode(this.val$fThis);
                                ChooseTrackPanel.this.trackUnlockedFX.start();
                            }
                        }, f);
                        this.getTaskManager().add(new Runnable((MenuButton)baseWidget, iControllerListener2){
                            final /* synthetic */ MenuButton val$button;
                            final /* synthetic */ IControllerListener val$fDoneListener;
                            {
                                this.val$button = menuButton;
                                this.val$fDoneListener = iControllerListener;
                            }

                            public void run() {
                                this.val$button.setEnabled(true);
                                ChooseTrackPanel.this.getGuiHandler().focusWidget(this.val$button);
                                if (this.val$fDoneListener != null) {
                                    this.val$fDoneListener.controllerTaskFinished(null);
                                }
                            }
                        }, f += 0.5f);
                        continue;
                    }
                    if (iControllerListener2 == null) continue;
                    iControllerListener2.controllerTaskFinished(null);
                }
            }
        }
        this.tracksToAccomplish = null;
        this.tracksToUnlock = null;
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.removeButtons();
    }

    private void removeButtons() {
        for (int i = 0; i < this.widgetsToRemove.size(); ++i) {
            this.removeWidget(this.widgetsToRemove.get(i));
        }
        this.widgetsToRemove.clear();
        if (this.tracksLayout != null) {
            this.tracksLayout.clear();
        }
    }

    private void chosenTrack(int n) {
        if (this.chosenTrackListener != null) {
            this.chosenTrackListener.chosenTrack(this.divisionIndex, n);
        }
    }

    public void setChosenTrackListener(IChosenTrackListener iChosenTrackListener) {
        this.chosenTrackListener = iChosenTrackListener;
    }

    public static interface IChosenTrackListener {
        public void chosenTrack(int var1, int var2);
    }

    private class TrackButton
    extends MenuButton {
        private int index;
        private boolean challenge;

        public TrackButton(String string, int n) {
            this(string, n, false);
        }

        public TrackButton(String string, int n, boolean bl) {
            super("trackButton" + n, string, 1.0f, 1.0f, 1.24f);
            this.challenge = false;
            this.challenge = bl;
            this.index = n;
            this.addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    ChooseTrackPanel.this.chosenTrack(TrackButton.this.index);
                }
            });
            if (this.isChallenge()) {
                this.disabled = new ColorRGBA(0.703125f, 0.53515625f, 0.296875f, 1.0f);
                this.normal = new ColorRGBA(0.9296875f, 0.546875f, 0.0f, 1.0f);
            }
            this.setEnabled(false);
            this.setEnabled(true);
        }

        public void setChallenge(boolean bl) {
            this.challenge = bl;
        }

        public boolean isChallenge() {
            return this.challenge;
        }
    }
}

