/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.msm.gui.turbogui.checkbox.CheckBox;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.listeners.ICheckBoxChanged;
import com.turborilla.msm.gui.turbogui.listeners.IListSelectionChangedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.ScrollableLabelList;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.msm.states.menus.InfoMenuPanel;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoMenuPanel
extends BaseMenuPanel
implements IEventListener {
    private ILayout rowLayout;
    private DisplayInfo displayInfo = null;
    private ScrollableLabelList<DisplayModeWrapper> displayChooser;
    private InfoMenuPanel infoMenuPanel;
    private static int FREQUENCY = 60;
    private static int maxNumberOfModes = 100;
    private CheckBox fullscreen;

    public VideoMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings, InfoMenuPanel infoMenuPanel) {
        super("Video", f, f2, guiHandler, gameSettings);
        this.rowLayout = new RowLayout(new Vector2f(0.0f, -f2 * 0.5f * 0.8f), f, f2 * 0.2f, 0.1f);
        this.infoMenuPanel = infoMenuPanel;
        this.initGUI();
    }

    private void layout() {
        this.displayChooser.setSize(this.getWidth() * 0.5f, this.getHeight() * 0.5f);
        this.displayChooser.setPosition(new Vector2f(0.0f, 0.25f * this.getHeight()));
        this.fullscreen.setSize(this.getWidth(), this.getHeight() * 0.2f);
        this.fullscreen.setPosition(new Vector2f(0.2f * this.getWidth(), -0.16f * this.getHeight()));
        this.rowLayout.setSize(this.getWidth(), this.getHeight() * 0.2f);
        this.rowLayout.setPosition(new Vector2f(0.0f, -this.getHeight() * 0.5f * 0.8f));
        this.rowLayout.setPadding(0.05f, 0.0f);
        this.rowLayout.doLayout();
        this.displayChooser.scrollToSelection();
    }

    private void initGUI() {
        this.displayChooser = new ScrollableLabelList("displayList", this.getWidth() * 0.6f, this.getHeight() * 0.42f, this.getGuiHandler(), "normal_small_black", "corner", "edge", "combobox", 0.3f, (float)DisplaySystem.getDisplaySystem().getHeight() * 0.0225f);
        this.addWidget(this.displayChooser, new Vector2f(0.5f, 0.75f), true, true);
        this.displayChooser.setSelectionChangedListener(new IListSelectionChangedListener<DisplayModeWrapper>(){

            @Override
            public void onSelectionChanged(ScrollableLabelList<DisplayModeWrapper> scrollableLabelList, DisplayModeWrapper displayModeWrapper) {
                ((VideoMenuPanel)VideoMenuPanel.this).displayInfo.selectedMode = displayModeWrapper;
            }
        });
        this.fullscreen = new CheckBox("FullscreenCheckBox", this.getWidth(), this.getHeight() * 0.2f, "Fullscreen", true);
        this.addWidget(this.fullscreen, new Vector2f(0.7f, 0.33f), true, true);
        this.fullscreen.setCheckedListener(new ICheckBoxChanged(){

            public void onCheckBoxChanged(CheckBox checkBox, boolean bl) {
                ((VideoMenuPanel)VideoMenuPanel.this).displayInfo.fullScreen = bl;
            }
        });
        MenuButton menuButton = new MenuButton("cancelButton", "Cancel", 200.0f, 50.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(0.5f, 0.5f), true, true);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                VideoMenuPanel.this.getEventManager().fireEvent("PreviousMenu");
            }
        });
        this.rowLayout.add(menuButton);
        menuButton = new MenuButton("applyButton", "Ok", 200.0f, 50.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(0.5f, 0.5f), true, true);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (VideoMenuPanel.this.getSettings() == null || VideoMenuPanel.this.displayInfo == null || ((VideoMenuPanel)VideoMenuPanel.this).displayInfo.selectedMode == null) {
                    return;
                }
                VideoMenuPanel.this.getSettings().setWidth(((VideoMenuPanel)VideoMenuPanel.this).displayInfo.selectedMode.getWidth());
                VideoMenuPanel.this.getSettings().setHeight(((VideoMenuPanel)VideoMenuPanel.this).displayInfo.selectedMode.getHeight());
                VideoMenuPanel.this.getSettings().setDepth(((VideoMenuPanel)VideoMenuPanel.this).displayInfo.selectedMode.getBitDepth());
                VideoMenuPanel.this.getSettings().setFrequency(((VideoMenuPanel)VideoMenuPanel.this).displayInfo.selectedMode.getRefreshRate());
                VideoMenuPanel.this.getSettings().setFullscreen(((VideoMenuPanel)VideoMenuPanel.this).displayInfo.fullScreen);
                VideoMenuPanel.this.getEventManager().fireEvent(new Event("ChangeDisplayMode"));
            }
        });
        this.rowLayout.add(menuButton);
        this.displayChooser.setSimulateClickWidgetOnDoubleClick(menuButton);
        this.rowLayout.doLayout();
        this.setUp();
        this.layout();
    }

    @Override
    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("DisplayChangeFailed")) {
            this.selectCurrentMode();
            this.infoMenuPanel.info("That display mode does not", "seem to be supported", "", "Ok");
        }
    }

    @Override
    public void onActivate() {
        super.onActivate();
        if (this.getEventManager() != null) {
            this.getEventManager().registerListener("DisplayChangeFailed", this);
        }
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        if (this.getEventManager() != null) {
            this.getEventManager().unregisterListenerForEvent(this, "DisplayChangeFailed");
        }
    }

    private void setSelectedInCombobox(DisplayModeWrapper displayModeWrapper, boolean bl) {
        this.fillDisplayChooserAccordingToBitDepth(this.displayInfo.selectedMode.getBitDepth());
        this.displayChooser.setSelectedItem(displayModeWrapper);
    }

    private void setUp() {
        DisplayModeWrapper[] displayModeWrapperArray;
        DisplayModeWrapper displayModeWrapper = new DisplayModeWrapper(Display.getDisplayMode());
        java.awt.DisplayMode[] displayModeArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayModes();
        DisplayModeWrapper[] displayModeWrapperArray2 = this.wrapArray(displayModeArray);
        DisplayMode[] displayModeArray2 = null;
        try {
            displayModeArray2 = Display.getAvailableDisplayModes();
            if (displayModeWrapperArray2.length < 2) {
                displayModeWrapperArray = null;
                displayModeWrapperArray = Display.getDisplayMode();
                displayModeWrapperArray2 = this.wrapArray(displayModeArray2);
            }
        }
        catch (LWJGLException lWJGLException) {
            // empty catch block
        }
        displayModeWrapperArray = displayModeWrapperArray2;
        Arrays.sort(displayModeWrapperArray, new DisplayModeSorter());
        this.displayInfo = new DisplayInfo(displayModeWrapperArray, displayModeWrapper, DisplaySystem.getDisplaySystem().isFullScreen());
        this.setSelectedInCombobox(this.displayInfo.selectedMode, this.displayInfo.fullScreen);
        this.fullscreen.setChecked(this.displayInfo.fullScreen);
    }

    private void fillDisplayChooserAccordingToBitDepth(int n) {
        this.fillDisplayChooser(n, this.displayInfo.modes, this.displayInfo.selectedMode);
    }

    private void fillDisplayChooser(int n, DisplayModeWrapper[] displayModeWrapperArray, DisplayModeWrapper displayModeWrapper) {
        int[] nArray = n <= 0 ? new int[]{24, 32} : new int[]{n};
        DisplayModeWrapper[] displayModeWrapperArray2 = this.clean(displayModeWrapperArray, nArray, null);
        this.displayChooser.clear();
        for (int i = 0; i < displayModeWrapperArray2.length; ++i) {
            this.displayChooser.addItem(displayModeWrapperArray2[i]);
            if (displayModeWrapperArray2[i].getWidth() != displayModeWrapper.getWidth() || displayModeWrapperArray2[i].getHeight() != displayModeWrapper.getHeight()) continue;
            this.displayChooser.setSelectedItem(displayModeWrapperArray2[i]);
        }
        this.fillSelectedModeFromChooser();
    }

    private void fillSelectedModeFromChooser() {
        DisplayModeWrapper displayModeWrapper = this.displayChooser.getSelected();
        if (this.displayInfo != null && displayModeWrapper != null) {
            this.displayInfo.selectedMode = displayModeWrapper;
        }
    }

    private void selectCurrentMode() {
        this.displayChooser.setSelectedItem(new DisplayModeWrapper(this.getSettings().getWidth(), this.getSettings().getHeight(), this.getSettings().getDepth(), this.getSettings().getFrequency()));
        this.fullscreen.setChecked(this.getSettings().getBoolean("GameFullscreen", false));
    }

    private DisplayModeWrapper[] clean(DisplayModeWrapper[] displayModeWrapperArray, int[] nArray, int[] nArray2) {
        ArrayList<DisplayModeWrapper> arrayList = new ArrayList<DisplayModeWrapper>();
        Arrays.sort(nArray);
        if (nArray2 != null) {
            Arrays.sort(nArray2);
        }
        for (DisplayModeWrapper displayModeWrapper : displayModeWrapperArray) {
            if (Arrays.binarySearch(nArray, displayModeWrapper.getBitDepth()) < 0 && displayModeWrapper.getBitDepth() > 0 || nArray2 != null && Arrays.binarySearch(nArray2, displayModeWrapper.getRefreshRate()) < 0 && displayModeWrapper.getRefreshRate() > 0 || this.isPresent(arrayList, displayModeWrapper)) continue;
            arrayList.add(displayModeWrapper);
            if (arrayList.size() >= maxNumberOfModes) break;
        }
        return arrayList.toArray(new DisplayModeWrapper[0]);
    }

    private boolean isPresent(ArrayList<DisplayModeWrapper> arrayList, DisplayModeWrapper displayModeWrapper) {
        for (DisplayModeWrapper displayModeWrapper2 : arrayList) {
            if (displayModeWrapper2.getWidth() != displayModeWrapper.getWidth() || displayModeWrapper2.getHeight() != displayModeWrapper.getHeight() || displayModeWrapper2.getBitDepth() != displayModeWrapper.getBitDepth()) continue;
            return true;
        }
        return false;
    }

    private DisplayModeWrapper[] wrapArray(java.awt.DisplayMode[] displayModeArray) {
        DisplayModeWrapper[] displayModeWrapperArray = new DisplayModeWrapper[displayModeArray.length];
        for (int i = 0; i < displayModeArray.length; ++i) {
            displayModeWrapperArray[i] = new DisplayModeWrapper(displayModeArray[i]);
        }
        return displayModeWrapperArray;
    }

    private DisplayModeWrapper[] wrapArray(DisplayMode[] displayModeArray) {
        DisplayModeWrapper[] displayModeWrapperArray = new DisplayModeWrapper[displayModeArray.length];
        for (int i = 0; i < displayModeArray.length; ++i) {
            displayModeWrapperArray[i] = new DisplayModeWrapper(displayModeArray[i]);
        }
        return displayModeWrapperArray;
    }

    private boolean isDisplayModeChanged() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        DisplayModeWrapper displayModeWrapper = this.displayInfo.selectedMode;
        return displaySystem.getWidth() != displayModeWrapper.getWidth() || displaySystem.getHeight() != displayModeWrapper.getHeight() || displaySystem.getBitDepth() != displayModeWrapper.getBitDepth() || displaySystem.getFrequency() != displayModeWrapper.getRefreshRate() || displaySystem.isFullScreen() != this.displayInfo.fullScreen;
    }

    @Override
    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.layout();
    }

    @Override
    public boolean isRemoveMeFromEventmanager() {
        return false;
    }

    private class DisplayModeWrapper {
        int width = 0;
        int height = 0;
        int bitDepth = 0;
        int refreshRate = 0;

        public DisplayModeWrapper(int n, int n2, int n3, int n4) {
            this.width = n;
            this.height = n2;
            this.bitDepth = n3;
            this.refreshRate = n4;
        }

        public DisplayModeWrapper(java.awt.DisplayMode displayMode) {
            this.setWidth(displayMode.getWidth());
            this.setHeight(displayMode.getHeight());
            this.setBitDepth(displayMode.getBitDepth());
            this.setRefreshRate(displayMode.getRefreshRate());
        }

        public DisplayModeWrapper(DisplayMode displayMode) {
            this.setWidth(displayMode.getWidth());
            this.setHeight(displayMode.getHeight());
            this.setBitDepth(displayMode.getBitsPerPixel());
            this.setRefreshRate(displayMode.getFrequency());
        }

        public String toString() {
            return "" + this.getWidth() + "x" + this.getHeight() + " " + this.getBitDepth() + "bpp ";
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof DisplayModeWrapper)) {
                return false;
            }
            DisplayModeWrapper displayModeWrapper = (DisplayModeWrapper)object;
            return displayModeWrapper.getWidth() == this.getWidth() && displayModeWrapper.getHeight() == this.getHeight() && displayModeWrapper.getBitDepth() == this.getBitDepth() && displayModeWrapper.getRefreshRate() == this.getRefreshRate();
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int n) {
            this.height = n;
        }

        public int getBitDepth() {
            return this.bitDepth;
        }

        public void setBitDepth(int n) {
            this.bitDepth = n;
        }

        public int getRefreshRate() {
            return this.refreshRate;
        }

        public void setRefreshRate(int n) {
            this.refreshRate = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisplayModeSorter
    implements Comparator<DisplayModeWrapper> {
        private DisplayModeSorter() {
        }

        @Override
        public int compare(DisplayModeWrapper displayModeWrapper, DisplayModeWrapper displayModeWrapper2) {
            if (displayModeWrapper.getWidth() != displayModeWrapper2.getWidth()) {
                return displayModeWrapper.getWidth() < displayModeWrapper2.getWidth() ? 1 : -1;
            }
            if (displayModeWrapper.getHeight() != displayModeWrapper2.getHeight()) {
                return displayModeWrapper.getHeight() < displayModeWrapper2.getHeight() ? 1 : -1;
            }
            if (displayModeWrapper.getBitDepth() != displayModeWrapper2.getBitDepth()) {
                return displayModeWrapper.getBitDepth() < displayModeWrapper2.getBitDepth() ? 1 : -1;
            }
            return 0;
        }
    }

    private class DisplayInfo {
        public DisplayModeWrapper[] modes;
        public DisplayModeWrapper selectedMode;
        public boolean fullScreen;

        DisplayInfo(DisplayModeWrapper[] displayModeWrapperArray, DisplayModeWrapper displayModeWrapper, boolean bl) {
            this.modes = displayModeWrapperArray;
            this.selectedMode = displayModeWrapper;
            this.fullScreen = bl;
        }

        public String getSelectedModeString() {
            DisplayModeWrapper displayModeWrapper = this.selectedMode;
            if (this.fullScreen) {
                return "Fullscreen " + displayModeWrapper.getWidth() + "x" + displayModeWrapper.getHeight() + " " + displayModeWrapper.getBitDepth() + "-bit " + displayModeWrapper.getRefreshRate() + " Hz";
            }
            return "Windowed " + displayModeWrapper.getWidth() + "x" + displayModeWrapper.getHeight() + " " + displayModeWrapper.getBitDepth() + "-bit " + displayModeWrapper.getRefreshRate() + " Hz";
        }

        public DisplayModeWrapper findCurrentMode() {
            DisplayModeWrapper displayModeWrapper = new DisplayModeWrapper(Display.getDisplayMode());
            for (int i = 0; i < this.modes.length; ++i) {
                if (this.modes[i] == null || !this.modes[i].equals(displayModeWrapper)) continue;
                displayModeWrapper = this.modes[i];
            }
            return displayModeWrapper;
        }
    }
}

