/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.listeners.IListSelectionChangedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.ScrollableLabelList;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class ProfileMenuPanel
extends BaseMenuPanel {
    private ScrollableLabelList<String> profileList;
    private ILayout columnLayout;
    private MenuButton okButton;
    private MenuButton renameButton;
    private String wasCurrentProfileName;
    private Profile wasCurrentProfile;

    public ProfileMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("ChooseProfile", f, f2, guiHandler, gameSettings);
        this.columnLayout = new ColumnLayout(new Vector2f(0.0f, -f2 * 0.5f * 0.6f), f, f2 * 0.4f, 0.024f, 0.45f);
        this.initGUI();
    }

    private void initGUI() {
        this.profileList = new ScrollableLabelList("ChooseProfile:FileList", this.getWidth() * 0.6f, this.getHeight() * 0.4f, this.getGuiHandler(), "normal_small_black", "corner", "edge", "combobox", 0.3f, (float)DisplaySystem.getDisplaySystem().getHeight() * 0.0325f);
        this.addWidget(this.profileList, new Vector2f(0.5f, 0.75f), true, true);
        this.refresh();
        RowLayout rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.1f);
        rowLayout.setPadding(0.1f, 0.0f);
        MenuButton menuButton = new MenuButton("newButton", "New", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ProfileMenuPanel.this.newProfile();
            }
        });
        rowLayout.add(menuButton);
        this.renameButton = new MenuButton("changeButton", "Edit", 1.0f, 1.0f, this.textSize);
        this.addWidget(this.renameButton);
        this.renameButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ProfileMenuPanel.this.rename();
            }
        });
        rowLayout.add(this.renameButton);
        this.columnLayout.add(rowLayout);
        rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.1f);
        rowLayout.setPadding(0.1f, 0.0f);
        MenuButton menuButton2 = new MenuButton("cancelButton", "Cancel", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton2);
        menuButton2.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ProfileMenuPanel.this.cancel();
            }
        });
        rowLayout.add(menuButton2);
        this.okButton = new MenuButton("applyButton", "Ok", 1.0f, 1.0f, this.textSize);
        this.addWidget(this.okButton);
        this.okButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ProfileMenuPanel.this.apply();
            }
        });
        rowLayout.add(this.okButton);
        this.columnLayout.add(rowLayout);
        this.columnLayout.doLayout();
        this.profileList.setSelectionChangedListener(new IListSelectionChangedListener<String>(){

            @Override
            public void onSelectionChanged(ScrollableLabelList<String> scrollableLabelList, String string) {
                if (string != null) {
                    Profile.setCurrentProfile(ProfileMenuPanel.this.getSettings(), string);
                }
                ProfileMenuPanel.this.toggleEnabledButtons();
            }
        });
        this.profileList.setSimulateClickWidgetOnDoubleClick(this.okButton);
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.columnLayout.setPosition(new Vector2f(0.0f, -f2 * 0.5f * 0.6f));
        this.columnLayout.setSize(f, f2 * 0.4f);
        this.columnLayout.doLayout();
        this.profileList.setSize(f * 0.6f, f2 * 0.4f);
        this.profileList.setPosition(new Vector2f(0.0f, 0.25f * this.getHeight()));
    }

    private void newProfile() {
        this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"NewProfile"}});
    }

    private void rename() {
        this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"EnterName"}});
    }

    private void cancel() {
        if (this.wasCurrentProfile != null) {
            if (!this.wasCurrentProfile.getName().equals(this.wasCurrentProfileName)) {
                this.wasCurrentProfile.setName(this.wasCurrentProfileName);
            }
            Profile.setCurrentProfile(this.getSettings(), this.wasCurrentProfileName);
        }
        this.getEventManager().fireEvent("PreviousMenu");
    }

    private void apply() {
        String string = this.profileList.getSelected();
        if (string != null) {
            Profile.setCurrentProfile(this.getSettings(), string);
        }
        this.getEventManager().fireEvent("PreviousMenu");
    }

    private void refresh() {
        String[] stringArray;
        String string = this.profileList.getSelected();
        if (string == null) {
            string = Profile.getCurrentProfileName(this.getSettings());
        }
        this.profileList.clear();
        for (String string2 : stringArray = Profile.getAllProfiles()) {
            this.profileList.addItem(string2);
        }
        if (string != null) {
            this.profileList.setSelectedItem(string);
        }
        this.toggleEnabledButtons();
    }

    private void toggleEnabledButtons() {
        if (this.okButton == null || this.renameButton == null) {
            return;
        }
        if (this.profileList.getSelected() == null) {
            this.okButton.setEnabled(false);
            this.renameButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
            this.renameButton.setEnabled(true);
        }
    }

    public void onActivate() {
        this.wasCurrentProfile = Profile.getCurrentProfile(this.getSettings());
        this.wasCurrentProfileName = this.wasCurrentProfile.getName();
        this.profileList.setSelectedItem(null);
        this.refresh();
    }
}

