/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.BorderPanel;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class PlayMenuPanel
extends BaseMenuPanel {
    private Label careerTitle;
    private Label arcadeCompletionLabel;
    private Label simulationCompletionLabel;
    private MenuButton arcadePlayButton;
    private MenuButton simulationPlayButton;

    public PlayMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("Play", f, f2, guiHandler, gameSettings);
        VariableRowLayout variableRowLayout = new VariableRowLayout(f, f2);
        if (Boolean.parseBoolean(gameSettings.get("simulationModeAvailable", "true"))) {
            variableRowLayout.setRows(3.0f, 0.5f, 1.0f, 1.0f);
        } else {
            variableRowLayout.setRows(1.5f, 0.5f, 1.0f, 1.5f, 1.0f);
        }
        this.setLayout(variableRowLayout);
        this.initGUI(guiHandler);
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    private void initGUI(GuiHandler guiHandler) {
        BorderPanel borderPanel = new BorderPanel("careerPanel", this.getWidth(), this.getHeight(), guiHandler, "corner", "edge", "combobox", 0.4f);
        this.addWidget(borderPanel);
        this.getLayout().add(borderPanel);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        if (Boolean.parseBoolean(this.getSettings().get("simulationModeAvailable", "true"))) {
            variableRowLayout.setRows(1.0f, 2.0f, 2.0f);
        } else {
            variableRowLayout.setRows(1.0f, 2.0f);
        }
        borderPanel.setLayout(variableRowLayout);
        BaseLayout baseLayout = new BaseLayout();
        baseLayout.setPadding(0.0f, 0.2f);
        this.careerTitle = new Label("careerTitle", "", 1.0f, 1.0f, "normal_small_black", null);
        borderPanel.addWidget(this.careerTitle);
        baseLayout.add(this.careerTitle);
        variableRowLayout.add(baseLayout);
        VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
        variableColumnLayout.setColumns(5.0f, 3.0f);
        VariableColumnLayout variableColumnLayout2 = new VariableColumnLayout();
        variableColumnLayout2.setColumns(5.0f, 3.0f);
        variableRowLayout.add(variableColumnLayout);
        if (Boolean.parseBoolean(this.getSettings().get("simulationModeAvailable", "true"))) {
            variableRowLayout.add(variableColumnLayout2);
        }
        VariableColumnLayout variableColumnLayout3 = new VariableColumnLayout();
        VariableColumnLayout variableColumnLayout4 = new VariableColumnLayout();
        variableColumnLayout3.setColumns(3.0f, 2.0f);
        variableColumnLayout4.setColumns(3.0f, 2.0f);
        variableColumnLayout3.setPadding(0.1f, 0.6f);
        variableColumnLayout4.setPadding(0.1f, 0.6f);
        variableColumnLayout.add(variableColumnLayout3);
        variableColumnLayout2.add(variableColumnLayout4);
        Label label = new Label("arcadeLabel", Difficulty.Arcade.name(), 1.0f, 1.0f, "italic_small_black", null);
        Label label2 = new Label("simulationLabel", Difficulty.Simulation.name(), 1.0f, 1.0f, "italic_small_black", null);
        borderPanel.addWidget(label);
        borderPanel.addWidget(label2);
        variableColumnLayout3.add(label);
        variableColumnLayout4.add(label2);
        label.setHorisontalAlignment(HorisontalAlignment.LEFT);
        label2.setHorisontalAlignment(HorisontalAlignment.LEFT);
        this.arcadeCompletionLabel = new Label("arcadeCompletionLabel", "0%", 1.0f, 1.0f, "italic_small_black", null);
        this.simulationCompletionLabel = new Label("simulationCompletionLabel", "0%", 1.0f, 1.0f, "italic_small_black", null);
        borderPanel.addWidget(this.arcadeCompletionLabel);
        borderPanel.addWidget(this.simulationCompletionLabel);
        variableColumnLayout3.add(this.arcadeCompletionLabel);
        variableColumnLayout4.add(this.simulationCompletionLabel);
        this.arcadeCompletionLabel.setHorisontalAlignment(HorisontalAlignment.RIGHT);
        this.simulationCompletionLabel.setHorisontalAlignment(HorisontalAlignment.RIGHT);
        this.arcadePlayButton = new MenuButton("arcadePlayButton", "Play", 1.0f, 1.0f);
        this.simulationPlayButton = new MenuButton("simulationPlayButton", "Play", 1.0f, 1.0f);
        BaseLayout baseLayout2 = new BaseLayout();
        baseLayout2.setPadding(0.0f, 0.2f);
        BaseLayout baseLayout3 = new BaseLayout();
        baseLayout3.setPadding(0.0f, 0.2f);
        borderPanel.addWidget(this.arcadePlayButton);
        borderPanel.addWidget(this.simulationPlayButton);
        baseLayout2.add(this.arcadePlayButton);
        baseLayout3.add(this.simulationPlayButton);
        variableColumnLayout.add(baseLayout2);
        variableColumnLayout2.add(baseLayout3);
        this.arcadePlayButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                PlayMenuPanel.this.getSettings().set("FirstProfile", "false");
                PlayMenuPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {"arcadePlayButton"}});
            }
        });
        this.simulationPlayButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                PlayMenuPanel.this.getSettings().set("FirstProfile", "false");
                PlayMenuPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {"simulationPlayButton"}});
            }
        });
        this.getLayout().add(null);
        MenuButton menuButton = new MenuButton("timeAttackButton", "Time attack", 1.0f, 1.0f);
        menuButton.setPadding(0.0f, 0.2f);
        this.addWidget(menuButton);
        this.getLayout().add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (Boolean.parseBoolean(PlayMenuPanel.this.getSettings().get("simulationModeAvailable", "true"))) {
                    PlayMenuPanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ChooseTimeAttackMode"}});
                } else {
                    Profile.getCurrentProfile(PlayMenuPanel.this.getSettings()).setDifficulty(Difficulty.Arcade);
                    PlayMenuPanel.this.getEventManager().fireEvent("ButtonPressed", new String[][]{{"name"}, {"playTimeAttackButton"}});
                }
            }
        });
        this.getLayout().add(null);
        BaseLayout baseLayout4 = new BaseLayout();
        baseLayout4.setPadding(0.5f, 0.2f);
        MenuButton menuButton2 = new MenuButton("backButton", "Back", 200.0f, 50.0f, this.textSize);
        this.addWidget(menuButton2, new Vector2f(0.5f, 0.5f), true, true);
        menuButton2.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                PlayMenuPanel.this.getEventManager().fireEvent("PreviousMenu");
            }
        });
        baseLayout4.add(menuButton2);
        this.getLayout().add(baseLayout4);
        if (Boolean.parseBoolean(this.getSettings().get("simulationModeAvailable", "true"))) {
            this.simulationPlayButton.setNextWidget(menuButton);
            menuButton.setPreviousWidget(this.simulationPlayButton);
            menuButton.setNextWidget(this.arcadePlayButton);
            this.arcadePlayButton.setPreviousWidget(menuButton);
        } else {
            menuButton.setPreviousWidget(this.arcadePlayButton);
            menuButton.setNextWidget(menuButton2);
            this.arcadePlayButton.setPreviousWidget(menuButton2);
            this.arcadePlayButton.setNextWidget(menuButton);
            menuButton2.setPreviousWidget(menuButton);
            menuButton2.setNextWidget(this.arcadePlayButton);
        }
    }

    public void onActivate() {
        super.onActivate();
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        String string = Profile.getCurrentProfileName(this.getSettings());
        if (string.charAt(string.length() - 1) == 's' || string.charAt(string.length() - 1) == 'S') {
            this.careerTitle.setText(string + "' career");
        } else {
            this.careerTitle.setText(string + "'s career");
        }
        this.arcadeCompletionLabel.setText(Math.round(profile.getCompletionPercentage(Difficulty.Arcade) * 100.0f) + "%");
        if (Boolean.parseBoolean(this.getSettings().get("simulationModeAvailable", "true"))) {
            this.simulationCompletionLabel.setText(Math.round(profile.getCompletionPercentage(Difficulty.Simulation) * 100.0f) + "%");
        }
        if (profile.getDifficulty() == Difficulty.Simulation) {
            this.getGuiHandler().focusWidget(this.simulationPlayButton);
        } else {
            this.getGuiHandler().focusWidget(this.arcadePlayButton);
        }
    }
}

