/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.input.InputHandler;
import com.jme.math.Vector2f;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.msm.Game;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.gui.turbogui.Image;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.statemachine.MsmStateMachineException;
import com.turborilla.msm.states.MsmGameStateException;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.states.menus.ArcadeControlsMenuPanel;
import com.turborilla.msm.states.menus.AudioMenuPanel;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.msm.states.menus.BaseMenuState;
import com.turborilla.msm.states.menus.ChooseTimeAttackModeMenuPanel;
import com.turborilla.msm.states.menus.CompletedGameMenuPanel;
import com.turborilla.msm.states.menus.ConfigureGamepadMenuPanel;
import com.turborilla.msm.states.menus.ConfigureKeyboardMenuPanel;
import com.turborilla.msm.states.menus.ConfigureMouseMenuPanel;
import com.turborilla.msm.states.menus.ConfirmMenuPanel;
import com.turborilla.msm.states.menus.ControlsMenuPanel;
import com.turborilla.msm.states.menus.InGameMenuPanel;
import com.turborilla.msm.states.menus.InfoMenuPanel;
import com.turborilla.msm.states.menus.MainMenuPanel;
import com.turborilla.msm.states.menus.NewProfileMenuPanel;
import com.turborilla.msm.states.menus.OptionsMenuPanel;
import com.turborilla.msm.states.menus.PlayMenuPanel;
import com.turborilla.msm.states.menus.ProfileMenuPanel;
import com.turborilla.msm.states.menus.ProfilePanel;
import com.turborilla.msm.states.menus.RenameProfileMenuPanel;
import com.turborilla.msm.states.menus.SimulationControlsMenuPanel;
import com.turborilla.msm.states.menus.VideoMenuPanel;
import com.turborilla.msm.states.menus.YouLostMenuPanel;
import com.turborilla.msm.states.menus.YouWonMenuPanel;
import com.turborilla.sound.SFX;
import com.turborilla.utils.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

public class MenuState
extends BaseMenuState {
    private float textSize;
    private ILayout layout;
    private Image logo;
    private MainMenuPanel mainMenuPanel;
    private ProfilePanel profilePanel;
    private GameState gameState;
    boolean startNewBackgroundRaceWhenActivated = true;

    public MenuState(String string, GameSettings gameSettings, URL uRL, GameState gameState) {
        super(string, gameSettings, uRL);
        this.gameState = gameState;
    }

    public MenuState(String string, GameSettings gameSettings, URL uRL, InputHandler inputHandler, GameState gameState) {
        super(string, gameSettings, uRL, inputHandler);
        this.gameState = gameState;
    }

    protected void initGUI() {
        this.setPanelPosition(0.5f, 0.3f);
        this.setMenuToSwitchToWhenReady("Main");
        this.textSize = 1.24f;
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.logo = new Image("Logo", "logomenu", 0.46f * (float)displaySystem.getHeight());
        this.getGui().addWidget(this.logo, new Vector2f(0.5f, 0.76f), true, true);
        float f = (float)displaySystem.getHeight() * 0.63f;
        float f2 = (float)displaySystem.getHeight() * 0.45f;
        this.mainMenuPanel = new MainMenuPanel(f, f2, this.getGui(), this.getSettings());
        this.addMenu(this.mainMenuPanel);
        InfoMenuPanel infoMenuPanel = new InfoMenuPanel(f, f2, this.getGui(), this.getSettings());
        this.addMenu(infoMenuPanel);
        this.addMenu(new PlayMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new ChooseTimeAttackModeMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new RenameProfileMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new OptionsMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new VideoMenuPanel(f, f2, this.getGui(), this.getSettings(), infoMenuPanel));
        SFX[] sFXArray = new SFX[4];
        try {
            sFXArray[0] = null;
            sFXArray[1] = (SFX)ResourceManager.getInstance().load("sfx", "beep", null);
            sFXArray[2] = (SFX)ResourceManager.getInstance().load("sfx", "bikenoise_plus_145384", null);
            sFXArray[3] = (SFX)ResourceManager.getInstance().load("sfx", "bikenoise_plus_145384", null);
        }
        catch (IOException iOException) {
            Logger.getLogger(Game.class.getName()).warning("Could not load preview sounds. Exception: " + iOException);
            sFXArray = null;
        }
        this.addMenu(new AudioMenuPanel(f, f2, this.getGui(), this.getSettings(), new String[][]{{"Music volume:", "GameMusicVolume"}, {"Sound effects volume:", "GameSFXVolume"}, {"Player engine volume:", "GamePlayerEngineVolume"}, {"Opponent engine volume:", "GameOpponentEngineVolume"}}, sFXArray));
        this.addMenu(new ControlsMenuPanel(f, f2, this.getGui(), this.getSettings()));
        ConfigureKeyboardMenuPanel configureKeyboardMenuPanel = new ConfigureKeyboardMenuPanel(f, f2, this.getGui(), this.getSettings());
        this.addMenu(configureKeyboardMenuPanel);
        ConfigureGamepadMenuPanel configureGamepadMenuPanel = new ConfigureGamepadMenuPanel(f, f2, this.getGui(), this.getSettings());
        this.addMenu(configureGamepadMenuPanel);
        ConfigureMouseMenuPanel configureMouseMenuPanel = new ConfigureMouseMenuPanel(f, f2, this.getGui(), this.getSettings());
        this.addMenu(configureMouseMenuPanel);
        this.addMenu(new ArcadeControlsMenuPanel(f, f2, this.getGui(), this.getSettings(), configureGamepadMenuPanel, configureKeyboardMenuPanel, configureMouseMenuPanel));
        this.addMenu(new SimulationControlsMenuPanel(f, f2, this.getGui(), this.getSettings(), configureGamepadMenuPanel, configureKeyboardMenuPanel, configureMouseMenuPanel));
        this.addMenu(new ProfileMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new NewProfileMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new ConfirmMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new InGameMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new YouWonMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new YouLostMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new CompletedGameMenuPanel(f, f2, this.getGui(), this.getSettings()));
        this.addMenu(new BaseMenuPanel("Empty", f, f2, this.getGui(), this.getSettings()){});
        this.profilePanel = new ProfilePanel("ProfilePanel", (float)displaySystem.getHeight() * 0.2f, (float)displaySystem.getHeight() * 0.2f, this.getGui(), this.settings, this.textSize);
        this.mainMenuPanel.addWidget(this.profilePanel, new Vector2f(-0.3f, 1.8f), true, true);
    }

    protected void onActivate() throws IOException {
        if (this.startNewBackgroundRaceWhenActivated) {
            this.startNewBackgroundRace();
            this.startNewBackgroundRaceWhenActivated = false;
        }
        super.onActivate();
    }

    private void startNewBackgroundRace() throws IOException {
        DivisionDescriptor divisionDescriptor = null;
        ProgressData progressData = Profile.getCurrentProfile(this.getSettings()).getData().getProgressData();
        ProgressData.Division division = progressData.getCurrentDivision();
        try {
            divisionDescriptor = Profile.getCurrentProfile(this.getSettings()).getDifficulty() == Difficulty.Arcade ? (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "arcade_divisions", null) : (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "simulation_divisions", null);
        }
        catch (IOException iOException) {
            throw new MsmStateMachineException(iOException);
        }
        int n = -1;
        if (division != null) {
            n = division.getIndex();
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = divisionDescriptor.getNumberOfTracks(n);
        int n3 = (int)Math.floor(Math.random() * (double)n2);
        if (n3 >= n2) {
            n3 = n2 - 1;
        }
        String string = divisionDescriptor.getTrack(n, n3);
        if (this.gameState.getParallax() == null) {
            this.gameState.prepareNewRace(Utils.getProperties(new String[][]{{"environment", "track", "numberOfBikes", "bike0", "bike1", "cameraFollowBikeNumber", "startsequence", "finishline"}, {divisionDescriptor.getEnvironment(n, null), string, "1", "computer", "computer", "-1", "false", "false"}}));
        } else {
            this.gameState.prepareNewRace(Utils.getProperties(new String[][]{{"track", "numberOfBikes", "bike0", "bike1", "cameraFollowBikeNumber", "startsequence", "finishline"}, {string, "1", "computer", "computer", "-1", "false", "false"}}));
        }
    }

    protected void resizeGui(Vector2f vector2f) {
        super.resizeGui(vector2f);
        for (int i = 0; i < this.menus.size(); ++i) {
            ((BaseMenuPanel)this.menus.get(i)).setSize(vector2f.y * 0.63f, vector2f.y * 0.45f);
        }
        this.logo.setSize(vector2f.y * 0.46f, vector2f.y * 0.46f);
        this.logo.setPosition(new Vector2f(0.5f * vector2f.x, 0.76f * vector2f.y));
        this.mainMenuPanel.removeWidget(this.profilePanel);
        this.profilePanel.setSize(vector2f.x * 0.2f, vector2f.y * 0.15f);
        this.mainMenuPanel.addWidget(this.profilePanel, new Vector2f(-0.3f, 1.8f), true, true);
    }

    protected void setCurrentMenu(BaseMenuPanel baseMenuPanel) {
        super.setCurrentMenu(baseMenuPanel);
        if (this.profilePanel != null) {
            this.profilePanel.update();
        }
    }

    public void setGlobalEventManager(EventManager eventManager) {
        super.setGlobalEventManager(eventManager);
        this.profilePanel.setEventManager(this.getGlobalEventManager());
        eventManager.registerListener("StartNewBackgroundRace", this);
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        super.handleEvent(receivedEvent);
        if ("StartNewBackgroundRace".equals(receivedEvent.getName())) {
            if (!this.isActive()) {
                this.startNewBackgroundRaceWhenActivated = true;
                return;
            }
            this.startNewBackgroundRaceWhenActivated = false;
            try {
                this.startNewBackgroundRace();
            }
            catch (IOException iOException) {
                throw new MsmGameStateException(iOException);
            }
        }
    }
}

