/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class DifficultyMenuPanel
extends BaseMenuPanel {
    ILayout layout;
    Difficulty chosenDifficulty = null;

    public DifficultyMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("Difficulty", f, f2, guiHandler, gameSettings);
        this.layout = new ColumnLayout(new Vector2f(), f, f2, 0.024f, 0.25f);
        this.initGUI();
    }

    private void initGUI() {
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        Difficulty[] difficultyArray = profile.getAvailableDifficulties();
        int n = difficultyArray.length;
        for (int i = 0; i < n; ++i) {
            Difficulty difficulty;
            final Difficulty difficulty2 = difficulty = difficultyArray[i];
            MenuButton menuButton = new MenuButton(difficulty.getName() + "Button", difficulty.getName(), 1.0f, 1.0f, this.textSize);
            this.addWidget(menuButton);
            this.layout.add(menuButton);
            menuButton.addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    DifficultyMenuPanel.this.chosenDifficulty = difficulty2;
                    Profile profile = Profile.getCurrentProfile(DifficultyMenuPanel.this.getSettings());
                    profile.setDifficulty(DifficultyMenuPanel.this.chosenDifficulty);
                    profile.save();
                    DifficultyMenuPanel.this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"Main"}});
                }
            });
            this.toolTip(menuButton, difficulty.getDescription());
        }
        this.layout.doLayout();
    }

    public void onActivate() {
        super.onActivate();
        this.chosenDifficulty = Profile.getCurrentProfile(this.getSettings()).getDifficulty();
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.layout.setSize(f, f2);
        this.layout.doLayout();
    }
}

