/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class ControlsMenuPanel
extends BaseMenuPanel {
    public ControlsMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("Controls", f, f2, guiHandler, gameSettings);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(4.0f, 1.0f);
        this.setLayout(variableRowLayout);
        this.initGUI();
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    private void initGUI() {
        ColumnLayout columnLayout = new ColumnLayout();
        this.getLayout().add(columnLayout);
        MenuButton menuButton = new MenuButton("ArcadeControlsButton", "Arcade controls", 1.0f, 1.0f);
        this.addWidget(menuButton);
        columnLayout.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ControlsMenuPanel.this.arcade();
            }
        });
        MenuButton menuButton2 = new MenuButton("SimulationControlsButton", "Simulation controls", 1.0f, 1.0f);
        this.addWidget(menuButton2);
        columnLayout.add(menuButton2);
        menuButton2.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ControlsMenuPanel.this.simulation();
            }
        });
        columnLayout.add(null);
        RowLayout rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.1f);
        this.getLayout().add(rowLayout);
        rowLayout.setPadding(0.45f, 0.05f);
        MenuButton menuButton3 = new MenuButton("OkButton", "Back", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton3, new Vector2f(), true, true);
        rowLayout.add(menuButton3);
        menuButton3.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ControlsMenuPanel.this.apply();
            }
        });
        this.reset();
    }

    protected void simulation() {
        this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"SimulationControls"}});
    }

    protected void arcade() {
        this.getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ArcadeControls"}});
    }

    private void reset() {
    }

    private void apply() {
        this.getEventManager().fireEvent("PreviousMenu");
    }

    private void cancel() {
        this.reset();
        this.getEventManager().fireEvent("PreviousMenu");
    }

    public void onActivate() {
        this.reset();
        if (Profile.getCurrentProfile(this.getSettings()).getDifficulty() == Difficulty.Simulation) {
            this.getGuiHandler().focusWidget(this.getLayer("SimulationControlsButton"));
        } else if (Profile.getCurrentProfile(this.getSettings()).getDifficulty() == Difficulty.Arcade) {
            this.getGuiHandler().focusWidget(this.getLayer("ArcadeControlsButton"));
        }
        super.onActivate();
    }
}

