/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.KeyboardData;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class ConfigureKeyboardMenuPanel
extends BaseMenuPanel {
    private ConfigureKeyboardInputLabel configureInputLabel;
    private Difficulty difficulty = Difficulty.Arcade;

    public ConfigureKeyboardMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("ConfigureKeyboard", f, f2, guiHandler, gameSettings);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.33f, 1.33f, 1.33f, 1.0f);
        this.setLayout(variableRowLayout);
        this.initGUI();
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    private void initGUI() {
        this.getLayout().add(null);
        BaseLayout baseLayout = new BaseLayout();
        this.getLayout().add(baseLayout);
        this.configureInputLabel = new ConfigureKeyboardInputLabel("ConfigureInputLabel");
        baseLayout.add(this.configureInputLabel);
        this.addWidget(this.configureInputLabel);
        this.configureInputLabel.setDoneListener(new Runnable(){

            public void run() {
                ConfigureKeyboardMenuPanel.this.apply();
            }
        });
        this.getLayout().add(null);
        RowLayout rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.2f);
        this.getLayout().add(rowLayout);
        MenuButton menuButton = new MenuButton("CancelButton", "Cancel", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        rowLayout.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ConfigureKeyboardMenuPanel.this.cancel();
            }
        });
        this.reset();
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    private void reset() {
        this.configureInputLabel.reset();
    }

    private void apply() {
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        KeyboardData keyboardData = profile.getData(this.difficulty).getInputData().getKeyboardData();
        keyboardData.setThrottle(this.configureInputLabel.throttle);
        keyboardData.setBrake(this.configureInputLabel.brake);
        keyboardData.setLeft(this.configureInputLabel.left);
        keyboardData.setRight(this.configureInputLabel.right);
        keyboardData.setSpecial(this.configureInputLabel.special);
        keyboardData.setConfigured(true);
        profile.save();
        profile.getData(this.difficulty).getInputData().notifyChangeListeners();
        this.getEventManager().fireEvent("PreviousMenu");
    }

    private void cancel() {
        this.getEventManager().fireEvent("PreviousMenu");
    }

    public void onActivate() {
        this.reset();
        super.onActivate();
        this.getGuiHandler().focusWidget(this.configureInputLabel);
    }

    public void onDeactivate() {
        super.onDeactivate();
    }

    private class ConfigureKeyboardInputLabel
    extends Label {
        private int step;
        private static final int numKeys = 300;
        private String[] stepTextArcade;
        private String[] stepTextSimulation;
        int throttle;
        int brake;
        int left;
        int right;
        int special;
        int[] alreadyChosenButtons;
        boolean[] buttonStateChanged;
        private Runnable doneListener;

        public ConfigureKeyboardInputLabel(String string) {
            super(string, "", 1.0f, 1.0f, "textfont", null);
            this.step = 0;
            this.stepTextArcade = new String[]{"press THROTTLE", "press BRAKE", "press LEFT", "press RIGHT", "press SPECIAL"};
            this.stepTextSimulation = new String[]{"press THROTTLE", "press BRAKE", "press LEFT", "press RIGHT", "press SLOW-MO"};
            this.alreadyChosenButtons = new int[5];
            this.doneListener = null;
            this.setFocusable(true);
            this.reset();
        }

        public void reset() {
            int n;
            for (n = 0; n < this.alreadyChosenButtons.length; ++n) {
                this.alreadyChosenButtons[n] = -1;
            }
            if (this.buttonStateChanged == null) {
                this.buttonStateChanged = new boolean[300];
            }
            for (n = 0; n < this.buttonStateChanged.length; ++n) {
                this.buttonStateChanged[n] = false;
            }
            this.gotoStep(0);
        }

        public void update() {
            if (!this.isEnabled()) {
                return;
            }
            switch (this.step) {
                case 0: {
                    int n = this.getButton();
                    if (n < 0) break;
                    this.throttle = n;
                    this.nextStep();
                    break;
                }
                case 1: {
                    int n = this.getButton();
                    if (n < 0) break;
                    this.brake = n;
                    this.nextStep();
                    break;
                }
                case 2: {
                    int n = this.getButton();
                    if (n < 0) break;
                    this.left = n;
                    this.nextStep();
                    break;
                }
                case 3: {
                    int n = this.getButton();
                    if (n < 0) break;
                    this.right = n;
                    this.nextStep();
                    break;
                }
                case 4: {
                    int n = this.getButton();
                    if (n < 0) break;
                    this.special = n;
                    this.nextStep();
                }
            }
        }

        private int getButton() {
            int n = -1;
            for (int i = 0; i < this.buttonStateChanged.length; ++i) {
                if (this.isAlreadyChosen(i, this.alreadyChosenButtons) || !this.buttonStateChanged[i]) continue;
                this.setAlreadyChosen(i, this.alreadyChosenButtons);
                n = i;
                break;
            }
            return n;
        }

        private boolean isAlreadyChosen(int n, int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
            return false;
        }

        private void setAlreadyChosen(int n, int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= 0) continue;
                nArray[i] = n;
                return;
            }
        }

        private void nextStep() {
            if (this.step + 1 >= (ConfigureKeyboardMenuPanel.this.difficulty == Difficulty.Simulation ? this.stepTextSimulation.length : this.stepTextArcade.length)) {
                this.done();
            } else {
                this.gotoStep(this.step + 1);
            }
        }

        private void done() {
            this.setText("");
            if (this.doneListener != null) {
                this.doneListener.run();
            }
        }

        private void gotoStep(int n) {
            this.step = n;
            this.setText(ConfigureKeyboardMenuPanel.this.difficulty == Difficulty.Simulation ? this.stepTextSimulation[n] : this.stepTextArcade[n]);
        }

        public boolean onKeyDown(int n, char c) {
            return true;
        }

        public boolean onKeyTyped(int n, char c) {
            this.buttonStateChanged[n] = true;
            return true;
        }

        public boolean onKeyUp(int n, char c) {
            return true;
        }

        public void updateGeometricState(float f, boolean bl) {
            super.updateGeometricState(f, bl);
            this.update();
        }

        public void setDoneListener(Runnable runnable) {
            this.doneListener = runnable;
        }
    }
}

