/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.JoystickData;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.menus.BaseMenuPanel;

public class ConfigureGamepadMenuPanel
extends BaseMenuPanel {
    private ConfigureJoystickInputLabel configureInputLabel;
    private Difficulty difficulty = Difficulty.Arcade;
    private boolean wasJoystickEnabled;

    public ConfigureGamepadMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super("ConfigureGamepad", f, f2, guiHandler, gameSettings);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.33f, 1.33f, 1.33f, 1.0f);
        this.setLayout(variableRowLayout);
        this.initGUI();
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.getLayout().doLayout();
    }

    private void initGUI() {
        this.getLayout().add(null);
        BaseLayout baseLayout = new BaseLayout();
        this.getLayout().add(baseLayout);
        this.configureInputLabel = new ConfigureJoystickInputLabel("ConfigureInputLabel", JoystickInput.get());
        baseLayout.add(this.configureInputLabel);
        this.addWidget(this.configureInputLabel);
        this.configureInputLabel.setDoneListener(new Runnable(){

            public void run() {
                ConfigureGamepadMenuPanel.this.apply();
            }
        });
        this.getLayout().add(null);
        RowLayout rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.2f);
        this.getLayout().add(rowLayout);
        MenuButton menuButton = new MenuButton("CancelButton", "Cancel", 1.0f, 1.0f, this.textSize);
        this.addWidget(menuButton, new Vector2f(), true, true);
        rowLayout.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                ConfigureGamepadMenuPanel.this.cancel();
            }
        });
        this.reset();
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    private void reset() {
        this.configureInputLabel.reset();
    }

    private void apply() {
        Profile profile = Profile.getCurrentProfile(this.getSettings());
        JoystickData joystickData = profile.getData(this.difficulty).getInputData().getJoystickData();
        joystickData.setJoystickIndex(this.configureInputLabel.joystickIndex);
        joystickData.setXAxisIndex(this.configureInputLabel.xAxisIndex);
        joystickData.setXAxisMaximumValue(this.configureInputLabel.xAxisMaximumValue);
        joystickData.setXAxisMinimumValue(this.configureInputLabel.xAxisMinimumValue);
        joystickData.setXAxisInverted(this.configureInputLabel.xAxisInverted);
        joystickData.setYAxisIndex(this.configureInputLabel.yAxisIndex);
        joystickData.setYAxisMaximumValue(this.configureInputLabel.yAxisMaximumValue);
        joystickData.setYAxisMinimumValue(this.configureInputLabel.yAxisMinimumValue);
        joystickData.setYAxisInverted(this.configureInputLabel.yAxisInverted);
        joystickData.setThrottleButtonIndex(this.configureInputLabel.throttleButtonIndex);
        joystickData.setBrakeButtonIndex(this.configureInputLabel.brakeButtonIndex);
        joystickData.setSpecialButtonIndex(this.configureInputLabel.specialButtonIndex);
        joystickData.setConfigured(true);
        profile.save();
        profile.getData(this.difficulty).getInputData().notifyChangeListeners();
        if (this.wasJoystickEnabled) {
            this.getGuiHandler().setJoystickEnabled(true);
        }
        this.getEventManager().fireEvent("PreviousMenu");
    }

    private void cancel() {
        if (this.wasJoystickEnabled) {
            this.getGuiHandler().setJoystickEnabled(true);
        }
        this.getEventManager().fireEvent("PreviousMenu");
    }

    public void onActivate() {
        this.reset();
        super.onActivate();
        this.wasJoystickEnabled = this.getGuiHandler().isJoystickEnabled();
        if (this.wasJoystickEnabled) {
            this.getGuiHandler().setJoystickEnabled(false);
        }
    }

    public void onDeactivate() {
        super.onDeactivate();
    }

    private class ConfigureJoystickInputLabel
    extends Label {
        private float threshold;
        private int step;
        private String[] stepTextArcade;
        private String[] stepTextSimulation;
        private JoystickInput joystickInput;
        int joystickIndex;
        int xAxisIndex;
        float xAxisMaximumValue;
        float xAxisMinimumValue;
        boolean xAxisInverted;
        int yAxisIndex;
        float yAxisMaximumValue;
        float yAxisMinimumValue;
        boolean yAxisInverted;
        int throttleButtonIndex;
        int brakeButtonIndex;
        int specialButtonIndex;
        int[] alreadyChosenAxes;
        int[] alreadyChosenButtons;
        float[][] axesState;
        float[][] axesMaxState;
        float[][] axesMinState;
        boolean[][] buttonState;
        boolean[][] axesStateChanged;
        boolean[][] buttonStateChanged;
        private Runnable doneListener;
        private boolean negative;

        public ConfigureJoystickInputLabel(String string, JoystickInput joystickInput) {
            super(string, "", 1.0f, 1.0f, "textfont", null);
            this.threshold = 0.6f;
            this.step = 0;
            this.stepTextArcade = new String[]{"move UP", "move RIGHT", "press THROTTLE", "press BRAKE", "press SPECIAL"};
            this.stepTextSimulation = new String[]{"move UP", "move RIGHT", "press THROTTLE", "press BRAKE", "press SLOW-MO"};
            this.joystickIndex = -1;
            this.xAxisIndex = 0;
            this.xAxisMaximumValue = 1.0f;
            this.xAxisMinimumValue = -1.0f;
            this.xAxisInverted = false;
            this.yAxisIndex = 1;
            this.yAxisMaximumValue = 1.0f;
            this.yAxisMinimumValue = -1.0f;
            this.yAxisInverted = false;
            this.throttleButtonIndex = 0;
            this.brakeButtonIndex = 1;
            this.specialButtonIndex = 2;
            this.alreadyChosenAxes = new int[2];
            this.alreadyChosenButtons = new int[3];
            this.doneListener = null;
            this.joystickInput = joystickInput;
            this.reset();
        }

        public void reset() {
            int n;
            int n2;
            this.axesMaxState = new float[this.joystickInput.getJoystickCount()][30];
            this.axesMinState = new float[this.joystickInput.getJoystickCount()][30];
            for (n2 = 0; n2 < this.joystickInput.getJoystickCount(); ++n2) {
                for (n = 0; n < this.axesMaxState[n2].length; ++n) {
                    this.axesMaxState[n2][n] = Float.NEGATIVE_INFINITY;
                }
            }
            for (n2 = 0; n2 < this.joystickInput.getJoystickCount(); ++n2) {
                for (n = 0; n < this.axesMinState[n2].length; ++n) {
                    this.axesMinState[n2][n] = Float.POSITIVE_INFINITY;
                }
            }
            for (n2 = 0; n2 < this.alreadyChosenAxes.length; ++n2) {
                this.alreadyChosenAxes[n2] = -1;
            }
            for (n2 = 0; n2 < this.alreadyChosenButtons.length; ++n2) {
                this.alreadyChosenButtons[n2] = -1;
            }
            this.joystickIndex = -1;
            this.gotoStep(0);
        }

        public void update() {
            if (!this.isEnabled()) {
                return;
            }
            this.negative = false;
            this.checkChangedStates();
            switch (this.step) {
                case 0: {
                    int n = this.getAxis();
                    if (n < 0) break;
                    this.yAxisIndex = n;
                    this.yAxisInverted = this.negative;
                    this.nextStep();
                    break;
                }
                case 1: {
                    int n = this.getAxis();
                    if (n < 0) break;
                    this.xAxisIndex = n;
                    this.xAxisInverted = this.negative;
                    this.nextStep();
                    break;
                }
                case 2: {
                    this.getAxis();
                    int n = this.getButton();
                    if (n < 0) break;
                    this.throttleButtonIndex = n;
                    this.nextStep();
                    break;
                }
                case 3: {
                    int n = this.getButton();
                    if (n < 0) break;
                    this.brakeButtonIndex = n;
                    this.nextStep();
                    break;
                }
                case 4: {
                    int n = this.getButton();
                    if (n < 0) break;
                    this.specialButtonIndex = n;
                    this.nextStep();
                }
            }
        }

        private int getButton() {
            int n = -1;
            if (this.joystickIndex < 0) {
                for (int i = 0; i < this.joystickInput.getJoystickCount(); ++i) {
                    n = this.getButton(i);
                    if (n < 0) continue;
                    this.joystickIndex = i;
                    break;
                }
            } else {
                n = this.getButton(this.joystickIndex);
            }
            return n;
        }

        private int getButton(int n) {
            int n2 = -1;
            Joystick joystick = this.joystickInput.getJoystick(n);
            if (joystick == null) {
                return -1;
            }
            for (int i = 0; i < joystick.getButtonCount() && i < this.buttonStateChanged[n].length; ++i) {
                boolean bl;
                if (this.isAlreadyChosen(i, this.alreadyChosenButtons) || !this.buttonStateChanged[n][i] || !(bl = joystick.isButtonPressed(i))) continue;
                this.setAlreadyChosen(i, this.alreadyChosenButtons);
                n2 = i;
            }
            return n2;
        }

        private int getAxis() {
            int n = -1;
            if (this.joystickIndex < 0) {
                for (int i = 0; i < this.joystickInput.getJoystickCount(); ++i) {
                    n = this.getAxis(i);
                    if (n < 0) continue;
                    this.joystickIndex = i;
                    break;
                }
            } else {
                n = this.getAxis(this.joystickIndex);
            }
            return n;
        }

        private int getAxis(int n) {
            int n2 = -1;
            Joystick joystick = this.joystickInput.getJoystick(n);
            if (joystick == null) {
                return -1;
            }
            for (int i = 0; i < joystick.getAxisCount() && i < this.axesStateChanged[n].length; ++i) {
                float f = joystick.getAxisValue(i);
                if (f > this.axesMaxState[n][i]) {
                    this.axesMaxState[n][i] = f;
                }
                if (f < this.axesMinState[n][i]) {
                    this.axesMinState[n][i] = f;
                }
                if (this.isAlreadyChosen(i, this.alreadyChosenAxes) || !this.axesStateChanged[n][i] || !(Math.abs(f) >= this.threshold)) continue;
                this.setAlreadyChosen(i, this.alreadyChosenAxes);
                n2 = i;
                if (f < 0.0f) {
                    this.negative = true;
                    break;
                }
                this.negative = false;
                break;
            }
            return n2;
        }

        private boolean isAlreadyChosen(int n, int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
            return false;
        }

        private void setAlreadyChosen(int n, int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= 0) continue;
                nArray[i] = n;
                return;
            }
        }

        private void nextStep() {
            if (this.step + 1 >= (ConfigureGamepadMenuPanel.this.difficulty == Difficulty.Simulation ? this.stepTextSimulation.length : this.stepTextArcade.length)) {
                this.done();
            } else {
                this.gotoStep(this.step + 1);
            }
        }

        private void done() {
            this.setText("");
            if (!this.xAxisInverted) {
                this.xAxisMaximumValue = this.axesMaxState[this.joystickIndex][this.xAxisIndex];
                this.xAxisMinimumValue = -this.xAxisMaximumValue;
            } else {
                this.xAxisMinimumValue = this.axesMinState[this.joystickIndex][this.xAxisIndex];
                this.xAxisMaximumValue = -this.xAxisMinimumValue;
            }
            if (!this.yAxisInverted) {
                this.yAxisMaximumValue = this.axesMaxState[this.joystickIndex][this.yAxisIndex];
                this.yAxisMinimumValue = -this.yAxisMaximumValue;
            } else {
                this.yAxisMinimumValue = this.axesMinState[this.joystickIndex][this.yAxisIndex];
                this.yAxisMaximumValue = -this.yAxisMinimumValue;
            }
            if (this.doneListener != null) {
                this.doneListener.run();
            }
        }

        private void gotoStep(int n) {
            this.step = n;
            this.setText(ConfigureGamepadMenuPanel.this.difficulty == Difficulty.Simulation ? this.stepTextSimulation[n] : this.stepTextArcade[n]);
            this.recordState();
        }

        private void recordState() {
            this.axesStateChanged = new boolean[this.joystickInput.getJoystickCount()][30];
            this.buttonStateChanged = new boolean[this.joystickInput.getJoystickCount()][30];
            this.axesState = new float[this.joystickInput.getJoystickCount()][30];
            this.buttonState = new boolean[this.joystickInput.getJoystickCount()][30];
            for (int i = 0; i < this.joystickInput.getJoystickCount(); ++i) {
                for (int j = 0; j < 30; ++j) {
                    this.axesStateChanged[i][j] = false;
                    this.buttonStateChanged[i][j] = false;
                    this.axesState[i][j] = j < this.joystickInput.getJoystick(i).getAxisCount() ? this.joystickInput.getJoystick(i).getAxisValue(j) : 0.0f;
                    this.buttonState[i][j] = j < this.joystickInput.getJoystick(i).getButtonCount() ? this.joystickInput.getJoystick(i).isButtonPressed(j) : false;
                }
            }
        }

        private void checkChangedStates() {
            for (int i = 0; i < this.joystickInput.getJoystickCount(); ++i) {
                for (int j = 0; j < 30; ++j) {
                    boolean bl;
                    float f;
                    if (j < this.joystickInput.getJoystick(i).getAxisCount() && Math.abs((f = this.joystickInput.getJoystick(i).getAxisValue(j)) - this.axesState[i][j]) > this.threshold) {
                        this.axesState[i][j] = f;
                        this.axesStateChanged[i][j] = true;
                    }
                    if (j >= this.joystickInput.getJoystick(i).getButtonCount() || (bl = this.joystickInput.getJoystick(i).isButtonPressed(j)) == this.buttonState[i][j]) continue;
                    this.buttonState[i][j] = bl;
                    this.buttonStateChanged[i][j] = true;
                }
            }
        }

        public void updateGeometricState(float f, boolean bl) {
            super.updateGeometricState(f, bl);
            this.update();
        }

        public void setDoneListener(Runnable runnable) {
            this.doneListener = runnable;
        }
    }
}

