/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.renderer.ColorRGBA;
import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.gameobject.GameObjectHandler;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.gui.widget.utils.Panel;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IMouseOverListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.utils.Scheduling;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;

public abstract class BaseMenuPanel
extends Panel {
    private EventManager eventManager;
    protected float textSize;
    private GameObjectHandler gameObjectHandler;
    private Scheduling taskManager;
    private GameSettings settings;
    private Label tipLabel;
    private static ToolTipOnMouseOver latestActivated = null;
    private static float toolTipFadeTime = 0.2f;
    private static ColorRGBA noAlphaColor = new ColorRGBA(1.0f, 0.5f, 0.5f, 0.0f);
    private static ColorRGBA fullAlphaColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);

    public BaseMenuPanel(String string, float f, float f2, GuiHandler guiHandler, GameSettings gameSettings) {
        super(string, f, f2, guiHandler);
        this.setEnabled(false);
        this.setSettings(gameSettings);
        this.textSize = 1.24f;
        this.tipLabel = new Label("tooltipLabel", "", this.getWidth() * 2.0f, this.getHeight() * 0.05f, "normal_small_white", null);
        this.tipLabel.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        this.addWidget(this.tipLabel, new Vector2f(0.5f, -0.05f), true, true);
        this.gameObjectHandler = new GameObjectHandler();
        this.taskManager = new Scheduling();
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void onActivate() {
    }

    public void onDeactivate() {
        this.getTaskManager().clearSchedule();
    }

    protected void toolTip(BaseWidget baseWidget, String string) {
        baseWidget.setMouseOverListener(new ToolTipOnMouseOver(string, null));
    }

    public GameSettings getSettings() {
        return this.settings;
    }

    public void setSettings(GameSettings gameSettings) {
        this.settings = gameSettings;
    }

    protected boolean handleEscape() {
        return false;
    }

    public GameObjectHandler getGameObjectHandler() {
        return this.gameObjectHandler;
    }

    public void setGameObjectHandler(GameObjectHandler gameObjectHandler) {
        this.gameObjectHandler = gameObjectHandler;
    }

    public void updateGeometricState(float f, boolean bl) {
        super.updateGeometricState(f, bl);
        if (this.getGameObjectHandler() != null) {
            this.getGameObjectHandler().update(f);
        }
        if (this.getTaskManager() != null) {
            this.getTaskManager().update(f);
        }
    }

    public Scheduling getTaskManager() {
        return this.taskManager;
    }

    private class ToolTipOnMouseOver
    implements IMouseOverListener {
        private String text = "";
        private String disabledText = null;

        ToolTipOnMouseOver(String string, String string2) {
            this(string);
            this.disabledText = string2 != null ? string2 : "";
        }

        ToolTipOnMouseOver(String string) {
            this.text = string != null ? string : "";
        }

        public void onMouseOver(IWidget iWidget) {
            if (iWidget instanceof MenuButton && !((MenuButton)iWidget).isEnabled()) {
                new FadeOutChangeTextAndFadeIn(BaseMenuPanel.this.tipLabel, this.disabledText);
            } else {
                new FadeOutChangeTextAndFadeIn(BaseMenuPanel.this.tipLabel, this.text);
            }
            latestActivated = this;
        }

        public void onMouseOut(IWidget iWidget) {
            if (latestActivated == this) {
                new FadeOutChangeTextAndFadeIn(BaseMenuPanel.this.tipLabel, "");
            }
            latestActivated = null;
        }

        private class FadeOutChangeTextAndFadeIn
        implements IControllerListener {
            Label label;
            String text;

            FadeOutChangeTextAndFadeIn(Label label, String string) {
                this.label = label;
                this.text = string;
                label.getFader().clearListeners();
                label.getFader().fadeTo(noAlphaColor, toolTipFadeTime);
                label.getFader().add(this);
            }

            public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                this.label.setText(this.text);
                this.label.getFader().fadeTo(fullAlphaColor, toolTipFadeTime);
            }
        }
    }
}

