/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.menus;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.Panel;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.listeners.IValueChangedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.slider.Slider;
import com.turborilla.msm.states.menus.BaseMenuPanel;
import com.turborilla.sound.SFX;
import java.util.ArrayList;

public class AudioMenuPanel
extends BaseMenuPanel {
    private ArrayList<Volume> volumes = new ArrayList();
    private MenuButton applyButton;
    private MenuButton cancelButton;
    private ILayout layout;

    public AudioMenuPanel(float f, float f2, GuiHandler guiHandler, GameSettings gameSettings, String[][] stringArray, SFX[] sFXArray) {
        super("Audio", f, f2, guiHandler, gameSettings);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            SFX sFX = null;
            if (sFXArray != null && i < sFXArray.length) {
                sFX = sFXArray[i];
            }
            Volume volume = new Volume(stringArray2[0], stringArray2[1], sFX);
            this.volumes.add(volume);
        }
        this.layout = new ColumnLayout(new Vector2f(), f, f2, 0.024f, 0.25f);
        this.setEnabled(false);
        this.initGUI(f, f2);
    }

    protected void initGUI(float f, float f2) {
        for (int i = 0; i < this.volumes.size(); ++i) {
            RowLayout rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.1f);
            this.layout.add(rowLayout);
            this.volumes.get(i).addTo(this, rowLayout);
        }
        RowLayout rowLayout = new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.1f);
        rowLayout.setPadding(0.05f, 0.0f);
        this.cancelButton = new MenuButton("CancelButton", "Cancel", 1.0f, 1.0f, this.textSize);
        this.addWidget(this.cancelButton, new Vector2f(), true, true);
        rowLayout.add(this.cancelButton);
        this.cancelButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                for (int i = 0; i < AudioMenuPanel.this.volumes.size(); ++i) {
                    Volume volume = (Volume)AudioMenuPanel.this.volumes.get(i);
                    volume.setInitialVolume();
                    AudioMenuPanel.this.getEventManager().fireEvent("VolumeChanged", new String[][]{{"category", "volume"}, {volume.settingName, AudioMenuPanel.this.getSettings().get(volume.settingName, "0.0")}});
                }
                AudioMenuPanel.this.getEventManager().fireEvent("PreviousMenu");
            }
        });
        this.applyButton = new MenuButton("OkButton", "Ok", 1.0f, 1.0f, this.textSize);
        this.addWidget(this.applyButton, new Vector2f(), true, true);
        rowLayout.add(this.applyButton);
        this.applyButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                for (int i = 0; i < AudioMenuPanel.this.volumes.size(); ++i) {
                    ((Volume)AudioMenuPanel.this.volumes.get(i)).apply();
                }
                AudioMenuPanel.this.getEventManager().fireEvent("PreviousMenu");
            }
        });
        this.layout.add(rowLayout);
        this.layout.doLayout();
        for (int i = 0; i < this.volumes.size(); ++i) {
            this.volumes.get(i).setInitialVolume();
        }
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.layout.setSize(f, f2);
        this.layout.doLayout();
    }

    private class Volume {
        String labelText;
        String settingName;
        float initialVolume;
        float volume;
        Label label;
        Slider slider;
        SFX preview;

        public Volume(String string, String string2, SFX sFX) {
            this.labelText = string;
            this.settingName = string2;
            this.preview = sFX;
            this.setInitialVolume();
        }

        public void setInitialVolume() {
            this.initialVolume = this.volume = AudioMenuPanel.this.getSettings().getFloat(this.settingName, 0.0f);
            if (this.slider != null) {
                this.slider.setValue(this.volume);
            }
        }

        public boolean apply() {
            boolean bl = false;
            if ((double)Math.abs(this.initialVolume - this.volume) > 0.01) {
                AudioMenuPanel.this.getSettings().set(this.settingName, Float.toString(this.volume));
                bl = true;
            }
            AudioMenuPanel.this.getEventManager().fireEvent("VolumeChanged", new String[][]{{"category", "volume"}, {this.settingName, Float.toString(this.volume)}});
            return bl;
        }

        public void addTo(Panel panel, ILayout iLayout) {
            this.label = new Label(this.settingName + "SliderLabel", this.labelText, 1.0f, 1.0f, "menufont", null);
            this.label.setHorisontalAlignment(HorisontalAlignment.RIGHT);
            panel.addWidget(this.label, new Vector2f(), true, true);
            iLayout.add(this.label);
            this.slider = new Slider(this.settingName + "Slider", 1.0f, 1.0f);
            panel.addWidget(this.slider, new Vector2f(), true, true);
            iLayout.add(this.slider);
            final Panel panel2 = panel;
            this.slider.setValueChangedListener(new IValueChangedListener(){

                public void onValueChanged(Slider slider) {
                    Volume.this.volume = slider.getValue();
                    if (panel2.isEnabled() && Volume.this.preview != null) {
                        if (!Volume.this.preview.isPlaying()) {
                            Volume.this.preview.stop();
                            Volume.this.preview.play();
                        }
                        Volume.this.preview.setVolume(Volume.this.volume);
                    }
                    if (AudioMenuPanel.this.getEventManager() != null) {
                        AudioMenuPanel.this.getEventManager().fireEvent("VolumeChanged", new String[][]{{"category", "volume"}, {Volume.this.settingName, Float.toString(Volume.this.volume)}});
                    }
                }
            });
        }
    }
}

