/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.game;

import com.turborilla.msm.states.game.BikeResult;
import com.turborilla.msm.track.Track1D;
import com.turborilla.msm.track.challenges.IChallenge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaceResults
implements Serializable {
    private ArrayList<BikeResult> bikeResults;
    private boolean everyBikePastFinishline;
    private int divisionIndex;
    private int trackIndex;
    private Track1D track;

    public RaceResults(ArrayList<BikeResult> arrayList, Track1D track1D) {
        this.bikeResults = arrayList;
        this.track = track1D;
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.bikeResults.size(); ++i) {
            this.bikeResults.get(i).reset();
        }
        this.everyBikePastFinishline = false;
    }

    public BikeResult getBikeResult(String string) {
        BikeResult bikeResult = null;
        for (int i = 0; i < this.bikeResults.size(); ++i) {
            if (!this.bikeResults.get(i).is(string)) continue;
            bikeResult = this.bikeResults.get(i);
            break;
        }
        return bikeResult;
    }

    public BikeResult[] getInOrderOfFinish() {
        BikeResult[] bikeResultArray = this.bikeResults.toArray(new BikeResult[0]);
        Arrays.sort(bikeResultArray, BikeResult.finishOrderComparator);
        return bikeResultArray;
    }

    public boolean isEveryBikePastFinishline() {
        return this.everyBikePastFinishline;
    }

    void setEveryBikePastFinishline(boolean bl) {
        this.everyBikePastFinishline = bl;
    }

    public int getDivisionIndex() {
        return this.divisionIndex;
    }

    public void setDivisionIndex(int n) {
        this.divisionIndex = n;
    }

    public int getTrackIndex() {
        return this.trackIndex;
    }

    public void setTrackIndex(int n) {
        this.trackIndex = n;
    }

    public String toString() {
        BikeResult[] bikeResultArray;
        String string = "";
        string = string + "Race Results:\n";
        for (BikeResult bikeResult : bikeResultArray = this.getInOrderOfFinish()) {
            string = string + "--------------------------------------\n";
            string = string + bikeResult;
            string = string + "--------------------------------------\n";
        }
        return string;
    }

    public boolean isChallengesAchieved() {
        boolean bl = true;
        Iterator<IChallenge> iterator = this.track.getChallengeIterator();
        while (iterator != null && iterator.hasNext()) {
            if (iterator.next().isAchieved()) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

