/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.game;

import com.jme.image.Image;
import com.jme.image.Texture;
import com.jme.input.InputHandler;
import com.jme.light.DirectionalLight;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.resource.ResourceLocatorTool;
import com.jme.util.resource.SimpleResourceLocator;
import com.turborilla.NodeFollowingTransformationProvider;
import com.turborilla.SpatialTransformationProvider;
import com.turborilla.TransformationProvider;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.game.FrameRateManager;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gui.Label;
import com.turborilla.msm.components.BoostArrowComponent;
import com.turborilla.msm.components.NNBikeControlComponent;
import com.turborilla.msm.components.NeuralNetZipRecorderComponent;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.gameobjects.ChallengesAchievedGameObject;
import com.turborilla.msm.gameobjects.CountdownGameObject;
import com.turborilla.msm.gameobjects.DisplayChallengesGameObject;
import com.turborilla.msm.gameobjects.FXGameObject;
import com.turborilla.msm.gameobjects.FinishlineGameObject;
import com.turborilla.msm.gameobjects.HalftimeLineGameObject;
import com.turborilla.msm.gameobjects.LapDisplayerGameObject;
import com.turborilla.msm.gameobjects.LaplineGameObject;
import com.turborilla.msm.gameobjects.LeadDisplayerGameObject;
import com.turborilla.msm.gameobjects.ParticleFXGameObject;
import com.turborilla.msm.gameobjects.TrackGameObject;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.InputData;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProfileData;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.profile.RaceData;
import com.turborilla.msm.replay.ReplayAI;
import com.turborilla.msm.replay.ReplayMetaData;
import com.turborilla.msm.replay.ReplayParticipant;
import com.turborilla.msm.rewards.CollectedReward;
import com.turborilla.msm.rewards.RewardDisplayer;
import com.turborilla.msm.states.GameObjectState;
import com.turborilla.msm.states.MsmGameStateException;
import com.turborilla.msm.states.RenderPass;
import com.turborilla.msm.states.RenderPassClearZ;
import com.turborilla.msm.states.game.BikeResult;
import com.turborilla.msm.states.game.RaceResults;
import com.turborilla.msm.track.SimpleShadow;
import com.turborilla.msm.track.Track1D;
import com.turborilla.msm.utils.ProviderFollowingCameraNode;
import com.turborilla.physics.particle.Particle;
import com.turborilla.replay.nioreplay.NioReplay;
import com.turborilla.scrolling.Layer;
import com.turborilla.scrolling.Parallax;
import com.turborilla.sound.SFX;
import com.turborilla.sound.TurboSoundSystem;
import com.turborilla.utils.Font;
import com.turborilla.utils.ImageUtils;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import com.turborilla.utils.controllers.SpatialFadeController;
import com.turborilla.utils.controllers.SpatialScaleController;
import com.turborilla.utils.folders.SystemFolder;
import com.turborilla.utils.math.Vector3d;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameState
extends GameObjectState {
    private static final Logger logger = Logger.getLogger(GameState.class.getName());
    private static final boolean displaySpeedLabel = false;
    private static final boolean displayFpsLabel = false;
    protected InputHandler input;
    protected TurboSoundSystem soundSystem;
    private RenderPass debugPass;
    private RenderPass skinPass;
    private Node hudNode;
    private ProviderFollowingCameraNode cameraNode;
    private Node simpleShadowNode;
    private Label fpsLabel;
    private Label speedLabel;
    private Font fonten;
    private ArrayList<BikeGameObject> bikes;
    private ArrayList<BikeGameObject> bikesPastFinishline;
    private BikeGameObject player;
    private Parallax parallax = null;
    private DisplayMode displayMode;
    private Properties properties;
    private Track1D track;
    private boolean displayCameraLocation = false;
    private BikeGameObject cameraFollowsBike;
    private Callable callOnRestartCompleted;
    private RaceResults results;
    private float raceTime;
    private CountdownGameObject startlineGameObject;
    private FinishlineGameObject finishlineGameObject;
    private FrameRateManager frameRateManager;
    private ParticleFXGameObject winEffect;
    private Node bikeFXNode = new Node("BikeFX");
    private Properties previousRaceProperties = null;
    private int previousRaceDivisionIndex = 0;
    private int previousRaceTrackIndex = 0;
    private boolean showArrowKeys;
    private boolean showSpaceKey;
    private ArrayList<LaplineGameObject> lapLines = new ArrayList();
    private boolean displayAfterRaceText;
    private boolean waitForStabilizedFrameRate = false;
    float previousRaceTime = 0.0f;
    private Vector3d tempVec = new Vector3d();
    private Node bikeNode;
    private Node effectsNode;
    private Node debugNode;
    private TrackGameObject trackGameObject;
    private NodeFollowingTransformationProvider playerFollower;
    private TransformationProvider cameraFollowProvider;
    private Event startEvent;
    private NeuralNetZipRecorderComponent aiRecordComponent;
    private LapDisplayerGameObject lapDisplayer;
    private com.turborilla.msm.gui.turbogui.Image beforeRaceImage;
    private String beforeRaceText;
    private com.turborilla.msm.gui.turbogui.Image afterRaceImage;
    private String afterRaceText;
    private FXGameObject specialAbilityFX;
    private ReplayMetaData replayRecorder;
    private LeadDisplayerGameObject leadDisplayer;
    private ChallengesAchievedGameObject challengesAchievedGameObject;
    private DisplayChallengesGameObject displayChallengesGameObject;
    private Quad arrowKeys = null;
    private SpatialFadeController arrowKeysFader = null;
    private SpatialScaleController arrowKeysScaler = null;
    private boolean arrowKeysShowing = false;
    private Quad spaceBar = null;
    private SpatialFadeController spaceBarFader = null;
    private SpatialScaleController spaceBarScaler = null;
    private boolean spaceBarShowing = false;
    private RewardDisplayer rewardDisplayer;

    public GameState(GameSettings gameSettings, FrameRateManager frameRateManager, URL uRL, TurboSoundSystem turboSoundSystem) {
        super("Game", gameSettings, uRL);
        this.frameRateManager = frameRateManager;
        this.soundSystem = turboSoundSystem;
        this.getEventManager().registerListener("PassedFinishline", this);
        this.getEventManager().registerListener("ResetAfterCrashRequested", this);
        this.getEventManager().registerListener("FinishedCountdown", this);
        this.getEventManager().registerListener("PassedStartline", this);
        try {
            ResourceLocatorTool.addResourceLocator("texture", new SimpleResourceLocator(GameState.class.getClassLoader().getResource("particles/")));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.input = new InputHandler();
        this.displayCameraLocation = false;
        this.bikes = new ArrayList();
        this.bikesPastFinishline = new ArrayList();
        this.skinPass = new RenderPassClearZ("skinPass");
        this.passManager.add(this.skinPass);
        this.debugPass = new RenderPassClearZ("debugPass");
        this.passManager.add(this.debugPass);
        RenderPass renderPass = new RenderPass("hudPass");
        this.hudNode = new Node("hudNode");
        this.hudNode.setLightCombineMode(0);
        this.hudNode.setRenderQueueMode(4);
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.hudNode.setRenderState(zBufferState);
        this.hudNode.setCullMode(3);
        this.hudNode.updateRenderState();
        renderPass.add(this.hudNode);
        this.passManager.add(renderPass);
        try {
            this.fonten = (Font)ResourceManager.getInstance().load("font", "kimberley_italic_gradient", null);
            this.fpsLabel = new Label("fpsLabel", this.fonten, 3);
            this.fpsLabel.setUpdateInterval(0.1f);
            this.fpsLabel.setLocalTranslation(60.0f, 30.0f, 0.0f);
            this.fpsLabel.setRightAligned(true);
            this.fpsLabel.setLocalScale(0.5f);
            this.speedLabel = new Label("speedLabel", this.fonten, 7);
            this.speedLabel.setUpdateInterval(0.3f);
            this.speedLabel.setLocalTranslation(DisplaySystem.getDisplaySystem().getWidth() / 2, (float)DisplaySystem.getDisplaySystem().getHeight() * 0.9f, 0.0f);
            this.speedLabel.setRightAligned(true);
            this.speedLabel.setLocalScale(0.5f);
            this.rewardDisplayer = new RewardDisplayer(this.fonten);
            this.addGameObject(this.rewardDisplayer);
            this.hudNode.attachChild(this.rewardDisplayer.getNode());
            this.hudNode.updateRenderState();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.challengesAchievedGameObject = new ChallengesAchievedGameObject("challengesAchievedGameObject", "Challenge Achieved", this.fonten);
        this.addGameObject(this.challengesAchievedGameObject);
        this.hudNode.attachChild(this.challengesAchievedGameObject.getNode());
        this.displayChallengesGameObject = new DisplayChallengesGameObject("displayChallengesGameObject", this.fonten);
        this.addGameObject(this.displayChallengesGameObject);
        this.hudNode.attachChild(this.displayChallengesGameObject.getNode());
    }

    @Override
    protected boolean initGL() {
        return true;
    }

    private void initParallax(Properties properties) {
        if (this.parallax != null) {
            this.passManager.remove(this.parallax);
            this.parallax.cleanUp();
            this.parallax = null;
        }
        Properties properties2 = new Properties();
        properties2.setProperty("GameHeight", this.settings.get("GameHeight", "1024"));
        properties2.setProperty("GameWidth", this.settings.get("GameWidth", "768"));
        properties2.setProperty("separateChannels", "true");
        properties2.setProperty("putInCache", "false");
        properties2.setProperty("lookInCache", "false");
        String string = properties.getProperty("environment");
        if (properties == null || null == string || string == "") {
            logger.warning("initParallax must be passed a Properties with the \"environment\" property set.");
        } else {
            try {
                this.parallax = (Parallax)ResourceManager.getInstance().load("parallax", string, properties2);
                this.passManager.insert(this.parallax, 0);
                this.parallax.setTransformationProvider(new SpatialTransformationProvider(this.cameraNode));
                this.parallax.setYTransformationBias(22.5f);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void initParallellCamera(BikeGameObject bikeGameObject) {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        float f = this.setCamFrustum(displaySystem);
        this.cameraNode.setLocalTranslation(new Vector3f(25.0f, 22.5f, 84.64f));
        Quaternion quaternion = new Quaternion(0.0f, 0.9956136f, -0.09356057f, 0.0f);
        this.cameraNode.setLocalRotation(quaternion);
        this.cameraNode.setCamera(this.cam);
        if (bikeGameObject != null) {
            this.cameraFollowProvider = bikeGameObject.getBikeParticleSystem().getRider();
            this.cameraNode.setTransformationProvider(this.cameraFollowProvider);
            this.cameraNode.setProviderMaximum(new Vector3f(Float.MAX_VALUE, 50.0f, Float.MAX_VALUE));
        } else {
            this.cameraNode.setTransformationProvider(null);
            this.cameraNode.setLocalTranslation(new Vector3f(100.0f, 22.5f, 84.64f));
        }
        this.cameraNode.setCameraSpeed(new Vector3f(4.7999997f, 2.3999999f, 0.0f));
        float f2 = 16.5f * f;
        this.cameraNode.setTranslationBias(new Vector3f(f2, 8.0f, 0.0f));
        this.cameraNode.setCameraSlackMax(new Vector3f(2.0f, 15.0f, 0.0f));
        this.cameraNode.setCameraSlackMin(new Vector3f(-2.0f, -12.0f, 0.0f));
        this.cameraNode.setSpeedForPreferredPos(new Vector3f(0.0f, 1.1999999f, 0.0f));
        this.cameraNode.setPreferredPosWhileInsideSlack(new Vector3f(0.0f, 22.5f, 0.0f));
    }

    private float setCamFrustum(DisplaySystem displaySystem) {
        float f = (float)displaySystem.getWidth() / (float)displaySystem.getHeight();
        float f2 = 20.0f;
        this.cam.setParallelProjection(true);
        this.cam.setFrustum(-150.0f, 150.0f, -f2 * f, f2 * f, -f2, f2);
        this.cam.update();
        this.cam.apply();
        return f;
    }

    private boolean hasPropertiesChanged(Properties properties, String ... stringArray) {
        boolean bl = false;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        Properties properties2 = this.properties;
        for (String string : stringArray) {
            String string2 = properties2.getProperty(string);
            String string3 = properties.getProperty(string);
            if (string3 == null || string3.equals(string2)) continue;
            bl = true;
            return true;
        }
        return bl;
    }

    public void prepareNewRace(Properties properties) throws IOException {
        this.prepareNewRace(properties, null, 0, 0, null);
    }

    public void prepareNewRace(Properties properties, DivisionDescriptor divisionDescriptor, int n, int n2) throws IOException {
        this.prepareNewRace(properties, divisionDescriptor, n, n2, null);
    }

    public void prepareNewRace(Properties properties, DivisionDescriptor divisionDescriptor, int n, int n2, ReplayMetaData replayMetaData) throws IOException {
        boolean bl;
        if (this.trackGameObject == null) {
            this.prepareNewGame(properties);
        }
        boolean bl2 = bl = properties != null && Boolean.parseBoolean(properties.getProperty("instantReplay", "false"));
        if (properties != null) {
            if (!bl) {
                this.previousRaceProperties = properties;
            }
        } else {
            properties = this.previousRaceProperties;
        }
        if (n >= 0) {
            if (!bl) {
                this.previousRaceDivisionIndex = n;
            }
        } else {
            n = this.previousRaceDivisionIndex;
        }
        if (n2 >= 0) {
            if (!bl) {
                this.previousRaceTrackIndex = n2;
            }
        } else {
            n2 = this.previousRaceTrackIndex;
        }
        this.restart(properties, divisionDescriptor, n, n2, replayMetaData);
    }

    private void restart(Properties properties, DivisionDescriptor divisionDescriptor, int n, int n2, ReplayMetaData replayMetaData) throws IOException {
        Savable savable;
        Texture texture;
        Savable savable2;
        Object object;
        Savable savable3;
        float f;
        Object object2;
        int n3;
        Object object3;
        Object object4;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.trackGameObject == null) {
            this.trackGameObject = new TrackGameObject();
            this.addGameObject(this.trackGameObject);
            this.trackGameObject.init(this.rootNode, properties);
            this.track = this.trackGameObject.getTrack();
        } else if (this.hasPropertiesChanged(properties, "track", "environment", "finishline")) {
            Properties properties2 = new Properties(properties);
            if (properties2.getProperty("track") == null && this.properties.getProperty("track") != null) {
                properties2.setProperty("track", this.properties.getProperty("track"));
            }
            if (properties2.getProperty("environment") == null && this.properties.getProperty("environment") != null) {
                properties2.setProperty("environment", this.properties.getProperty("environment"));
            }
            if (properties2.getProperty("finishline") == null && this.properties.getProperty("finishline") != null) {
                properties2.setProperty("finishline", this.properties.getProperty("finishline"));
            }
            this.trackGameObject.init(this.rootNode, properties2);
            this.track = this.trackGameObject.getTrack();
        }
        if (properties.getProperty("track") != null) {
            this.track.setName(properties.getProperty("track"));
        }
        boolean bl = Boolean.parseBoolean(properties.getProperty("instantReplay", "false"));
        boolean bl2 = Boolean.parseBoolean(properties.getProperty("timeAttack", "false"));
        boolean bl3 = divisionDescriptor != null && Boolean.parseBoolean(divisionDescriptor.getTrackProperty(n, n2, "turbo", "false")) || Boolean.parseBoolean(properties.getProperty("turbo", "false"));
        boolean bl4 = false;
        boolean bl5 = false;
        ReplayMetaData replayMetaData2 = null;
        String string = properties.getProperty("replayFile", this.properties.getProperty("replayFile"));
        if (bl2) {
            if (replayMetaData != null) {
                replayMetaData2 = replayMetaData;
            } else {
                object4 = Profile.getCurrentProfile(this.settings).getData().getRaces(n, n2)[0];
                replayMetaData2 = ((RaceData)object4).loadReplay();
            }
        } else if (bl) {
            replayMetaData2 = this.replayRecorder;
            bl4 = true;
            try {
                object4 = (ReplayAI)ResourceManager.getInstance().load("replayAI", this.track.getName(), null);
                replayMetaData2.addParticipant(((ReplayAI)object4).getSpecialAbility(), ((ReplayAI)object4).getBikeResult(), ((ReplayAI)object4).getReplayData());
            }
            catch (Exception exception) {
                bl5 = true;
            }
            object3 = object4 = replayMetaData2.getParticipants();
            int n4 = ((Object)object3).length;
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = object3[n3];
                ((ReplayParticipant)object2).getReplayData().clearReplayElements();
            }
        } else if (string != null && !string.equals("")) {
            object4 = new File(SystemFolder.getReplayFolder(null));
            object3 = new File((File)object4, string);
            try {
                replayMetaData2 = (ReplayMetaData)BinaryImporter.getInstance().load((File)object3);
            }
            catch (IOException iOException) {
                logger.severe("Could not load replay \"" + string + "\" due to " + iOException);
                replayMetaData2 = null;
            }
        } else if (replayMetaData != null) {
            replayMetaData2 = replayMetaData;
        } else {
            try {
                object4 = (ReplayAI)ResourceManager.getInstance().load("replayAI", properties.getProperty("track"), null);
                replayMetaData2 = new ReplayMetaData(this.track, properties);
                replayMetaData2.addParticipant(((ReplayAI)object4).getSpecialAbility(), ((ReplayAI)object4).getBikeResult(), ((ReplayAI)object4).getReplayData());
                bl4 = true;
            }
            catch (Exception exception) {
                replayMetaData2 = null;
                bl4 = false;
            }
        }
        object4 = null;
        if (replayMetaData2 != null) {
            object4 = replayMetaData2.getParticipants();
        }
        if (!bl) {
            this.replayRecorder = new ReplayMetaData(this.track, properties);
        }
        int n5 = 0;
        ArrayList<BikeResult> arrayList = new ArrayList<BikeResult>();
        if (bl2 || !this.hasPropertiesChanged(properties, "numberOfBikes", "bike0", "bike1", "bike2", "bike3", "controlMode", "specialAbility")) {
            // empty if block
        }
        if (this.bikeNode != null) {
            this.bikeNode.detachAllChildren();
        }
        if (this.effectsNode != null) {
            this.effectsNode.detachAllChildren();
        }
        if (this.debugNode != null) {
            this.debugNode.detachAllChildren();
        }
        if (this.simpleShadowNode != null) {
            this.simpleShadowNode.detachAllChildren();
        }
        if (this.bikeFXNode != null) {
            this.bikeFXNode.detachAllChildren();
        }
        this.input.clearActions();
        for (n3 = 0; n3 < this.bikes.size(); ++n3) {
            object2 = this.bikes.get(n3);
            this.removeGameObject((GameObject)object2);
        }
        this.bikes.clear();
        n3 = Integer.parseInt(properties.getProperty("numberOfBikes", this.properties.getProperty("numberOfBikes")));
        if (bl && bl5) {
            --n3;
        }
        float f2 = 58.0f;
        float f3 = 15.0f;
        float f4 = 0.0f;
        if (n3 > 1) {
            f4 = (f2 - f3 * 2.0f) / (float)(n3 - 1);
        } else {
            f3 += (f2 - f3 * 2.0f) / 2.0f;
        }
        this.player = null;
        Object object5 = new String[n3];
        for (int i = 0; i < n3; ++i) {
            object5[i] = properties.getProperty("bike" + i, this.properties.getProperty("bike" + i));
            boolean bl6 = "human".equals(object5[i]);
            boolean bl7 = "replay".equals(object5[i]);
            if (!bl6 && bl4) {
                bl7 = true;
            }
            f = f3 + f4 * (float)(n3 - i - 1);
            if (bl7 && replayMetaData2 == null) continue;
            Object object6 = null;
            String string2 = null;
            savable3 = null;
            if (bl7 && n5 < ((Object)object4).length) {
                object6 = object4[n5];
                string2 = ((ReplayParticipant)object6).getSpecialAbility();
                savable3 = ((ReplayParticipant)object6).getReplayData();
                ++n5;
            }
            if (string2 == null) {
                string2 = properties.getProperty("specialAbility", null);
            }
            object = new BikeGameObject(object5[i] + "BikeGameObject" + i);
            this.addGameObject((GameObject)object);
            ((BikeGameObject)object).init(f, this.trackGameObject.getCollisionStructure(), this.bikeNode, null, this.effectsNode, this.debugNode, bl6 ? this.input : null, this, bl6 ? Profile.getCurrentProfile(this.settings).getDifficulty() : Difficulty.valueOf(properties.getProperty("controlMode", Difficulty.Simulation.getName())), bl6 ? Profile.getCurrentProfile(this.settings) : null, string2, (NioReplay)savable3, bl7, (ReplayParticipant)object6, bl3, bl && i == 0 ? Integer.valueOf(1) : null);
            this.bikes.add((BikeGameObject)object);
            savable2 = new BikeResult((BikeGameObject)object);
            arrayList.add((BikeResult)savable2);
            if (bl6 && ((BikeGameObject)object).getReplayComponent() != null && ((BikeGameObject)object).getReplayComponent().getReplay() != null) {
                this.replayRecorder.addParticipant(properties.getProperty("specialAbility", null), (BikeResult)savable2, ((BikeGameObject)object).getReplayComponent().getReplay());
            }
            this.specialAbilityFX = ((BikeGameObject)object).getSpecialAbilityFX();
            if (this.specialAbilityFX != null) {
                this.specialAbilityFX.attachToNode(this.bikeFXNode);
                this.addGameObject(this.specialAbilityFX);
            }
            if (bl6) {
                this.player = object;
                this.aiRecordComponent = ((BikeGameObject)object).getAiRecordComponent();
            }
            if (!this.settings.getBoolean("ProjectedQuadShadows", true) || this.settings.getBoolean("ZFailShadows", false)) continue;
            texture = null;
            try {
                texture = (Texture)ResourceManager.getInstance().load("texture", "shadow", null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Particle[] particleArray = ((BikeGameObject)object).getBikeParticleSystem().getFrame().getParticles().toArray(new Particle[0]);
            savable = new SimpleShadow("bikeShadow", this.trackGameObject.getTrack(), particleArray, 5.0f, 5.0f, 5, 1, new Vector3f(0.1f, 0.3f, 1.25f), texture);
            this.simpleShadowNode.attachChild((Spatial)savable);
            Particle[] particleArray2 = ((BikeGameObject)object).getBikeParticleSystem().getRider().getParticles().toArray(new Particle[0]);
            savable = new SimpleShadow("riderShadow", this.trackGameObject.getTrack(), particleArray2, 3.0f, 5.0f, 5, 1, new Vector3f(-0.2f, 0.25f, 3.0f), texture);
            this.simpleShadowNode.attachChild((Spatial)savable);
        }
        if (!bl) {
            this.results = new RaceResults(arrayList, this.track);
            this.results.setDivisionIndex(n);
            this.results.setTrackIndex(n2);
        }
        this.bikeNode.attachChild(this.bikeFXNode);
        this.resetBikePositions();
        this.setNNEnabled(false);
        this.setControlEnabled(false, false);
        for (n3 = 0; n3 < this.bikes.size(); ++n3) {
            BikeGameObject bikeGameObject = this.bikes.get(n3);
            Properties properties3 = null;
            try {
                properties3 = (Properties)ResourceManager.getInstance().load("properties", "boostarrow", null);
            }
            catch (IOException iOException) {
                properties3 = null;
            }
            if (properties3 == null) {
                properties3 = new Properties();
            }
            BoostArrowComponent boostArrowComponent = new BoostArrowComponent(Float.parseFloat(properties3.getProperty("duration", "0.02")), Float.parseFloat(properties3.getProperty("strength", "1000")), bikeGameObject.getBikeParticleSystem(), this.track, this.settings);
            bikeGameObject.removeComponent(boostArrowComponent.getName());
            bikeGameObject.addComponent(boostArrowComponent);
            object5 = null;
            try {
                Properties properties4 = new Properties();
                properties4.setProperty("putInCache", "false");
                properties4.setProperty("lookInCache", "false");
                object5 = (SFX)ResourceManager.getInstance().load("sfx", "boostarrow", properties4);
                if (object5 == null) continue;
                ((SFX)object5).setVolumeCategory("GameSFXVolume");
                boostArrowComponent.setSfx((SFX)object5);
                ((SFX)object5).setSpatialToTrack(bikeGameObject.getFrameFollower());
                continue;
            }
            catch (IOException iOException) {
                logger.severe("Could not load sfx \"boostarrow\" due to " + iOException);
            }
        }
        if (Boolean.parseBoolean(properties.getProperty("startsequence", this.properties.getProperty("startsequence", "false")))) {
            this.setStartlineEnabled(true);
        } else {
            if (Boolean.parseBoolean(properties.getProperty("startline", this.properties.getProperty("startline", "false")))) {
                this.setStartlineEnabled(true);
            } else {
                this.setStartlineEnabled(false);
            }
            this.setNNEnabled(true);
            this.setControlEnabled(true, true);
        }
        this.constructFinishline(properties);
        n3 = Integer.parseInt(properties.getProperty("cameraFollowBikeNumber", this.properties.getProperty("cameraFollowBikeNumber", "-1")));
        if (n3 < 0 || n3 >= this.bikes.size()) {
            this.cameraFollowsBike = null;
            if (this.playerFollower != null) {
                this.rootNode.detachChild(this.playerFollower);
                this.playerFollower = null;
            }
            if (this.soundSystem != null) {
                this.soundSystem.setCamera(this.cam);
            }
        } else {
            this.cameraFollowsBike = this.bikes.get(n3);
            if (this.playerFollower == null) {
                this.playerFollower = new NodeFollowingTransformationProvider(this.cameraFollowsBike.getBikeParticleSystem().getRider());
                this.rootNode.attachChild(this.playerFollower);
            } else {
                this.playerFollower.setProvider(this.cameraFollowsBike.getBikeParticleSystem().getRider());
            }
            if (this.soundSystem != null) {
                this.soundSystem.setCamera(this.cam, this.playerFollower.getProvider());
            }
        }
        this.initParallellCamera(this.cameraFollowsBike);
        if (this.hasPropertiesChanged(properties, "environment")) {
            this.initParallax(properties);
        }
        if (this.winEffect != null) {
            this.removeGameObject(this.winEffect);
        }
        this.winEffect = new ParticleFXGameObject("WinParticleEffect");
        try {
            this.winEffect.load(properties.getProperty("environment", "tiki"));
            this.winEffect.setRepeat(false);
        }
        catch (Exception exception) {
            logger.severe("Could not load particle system \"" + properties.getProperty("environment", "tiki") + "\" because of: " + exception);
            this.winEffect = null;
        }
        if (this.winEffect != null) {
            this.addGameObject(this.winEffect);
            this.winEffect.getNode().setLocalScale(30.0f);
            this.track.attachChild(this.winEffect.getNode());
        }
        if (this.parallax != null) {
            Iterator<Layer> iterator = this.parallax.getLayerIterator();
            while (iterator.hasNext()) {
                iterator.next().clearExtras();
            }
            if (divisionDescriptor != null) {
                Properties properties5 = new Properties();
                properties5.setProperty("GameHeight", this.settings.get("GameHeight", "1024"));
                properties5.setProperty("GameWidth", this.settings.get("GameWidth", "768"));
                properties5.setProperty("separateChannels", "false");
                String string3 = null;
                int n6 = 0;
                while (null != (string3 = divisionDescriptor.getTrackProperty(n, n2, "backgroundExtras" + (n6 + 1), null))) {
                    String[] stringArray = string3.split(":");
                    String string4 = stringArray[0];
                    String string5 = stringArray[1];
                    f = Float.parseFloat(stringArray[2]);
                    float f5 = Float.parseFloat(stringArray[3]);
                    float f6 = Float.parseFloat(stringArray[4]);
                    if (this.parallax != null) {
                        savable3 = this.parallax.getLayer(string4);
                        if (savable3 != null) {
                            try {
                                object = (Image)ResourceManager.getInstance().load("image", string5, properties5);
                                savable2 = new Quad("backgroundExtras" + (n6 + 1), ((Image)object).getWidth(), ((Image)object).getHeight());
                                texture = ImageUtils.loadTexture((Image)object, 1, 1, true);
                                savable = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                                ((TextureState)savable).setTexture(texture);
                                ((SceneElement)savable2).setRenderState((RenderState)savable);
                                ((SceneElement)savable2).updateRenderState();
                                float f7 = (float)DisplaySystem.getDisplaySystem().getHeight() / 1024.0f;
                                ((Layer)savable3).addExtra((Quad)savable2, new Vector2f((f + 1200.0f) * f7, f5 * f7 + (float)(((Image)object).getHeight() / 2)), f6);
                            }
                            catch (IOException iOException) {
                                logger.severe("Could not load parallax extras \"" + string5 + "\". Exception: " + iOException);
                            }
                        } else {
                            logger.severe("Could not find parallax layer \"" + string4 + "\".");
                        }
                    }
                    ++n6;
                }
            }
        }
        this.prepareBeforeRaceMessage(divisionDescriptor, n, n2);
        this.prepareAfterRaceMessage(divisionDescriptor, n, n2);
        this.showArrowKeys = false;
        this.showSpaceKey = false;
        if (divisionDescriptor != null) {
            String string6 = divisionDescriptor.getTrackProperty(n, n2, "showArrowKeys", "false");
            if (string6 != null) {
                this.showArrowKeys = Boolean.parseBoolean(string6);
            }
            if ((string6 = divisionDescriptor.getTrackProperty(n, n2, "showSpaceKey", "false")) != null) {
                this.showSpaceKey = Boolean.parseBoolean(string6);
            }
        }
        if (this.challengesAchievedGameObject != null) {
            this.challengesAchievedGameObject.reset();
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        for (Object object7 : properties.keySet()) {
            String string7 = (String)object7;
            this.properties.setProperty(string7, properties.getProperty(string7));
        }
        if (this.debugNode != null) {
            this.debugPass.remove(this.debugNode);
            this.debugPass.add(this.debugNode);
            this.debugNode.updateRenderState();
        }
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
        this.getGlobalEventManager().fireEvent("SetProgress", new String[][]{{"progress"}, {"1.0"}});
        this.raceTime = 0.0f;
        this.getGlobalEventManager().handleRemoveRequests();
        this.getEventManager().handleRemoveRequests();
        if (this.callOnRestartCompleted != null) {
            try {
                this.callOnRestartCompleted.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void prepareAfterRaceMessage(DivisionDescriptor divisionDescriptor, int n, int n2) {
        String string;
        this.afterRaceImage = null;
        this.afterRaceText = null;
        if (divisionDescriptor != null && (string = divisionDescriptor.getTrackProperty(n, n2, "winmessage", null)) != null) {
            String[] stringArray = string.split(":");
            String string2 = null;
            String string3 = null;
            if (stringArray.length >= 2) {
                string2 = stringArray[0];
                string3 = stringArray[1];
            } else {
                string3 = stringArray[0];
            }
            if (string2 != null && string2.length() > 0) {
                this.afterRaceImage = new com.turborilla.msm.gui.turbogui.Image("AfterRaceImage", string2, 1.0f);
            }
            if (string3 != null && string3.length() > 0) {
                this.afterRaceText = string3;
            }
        }
    }

    public void prepareBeforeRaceMessage(DivisionDescriptor divisionDescriptor, int n, int n2) {
        this.beforeRaceImage = null;
        this.beforeRaceText = null;
        ProgressData.Division.Track track = Profile.getCurrentProfile(this.settings).getData().getProgressData().getDivisions()[n].getTracks()[n2];
        if (divisionDescriptor != null && !track.isAccomplished()) {
            int n3 = track.getNumberOfRaces();
            String string = divisionDescriptor.getTrackProperty(n, n2, "message" + (n3 + 1), null);
            if (string != null) {
                String[] stringArray = string.split(":");
                String string2 = null;
                String string3 = null;
                if (stringArray.length >= 2) {
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                } else {
                    string3 = stringArray[0];
                }
                if (string2 != null && string2.length() > 0) {
                    this.beforeRaceImage = new com.turborilla.msm.gui.turbogui.Image("BeforeRaceImage", string2, 1.0f);
                }
                if (string3 != null && string3.length() > 0) {
                    this.beforeRaceText = string3;
                }
            }
        }
    }

    public void constructFinishline() {
        this.constructFinishline(null);
    }

    public void constructFinishline(Properties properties) {
        if (this.finishlineGameObject != null) {
            this.rootNode.detachChild(this.finishlineGameObject.getNode());
            this.removeGameObject(this.finishlineGameObject);
        }
        this.finishlineGameObject = new FinishlineGameObject();
        this.addGameObject(this.finishlineGameObject);
        this.finishlineGameObject.init(this.getTrack().getFinishPosition(), "finishline");
        for (int i = 0; i < this.bikes.size(); ++i) {
            this.finishlineGameObject.addObjectToCheckAgainstLine(this.bikes.get(i), new TransformationProvider[]{this.bikes.get(i).getBikeParticleSystem().getRider().getLeftCalf(), this.bikes.get(i).getBikeParticleSystem().getRider().getRightCalf(), this.bikes.get(i).getBikeParticleSystem().getRider().getLeftThigh(), this.bikes.get(i).getBikeParticleSystem().getRider().getRightThigh(), this.bikes.get(i).getBikeParticleSystem().getRider().getTorso(), this.bikes.get(i).getBikeParticleSystem().getRider().getLeftUpperArm(), this.bikes.get(i).getBikeParticleSystem().getRider().getRightUpperArm(), this.bikes.get(i).getBikeParticleSystem().getRider().getLeftLowerArm(), this.bikes.get(i).getBikeParticleSystem().getRider().getRightLowerArm()}, new float[]{(float)(this.bikes.get(i).getBikeParticleSystem().getRider().getLeftCalf().getRestLength() * 0.5), (float)(this.bikes.get(i).getBikeParticleSystem().getRider().getRightCalf().getRestLength() * 0.5), (float)(this.bikes.get(i).getBikeParticleSystem().getRider().getLeftThigh().getRestLength() * 0.5), (float)(this.bikes.get(i).getBikeParticleSystem().getRider().getRightThigh().getRestLength() * 0.5), (float)(this.bikes.get(i).getBikeParticleSystem().getRider().getTorso().getRestLength() * 0.5), (float)(this.bikes.get(i).getBikeParticleSystem().getRider().getLeftUpperArm().getRestLength() * 0.5), (float)(this.bikes.get(i).getBikeParticleSystem().getRider().getRightUpperArm().getRestLength() * 0.5), (float)(this.bikes.get(i).getBikeParticleSystem().getRider().getLeftLowerArm().getRestLength() * 0.5), (float)(this.bikes.get(i).getBikeParticleSystem().getRider().getRightLowerArm().getRestLength() * 0.5)});
        }
        this.rootNode.attachChild(this.finishlineGameObject.getNode());
        for (LaplineGameObject laplineGameObject : this.lapLines) {
            this.rootNode.detachChild(laplineGameObject.getNode());
            this.removeGameObject(laplineGameObject);
        }
        int n = properties != null ? Integer.parseInt(properties.getProperty("numberOfLaps", "1")) : 1;
        float f = this.getTrack().getLapLinePosition(1, n);
        if (n > 0 && this.player != null) {
            for (int i = 0; i < n; ++i) {
                LaplineGameObject laplineGameObject;
                if (n > 1 && i >= 1) {
                    laplineGameObject = new LaplineGameObject("LapLine" + i);
                    this.addGameObject(laplineGameObject);
                    laplineGameObject.init(this.getTrack().getLapLinePosition(i, n), "finishline");
                    laplineGameObject.addObjectToCheckAgainstLine(this.player, new TransformationProvider[]{this.player.getBikeParticleSystem().getRider().getLeftCalf(), this.player.getBikeParticleSystem().getRider().getRightCalf(), this.player.getBikeParticleSystem().getRider().getLeftThigh(), this.player.getBikeParticleSystem().getRider().getRightThigh(), this.player.getBikeParticleSystem().getRider().getTorso(), this.player.getBikeParticleSystem().getRider().getLeftUpperArm(), this.player.getBikeParticleSystem().getRider().getRightUpperArm(), this.player.getBikeParticleSystem().getRider().getLeftLowerArm(), this.player.getBikeParticleSystem().getRider().getRightLowerArm()}, new float[]{(float)(this.player.getBikeParticleSystem().getRider().getLeftCalf().getRestLength() * 0.5), (float)(this.player.getBikeParticleSystem().getRider().getRightCalf().getRestLength() * 0.5), (float)(this.player.getBikeParticleSystem().getRider().getLeftThigh().getRestLength() * 0.5), (float)(this.player.getBikeParticleSystem().getRider().getRightThigh().getRestLength() * 0.5), (float)(this.player.getBikeParticleSystem().getRider().getTorso().getRestLength() * 0.5), (float)(this.player.getBikeParticleSystem().getRider().getLeftUpperArm().getRestLength() * 0.5), (float)(this.player.getBikeParticleSystem().getRider().getRightUpperArm().getRestLength() * 0.5), (float)(this.player.getBikeParticleSystem().getRider().getLeftLowerArm().getRestLength() * 0.5), (float)(this.player.getBikeParticleSystem().getRider().getRightLowerArm().getRestLength() * 0.5)});
                    this.rootNode.attachChild(laplineGameObject.getNode());
                    this.lapLines.add(laplineGameObject);
                }
                if (!(f > 800.0f)) continue;
                laplineGameObject = new HalftimeLineGameObject("HalftimeLine" + i);
                this.addGameObject(laplineGameObject);
                laplineGameObject.init(this.getTrack().getLapLinePosition(i, n) + f / 2.0f - 100.0f, null);
                laplineGameObject.addObjectToCheckAgainstLine(this.player, new TransformationProvider[]{this.player.getBikeParticleSystem().getFrontWheel(), this.player.getBikeParticleSystem().getRearWheel()}, new float[]{(float)this.player.getBikeParticleSystem().getFrontWheel().getRadius(), (float)this.player.getBikeParticleSystem().getRearWheel().getRadius()});
                this.rootNode.attachChild(laplineGameObject.getNode());
                this.lapLines.add(laplineGameObject);
            }
        }
        if (this.lapDisplayer != null) {
            this.removeGameObject(this.lapDisplayer);
        }
        if (this.player != null) {
            this.lapDisplayer = new LapDisplayerGameObject("LapDisplayer", this.fonten, this.player, n);
            this.addGameObject(this.lapDisplayer);
            this.lapDisplayer.setPaused(true);
            this.hudNode.attachChild(this.lapDisplayer.getNode());
        }
        if (this.leadDisplayer != null) {
            this.removeGameObject(this.leadDisplayer);
        }
        if (this.player != null) {
            BikeGameObject bikeGameObject = null;
            for (int i = 0; i < this.bikes.size(); ++i) {
                if (this.bikes.get(i) == this.player) continue;
                bikeGameObject = this.bikes.get(i);
                break;
            }
            if (bikeGameObject != null) {
                this.leadDisplayer = new LeadDisplayerGameObject("LeadDisplayer", this.fonten, this.player, bikeGameObject);
                this.addGameObject(this.leadDisplayer);
                this.leadDisplayer.setPaused(false);
                this.hudNode.attachChild(this.leadDisplayer.getNode());
            }
        }
    }

    public void setStartlineEnabled(boolean bl) {
        if (this.startlineGameObject != null) {
            this.rootNode.detachChild(this.startlineGameObject.getNode());
            this.removeGameObject(this.startlineGameObject);
        }
        if (bl) {
            this.startlineGameObject = new CountdownGameObject();
            this.addGameObject(this.startlineGameObject);
            this.startlineGameObject.init(20.0f);
            for (int i = 0; i < this.bikes.size(); ++i) {
                this.startlineGameObject.addObjectToCheckAgainstLine(this.bikes.get(i), new TransformationProvider[]{this.bikes.get(i).getBikeParticleSystem().getFrontWheel(), this.bikes.get(i).getBikeParticleSystem().getRearWheel()}, new float[]{(float)this.bikes.get(i).getBikeParticleSystem().getFrontWheel().getRadius(), (float)this.bikes.get(i).getBikeParticleSystem().getRearWheel().getRadius()});
            }
            this.rootNode.attachChild(this.startlineGameObject.getNode());
        }
    }

    public void resetBikePositions() {
        for (int i = 0; i < this.bikes.size(); ++i) {
            Vector3d vector3d = new Vector3d(0.0, 0.5, 0.0);
            this.bikes.get(i).getBikeParticleSystem().reset(vector3d);
            this.bikes.get(i).getControl().setBrakeAlways(false);
            if (this.bikes.get(i).getControl().getSpecialAbilityComponent() != null) {
                this.bikes.get(i).getControl().getSpecialAbilityComponent().reset();
            }
            this.bikes.get(i).resetReplayComponent();
        }
        this.bikesPastFinishline.clear();
    }

    public void startCountdown() {
        if (this.startlineGameObject != null) {
            this.startlineGameObject.startCountdown();
        }
        if (this.getRaceResults() != null) {
            this.getRaceResults().reset();
        }
        if (this.challengesAchievedGameObject != null) {
            this.challengesAchievedGameObject.reset();
        }
        if (this.finishlineGameObject != null) {
            this.finishlineGameObject.reset();
        }
        this.showChallenges();
        this.bikesPastFinishline.clear();
        this.hideArrowKeys();
        this.hideSpaceBar();
        if (this.player != null && this.results != null) {
            InputData inputData;
            ProfileData profileData;
            int n = this.results.getDivisionIndex();
            int n2 = this.results.getTrackIndex();
            if (this.showArrowKeys) {
                profileData = Profile.getCurrentProfile(this.getSettings()).getData();
                inputData = profileData.getInputData();
                if (!profileData.getProgressData().getDivisions()[n].getTracks()[n2].isAccomplished() && inputData.getDevice() == InputData.Device.Keyboard && !inputData.getKeyboardData().isConfigured()) {
                    this.showArrowKeys();
                }
            }
            if (this.showSpaceKey) {
                profileData = Profile.getCurrentProfile(this.getSettings()).getData();
                inputData = profileData.getInputData();
                if (!profileData.getProgressData().getDivisions()[n].getTracks()[n2].isAccomplished() && (inputData.getDevice() == InputData.Device.Keyboard && inputData.getKeyboardData().getSpecial() == 57 || inputData.getDevice() == InputData.Device.Mouse && inputData.getMouseData().getSpecialKey() == 57)) {
                    this.showSpaceBar();
                }
            }
        }
    }

    public void raceQuitted() {
        if (this.rewardDisplayer != null) {
            this.rewardDisplayer.reset();
        }
    }

    public void startAIRecording() {
        if (this.aiRecordComponent == null) {
            return;
        }
        this.aiRecordComponent.startRecording("AIrecording" + new Date().getTime() + ".gz", false);
    }

    public void startAIRaceRecording() {
        if (this.aiRecordComponent == null) {
            return;
        }
        this.aiRecordComponent.countdownFinished();
    }

    public void stopAIRecording() {
        if (this.aiRecordComponent == null) {
            return;
        }
        this.aiRecordComponent.raceFinished(this.getRaceResults());
    }

    public void startCollectingStats() {
        if (this.player == null || this.player.getStatComponent() == null) {
            return;
        }
        this.player.getStatComponent().startCollectingStats(this.getPlayer().getProfile().getData().getRewardData());
    }

    public void stopCollectingStats() {
        if (this.player == null || this.player.getStatComponent() == null) {
            return;
        }
        this.player.getStatComponent().stopCollectingStats();
    }

    public void startMonitoringChallenges() {
        if (this.player == null || this.player.getChallengeMonitorComponent() == null) {
            return;
        }
        this.player.getChallengeMonitorComponent().startMonitoring();
        if (this.challengesAchievedGameObject != null) {
            this.challengesAchievedGameObject.reset();
        }
        if (this.displayChallengesGameObject != null) {
            this.displayChallengesGameObject.reset();
        }
        this.trackGameObject.getTrack().setAllChallengesAchievedListener(new Runnable(){

            public void run() {
                if (GameState.this.getEventManager() != null) {
                    GameState.this.getEventManager().fireEvent("AllChallengesAchieved");
                    GameState.this.getEventManager().fireEvent("PassedFinishline", new String[][]{{"gameObject"}, {GameState.this.player.getName()}});
                }
            }
        });
    }

    public void stopMonitoringChallenges() {
        if (this.player == null || this.player.getChallengeMonitorComponent() == null) {
            return;
        }
        this.player.getChallengeMonitorComponent().stopMonitoring();
    }

    public void showChallenges() {
        if (this.trackGameObject != null && this.trackGameObject.getTrack() != null) {
            this.displayChallengesGameObject.show(this.trackGameObject.getTrack().getChallengeIterator());
        }
    }

    public void startReplayComponent() {
        this.stopReplayComponent();
        float f = this.startlineGameObject.getReplayAITimeAdder();
        for (int i = 0; i < this.bikes.size(); ++i) {
            this.bikes.get(i).startReplayComponent(f);
        }
    }

    public void stopReplayComponent() {
        for (int i = 0; i < this.bikes.size(); ++i) {
            if (this.bikes.get(i).isReplay()) continue;
            this.bikes.get(i).stopReplayComponent();
        }
    }

    public void saveReplay(String string) throws IOException {
        if (this.replayRecorder != null) {
            File file = new File(SystemFolder.getReplayFolder(null));
            File file2 = new File(file, string);
            BinaryExporter.getInstance().save((Savable)this.replayRecorder, file2);
        }
    }

    public void saveReplay(String string, String string2) {
        if (this.replayRecorder != null) {
            File file = new File(string);
            File file2 = new File(file, string2);
            try {
                BinaryExporter.getInstance().save((Savable)this.replayRecorder, file2);
            }
            catch (IOException iOException) {
                logger.severe("Could not save replay \"" + string2 + "\" in \"" + string + "\" due to " + iOException);
            }
        }
    }

    public void changeSpecialAbility(String string) {
        if (this.specialAbilityFX != null) {
            this.specialAbilityFX.detachFromParent();
            this.removeGameObject(this.specialAbilityFX);
        }
        for (int i = 0; i < this.bikes.size(); ++i) {
            try {
                this.bikes.get(i).changeSpecialAbility(string);
            }
            catch (IOException iOException) {
                throw new MsmGameStateException(iOException);
            }
            this.specialAbilityFX = this.bikes.get(i).getSpecialAbilityFX();
            if (this.specialAbilityFX == null) continue;
            this.specialAbilityFX.attachToNode(this.bikeFXNode);
            this.addGameObject(this.specialAbilityFX);
        }
    }

    public void changeTurbo(boolean bl) {
        for (int i = 0; i < this.bikes.size(); ++i) {
            this.bikes.get(i).setTurbo(bl);
        }
    }

    public void setControlEnabled(boolean bl, boolean bl2) {
        for (int i = 0; i < this.bikes.size(); ++i) {
            this.setControlEnabled(i, bl, bl2);
        }
    }

    public void setControlEnabled(BikeGameObject bikeGameObject, boolean bl, boolean bl2) {
        bikeGameObject.getControl().setPaused(!bl);
        bikeGameObject.getControl().setBikeControlsEnabled(bl2);
        if (bl2) {
            bikeGameObject.getBikeParticleSystem().getRearWheel().setBrakeAmount(0.0);
        }
    }

    public void setControlEnabled(int n, boolean bl, boolean bl2) {
        this.setControlEnabled(this.bikes.get(n), bl, bl2);
    }

    public void setNNEnabled(boolean bl) {
        for (int i = 0; i < this.bikes.size(); ++i) {
            BikeGameObject bikeGameObject = this.bikes.get(i);
            if (bikeGameObject.isPlayer() || bikeGameObject.isReplay() || !(bikeGameObject.getControl() instanceof NNBikeControlComponent)) continue;
            ((NNBikeControlComponent)bikeGameObject.getControl()).setStoppedAI(!bl);
        }
    }

    public RaceResults getRaceResults() {
        return this.results;
    }

    public boolean constructRaceResults() {
        boolean bl = false;
        RaceResults raceResults = this.getRaceResults();
        logger.info(raceResults.toString());
        BikeResult[] bikeResultArray = raceResults.getInOrderOfFinish();
        for (int i = 0; i < bikeResultArray.length; ++i) {
            Serializable serializable;
            Object object;
            BikeResult bikeResult = bikeResultArray[i];
            Profile profile = bikeResult.getProfile();
            if (profile == null) continue;
            ProfileData profileData = profile.getData();
            RaceData raceData = new RaceData();
            raceData.setDivisionIndex(raceResults.getDivisionIndex());
            raceData.setTrackIndex(raceResults.getTrackIndex());
            raceData.setNumberOfCrashes(bikeResult.getNumberOfCrashes());
            raceData.setFinishingPlace(i + 1);
            boolean bl2 = raceResults.isChallengesAchieved();
            raceData.setFinishedRace(bikeResult.hasFinishedRace() && bl2);
            if (bikeResult.hasFinishedRace()) {
                raceData.setPassedFinishlineAtTime(bikeResult.getPassedFinishlineAtTime());
            }
            raceData.setPassedStartlineAtTime(bikeResult.getPassedStartlineAtTime());
            if (this.replayRecorder != null) {
                try {
                    raceData.saveReplay(this.replayRecorder);
                }
                catch (IOException iOException) {
                    logger.severe("Could not save replay due to: " + iOException);
                }
            }
            if (bikeResult.hasFinishedRace() && bl2 && (object = profileData.getBestRace(raceResults.getDivisionIndex(), raceResults.getTrackIndex())) != null && bikeResult.getPassedFinishlineAtTime() < ((RaceData)object).getPassedFinishlineAtTime()) {
                bikeResult.setPersonalBest(true);
                bikeResult.setShavedTime(-(bikeResult.getPassedFinishlineAtTime() - ((RaceData)object).getPassedFinishlineAtTime()));
            }
            if (bikeResult.hasFinishedRace()) {
                ProgressData.Division.Track track;
                object = profileData.getProgressData().getDivisions();
                serializable = object[raceResults.getDivisionIndex()];
                ProgressData.Division.Track[] trackArray = ((ProgressData.Division)serializable).getTracks();
                ProgressData.Division[] divisionArray = trackArray[raceResults.getTrackIndex()];
                int n = raceData.getFinishingPlace();
                int n2 = raceData.getDivisionIndex();
                int n3 = raceData.getTrackIndex();
                int n4 = n3 + 1;
                int n5 = n2 + 1;
                this.displayAfterRaceText = false;
                if (n == 1 && bl2 && !divisionArray.isAccomplished()) {
                    this.displayAfterRaceText = true;
                    divisionArray.setAccomplished(true);
                    this.fireProgressEvent("Accomplished", "track", raceResults.getTrackIndex());
                }
                if (n4 < trackArray.length && !(track = trackArray[n4]).isUnlocked()) {
                    track.setUnlocked(true);
                    this.fireProgressEvent("Unlocked", "track", n4);
                }
                int n6 = 1;
                for (ProgressData.Division.Track track2 : trackArray) {
                    if (track2.isAccomplished()) continue;
                    n6 = 0;
                    break;
                }
                if (n6 != 0) {
                    Object object2;
                    if (!((ProgressData.Division)serializable).isAccomplished()) {
                        ((ProgressData.Division)serializable).setAccomplished(true);
                        this.fireProgressEvent("Accomplished", "division", n2);
                    }
                    if (n5 < ((Object)object).length && !((ProgressData.Division)(object2 = object[n5])).isUnlocked()) {
                        ((ProgressData.Division)object2).setUnlocked(true);
                        ((ProgressData.Division)object2).getTracks()[0].setUnlocked(true);
                        this.fireProgressEvent("Unlocked", "division", n5);
                    }
                }
            }
            profileData.addRaceData(raceData);
            object = new ArrayList();
            serializable = bikeResult.getBike().getStatComponent().saveToProfile(bikeResult.getProfile().getData().getRewardData(), (ArrayList<CollectedReward>)object);
            bikeResult.setCollectedRewards((ArrayList<CollectedReward>)serializable, (ArrayList<CollectedReward>)object);
            boolean bl3 = true;
            for (ProgressData.Division division : profileData.getProgressData().getDivisions()) {
                for (ProgressData.Division.Track track : division.getTracks()) {
                    if (track.isAccomplished()) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3) break;
            }
            if (!bl3) continue;
            bl = true;
        }
        return bl;
    }

    public void saveRaceResults() {
        RaceResults raceResults = this.getRaceResults();
        BikeResult[] bikeResultArray = raceResults.getInOrderOfFinish();
        for (int i = 0; i < bikeResultArray.length; ++i) {
            BikeResult bikeResult = bikeResultArray[i];
            Profile profile = bikeResult.getProfile();
            if (profile == null) continue;
            profile.save();
        }
    }

    private void fireProgressEvent(String string, String string2, int n) {
        this.getGlobalEventManager().fireEvent(string, new String[][]{{"elementType", "index"}, {string2, "" + n}});
    }

    protected boolean prepareNewGame(Properties properties) {
        this.rootNode.setCullMode(3);
        this.displayMode = new DisplayMode(DisplaySystem.getDisplaySystem());
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.simpleShadowNode = new Node("simpleShadowNode");
        this.rootNode.attachChild(this.simpleShadowNode);
        this.bikeNode = new Node();
        this.effectsNode = new Node();
        this.debugNode = null;
        this.skinPass.add(this.bikeNode);
        this.skinPass.add(this.effectsNode);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setEnabled(true);
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setDirection(new Vector3f(0.7f, -0.4f, 0.4f).normalizeLocal());
        directionalLight.setShadowCaster(true);
        LightState lightState = displaySystem.getRenderer().createLightState();
        lightState.attach(directionalLight);
        lightState.setGlobalAmbient(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        lightState.setEnabled(true);
        this.rootNode.setRenderState(lightState);
        System.gc();
        this.rootNode.updateRenderState();
        return true;
    }

    @Override
    protected void stateUpdate(float f) {
        if (!this.isWaitForStabilizedFrameRate() || this.frameRateManager.isStable()) {
            this.waitForStabilizedFrameRate = false;
            if (this.previousRaceTime > this.raceTime) {
                this.previousRaceTime = 0.0f;
            }
            this.raceTime += f;
            if (this.raceTime > this.previousRaceTime + 10.0f) {
                this.previousRaceTime = this.raceTime;
                float f2 = Float.parseFloat(this.getSettings().get("time", "0"));
                this.getSettings().set("time", "" + (f2 += 10.0f));
            }
            if (this.arrowKeysShowing && this.raceTime > 5.0f && (int)this.raceTime % 10 == 0) {
                this.wiggleArrowKeys();
            }
            super.stateUpdate(f);
            this.input.update(f);
            this.camNode.updateWorldData(f);
            if (this.displayCameraLocation) {
                System.out.println("Ear: " + this.soundSystem.getListenerData().position + " cam: " + this.camNode.getLocalTranslation());
            }
            if (this.player != null) {
                // empty if block
            }
        }
    }

    @Override
    protected void stateRender(float f) {
        super.stateRender(f);
    }

    @Override
    protected void onActivate() throws IOException {
        this.checkDisplayModeChanged();
        super.onActivate();
    }

    @Override
    public void setPaused(boolean bl) {
        if (this.isPaused() && !bl) {
            this.checkDisplayModeChanged();
        }
        super.setPaused(bl);
    }

    private void checkDisplayModeChanged() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        DisplayMode displayMode = new DisplayMode(displaySystem);
        if (this.displayMode == null || !displayMode.equals(this.displayMode)) {
            this.displayMode = displayMode;
            if (this.properties != null) {
                this.initParallellCamera(this.cameraFollowsBike);
                this.initParallax(this.properties);
                if (this.parallax != null) {
                    this.parallax.update(0.016f);
                }
            }
        }
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
    }

    @Override
    public void handleEvent(ReceivedEvent receivedEvent) {
        GameObject gameObject;
        String string;
        if (receivedEvent.is("PassedFinishline")) {
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 0; i < this.bikes.size(); ++i) {
                if (receivedEvent.getArgumentValue("gameObject").equals(this.bikes.get(i).getName()) && !this.bikesPastFinishline.contains(this.bikes.get(i))) {
                    this.bikes.get(i).getBikeParticleSystem().getRearWheel().setPermaBreak(true);
                    this.setControlEnabled(i, true, false);
                    this.bikesPastFinishline.add(this.bikes.get(i));
                    BikeResult bikeResult = this.results.getBikeResult(this.bikes.get(i).getName());
                    if (bikeResult != null) {
                        BikeResult bikeResult2;
                        ReplayParticipant replayParticipant;
                        boolean bl3 = false;
                        if (this.bikes.get(i).isReplay() && (replayParticipant = this.bikes.get(i).getReplayParticipant()) != null && (bikeResult2 = replayParticipant.getBikeResult()) != null) {
                            bikeResult.setPassedFinishlineAtTime(bikeResult2.getPassedFinishlineAtTime());
                            bl3 = true;
                        }
                        if (!bl3) {
                            bikeResult.setPassedFinishlineAtTime(this.raceTime);
                        }
                    }
                }
                if (this.bikesPastFinishline.contains(this.bikes.get(i))) continue;
                bl = false;
                if (!this.bikes.get(i).isPlayer()) continue;
                bl2 = false;
            }
            this.getGlobalEventManager().fireEvent(Event.createEvent(receivedEvent));
            if (bl) {
                this.results.setEveryBikePastFinishline(true);
            }
            if (bl2) {
                this.getGlobalEventManager().fireEvent("AllHumansPassedFinishline");
            }
        } else if (receivedEvent.is("PassedStartline")) {
            BikeResult bikeResult = this.results.getBikeResult(receivedEvent.getArgumentValue("gameObject"));
            if (bikeResult != null) {
                bikeResult.setPassedStartlineAtTime(this.raceTime);
                if (bikeResult.getBike().isPlayer()) {
                    this.hideArrowKeys();
                    this.hideSpaceBar();
                }
            }
            this.getGlobalEventManager().fireEvent(Event.createEvent(receivedEvent));
        } else if (receivedEvent.is("FinishedCountdown")) {
            this.raceTime = 0.0f;
            this.getGlobalEventManager().fireEvent(Event.createEvent(receivedEvent));
        } else if ("DisplayModeChanged".equals(receivedEvent.getName()) || "DisplayChangeReverted".equals(receivedEvent.getName())) {
            this.checkDisplayModeChanged();
        } else if (receivedEvent.is("ResetAfterCrashRequested") && (string = receivedEvent.getArgumentValue("gameObject")) != null && (gameObject = this.hasGameObject(string)) != null && gameObject instanceof BikeGameObject) {
            BikeGameObject bikeGameObject = (BikeGameObject)gameObject;
            bikeGameObject.getBikeParticleSystem().getRider().getCenterOfMass(this.tempVec);
            this.tempVec = this.track.findGoodResetSpot(this.tempVec.x, 8.0, 2.5, this.tempVec);
            bikeGameObject.getBikeParticleSystem().reset(this.tempVec.subtractLocal(16.0, 0.0, 0.0), true);
            BikeResult bikeResult = this.results.getBikeResult(bikeGameObject.getName());
            if (bikeResult != null) {
                bikeResult.incNumberOfCrashes();
            }
            this.setControlEnabled(bikeGameObject, true, !this.bikesPastFinishline.contains(bikeGameObject));
        }
    }

    @Override
    public void cleanup() {
        if (this.getEventManager() != null) {
            this.getEventManager().unregisterListener(this);
        }
        if (this.getGlobalEventManager() != null) {
            this.getGlobalEventManager().unregisterListener(this);
        }
        super.cleanup();
    }

    public InputHandler getInput() {
        return this.input;
    }

    @Override
    protected void initCamera() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.cam = displaySystem.getRenderer().createCamera(displaySystem.getWidth(), displaySystem.getHeight());
        this.cam.setFrustumPerspective(45.0f, (float)displaySystem.getWidth() / (float)displaySystem.getHeight(), 1.0f, 1000.0f);
        this.cam.update();
        this.cameraNode = new ProviderFollowingCameraNode("CameraNode", this.cam);
        this.cameraNode.setLocalRotation(new Quaternion());
        this.cameraNode.setLocalTranslation(new Vector3f());
        this.cameraNode.setLocalScale(1.0f);
        this.cameraNode.updateWorldData(0.0f);
        this.cameraNode.setProviderMinimum(new Vector3f(11.0f, -10000.0f, -10000.0f));
        this.camNode = this.cameraNode;
        displaySystem.getRenderer().setCamera(this.cam);
        this.rootNode.attachChild(this.camNode);
    }

    public Track1D getTrack() {
        return this.track;
    }

    public ProviderFollowingCameraNode getCameraNode() {
        return this.cameraNode;
    }

    public ArrayList<BikeGameObject> getBikes() {
        return this.bikes;
    }

    public TransformationProvider getCameraFollowProvider() {
        return this.cameraFollowProvider;
    }

    public void setCallOnRestartCompleted(Callable callable) {
        this.callOnRestartCompleted = callable;
    }

    @Override
    public void setGlobalEventManager(EventManager eventManager) {
        super.setGlobalEventManager(eventManager);
        if (this.getGlobalEventManager() != null) {
            this.getGlobalEventManager().registerListener("DisplayModeChanged", this);
            this.getGlobalEventManager().registerListener("DisplayChangeReverted", this);
        }
    }

    public TrackGameObject getTrackGameObject() {
        return this.trackGameObject;
    }

    public BikeGameObject getPlayer() {
        return this.player;
    }

    public Parallax getParallax() {
        return this.parallax;
    }

    public boolean isWaitForStabilizedFrameRate() {
        return this.waitForStabilizedFrameRate;
    }

    public void waitForStabilizedFrameRate(boolean bl) {
        this.waitForStabilizedFrameRate = bl;
        if (bl) {
            this.frameRateManager.resetVariableFrameRate(false);
        }
    }

    public void startFireworks() {
        if (this.winEffect != null && this.player != null) {
            Node node = this.winEffect.getNode();
            node.setLocalTranslation((float)this.player.getBikeParticleSystem().getRider().getLocalTranslation().x, (float)this.player.getBikeParticleSystem().getRider().getLocalTranslation().y, (float)this.player.getBikeParticleSystem().getRider().getLocalTranslation().z);
            this.winEffect.start();
        }
    }

    public void stopFireworks() {
        if (this.winEffect != null) {
            this.winEffect.stop();
        }
    }

    public FrameRateManager getFrameRateManager() {
        return this.frameRateManager;
    }

    public LapDisplayerGameObject getLapDisplayer() {
        return this.lapDisplayer;
    }

    public Node getHudNode() {
        return this.hudNode;
    }

    public String getAfterRaceText() {
        return this.afterRaceText;
    }

    public void setAfterRaceText(String string) {
        this.afterRaceText = string;
    }

    public com.turborilla.msm.gui.turbogui.Image getAfterRaceImage() {
        return this.afterRaceImage;
    }

    public void setAfterRaceImage(com.turborilla.msm.gui.turbogui.Image image) {
        this.afterRaceImage = image;
    }

    public com.turborilla.msm.gui.turbogui.Image getBeforeRaceImage() {
        return this.beforeRaceImage;
    }

    public String getBeforeRaceText() {
        return this.beforeRaceText;
    }

    public float getRaceTime() {
        return this.raceTime;
    }

    public void setRaceTime(float f) {
        this.raceTime = f;
    }

    public boolean isDisplayAfterRaceText() {
        return this.displayAfterRaceText;
    }

    public void showArrowKeys() {
        int n = this.getSettings().getWidth();
        int n2 = this.getSettings().getHeight();
        if (this.arrowKeys == null) {
            this.arrowKeys = new Quad("arrowKeys", 1.0f, 1.0f);
            try {
                Properties properties = new Properties();
                properties.setProperty("textureMinFilter", "5");
                properties.setProperty("textureMagFilter", "1");
                Texture texture = (Texture)ResourceManager.getInstance().load("texture", "arrow_keys", properties);
                TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                textureState.setTexture(texture);
                this.arrowKeys.setRenderState(textureState);
                this.arrowKeysFader = new SpatialFadeController(this.arrowKeys);
                this.arrowKeysFader.initRenderStates();
                this.arrowKeysScaler = new SpatialScaleController(this.arrowKeys);
            }
            catch (IOException iOException) {
                this.arrowKeys = null;
            }
        }
        if (this.arrowKeys != null) {
            if (!this.hudNode.hasChild(this.arrowKeys)) {
                this.hudNode.attachChild(this.arrowKeys);
            }
            this.arrowKeys.resize(n2 / 4, n2 / 4);
            this.arrowKeys.setLocalTranslation(n / 2, n2 - n2 / 4, 0.0f);
            this.arrowKeysFader.clearFadeQueue();
            this.arrowKeysFader.setColor(1.0f, 1.0f, 1.0f, 0.0f);
            this.arrowKeysFader.fadeTo(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f), 3.0f);
            this.arrowKeysScaler.clearScalingQueue();
            this.arrowKeysScaler.setDamping(0.2f);
            this.arrowKeysScaler.setScale(0.0f, 0.0f, 1.0f);
            this.arrowKeysScaler.scaleTo(new Vector3f(1.0f, 1.0f, 1.0f), 6.0f, 3.0f);
            this.arrowKeysShowing = true;
        }
    }

    public void hideArrowKeys() {
        if (this.arrowKeys != null && this.arrowKeysShowing) {
            this.arrowKeysFader.clearFadeQueue();
            this.arrowKeysFader.fadeTo(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f), 1.5f);
            this.arrowKeysScaler.clearScalingQueue();
            this.arrowKeysScaler.setDamping(0.2f);
            this.arrowKeysScaler.scaleTo(new Vector3f(0.7f, 0.7f, 1.0f), 4.0f, 4.0f);
            this.arrowKeysFader.add(new IControllerListener(){

                public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                    GameState.this.hudNode.detachChild(GameState.this.arrowKeys);
                }
            });
        }
        this.arrowKeysShowing = false;
    }

    public void wiggleArrowKeys() {
        if (this.arrowKeys != null && this.arrowKeysShowing && !this.arrowKeysScaler.isScaling()) {
            this.arrowKeysScaler.clearScalingQueue();
            this.arrowKeysScaler.setDamping(0.05f);
            this.arrowKeysScaler.setScale(new Vector3f(0.9f, 0.9f, 0.9f));
            this.arrowKeysScaler.scaleTo(new Vector3f(1.0f, 1.0f, 1.0f), 0.2f, 2.0f);
        }
    }

    public void showSpaceBar() {
        int n = this.getSettings().getWidth();
        int n2 = this.getSettings().getHeight();
        if (this.spaceBar == null) {
            this.spaceBar = new Quad("spaceBar", 1.0f, 1.0f);
            try {
                Properties properties = new Properties();
                properties.setProperty("textureMinFilter", "5");
                properties.setProperty("textureMagFilter", "1");
                Texture texture = (Texture)ResourceManager.getInstance().load("texture", "spacebar", properties);
                TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                textureState.setTexture(texture);
                this.spaceBar.setRenderState(textureState);
                this.spaceBarFader = new SpatialFadeController(this.spaceBar);
                this.spaceBarFader.initRenderStates();
                this.spaceBarScaler = new SpatialScaleController(this.spaceBar);
            }
            catch (IOException iOException) {
                this.spaceBar = null;
            }
        }
        if (this.spaceBar != null) {
            if (!this.hudNode.hasChild(this.spaceBar)) {
                this.hudNode.attachChild(this.spaceBar);
            }
            this.spaceBar.resize(n2 / 2, n2 / 8);
            this.spaceBar.setLocalTranslation(n / 2, n2 - n2 / 3, 0.0f);
            this.spaceBarFader.clearFadeQueue();
            this.spaceBarFader.setColor(1.0f, 1.0f, 1.0f, 0.0f);
            this.spaceBarFader.fadeTo(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.8f), 3.0f);
            this.spaceBarScaler.clearScalingQueue();
            this.spaceBarScaler.setDamping(0.2f);
            this.spaceBarScaler.setScale(0.0f, 0.0f, 1.0f);
            this.spaceBarScaler.scaleTo(new Vector3f(1.0f, 1.0f, 1.0f), 6.0f, 3.0f);
            this.spaceBarShowing = true;
        }
    }

    public void hideSpaceBar() {
        if (this.spaceBar != null && this.spaceBarShowing) {
            this.spaceBarFader.clearFadeQueue();
            this.spaceBarFader.fadeTo(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f), 1.5f);
            this.spaceBarScaler.clearScalingQueue();
            this.spaceBarScaler.setDamping(0.2f);
            this.spaceBarScaler.scaleTo(new Vector3f(0.7f, 0.7f, 1.0f), 4.0f, 4.0f);
            this.spaceBarFader.add(new IControllerListener(){

                public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                    GameState.this.hudNode.detachChild(GameState.this.spaceBar);
                }
            });
        }
        this.spaceBarShowing = false;
    }

    public void wiggleSpaceBar() {
        if (this.spaceBar != null && this.spaceBarShowing && !this.spaceBarScaler.isScaling()) {
            this.spaceBarScaler.clearScalingQueue();
            this.spaceBarScaler.setDamping(0.05f);
            this.spaceBarScaler.setScale(new Vector3f(0.9f, 0.9f, 0.9f));
            this.spaceBarScaler.scaleTo(new Vector3f(1.0f, 1.0f, 1.0f), 0.2f, 2.0f);
        }
    }

    private class DisplayMode {
        int width;
        int height;
        int bpp;
        int frequency;
        boolean fullscreen;

        public DisplayMode(int n, int n2, int n3, int n4, boolean bl) {
            this.width = n;
            this.height = n2;
            this.bpp = n3;
            this.frequency = n4;
            this.fullscreen = bl;
        }

        public DisplayMode(DisplaySystem displaySystem) {
            this.width = displaySystem.getWidth();
            this.height = displaySystem.getHeight();
            this.bpp = displaySystem.getBitDepth();
            this.frequency = displaySystem.getFrequency();
            this.fullscreen = displaySystem.isFullScreen();
        }

        public DisplayMode(GameSettings gameSettings) {
            this.width = gameSettings.getWidth();
            this.height = gameSettings.getHeight();
            this.bpp = gameSettings.getDepth();
            this.frequency = gameSettings.getFrequency();
            this.fullscreen = gameSettings.isFullscreen();
        }

        public boolean equals(DisplayMode displayMode) {
            return displayMode != null && this.width == displayMode.width && this.height == displayMode.height && this.bpp == displayMode.bpp && this.frequency == displayMode.frequency;
        }
    }
}

