/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.game;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.rewards.CollectedReward;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BikeResult
implements Savable {
    private BikeGameObject bike;
    private float passedStartlineAtTime;
    private float passedFinishlineAtTime;
    private int numberOfCrashes;
    private boolean finishedRace;
    private ArrayList<CollectedReward> improvedRewards;
    private ArrayList<CollectedReward> notImprovedRewards;
    private boolean personalBest = false;
    private float shavedTime = 0.0f;
    public static Comparator<BikeResult> finishOrderComparator = new Comparator<BikeResult>(){

        @Override
        public int compare(BikeResult bikeResult, BikeResult bikeResult2) {
            if (bikeResult.hasFinishedRace() && !bikeResult2.hasFinishedRace()) {
                return -1;
            }
            if (!bikeResult.hasFinishedRace() && bikeResult2.hasFinishedRace()) {
                return 1;
            }
            if (!bikeResult.hasFinishedRace() && !bikeResult2.hasFinishedRace()) {
                return 0;
            }
            float f = bikeResult.getPassedFinishlineAtTime() - bikeResult2.getPassedFinishlineAtTime();
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator<BikeResult> startOrderComparator = new Comparator<BikeResult>(){

        @Override
        public int compare(BikeResult bikeResult, BikeResult bikeResult2) {
            float f = bikeResult.getPassedStartlineAtTime() - bikeResult2.getPassedStartlineAtTime();
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    };
    private String riderName;
    private int version = 1;

    public float getShavedTime() {
        return this.shavedTime;
    }

    public void setShavedTime(float f) {
        this.shavedTime = f;
    }

    public BikeResult(BikeGameObject bikeGameObject) {
        this.bike = bikeGameObject;
    }

    public BikeResult() {
    }

    public void reset() {
        this.passedStartlineAtTime = 0.0f;
        this.passedFinishlineAtTime = 0.0f;
        this.personalBest = false;
        this.shavedTime = 0.0f;
        this.numberOfCrashes = 0;
        this.finishedRace = false;
        this.improvedRewards = null;
        this.notImprovedRewards = null;
    }

    boolean is(GameObject gameObject) {
        return gameObject == this.bike;
    }

    boolean is(String string) {
        return string.equals(this.bike.getName());
    }

    public void setCollectedRewards(ArrayList<CollectedReward> arrayList, ArrayList<CollectedReward> arrayList2) {
        this.improvedRewards = arrayList;
        this.notImprovedRewards = arrayList2;
    }

    public ArrayList<CollectedReward> getImprovedRewards() {
        return this.improvedRewards;
    }

    public ArrayList<CollectedReward> getNotImprovedRewards() {
        return this.notImprovedRewards;
    }

    public float getPassedStartlineAtTime() {
        return this.passedStartlineAtTime;
    }

    void setPassedStartlineAtTime(float f) {
        this.passedStartlineAtTime = f;
    }

    public boolean isPersonalBest() {
        return this.personalBest;
    }

    public void setPersonalBest(boolean bl) {
        this.personalBest = bl;
    }

    public float getPassedFinishlineAtTime() {
        return this.passedFinishlineAtTime;
    }

    void setPassedFinishlineAtTime(float f) {
        this.passedFinishlineAtTime = f;
        if (f > 0.0f) {
            this.finishedRace = true;
        }
    }

    public int getNumberOfCrashes() {
        return this.numberOfCrashes;
    }

    void setNumberOfCrashes(int n) {
        this.numberOfCrashes = n;
    }

    public BikeGameObject getBike() {
        return this.bike;
    }

    public Profile getProfile() {
        if (this.getBike() == null) {
            return null;
        }
        return this.getBike().getProfile();
    }

    public boolean hasFinishedRace() {
        return this.finishedRace;
    }

    void incNumberOfCrashes() {
        ++this.numberOfCrashes;
    }

    public String toString() {
        String string = "";
        string = string + "Bike: " + this.getBike() + "\n";
        if (this.getBike() != null) {
            string = string + "Profile: " + this.getBike().getProfile() + "\n";
        }
        string = string + "Number of crashes: " + this.getNumberOfCrashes() + "\n";
        string = string + "Passed start line at: " + this.getPassedStartlineAtTime() + " seconds\n";
        string = this.hasFinishedRace() ? string + "Passed finish line at: " + this.getPassedFinishlineAtTime() + " seconds\n" : string + "Did not pass finish line yet\n";
        return string;
    }

    public void setFinishedRace(boolean bl) {
        this.finishedRace = bl;
    }

    @Override
    public Class getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            Logger.getLogger(this.getClassTag().getName()).warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.passedStartlineAtTime = inputCapsule.readFloat("passedStartlineAtTime", 0.0f);
                this.passedFinishlineAtTime = inputCapsule.readFloat("passedFinishlineAtTime", 0.0f);
                this.numberOfCrashes = inputCapsule.readInt("numberOfCrashes", 0);
                this.personalBest = inputCapsule.readBoolean("personalBest", false);
                this.shavedTime = inputCapsule.readFloat("shavedTime", 0.0f);
                this.riderName = inputCapsule.readString("riderName", null);
                this.improvedRewards = inputCapsule.readSavableArrayList("collectedRewards", null);
                this.notImprovedRewards = inputCapsule.readSavableArrayList("notImprovedRewards", null);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.passedStartlineAtTime, "passedStartlineAtTime", 0.0f);
        outputCapsule.write(this.passedFinishlineAtTime, "passedFinishlineAtTime", 0.0f);
        outputCapsule.write(this.numberOfCrashes, "numberOfCrashes", 0);
        outputCapsule.write(this.personalBest, "personalBest", false);
        outputCapsule.write(this.shavedTime, "shavedTime", 0.0f);
        outputCapsule.write(this.getRiderName(), "riderName", null);
        outputCapsule.writeSavableArrayList(this.improvedRewards, "collectedRewards", null);
        outputCapsule.writeSavableArrayList(this.notImprovedRewards, "notImprovedRewards", null);
    }

    public String getRiderName() {
        if (this.bike != null && this.bike.getProfile() != null) {
            return this.bike.getProfile().getName();
        }
        return this.riderName;
    }

    public void setRiderName(String string) {
        this.riderName = string;
    }
}

