/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.editor.interpolation;

import com.turborilla.msm.states.editor.interpolation.IInterpolator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;

public abstract class AbstractInterpolator
implements IInterpolator {
    protected String name = "NoName";
    private HashMap<String, Parameter> parameters = new HashMap();
    private Properties tooltips = new Properties();
    private int leftHeight = 0;
    private int rightHeight = 0;
    private boolean takeHeightFromHeightMap = true;
    private int order = 0;

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        String[] stringArray = new String[this.parameters.values().size()];
        Object[] objectArray = this.parameters.values().toArray(new Parameter[0]);
        Arrays.sort(objectArray);
        int n = 0;
        for (Object object : objectArray) {
            stringArray[n] = ((Parameter)object).getParameterName();
            ++n;
        }
        return stringArray;
    }

    public void setParameterValue(String string, float f) {
        Parameter parameter = this.parameters.get(string);
        if (parameter == null) {
            return;
        }
        parameter.setValue(f);
    }

    public float getParameterValue(String string) {
        Parameter parameter = this.parameters.get(string);
        if (parameter == null) {
            return 0.0f;
        }
        return parameter.getValue();
    }

    public String getTooltip(String string) {
        return this.tooltips.getProperty(string);
    }

    protected void setTooltip(String string, String string2) {
        this.tooltips.setProperty(string, string2);
    }

    protected void setParameter(String string, float f) {
        Parameter parameter = this.parameters.get(string);
        if (parameter == null) {
            parameter = new Parameter(string, this.order++);
            this.parameters.put(string, parameter);
        }
        parameter.setValue(f);
    }

    public int getLeftHeight() {
        return this.leftHeight;
    }

    public void setLeftHeight(int n) {
        this.leftHeight = n;
    }

    public int getRightHeight() {
        return this.rightHeight;
    }

    public void setRightHeight(int n) {
        this.rightHeight = n;
    }

    protected boolean isTakeHeightFromHeightMap() {
        return this.takeHeightFromHeightMap;
    }

    public void setTakeHeightFromHeightMap(boolean bl) {
        this.takeHeightFromHeightMap = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parameter
    implements Comparable<Parameter> {
        private String parameterName;
        private float value;
        private int order;

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int n) {
            this.order = n;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public void setParameterName(String string) {
            this.parameterName = string;
        }

        Parameter(String string, int n) {
            this.parameterName = string;
            this.order = n;
        }

        @Override
        public int compareTo(Parameter parameter) {
            return this.order - parameter.order;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Parameter) {
                Parameter parameter = (Parameter)object;
                return this.parameterName.equals(parameter.getParameterName());
            }
            return false;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float f) {
            this.value = f;
        }
    }
}

