/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.editor.challenge;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.msm.states.editor.challenge.IChallenge;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class AbstractChallenge
implements IChallenge {
    private static Logger logger = Logger.getLogger(AbstractChallenge.class.getCanonicalName());
    protected String name = "NoName";
    private HashMap<String, Parameter> parameters = new HashMap();
    private Properties tooltips = new Properties();
    private int order = 0;
    protected int version = 1;

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        String[] stringArray = new String[this.parameters.values().size()];
        Object[] objectArray = this.parameters.values().toArray(new Parameter[0]);
        Arrays.sort(objectArray);
        int n = 0;
        for (Object object : objectArray) {
            stringArray[n] = ((Parameter)object).getParameterName();
            ++n;
        }
        return stringArray;
    }

    public void setParameterValue(String string, int n) {
        Parameter parameter = this.parameters.get(string);
        if (parameter == null) {
            return;
        }
        parameter.setValue(n);
    }

    public int getParameterValue(String string) {
        Parameter parameter = this.parameters.get(string);
        if (parameter == null) {
            return 0;
        }
        return parameter.getValue();
    }

    public String getTooltip(String string) {
        return this.tooltips.getProperty(string);
    }

    protected void setTooltip(String string, String string2) {
        this.tooltips.setProperty(string, string2);
    }

    protected void setParameter(String string, int n) {
        Parameter parameter = this.parameters.get(string);
        if (parameter == null) {
            parameter = new Parameter(string, this.order++);
            this.parameters.put(string, parameter);
        }
        parameter.setValue(n);
    }

    public String toString() {
        String string = this.getName();
        return string;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                Savable[] savableArray;
                this.name = inputCapsule.readString("name", "noname");
                for (Savable savable : savableArray = inputCapsule.readSavableArray("parameters", new Parameter[0])) {
                    if (!(savable instanceof Parameter)) continue;
                    Parameter parameter = (Parameter)savable;
                    this.parameters.put(parameter.getParameterName(), parameter);
                }
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.getName(), "name", "noname");
        Savable[] savableArray = this.parameters.values().toArray(new Parameter[0]);
        outputCapsule.write(savableArray, "parameters", new Parameter[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter
    implements Comparable<Parameter>,
    Savable {
        private String parameterName;
        private int value;
        private int order;
        protected int version = 1;

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int n) {
            this.order = n;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public void setParameterName(String string) {
            this.parameterName = string;
        }

        Parameter(String string, int n) {
            this.parameterName = string;
            this.order = n;
        }

        public Parameter() {
        }

        @Override
        public int compareTo(Parameter parameter) {
            return this.order - parameter.order;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Parameter) {
                Parameter parameter = (Parameter)object;
                return this.parameterName.equals(parameter.getParameterName());
            }
            return false;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        @Override
        public Class getClassTag() {
            return this.getClass();
        }

        @Override
        public void read(JMEImporter jMEImporter) throws IOException {
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            int n = inputCapsule.readInt("version", 0);
            if (n != this.version) {
                logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
            }
            this.read(n, inputCapsule);
        }

        protected void read(int n, InputCapsule inputCapsule) throws IOException {
            switch (n) {
                case 1: {
                    this.parameterName = inputCapsule.readString("parameterName", "noname");
                    this.value = inputCapsule.readInt("value", 0);
                    this.order = inputCapsule.readInt("order", 0);
                    break;
                }
                default: {
                    throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
                }
            }
        }

        @Override
        public void write(JMEExporter jMEExporter) throws IOException {
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.version, "version", 0);
            outputCapsule.write(this.getParameterName(), "parameterName", "noname");
            outputCapsule.write(this.getValue(), "value", 0);
            outputCapsule.write(this.getOrder(), "order", 0);
        }
    }
}

