/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.editor;

import com.jme.renderer.ColorRGBA;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IMouseOverListener;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolTipOnMouseOver
implements IMouseOverListener<IWidget> {
    private static ColorRGBA noAlphaColor = new ColorRGBA(1.0f, 0.5f, 0.5f, 0.0f);
    private static ColorRGBA fullAlphaColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private static float toolTipFadeTime = 0.2f;
    private String text = "";
    private String disabledText = null;
    private Label tipLabel = null;

    public ToolTipOnMouseOver(String string, String string2, Label label) {
        this(string, label);
        this.disabledText = string2 != null ? string2 : "";
    }

    public ToolTipOnMouseOver(String string, Label label) {
        this.text = string != null ? string : "";
        this.tipLabel = label;
    }

    @Override
    public void onMouseOver(IWidget iWidget) {
        if (iWidget instanceof BaseWidget && !((BaseWidget)iWidget).isEnabled()) {
            new FadeOutChangeTextAndFadeIn(this.tipLabel, this.disabledText);
        } else {
            new FadeOutChangeTextAndFadeIn(this.tipLabel, this.text);
        }
    }

    @Override
    public void onMouseOut(IWidget iWidget) {
        if (this.text.equals(this.tipLabel.getText()) || this.disabledText != null && this.disabledText.equals(this.tipLabel.getText())) {
            new FadeOutChangeTextAndFadeIn(this.tipLabel, "");
        }
    }

    private class FadeOutChangeTextAndFadeIn
    implements IControllerListener {
        Label label;
        String text;

        FadeOutChangeTextAndFadeIn(Label label, String string) {
            this.label = label;
            this.text = string;
            if (label != null && label.getFader() != null) {
                label.getFader().clearListeners();
                label.getFader().fadeTo(noAlphaColor, toolTipFadeTime);
                label.getFader().add(this);
            }
        }

        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            if (this.label != null && this.label.getFader() != null) {
                this.label.setText(this.text);
                this.label.getFader().fadeTo(fullAlphaColor, toolTipFadeTime);
            }
        }
    }
}

