/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states.editor;

import com.jme.bounding.BoundingBox;
import com.jme.input.InputHandler;
import com.jme.intersection.TrianglePickResults;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Geometry;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.geom.BufferUtils;
import com.turborilla.TransformationCoupler;
import com.turborilla.TransformationProvider;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.IGuiListener;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.gui.widget.utils.Panel;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableColumnLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.Game;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.gui.turbogui.Image;
import com.turborilla.msm.gui.turbogui.Rectangle;
import com.turborilla.msm.gui.turbogui.checkbox.CheckBox;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.listeners.ICheckBoxChanged;
import com.turborilla.msm.gui.turbogui.listeners.ILeftMouseDownListener;
import com.turborilla.msm.gui.turbogui.listeners.IRightMouseDownListener;
import com.turborilla.msm.gui.turbogui.listeners.IValueChangedListener;
import com.turborilla.msm.gui.turbogui.menubutton.BuyMenuButton;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.minimap.MiniMap;
import com.turborilla.msm.gui.turbogui.panel.BorderPanel;
import com.turborilla.msm.gui.turbogui.panel.FilePanel;
import com.turborilla.msm.gui.turbogui.slider.Slider;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.StandardState;
import com.turborilla.msm.states.editor.ChallengesPanel;
import com.turborilla.msm.states.editor.ToolTipOnMouseOver;
import com.turborilla.msm.states.editor.challenge.BackflipChallenge;
import com.turborilla.msm.states.editor.challenge.ChallengePanel;
import com.turborilla.msm.states.editor.challenge.DoubleBackflipChallenge;
import com.turborilla.msm.states.editor.challenge.FrontflipChallenge;
import com.turborilla.msm.states.editor.challenge.IChallenge;
import com.turborilla.msm.states.editor.challenge.StoppieChallenge;
import com.turborilla.msm.states.editor.challenge.TimeChallenge;
import com.turborilla.msm.states.editor.challenge.WheelieChallenge;
import com.turborilla.msm.states.editor.interpolation.CubicInterpolator;
import com.turborilla.msm.states.editor.interpolation.IInterpolator;
import com.turborilla.msm.states.editor.interpolation.LinearInterpolator;
import com.turborilla.msm.states.editor.interpolation.SineInterpolator;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.track.Track1D;
import com.turborilla.msm.track.challenges.IAchievedListener;
import com.turborilla.msm.utils.ProviderFollowingCameraNode;
import com.turborilla.terrain.ImageHeightMap;
import com.turborilla.utils.Utils;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import com.turborilla.utils.controllers.SpatialFadeController;
import com.turborilla.utils.controllers.SpatialTranslationController;
import com.turborilla.utils.folders.SystemFolder;
import com.turborilla.utils.math.Vector3d;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Logger;

public class EditorState
extends StandardState {
    private static final int undoLimit = 80;
    private static Logger logger = Logger.getLogger(EditorState.class.getName());
    private static float buttonSlideTime = 5.0f;
    private static String gameStateName;
    private static ColorRGBA noAlphaColor;
    private static ColorRGBA fullAlphaColor;
    private static ColorRGBA mouseOverColor;
    private static ColorRGBA selectedColor;
    private static ColorRGBA previewColor;
    private static ColorRGBA previewNotValidColor;
    private static Vector3f panelHideVector;
    private static Vector3f buttonHideVector;
    private static float fadeTime;
    private static float moveTime;
    private static float moveDamping;
    private static float scrollSpeed;
    private static float editPanelMoveTime;
    private static float editPanelRemoveTime;
    private static float bikeMarkerMoveTime;
    private static float bikeMarkerMoveDamping;
    GuiHandler gui;
    InputHandler input;
    GameState gameState;
    private MenuButton editButton;
    private MenuButton restartButton;
    private MenuButton playButton;
    private MenuButton undoButton;
    private MenuButton redoButton;
    private boolean inEdit = false;
    private IControllerListener fadeAndRemove = new FadeAndRemove();
    private Label heightLabel;
    private TransformationCoupler mouseCameraFollower;
    private TransformationProvider bikeCameraFollower;
    private ProviderFollowingCameraNode gameStateCameraNode;
    private Panel editPanel;
    private Panel playPanel;
    private Vector3f editPanelPosition = new Vector3f();
    private Vector3f childPanelPosition = new Vector3f();
    private Vector3f playPanelPosition = new Vector3f();
    private Vector3f playButtonPosition = new Vector3f();
    private Label tipLabel;
    private int maxIntHeight = 640;
    private int minIntHeight = -640;
    private double maxHeight = (double)this.maxIntHeight * 0.025;
    private double minHeight = (double)this.minIntHeight * 0.025;
    private Label lengthLabel;
    private MiniMap miniMap;
    private Vector3f miniMapPosition = new Vector3f();
    private Vector3f miniMapHideVector = new Vector3f();
    private Rectangle cameraMarker;
    private Image bikeMarker;
    private FilePanel filePanel;
    private ArrayList<MenuButton> enabledWhenStripChosen;
    private ArrayList<MenuButton> enabledWhen3StripsChosen;
    private IInterpolator[] interpolators = new IInterpolator[]{new LinearInterpolator(), new CubicInterpolator(), new SineInterpolator()};
    private IChallenge[] challenges = new IChallenge[]{new TimeChallenge(), new WheelieChallenge(), new StoppieChallenge(), new BackflipChallenge(), new FrontflipChallenge(), new DoubleBackflipChallenge()};
    private int activeInterpolator = -1;
    private Vector3f cameraSpeed;
    private Vector3f cameraSlackMin;
    private Vector3f cameraSlackMax;
    private ArrayList<Slider> leftHeightSliders;
    private ArrayList<Slider> rightHeightSliders;
    private ArrayList<IResizableWidget> widgetsToResize;
    private int previousScreenWidth;
    private int previousScreenHeight;
    private int columnWhereSelectStarted = -1;
    private ArrayList<Geometry> selectedHighlights = new ArrayList();
    private ArrayList<Integer> selected = new ArrayList();
    private int latestSelected = -1;
    private Vector3f tempVec = new Vector3f();
    private Vector3d tempVecd = new Vector3d();
    private double latestMouseOverXPos = 0.0;
    private Highlight mouseOverHighlight = null;
    private int mouseOverColumn = -1;
    private Node selectedNode = null;
    private Node highlightNode = null;
    private Node previewNode = null;
    private Track1D track;
    private float tpf = 0.016f;
    private float scrolling = 0.0f;
    private IControllerListener detachWhenDone = new DetachWhenDone();
    private IAchievedListener challengeListener = new ChallengeListener();
    private int[] clipboard;
    private Stack<int[]> undo;
    private Stack<int[]> redo;
    private int autoSaveInterval = 1;
    private int autoSaveCount = 0;
    private File autoSaveFile = null;
    private ChallengesPanel challengesPanel;
    private BorderPanel specialPanel;

    public EditorState(GameState gameState, GameSettings gameSettings, URL uRL) {
        super("EditorState", gameSettings, uRL);
        this.enabledWhenStripChosen = new ArrayList();
        this.enabledWhen3StripsChosen = new ArrayList();
        this.leftHeightSliders = new ArrayList();
        this.rightHeightSliders = new ArrayList();
        this.widgetsToResize = new ArrayList();
        this.gameState = gameState;
        gameStateName = gameState.getName();
        this.initRootNode();
        this.initGui();
        this.createHighlightNodes();
        this.heightLabel = new Label("heightLabel", "", 6.0f, 2.0f, "menufont", null);
        this.heightLabel.setRenderQueueMode(3);
        this.heightLabel.getMover().setDamping(moveDamping);
        this.heightLabel.getFader().setColor(fullAlphaColor);
        this.highlightNode.attachChild(this.heightLabel.getSpatial());
        this.getRootNode().updateRenderState();
        this.undo = new Stack();
        this.redo = new Stack();
    }

    private void initRootNode() {
        this.rootNode.setCullMode(3);
        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
        cullState.setCullMode(0);
        cullState.setEnabled(true);
        this.rootNode.setRenderState(cullState);
    }

    private void initGui() {
        Object object;
        Object f12;
        Object f11;
        Object object2;
        IResizableWidget iResizableWidget;
        String[] stringArray;
        Object object3;
        IResizableWidget iResizableWidget2;
        this.input = new InputHandler();
        final DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.previousScreenWidth = displaySystem.getWidth();
        this.previousScreenHeight = displaySystem.getHeight();
        URL uRL = ResourceManager.findUrl("cursor", new String[]{"images", "images/gui"}, new String[]{"png", "tga", "jpg"});
        this.gui = new GuiHandler(new Vector2f(displaySystem.getWidth(), displaySystem.getHeight()), this.input, uRL, new Vector3f(4.0f, 31.0f, 0.0f));
        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
        cullState.setCullMode(0);
        cullState.setEnabled(true);
        this.gui.getNode().setRenderState(cullState);
        this.gui.getNode().setRenderQueueMode(4);
        this.gui.getNode().setCullMode(3);
        this.gui.getNode().setLightCombineMode(5);
        LightState lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        lightState.detachAll();
        lightState.setEnabled(true);
        this.gui.getNode().setRenderState(lightState);
        GlobalGuiListener globalGuiListener = new GlobalGuiListener(this);
        this.gui.setListener(globalGuiListener);
        this.playPanel = new Panel("PlayPanel", displaySystem.getWidth(), (float)displaySystem.getHeight() * 0.08f, this.gui);
        this.playPanel.getMover().setDamping(0.14f);
        this.gui.addWidget(this.playPanel, new Vector2f(0.5f, 0.9f), true, true);
        this.widgetsToResize.add(this.playPanel);
        VariableColumnLayout variableColumnLayout = new VariableColumnLayout();
        this.playPanel.setLayout(variableColumnLayout);
        variableColumnLayout.setColumns(4.5f, 1.1f, 1.1f);
        variableColumnLayout.add(null);
        this.restartButton = new MenuButton("RestartButton", "Restart", this.playPanel.getWidth() * 0.15f, this.playPanel.getHeight());
        this.restartButton.getMover().setDamping(0.14f);
        this.playPanel.addWidget(this.restartButton, new Vector2f(0.6f, 0.5f), true, true);
        variableColumnLayout.add(this.restartButton);
        this.restartButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.setInEdit(true);
                EditorState.this.setInEdit(false);
            }
        });
        this.editButton = new MenuButton("EditButton", "Edit", this.playPanel.getWidth() * 0.15f, this.playPanel.getHeight());
        this.editButton.getMover().setDamping(0.14f);
        this.playPanel.addWidget(this.editButton, new Vector2f(0.8f, 0.5f), true, true);
        variableColumnLayout.add(this.editButton);
        this.playButton = new MenuButton("PlayButton", "Play", 200.0f, 50.0f);
        this.playButton.getMover().setDamping(0.14f);
        this.gui.addWidget(this.playButton, new Vector2f(0.8f, 0.5f), true, true);
        this.playButtonPosition.set(this.playButton.getLocalTranslation());
        this.tempVec.set(this.playButtonPosition).addLocal(buttonHideVector);
        this.playButton.getMover().setPosition(this.tempVec);
        this.playPanelPosition.set(this.playPanel.getLocalTranslation());
        this.editPanel = new BorderPanel("EditPanel", (float)displaySystem.getWidth() * 0.9f, (float)displaySystem.getHeight() * 0.4f, this.gui, "corner", "edge", "combobox", 0.4f);
        this.editPanel.getMover().setDamping(0.14f);
        this.gui.addWidget(this.editPanel, new Vector2f(0.5f, 0.82f), true, true);
        this.widgetsToResize.add(this.editPanel);
        this.editPanelPosition.set(this.editPanel.getLocalTranslation());
        this.tempVec.set(this.editPanelPosition).addLocal(panelHideVector);
        this.editPanel.getMover().setPosition(this.tempVec);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        variableRowLayout.setRows(1.0f, 4.0f, 4.0f, 4.0f, 2.6f, 1.9f);
        variableRowLayout.setPadding(0.0f, 0.03f);
        this.editPanel.setLayout(variableRowLayout);
        RowLayout[] rowLayoutArray = new RowLayout[]{new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.0f), new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.0f), new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.0f), new RowLayout(new Vector2f(), 1.0f, 1.0f, 0.0f)};
        rowLayoutArray[0].setPadding(0.02f, 0.0f);
        rowLayoutArray[1].setPadding(0.02f, 0.0f);
        rowLayoutArray[2].setPadding(0.02f, 0.0f);
        variableRowLayout.add(null);
        variableRowLayout.add(rowLayoutArray[0]);
        variableRowLayout.add(rowLayoutArray[1]);
        variableRowLayout.add(rowLayoutArray[2]);
        variableRowLayout.add(null);
        variableRowLayout.add(rowLayoutArray[3]);
        ColumnLayout columnLayout = new ColumnLayout();
        rowLayoutArray[1].add(columnLayout);
        BaseLayout baseLayout = new BaseLayout();
        columnLayout.add(baseLayout);
        BaseLayout baseLayout2 = new BaseLayout();
        columnLayout.add(baseLayout2);
        ColumnLayout columnLayout2 = new ColumnLayout();
        rowLayoutArray[1].add(columnLayout2);
        BaseLayout baseLayout3 = new BaseLayout();
        columnLayout2.add(baseLayout3);
        BaseLayout baseLayout4 = null;
        this.tipLabel = new Label("ToolTip", "Choose a strip of the track by clicking with the left mouse button. Choose multiple by holding SHIFT.", this.editPanel.getWidth() * 0.9f, this.editPanel.getHeight() * 0.05f, "normal_small_black", null);
        this.tipLabel.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        this.editPanel.addWidget(this.tipLabel, new Vector2f(0.5f, 0.07f), true, true);
        rowLayoutArray[3].add(this.tipLabel);
        if ("Demo".equals(this.getSettings().get("version", "Demo")) && Boolean.parseBoolean(this.settings.get("showBuyButtons", "false"))) {
            baseLayout4 = new BaseLayout();
            iResizableWidget2 = new BuyMenuButton("webButton", "Buy now!", 200.0f, 50.0f, 0.99200004f);
            IButtonClickedListener iButtonClickedListener = new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.gui.focusWidget(null);
                    Game.buy("editor");
                }
            };
            this.editPanel.addWidget((BaseWidget)((Object)iResizableWidget2), new Vector2f(0.5f, 0.5f), true, true);
            ((MenuButton)iResizableWidget2).addListener(iButtonClickedListener);
            ((BaseWidget)((Object)iResizableWidget2)).setMouseOverListener(new ToolTipOnMouseOver("Buy the full version of Mad Skills Motocross to enjoy the full potential of the editor", this.tipLabel));
            baseLayout4.add(iResizableWidget2);
        }
        columnLayout2.add(baseLayout4);
        this.lengthLabel = new Label("LengthLabel", "Track Length: 600", this.editPanel.getWidth() * 0.3f, this.editPanel.getHeight() * 0.05f, "normal_small_black", null);
        this.lengthLabel.setHorisontalAlignment(HorisontalAlignment.LEFT);
        this.editPanel.addWidget(this.lengthLabel, new Vector2f(0.15f, 0.9f), true, true);
        iResizableWidget2 = new ColumnLayout();
        ((BaseLayout)iResizableWidget2).add(this.lengthLabel);
        ((BaseLayout)iResizableWidget2).add(null);
        rowLayoutArray[0].add(iResizableWidget2);
        this.undoButton = new MenuButton("UndoButton", "Undo", 1.0f, 1.0f);
        this.editPanel.addWidget(this.undoButton);
        this.undoButton.setEnabled(false);
        rowLayoutArray[0].add(this.undoButton);
        this.undoButton.setMouseOverListener(new ToolTipOnMouseOver("Undo latest change", this.tipLabel));
        this.undoButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.undo();
            }
        });
        this.redoButton = new MenuButton("RedoButton", "Redo", 1.0f, 1.0f);
        this.editPanel.addWidget(this.redoButton);
        this.redoButton.setEnabled(false);
        rowLayoutArray[0].add(this.redoButton);
        this.redoButton.setMouseOverListener(new ToolTipOnMouseOver("Redo latest undo", this.tipLabel));
        this.redoButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.redo();
            }
        });
        int n = 5;
        float f = 0.05f;
        float f2 = 0.1f / (float)n;
        float f3 = f2 * (float)(n - 1);
        float f4 = f3 + f * 2.0f;
        float f5 = (1.0f - f4) / (float)n;
        float f6 = f5 * this.editPanel.getWidth();
        float f7 = f6 * 0.4f;
        float f8 = f + f5 * 0.5f;
        float f9 = 0.2f;
        MenuButton menuButton = new MenuButton("AddButton", "Add", f6, f7);
        this.editPanel.addWidget(menuButton, new Vector2f(f8, f9), true, true);
        rowLayoutArray[2].add(menuButton);
        menuButton.setEnabled(false);
        this.enabledWhenStripChosen.add(menuButton);
        menuButton.setMouseOverListener(new ToolTipOnMouseOver("Raise the selected parts of the track, hold SHIFT for finer precision (shortcut: + or UP arrow)", "This will be enabled when a selection is made", this.tipLabel));
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (!EditorState.this.isMultiSelect()) {
                    EditorState.this.changeTrackHeight(10);
                } else {
                    EditorState.this.changeTrackHeight(1);
                }
            }
        });
        menuButton = new MenuButton("SubButton", "Subtract", f6, f7);
        this.editPanel.addWidget(menuButton, new Vector2f(f8 += f5 + f2, f9), true, true);
        rowLayoutArray[2].add(menuButton);
        menuButton.setEnabled(false);
        this.enabledWhenStripChosen.add(menuButton);
        menuButton.setMouseOverListener(new ToolTipOnMouseOver("Lower the selected parts of the track, hold SHIFT for finer precision (shortcut: - or DOWN arrow)", "This will be enabled when a selection is made", this.tipLabel));
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (!EditorState.this.isMultiSelect()) {
                    EditorState.this.changeTrackHeight(-10);
                } else {
                    EditorState.this.changeTrackHeight(-1);
                }
            }
        });
        menuButton = new MenuButton("MultButton", "Multiply", f6, f7);
        this.editPanel.addWidget(menuButton, new Vector2f(f8 += f5 + f2, f9), true, true);
        rowLayoutArray[2].add(menuButton);
        menuButton.setEnabled(false);
        this.enabledWhenStripChosen.add(menuButton);
        menuButton.setMouseOverListener(new ToolTipOnMouseOver("Multiply the height of the selected parts of the track, hold SHIFT for finer precision (shortcut: *)", "This will be enabled when a selection is made", this.tipLabel));
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (!EditorState.this.isMultiSelect()) {
                    EditorState.this.changeTrackHeight(2.0f);
                } else {
                    EditorState.this.changeTrackHeight(1.25f);
                }
            }
        });
        menuButton = new MenuButton("DivButton", "Divide", f6, f7);
        this.editPanel.addWidget(menuButton, new Vector2f(f8 += f5 + f2, f9), true, true);
        rowLayoutArray[2].add(menuButton);
        menuButton.setEnabled(false);
        this.enabledWhenStripChosen.add(menuButton);
        menuButton.setMouseOverListener(new ToolTipOnMouseOver("Divide the height of the selected parts of the track, hold SHIFT for finer precision (shortcut: /)", "This will be enabled when a selection is made", this.tipLabel));
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (!EditorState.this.isMultiSelect()) {
                    EditorState.this.changeTrackHeight(0.5f);
                } else {
                    EditorState.this.changeTrackHeight(0.8f);
                }
            }
        });
        menuButton = new MenuButton("MirrorButton", "Mirror", f6, f7);
        this.editPanel.addWidget(menuButton, new Vector2f(f8 += f5 + f2, f9), true, true);
        rowLayoutArray[2].add(menuButton);
        menuButton.setEnabled(false);
        this.enabledWhen3StripsChosen.add(menuButton);
        menuButton.setMouseOverListener(new ToolTipOnMouseOver("Mirror the selection (shortcut: Ctrl+M)", "This will be enabled when multiple strips are selected", this.tipLabel));
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.mirror();
            }
        });
        f8 += f5 + f2;
        f8 = 0.2f;
        float f10 = 0.5f;
        int n2 = 0;
        for (IInterpolator object62 : this.interpolators) {
            object3 = new BorderPanel(object62.getName() + "Panel", (float)displaySystem.getWidth() * 0.9f, (float)displaySystem.getHeight() * 0.4f, this.gui, "corner", "edge", "combobox", 0.4f);
            ((BaseWidget)object3).getMover().setDamping(0.14f);
            this.editPanel.addWidget((BaseWidget)object3, new Vector2f(0.5f, 0.5f), true, true);
            this.widgetsToResize.add((IResizableWidget)object3);
            stringArray = new VariableRowLayout();
            stringArray.setRows(1.0f, 14.6f, 1.9f);
            stringArray.add(null);
            stringArray.setPadding(0.02f, 0.03f);
            ((Panel)object3).setLayout((ILayout)stringArray);
            iResizableWidget = new VariableColumnLayout();
            ((VariableColumnLayout)iResizableWidget).setColumns(1.0f, 7.0f, 1.0f);
            ((BaseLayout)iResizableWidget).setPadding(0.02f, 0.0f);
            stringArray.add(iResizableWidget);
            object2 = new ColumnLayout();
            ((BaseLayout)object2).setPadding(0.4f, 0.0f);
            ((BaseLayout)iResizableWidget).add((IResizableWidget)object2);
            VariableRowLayout n5 = new VariableRowLayout();
            n5.setPadding(0.0f, 0.0f);
            n5.setRows(7.5f, 0.5f, 2.0f);
            ((BaseLayout)iResizableWidget).add(n5);
            RowLayout i = new RowLayout();
            f11 = new ColumnLayout();
            f12 = new ColumnLayout();
            ((BaseLayout)f11).setPadding(0.2f, -0.05f);
            ((BaseLayout)f12).setPadding(0.2f, -0.05f);
            i.add((IResizableWidget)f11);
            i.add((IResizableWidget)f12);
            n5.add(i);
            object = new ColumnLayout();
            ((BaseLayout)object).setPadding(0.4f, 0.0f);
            ((BaseLayout)iResizableWidget).add((IResizableWidget)object);
            VariableColumnLayout variableColumnLayout2 = new VariableColumnLayout();
            variableColumnLayout2.setColumns(1.0f, 1.0f, 1.0f, 1.0f);
            variableColumnLayout2.setPadding(0.05f, 0.0f);
            variableColumnLayout2.add(null);
            n5.add(null);
            n5.add(variableColumnLayout2);
            this.childPanelPosition.set(((Spatial)object3).getLocalTranslation());
            this.tempVec.set(this.childPanelPosition).addLocal(panelHideVector);
            ((BaseWidget)object3).getMover().setPosition(this.tempVec);
            ((BaseWidget)object3).setOrder((int)((float)this.editPanel.getOrder() - 50.0f * f8), true);
            Label label = new Label(object62.getName() + "ToolTipLabel", "Adjust any parameters and click 'Apply'", ((Panel)object3).getWidth() * 0.9f, ((Panel)object3).getHeight() * 0.05f, "normal_small_black", null);
            label.setHorisontalAlignment(HorisontalAlignment.CENTERED);
            ((Panel)object3).addWidget(label, new Vector2f(0.5f, 0.07f), true, true);
            stringArray.add(label);
            menuButton = new MenuButton(object62.getName() + "Button", object62.getName(), 130.0f, 50.0f);
            this.editPanel.addWidget(menuButton, new Vector2f(f8, f10), true, true);
            rowLayoutArray[1].add(menuButton);
            int n3 = n2;
            menuButton.addListener(new IButtonClickedListener((Panel)object3, n3){
                final /* synthetic */ Panel val$panel;
                final /* synthetic */ int val$activateIndex;
                {
                    this.val$panel = panel;
                    this.val$activateIndex = n;
                }

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.showChildPanel(this.val$panel);
                    EditorState.this.activeInterpolator = this.val$activateIndex;
                    EditorState.this.updatePreview();
                }
            });
            menuButton.setMouseOverListener(new ToolTipOnMouseOver(object62.getTooltip(object62.getName()), this.tipLabel));
            String[] stringArray2 = object62.getParameters();
            int n4 = 0;
            final IInterpolator iInterpolator = object62;
            for (String string : stringArray2) {
                Slider slider = new Slider(object62.getName() + string + "Slider", 130.0f, 40.0f, "sliderknobnormal", "sliderknobover", "sliderline", null, null);
                Label label2 = new Label(object62.getName() + string + "Label", string, 130.0f, 50.0f);
                label2.setHorisontalAlignment(HorisontalAlignment.RIGHT);
                switch (n4) {
                    case 0: 
                    case 1: {
                        ((BaseLayout)f11).add(label2);
                        ((BaseLayout)f11).add(slider);
                        break;
                    }
                    case 2: 
                    case 3: {
                        ((BaseLayout)f12).add(label2);
                        ((BaseLayout)f12).add(slider);
                    }
                }
                ((Panel)object3).addWidget(label2);
                ((Panel)object3).addWidget(slider);
                final String string2 = string;
                slider.setValue(object62.getParameterValue(string));
                slider.setValueChangedListener(new IValueChangedListener(){

                    public void onValueChanged(Slider slider) {
                        iInterpolator.setParameterValue(string2, slider.getValue());
                        EditorState.this.updatePreview();
                    }
                });
                slider.setMouseOverListener(new ToolTipOnMouseOver(object62.getTooltip(string), label));
                ++n4;
            }
            Object object4 = new Slider(object62.getName() + "LeftSlider", 200.0f, 40.0f, "sliderknobnormal", "sliderknobover", "sliderline", null, null, true);
            ((Panel)object3).addWidget((BaseWidget)object4, new Vector2f(0.0f, 0.5f), true, true);
            ((BaseLayout)object2).add((IResizableWidget)object4);
            ((Slider)object4).setValueChangedListener(new IValueChangedListener(){

                public void onValueChanged(Slider slider) {
                    iInterpolator.setTakeHeightFromHeightMap(false);
                    iInterpolator.setLeftHeight(EditorState.this.minIntHeight + (int)((float)(EditorState.this.maxIntHeight - EditorState.this.minIntHeight) * slider.getValue()));
                    EditorState.this.updatePreview();
                }
            });
            ((BaseWidget)object4).setMouseOverListener(new ToolTipOnMouseOver("Changes the height of the left part of the selection", label));
            this.leftHeightSliders.add((Slider)object4);
            object4 = new Slider(object62.getName() + "RightSlider", 200.0f, 40.0f, "sliderknobnormal", "sliderknobover", "sliderline", null, null, true);
            ((Panel)object3).addWidget((BaseWidget)object4, new Vector2f(1.0f, 0.5f), true, true);
            ((BaseLayout)object).add((IResizableWidget)object4);
            ((Slider)object4).setValueChangedListener(new IValueChangedListener(){

                public void onValueChanged(Slider slider) {
                    iInterpolator.setTakeHeightFromHeightMap(false);
                    iInterpolator.setRightHeight(EditorState.this.minIntHeight + (int)((float)(EditorState.this.maxIntHeight - EditorState.this.minIntHeight) * slider.getValue()));
                    EditorState.this.updatePreview();
                }
            });
            ((BaseWidget)object4).setMouseOverListener(new ToolTipOnMouseOver("Changes the height of the right part of the selection", label));
            this.rightHeightSliders.add((Slider)object4);
            menuButton = new MenuButton(object62.getName() + "ApplyButton", "Apply", 130.0f, 50.0f);
            ((Panel)object3).addWidget(menuButton, new Vector2f(0.4f, 0.2f), true, true);
            variableColumnLayout2.add(menuButton);
            menuButton.addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.applyInterpolation();
                }
            });
            menuButton.setMouseOverListener(new ToolTipOnMouseOver("Apply the interpolation to the track", "This will be enabled when you choose more than two strips of the track (hold SHIFT)", label));
            menuButton.setEnabled(false);
            this.enabledWhen3StripsChosen.add(menuButton);
            menuButton = new MenuButton(object62.getName() + "CloseButton", "Close", 130.0f, 50.0f);
            ((Panel)object3).addWidget(menuButton, new Vector2f(0.6f, 0.2f), true, true);
            variableColumnLayout2.add(menuButton);
            menuButton.addListener(new IButtonClickedListener((Panel)object3){
                final /* synthetic */ Panel val$panel;
                {
                    this.val$panel = panel;
                }

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.hideChildPanel(this.val$panel);
                    EditorState.this.activeInterpolator = -1;
                    EditorState.this.updatePreview();
                }
            });
            menuButton.setMouseOverListener(new ToolTipOnMouseOver("Go back to main editor menu", label));
            stringArray.doLayout();
            f8 += 0.2f;
            ++n2;
        }
        this.specialPanel = new BorderPanel("SpecialPanel", (float)displaySystem.getWidth() * 0.9f, (float)displaySystem.getHeight() * 0.4f, this.gui, "corner", "edge", "combobox", 0.4f);
        this.specialPanel.getMover().setDamping(0.14f);
        this.editPanel.addWidget(this.specialPanel, new Vector2f(0.5f, 0.5f), true, true);
        this.widgetsToResize.add(this.specialPanel);
        this.tempVec.set(this.childPanelPosition).addLocal(panelHideVector);
        this.specialPanel.getMover().setPosition(this.tempVec);
        this.specialPanel.setOrder(this.editPanel.getOrder() - 350, true);
        menuButton = new MenuButton("SpecialButton", "Special", 130.0f, 50.0f);
        this.editPanel.addWidget(menuButton, new Vector2f(0.7f, 0.8f), true, true);
        baseLayout2.add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.showChildPanel(EditorState.this.specialPanel);
            }
        });
        menuButton.setMouseOverListener(new ToolTipOnMouseOver("Choose the special ability to race with", this.tipLabel));
        VariableRowLayout variableRowLayout3 = new VariableRowLayout();
        variableRowLayout3.setRows(1.0f, 3.2444446f, 3.2444446f, 1.6222223f, 3.2444446f, 3.2444446f, 1.9f);
        variableRowLayout3.setPadding(0.02f, 0.03f);
        this.specialPanel.setLayout(variableRowLayout3);
        Label label = new Label(this.getName() + "ToolTipLabel", "Choose special abilities to use when racing this track", 1.0f, 1.0f, "normal_small_black", null);
        variableRowLayout3.add(null);
        variableRowLayout3.add(null);
        RowLayout rowLayout = new RowLayout();
        variableRowLayout3.add(rowLayout);
        CheckBox checkBox = new CheckBox("turboCheckBox", 1.0f, 1.0f, "turbo charger", true, 0.15f);
        checkBox.setCheckedListener(new ICheckBoxChanged(){

            public void onCheckBoxChanged(CheckBox checkBox, boolean bl) {
                EditorState.this.gameState.changeTurbo(bl);
            }
        });
        if ("Demo".equals(this.getSettings().get("version", "Demo"))) {
            checkBox.setEnabled(false);
            checkBox.setMouseOverListener(new ToolTipOnMouseOver("", "Purchase the full version, to be able to use the Turbo Charger", label));
        }
        rowLayout.add(null);
        rowLayout.add(checkBox);
        if ("Demo".equals(this.getSettings().get("version", "Demo")) && Boolean.parseBoolean(this.settings.get("showBuyButtons", "false"))) {
            baseLayout4 = new BaseLayout();
            menuButton = new BuyMenuButton("webButton", "Get full version", 200.0f, 50.0f, 0.99200004f);
            object3 = new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.gui.focusWidget(null);
                    Game.buy("abilities");
                }
            };
            this.specialPanel.addWidget(menuButton, new Vector2f(0.5f, 0.5f), true, true);
            menuButton.addListener((IButtonClickedListener)object3);
            baseLayout4.add(menuButton);
            rowLayout.add(baseLayout4);
            menuButton.setMouseOverListener(new ToolTipOnMouseOver("Purchase the full version of Mad Skills Motocross, it only takes a couple of minutes", label));
        } else {
            rowLayout.add(null);
        }
        this.specialPanel.addWidget(checkBox);
        variableRowLayout3.add(null);
        object3 = new RowLayout();
        ((BaseLayout)object3).setPadding(0.03f, 0.05f);
        variableRowLayout3.add((IResizableWidget)object3);
        stringArray = new String[]{"jumper", "nitro", "glider", "jetpack", "none"};
        object2 = stringArray;
        int filePanel = ((String[])object2).length;
        for (int label3 = 0; label3 < filePanel; ++label3) {
            f12 = f11 = object2[label3];
            object = ((String)f11).substring(0, 1).toUpperCase() + ((String)f11).substring(1, ((String)f11).length());
            iResizableWidget = new MenuButton("abilityButton", (String)object, 1.0f, 1.0f);
            this.specialPanel.addWidget((BaseWidget)((Object)iResizableWidget));
            ((BaseLayout)object3).add(iResizableWidget);
            ((MenuButton)iResizableWidget).addListener(new IButtonClickedListener((String)f12){
                final /* synthetic */ String val$fability;
                {
                    this.val$fability = string;
                }

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.gameState.changeSpecialAbility(this.val$fability);
                    EditorState.this.hideChildPanel(EditorState.this.specialPanel);
                }
            });
            if (!"Demo".equals(this.getSettings().get("version", "Demo")) || f11 == "jumper" || f11 == "none") continue;
            ((BaseWidget)((Object)iResizableWidget)).setEnabled(false);
            ((BaseWidget)((Object)iResizableWidget)).setMouseOverListener(new ToolTipOnMouseOver("", "Purchase the full version, to be able to use the " + (String)f11, label));
        }
        variableRowLayout3.add(null);
        label.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        this.specialPanel.addWidget(label, new Vector2f(0.5f, 0.07f), true, true);
        variableRowLayout3.add(label);
        this.specialPanel.doLayout();
        this.specialPanel.disableTemporarily();
        if (this.challenges != null && this.challenges.length > 0) {
            this.challengesPanel = new ChallengesPanel(displaySystem, this.gui);
            this.challengesPanel.getMover().setDamping(0.14f);
            this.editPanel.addWidget(this.challengesPanel, new Vector2f(0.5f, 0.5f), true, true);
            this.widgetsToResize.add(this.challengesPanel);
            this.tempVec.set(this.childPanelPosition).addLocal(panelHideVector);
            this.challengesPanel.getMover().setPosition(this.tempVec);
            this.challengesPanel.setOrder(this.editPanel.getOrder() - 350, true);
            menuButton = new MenuButton("ChallengesButton", "Challenges", 130.0f, 50.0f);
            this.editPanel.addWidget(menuButton, new Vector2f(0.7f, 0.8f), true, true);
            baseLayout.add(menuButton);
            menuButton.addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.showChildPanel(EditorState.this.challengesPanel);
                    EditorState.this.challengesPanel.fillLists(EditorState.this.track, EditorState.this.challenges);
                }
            });
            menuButton.setMouseOverListener(new ToolTipOnMouseOver("Attach challenges to your track", this.tipLabel));
            this.challengesPanel.getCloseButton().addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.hideChildPanel(EditorState.this.challengesPanel);
                    EditorState.this.track.setChallenges(EditorState.this.challengesPanel.getChosenChallenges());
                }
            });
            this.challengesPanel.getEditButton().addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    IChallenge iChallenge = EditorState.this.challengesPanel.getSelectedChosenChallenge();
                    if (iChallenge == null) {
                        return;
                    }
                    final ChallengePanel challengePanel = new ChallengePanel(displaySystem, EditorState.this.gui, iChallenge);
                    EditorState.this.editPanel.addWidget(challengePanel, new Vector2f(0.5f, 0.5f), true, true);
                    challengePanel.getMover().setDamping(0.14f);
                    challengePanel.setOrder(EditorState.this.editPanel.getOrder() - 500, true);
                    challengePanel.getMover().setPosition(EditorState.this.tempVec.set(EditorState.this.childPanelPosition).addLocal(panelHideVector));
                    challengePanel.getApplyButton().addListener(new IButtonClickedListener(){

                        public void onClick(MenuButton menuButton, Vector3f vector3f) {
                            EditorState.this.hideAndRemoveChildPanel(challengePanel);
                        }
                    });
                    challengePanel.getCancelButton().addListener(new IButtonClickedListener(){

                        public void onClick(MenuButton menuButton, Vector3f vector3f) {
                            EditorState.this.hideAndRemoveChildPanel(challengePanel);
                        }
                    });
                    EditorState.this.showChildPanel(challengePanel);
                }
            });
        }
        object2 = new MenuButton("boostArrowButton", "Boost", 1.0f, 1.0f);
        this.editPanel.addWidget((BaseWidget)object2);
        baseLayout3.add((IResizableWidget)object2);
        ((MenuButton)object2).addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.makeBoostArrow();
            }
        });
        ((BaseWidget)object2).setMouseOverListener(new ToolTipOnMouseOver("Make a boost arrow on the marked strips", "Boost arrows will be enabled when you choose multiple strips of the track", this.tipLabel));
        ((BaseWidget)object2).setEnabled(false);
        this.enabledWhenStripChosen.add((MenuButton)object2);
        final FilePanel filePanel2 = new FilePanel(this.getName() + ":FilePanel", (float)displaySystem.getWidth() * 0.9f, (float)displaySystem.getHeight() * 0.4f, this.gui, "corner", "edge", "combobox", 0.4f);
        this.editPanel.addWidget(filePanel2, new Vector2f(), true, true);
        this.widgetsToResize.add(filePanel2);
        filePanel2.setSuffix("msmtrack");
        filePanel2.getMover().setDamping(0.14f);
        filePanel2.setOrder((int)((float)this.editPanel.getOrder() - 50.0f * f8), true);
        filePanel2.getMover().setPosition(this.tempVec.set(this.childPanelPosition).addLocal(panelHideVector));
        filePanel2.setDirectory(new File(SystemFolder.getUserCreatedContentFolder("tracks")));
        filePanel2.addForbiddenFilename("autosave");
        this.autoSaveFile = new File(SystemFolder.getUserCreatedContentFolder("tracks"), "autosave.msmtrack");
        Label label3 = filePanel2.getFileTipLabel();
        menuButton = new MenuButton("SaveButton", "Save", 130.0f, 50.0f);
        this.editPanel.addWidget(menuButton, new Vector2f(0.7f, 0.8f), true, true);
        rowLayoutArray[0].add(menuButton);
        menuButton.addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.showChildPanel(filePanel2);
                filePanel2.setInSavingMode();
            }
        });
        menuButton.setMouseOverListener(new ToolTipOnMouseOver("Save your track", this.tipLabel));
        menuButton = new MenuButton("LoadButton", "Load", 130.0f, 50.0f);
        this.editPanel.addWidget(menuButton, new Vector2f(0.9f, 0.8f), true, true);
        rowLayoutArray[0].add(menuButton);
        if ("Demo".equals(this.getSettings().get("version", "Demo"))) {
            menuButton.setMouseOverListener(new ToolTipOnMouseOver("Buy the game, and you will be able to load your saved tracks", this.tipLabel));
        } else {
            menuButton.addListener(new IButtonClickedListener(){

                public void onClick(MenuButton menuButton, Vector3f vector3f) {
                    EditorState.this.showChildPanel(filePanel2);
                    filePanel2.setInLoadingMode();
                }
            });
            menuButton.setMouseOverListener(new ToolTipOnMouseOver("Load a track", this.tipLabel));
        }
        filePanel2.setCancelListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.hideChildPanel(filePanel2);
            }
        });
        filePanel2.setSaveListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                EditorState.this.save(filePanel2.getSelectedFile());
                EditorState.this.tipLabel.setText("Saved " + filePanel2.getSelectedFile());
                EditorState.this.hideChildPanel(filePanel2);
            }
        });
        filePanel2.setLoadListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                if (filePanel2.getSelectedFile() == null) {
                    return;
                }
                EditorState.this.load(filePanel2.getSelectedFile());
                EditorState.this.tipLabel.setText("Loaded " + filePanel2.getSelectedFile());
                EditorState.this.hideChildPanel(filePanel2);
            }
        });
        filePanel2.getLoadButton().setMouseOverListener(new ToolTipOnMouseOver("Load the selected track", "Choose a track to load first", label3));
        filePanel2.getSaveButton().setMouseOverListener(new ToolTipOnMouseOver("Save the track (will overwrite existing files)", "Enter a valid file name first", label3));
        filePanel2.getFilenameTextField().setMouseOverListener(new ToolTipOnMouseOver("Enter the file name you would like to save the track as", label3));
        filePanel2.getCancelButton().setMouseOverListener(new ToolTipOnMouseOver("Cancel", label3));
        this.filePanel = filePanel2;
        float f13 = 0.05f;
        float f14 = (float)DisplaySystem.getDisplaySystem().getHeight() * f13;
        this.miniMap = new MiniMap("MiniMap", (float)DisplaySystem.getDisplaySystem().getWidth() * 0.96f, f14, 512);
        this.gui.addWidget(this.miniMap, new Vector2f(0.5f, f13 * 0.5f), true, true);
        this.miniMapPosition.set(this.miniMap.getLocalTranslation());
        this.miniMapHideVector.set(0.0f, -f14 * 1.5f, 0.0f);
        this.tempVec.set(this.miniMapPosition).addLocal(this.miniMapHideVector);
        this.miniMap.getMover().setPosition(this.tempVec);
        this.cameraMarker = new Rectangle("CameraMarker", 1.0f, this.miniMap.getHeight(), new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.cameraMarker.getFader().initRenderStates();
        this.cameraMarker.getFader().setColor(1.0f, 1.0f, 1.0f, 0.3f);
        this.miniMap.addLayer(this.cameraMarker);
        this.miniMap.setLeftMouseDownListener(new ILeftMouseDownListener(){

            public void onLeftMouseDown(BaseWidget baseWidget, Vector3f vector3f) {
                if (!EditorState.this.inEdit) {
                    return;
                }
                baseWidget.getSpatial().worldToLocal(vector3f, EditorState.this.tempVec);
                float f = (((EditorState)EditorState.this).tempVec.x + EditorState.this.miniMap.getWidth() * 0.5f) / EditorState.this.miniMap.getWidth();
                DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
                float f2 = (float)displaySystem.getWidth() / (float)displaySystem.getHeight();
                float f3 = 20.0f;
                ((EditorState)EditorState.this).mouseCameraFollower.getLocalTranslation().x = EditorState.this.track.getOriginalLength() * f - f2 * f3 * 0.5f;
            }
        });
        this.bikeMarker = new Image("BikeMarkerImage", "bike-thumb", -1.0f);
        this.bikeMarker.getMover().setDamping(bikeMarkerMoveDamping);
        this.bikeMarker.getMover().setPosition(-this.miniMap.getWidth() * 0.5f, 0.0f, 0.0f);
        this.miniMap.addLayer(this.bikeMarker);
        this.miniMap.setRightMouseDownListener(new IRightMouseDownListener(){

            public void onRightMouseDown(BaseWidget baseWidget, Vector3f vector3f) {
                baseWidget.getSpatial().worldToLocal(vector3f, EditorState.this.tempVec);
                float f = (((EditorState)EditorState.this).tempVec.x + EditorState.this.miniMap.getWidth() * 0.5f) / EditorState.this.miniMap.getWidth();
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 0.98f) {
                    f = 0.98f;
                }
                ((EditorState)EditorState.this).tempVec.set((Vector3f)((EditorState)EditorState.this).bikeMarker.getLocalTranslation()).x = f * EditorState.this.miniMap.getWidth() - EditorState.this.miniMap.getWidth() * 0.5f;
                EditorState.this.bikeMarker.getMover().translateTo(EditorState.this.tempVec, bikeMarkerMoveTime, bikeMarkerMoveTime);
            }
        });
        this.widgetsToResize.add(this.miniMap);
        this.widgetsToResize.add(this.cameraMarker);
        this.widgetsToResize.add(this.bikeMarker);
        object = new PlayEditButtonListener(this.editButton, this.playButton);
        this.editButton.addListener((IButtonClickedListener)object);
        this.playButton.addListener((IButtonClickedListener)object);
        this.getRootNode().attachChild(this.gui.getNode());
        this.playButton.setMouseOverListener(new ToolTipOnMouseOver("Click 'Play' to instantly try your track", this.tipLabel));
        this.miniMap.setMouseOverListener(new ToolTipOnMouseOver("Minimap: Left mouse button = move camera, right mouse button = where to start when \"Play\" is pressed", this.tipLabel));
        variableRowLayout.doLayout();
    }

    public void hideChildPanel(Panel panel) {
        panel.disableTemporarily();
        this.tempVec.set(this.childPanelPosition).addLocal(panelHideVector);
        panel.getMover().clearListeners();
        panel.getMover().translateTo(this.tempVec, editPanelMoveTime, editPanelRemoveTime);
        panel.getMover().add(this.detachWhenDone);
    }

    public void hideAndRemoveChildPanel(Panel panel) {
        panel.disableTemporarily();
        this.tempVec.set(this.childPanelPosition).addLocal(panelHideVector);
        panel.getMover().clearListeners();
        panel.getMover().translateTo(this.tempVec, editPanelMoveTime, editPanelRemoveTime);
        panel.getMover().add(new RemoveWidgetFromEditPanelWhenDone(panel));
    }

    public void showChildPanel(Panel panel) {
        this.editPanel.attachChild(panel.getSpatial());
        panel.enableFromTemporaryDisable();
        panel.getMover().clearListeners();
        panel.getMover().translateTo(this.childPanelPosition, editPanelMoveTime, editPanelRemoveTime);
    }

    protected boolean initGL() {
        return false;
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("DisplayModeChanged") || receivedEvent.is("DisplayChangeReverted") || receivedEvent.is("DisplayChangeFailed")) {
            this.displayModeChanged();
        }
    }

    public void passedStartline() {
        this.gameState.setRaceTime(0.0f);
    }

    public void passedFinishline() {
        int n;
        Object object;
        if (this.isActive()) {
            object = this.gameState.getBikes();
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                BikeGameObject bikeGameObject = (BikeGameObject)((ArrayList)object).get(n);
                if (bikeGameObject == null) continue;
                bikeGameObject.getChallengeMonitorComponent().stopMonitoring();
                bikeGameObject.stopEngine();
            }
            this.setInEdit(true);
            this.setInEdit(false);
            this.setInEdit(true);
        }
        if ((n = ((String)(object = Float.toString(this.gameState.getRaceTime()))).indexOf(46)) > 0) {
            int n2 = n + 3;
            if (((String)object).length() > n2) {
                object = ((String)object).substring(0, n2);
            }
        }
        this.showText("Finish time: " + (String)object);
    }

    private void displayModeChanged() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        float f = (float)displaySystem.getWidth() / (float)this.previousScreenWidth;
        float f2 = (float)displaySystem.getHeight() / (float)this.previousScreenHeight;
        Vector2f vector2f = new Vector2f(f, f2);
        Vector3f vector3f = new Vector3f(f, f2, 1.0f);
        for (int i = 0; i < this.widgetsToResize.size(); ++i) {
            IResizableWidget iResizableWidget = this.widgetsToResize.get(i);
            iResizableWidget.setSize(iResizableWidget.getWidth() * f, iResizableWidget.getHeight() * f2);
            iResizableWidget.setPosition(iResizableWidget.getPosition().multLocal(vector2f));
        }
        this.gui.setMouseLimit(new Vector2f(displaySystem.getWidth(), displaySystem.getHeight()));
        this.childPanelPosition.multLocal(vector3f);
        panelHideVector.multLocal(vector3f);
        this.editPanelPosition.multLocal(vector3f);
        this.playPanelPosition.multLocal(vector3f);
        this.playButtonPosition.multLocal(vector3f);
        this.miniMapPosition.multLocal(vector3f);
        this.miniMapHideVector.multLocal(vector3f);
        buttonHideVector.multLocal(vector3f);
        this.previousScreenWidth = displaySystem.getWidth();
        this.previousScreenHeight = displaySystem.getHeight();
    }

    private void save(File file) {
        Object object;
        File file2 = new File(file.getPath());
        if (file.exists()) {
            object = new File(file.getPath() + ".BAK");
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            file.renameTo((File)object);
        }
        try {
            file2.createNewFile();
            object = BinaryExporter.getInstance();
            ((BinaryExporter)object).save((Savable)this.track, file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void load(File file) {
        try {
            Properties properties = new Properties();
            properties.put("putInCache", "false");
            properties.put("lookInCache", "false");
            Track1D track1D = (Track1D)ResourceManager.getInstance().load("track1D", file.toURL(), properties);
            this.track.setChallenges(track1D.getChallenges());
            this.track.reconstruct(track1D.getOriginalHeightMap(), track1D.getOriginalFeatureMap());
            this.track.reconstructCollisionStructure();
            this.gameState.constructFinishline();
            this.gameState.setStartlineEnabled(true);
            this.updateHighlightHeights();
            this.updateAfterSelection();
            this.updateMiniMap();
            this.updateButtons();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.lengthLabel.setText("Track length: " + this.track.getOriginalHeightMap().getXsize());
    }

    protected void stateUpdate(float f) {
        float f2;
        float f3;
        if (f > 0.016666668f) {
            f = 0.016666668f;
        }
        this.tpf = f;
        this.input.update(f);
        if (this.inEdit) {
            if (this.gameStateCameraNode != null) {
                this.gameStateCameraNode.updateGeometricState(f, true);
            }
            if (this.mouseCameraFollower != null) {
                double d;
                if (this.scrolling > 0.0f && this.mouseCameraFollower.getLocalTranslation().x > (double)this.track.getOriginalLength()) {
                    this.scrolling = 0.0f;
                }
                if (this.scrolling < 0.0f && this.mouseCameraFollower.getLocalTranslation().x < 0.0) {
                    this.scrolling = 0.0f;
                }
                this.mouseCameraFollower.getLocalTranslation().addLocal(this.scrolling * f, 0.0, 0.0);
                DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
                f3 = (float)displaySystem.getWidth() / (float)displaySystem.getHeight();
                f2 = 20.0f;
                float f4 = f3 * f2;
                double d2 = 0.0;
                int n = 0;
                n = this.mouseOverColumn < 0 || Math.abs(this.scrolling) > Float.MIN_VALUE ? this.track.getColumn(this.mouseCameraFollower.getLocalTranslation().x + (double)f4 + (double)(this.track.getStepScale().x * 0.5f)) : this.mouseOverColumn;
                this.mouseCameraFollower.getLocalTranslation().y = d = this.track.getHeightAt(n) + 5.0;
            }
        }
        if (this.cameraMarker != null && this.gameStateCameraNode != null) {
            float f5 = this.track.getOriginalLength();
            f3 = this.gameStateCameraNode.getWorldTranslation().x / f5;
            f2 = f3 * this.miniMap.getWidth() - this.miniMap.getWidth() * 0.5f - this.cameraMarker.getWidth() * 0.5f;
            this.tempVec.set(this.cameraMarker.getLocalTranslation());
            this.tempVec.x = f2;
            this.cameraMarker.getMover().setPosition(this.tempVec);
        }
        super.stateUpdate(f);
    }

    protected void onActivate() throws IOException {
        if (this.autoSaveFile.exists()) {
            this.track = this.gameState.getTrack();
            String[][] stringArray = new String[][]{{"startsequence", "startline", "finishline", "numberOfBikes", "bike0", "cameraFollowBikeNumber", "controlMode"}, {"false", "true", "true", "1", "human", "0", Profile.getCurrentProfile(this.getSettings()).getDifficulty().getName()}};
            this.gameState.prepareNewRace(Utils.getProperties(stringArray));
            this.load(this.autoSaveFile);
        } else {
            String[][] stringArray = new String[][]{{"track", "startsequence", "startline", "finishline", "numberOfBikes", "bike0", "cameraFollowBikeNumber", "controlMode"}, {"empty", "false", "true", "true", "1", "human", "0", Profile.getCurrentProfile(this.getSettings()).getDifficulty().getName()}};
            this.gameState.prepareNewRace(Utils.getProperties(stringArray));
            this.track = this.gameState.getTrack();
            this.reconstruct(this.track.getOriginalHeightMap());
            this.track.reconstructCollisionStructure();
            this.updateMiniMap();
        }
        this.gameStateCameraNode = this.gameState.getCameraNode();
        this.cameraSpeed = this.gameState.getCameraNode().getCameraSpeed();
        this.cameraSlackMin = this.gameState.getCameraNode().getCameraSlackMin();
        this.cameraSlackMax = this.gameState.getCameraNode().getCameraSlackMax();
        this.gui.setPaused(false);
        this.updateButtons();
        this.setInEdit(true);
    }

    protected void onDeactivate() {
        this.gui.setPaused(true);
        this.setInEdit(false);
    }

    private int getSelectionStart() {
        if (this.selected.isEmpty()) {
            return 0;
        }
        Object[] objectArray = new Integer[this.selected.size()];
        objectArray = this.selected.toArray(objectArray);
        Arrays.sort(objectArray);
        return (Integer)objectArray[0];
    }

    private int getSelectionEnd() {
        if (this.selected.isEmpty()) {
            return 0;
        }
        Object[] objectArray = new Integer[this.selected.size()];
        objectArray = this.selected.toArray(objectArray);
        Arrays.sort(objectArray);
        return (Integer)objectArray[objectArray.length - 1];
    }

    private int[] getSelectedColumnHeights() {
        if (this.selected.isEmpty()) {
            return new int[]{0};
        }
        int[] nArray = new int[this.selected.size()];
        Object[] objectArray = new Integer[this.selected.size()];
        objectArray = this.selected.toArray(objectArray);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            ImageHeightMap imageHeightMap = this.track.getOriginalHeightMap();
            int n = this.track.getOriginalHeightMapStartsAt();
            int n2 = (Integer)objectArray[i];
            nArray[i] = (n2 -= this.track.getOriginalHeightMapStartsAt()) >= 0 && n2 < imageHeightMap.getXsize() ? imageHeightMap.getTrueHeightAtPoint(n2, 0) : 0;
        }
        return nArray;
    }

    private void prepareForChange() {
        this.saveUndoData();
        this.extendTrackToSelection();
    }

    private void reconstruct(ImageHeightMap imageHeightMap) {
        int[] nArray = imageHeightMap.getHeightMap();
        if (nArray.length <= 0) {
            nArray = new int[2];
            imageHeightMap = new ImageHeightMap();
            imageHeightMap.setHeightData(nArray, nArray.length, this.track.getOriginalHeightMap().getYsize());
        }
        imageHeightMap.setHeightAtPoint(0, 0, 0);
        this.track.reconstruct(imageHeightMap, this.track.getOriginalFeatureMap());
        this.gameState.constructFinishline();
        this.gameState.setStartlineEnabled(true);
        this.updateHighlightHeights();
        this.updateAfterSelection();
        this.updateMiniMap();
    }

    public void makeBoostArrow() {
        int n;
        int n2;
        if (!this.inEdit) {
            return;
        }
        if (this.selected.size() < 1) {
            return;
        }
        this.prepareForChange();
        ImageHeightMap imageHeightMap = this.track.getOriginalFeatureMap();
        int n3 = 0;
        for (n2 = 0; n2 < this.selected.size(); ++n2) {
            n = this.selected.get(n2);
            if ((n -= this.track.getOriginalHeightMapStartsAt()) < 0) continue;
            n3 += imageHeightMap.getTrueHeightAtPoint(n, 0);
        }
        n2 = (n3 /= this.selected.size()) > 128 ? 0 : 255;
        for (n = 0; n < this.selected.size(); ++n) {
            int n4 = this.selected.get(n);
            if ((n4 -= this.track.getOriginalHeightMapStartsAt()) < 0) continue;
            imageHeightMap.setHeightAtPoint(n2, n4, 0);
        }
        this.reconstruct(this.track.getOriginalHeightMap());
    }

    public void changeTrackHeight(int n) {
        if (!this.inEdit) {
            return;
        }
        boolean bl = false;
        this.prepareForChange();
        ImageHeightMap imageHeightMap = this.track.getOriginalHeightMap();
        for (int i = 0; i < this.selected.size(); ++i) {
            int n2;
            int n3;
            int n4 = this.selected.get(i);
            if ((n4 -= this.track.getOriginalHeightMapStartsAt()) < 0 || (n3 = this.clampHeight((n2 = imageHeightMap.getTrueHeightAtPoint(n4, 0)) + n)) == n2) continue;
            imageHeightMap.setHeightAtPoint(n3, n4, 0);
            bl = true;
        }
        if (bl) {
            this.reconstruct(imageHeightMap);
        }
        this.setDisregardHeightsliders(true);
    }

    public double clampHeight(double d) {
        if (d < this.getMinHeight()) {
            return this.getMinHeight();
        }
        if (d > this.getMaxHeight()) {
            return this.getMaxHeight();
        }
        return d;
    }

    public int clampHeight(int n) {
        return (int)(this.clampHeight((float)n * this.track.getStepScale().y) / (double)this.track.getStepScale().y);
    }

    public void changeTrackHeight(float f) {
        if (!this.inEdit) {
            return;
        }
        boolean bl = false;
        this.prepareForChange();
        ImageHeightMap imageHeightMap = this.track.getOriginalHeightMap();
        for (int i = 0; i < this.selected.size(); ++i) {
            int n;
            int n2;
            int n3 = this.selected.get(i);
            if ((n3 -= this.track.getOriginalHeightMapStartsAt()) < 0 || (n2 = this.clampHeight((int)((float)(n = imageHeightMap.getTrueHeightAtPoint(n3, 0)) * f))) == n) continue;
            imageHeightMap.setHeightAtPoint(n2, n3, 0);
            bl = true;
        }
        if (bl) {
            this.reconstruct(imageHeightMap);
        }
        this.setDisregardHeightsliders(true);
    }

    public void updateHighlightHeights() {
        if (!this.inEdit) {
            return;
        }
        this.selectedNode.detachAllChildren();
        this.selectedHighlights.clear();
        ArrayList arrayList = (ArrayList)this.selected.clone();
        this.selected.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.selectColumn((Integer)arrayList.get(i));
        }
        if (this.highlightNode.hasChild(this.mouseOverHighlight)) {
            this.mouseOverTrackAtWorldPos(this.latestMouseOverXPos);
        }
    }

    public void updateHeightSliders() {
        int n;
        if (this.selected.size() < 1) {
            return;
        }
        int[] nArray = this.getSelectedColumnHeights();
        int n2 = nArray[0];
        int n3 = nArray[nArray.length - 1];
        nArray = null;
        for (n = 0; n < this.leftHeightSliders.size(); ++n) {
            this.leftHeightSliders.get(n).setValue((float)(n2 - this.minIntHeight) / (float)(this.maxIntHeight - this.minIntHeight));
        }
        for (n = 0; n < this.rightHeightSliders.size(); ++n) {
            this.rightHeightSliders.get(n).setValue((float)(n3 - this.minIntHeight) / (float)(this.maxIntHeight - this.minIntHeight));
        }
    }

    public void setDisregardHeightsliders(boolean bl) {
        for (int i = 0; i < this.interpolators.length; ++i) {
            this.interpolators[i].setTakeHeightFromHeightMap(bl);
        }
        this.updateHeightSliders();
    }

    public void updatePreview() {
        if (this.selected.size() < 3 || this.activeInterpolator < 0 || !this.inEdit) {
            this.updatePreview(new int[0], 0);
        } else {
            IInterpolator iInterpolator = this.interpolators[this.activeInterpolator];
            this.updatePreview(iInterpolator.interpolate(this.getSelectedColumnHeights()), this.getSelectionStart());
        }
    }

    public void updatePreview(int[] nArray, int n) {
        if (!this.inEdit) {
            return;
        }
        this.previewNode.detachAllChildren();
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(nArray.length);
        floatBuffer.clear();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            double d = (float)n2 * this.track.getStepScale().y;
            Highlight highlight = null;
            if (d < this.getMinHeight() || d > this.getMaxHeight()) {
                this.tempVec = new Vector3f((float)this.track.getXPosition(n + i), (float)d + 0.1f, this.track.getActualWidth() * 0.5f);
                highlight = new Highlight(0.2f, this.track.getActualWidth() * 0.7f);
                highlight.getFader().setColor(previewNotValidColor);
                highlight.getMover().setPosition(this.tempVec);
                this.previewNode.attachChild(highlight);
                d = this.clampHeight(d);
            }
            this.tempVec = new Vector3f((float)this.track.getXPosition(n + i), (float)d + 0.1f, this.track.getActualWidth() * 0.5f);
            highlight = new Highlight(0.2f, this.track.getActualWidth() * 0.7f);
            highlight.getFader().setColor(previewColor);
            highlight.getMover().setPosition(this.tempVec);
            this.previewNode.attachChild(highlight);
            this.tempVec.z = this.track.getActualWidth() * 0.85f;
            BufferUtils.setInBuffer(this.tempVec, floatBuffer, i);
        }
        if (nArray.length > 2) {
            Line line = new Line("previewLineNear", floatBuffer, null, null, null);
            line.setDefaultColor(previewColor);
            line.setMode(1);
            line.setAntialiased(true);
            line.setLineWidth(2.0f);
            this.previewNode.attachChild(line);
            line = new Line("previewLineFar", floatBuffer, null, null, null);
            line.setDefaultColor(previewColor);
            line.setMode(1);
            line.setAntialiased(true);
            line.setLineWidth(2.0f);
            line.setLocalTranslation(0.0f, 0.0f, -this.track.getActualWidth() * 0.7f);
            this.previewNode.attachChild(line);
        }
    }

    public void applyInterpolation() {
        if (!this.inEdit) {
            return;
        }
        if (this.selected.size() < 3 || this.activeInterpolator < 0) {
            return;
        }
        this.prepareForChange();
        IInterpolator iInterpolator = this.interpolators[this.activeInterpolator];
        int[] nArray = iInterpolator.interpolate(this.getSelectedColumnHeights());
        int n = this.getSelectionStart();
        ImageHeightMap imageHeightMap = this.track.getOriginalHeightMap();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = n + i;
            if ((n2 -= this.track.getOriginalHeightMapStartsAt()) < 0 || n2 >= imageHeightMap.getXsize()) continue;
            imageHeightMap.setHeightAtPoint(this.clampHeight(nArray[i]), n2, 0);
        }
        this.reconstruct(imageHeightMap);
    }

    public void mouseOverTrackAtWorldPos(double d) {
        if (!this.inEdit) {
            return;
        }
        this.latestMouseOverXPos = d;
        int n = this.track.getColumn(d + (double)(this.track.getStepScale().x * 0.5f));
        if (n < 0) {
            this.removeMouseOver();
            return;
        }
        double d2 = this.track.getHeightAt(n);
        this.tempVec = new Vector3f((float)this.track.getXPosition(n), (float)d2 + 0.1f, this.track.getActualWidth() * 0.5f);
        this.mouseOverColumn = n;
        if (this.mouseOverHighlight == null) {
            this.mouseOverHighlight = new Highlight(0.3f, this.track.getActualWidth() * 0.7f);
            this.mouseOverHighlight.getFader().fadeTo(mouseOverColor, fadeTime);
            this.mouseOverHighlight.getMover().setPosition(this.tempVec);
            this.highlightNode.attachChild(this.mouseOverHighlight);
        } else if (!this.highlightNode.hasChild(this.mouseOverHighlight)) {
            this.highlightNode.attachChild(this.mouseOverHighlight);
            this.mouseOverHighlight.getMover().setPosition(this.tempVec);
            this.heightLabel.getFader().fadeTo(fullAlphaColor, fadeTime);
            this.tempVec.y += 0.2f;
            this.tempVec.z = 0.0f;
            this.heightLabel.getMover().setPosition(this.tempVec);
        } else if (moveTime < 0.0f) {
            this.mouseOverHighlight.getMover().setPosition(this.tempVec);
            this.tempVec.y += 0.2f;
            this.tempVec.z = 0.0f;
            this.heightLabel.getMover().setPosition(this.tempVec);
        } else {
            this.mouseOverHighlight.getMover().translateTo(this.tempVec, moveTime, moveTime);
            this.tempVec.y += 0.2f;
            this.tempVec.z = 0.0f;
            this.heightLabel.getMover().translateTo(this.tempVec, moveTime * 1.8f, moveTime * 1.8f);
        }
        this.heightLabel.setText(String.valueOf((int)(d2 * 10.0)));
    }

    public void removeMouseOver() {
        if (!this.inEdit) {
            return;
        }
        if (this.mouseOverHighlight != null) {
            this.highlightNode.detachChild(this.mouseOverHighlight);
            this.heightLabel.getFader().fadeTo(noAlphaColor, fadeTime);
        }
        this.mouseOverColumn = -1;
    }

    public void removeSelection() {
        ArrayList arrayList = (ArrayList)this.selected.clone();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.unselectColumn((Integer)arrayList.get(i));
        }
        this.tipLabel.setText("Choose a strip of the track by clicking with the left mouse button. Choose multiple by holding SHIFT.");
    }

    public void startSelectAtWorldPos(double d, boolean bl) {
        if (!this.inEdit) {
            return;
        }
        if (this.columnWhereSelectStarted < 0) {
            this.columnWhereSelectStarted = this.track.getColumn(d + (double)(this.track.getStepScale().x * 0.5f));
            if (this.columnWhereSelectStarted < 0) {
                return;
            }
            this.selectTrackAtWorldPos(d, bl);
        } else {
            this.selectTrackAtWorldPos(d, true);
        }
    }

    public void endSelectAtWorldPos(double d, boolean bl) {
        this.selectTrackAtWorldPos(d, true);
        this.columnWhereSelectStarted = -1;
    }

    public void selectTrackAtWorldPos(double d, boolean bl) {
        if (!this.inEdit) {
            return;
        }
        int n = this.track.getColumn(d + (double)(this.track.getStepScale().x * 0.5f));
        if (n < 0) {
            this.removeSelection();
            return;
        }
        if (!bl) {
            this.removeSelection();
            this.selectColumn(n);
        } else if (this.latestSelected != n || this.selected.isEmpty()) {
            if (this.latestSelected < 0 || this.selected.isEmpty()) {
                this.selectColumn(n);
            } else {
                int n2 = this.latestSelected;
                if (n2 < n) {
                    for (int i = n2 + 1; i <= n; ++i) {
                        this.selectColumn(i);
                    }
                } else {
                    for (int i = n; i < n2; ++i) {
                        this.selectColumn(i);
                    }
                }
            }
        }
        this.tipLabel.setText("Use arrow keys UP and DOWN to raise and lower the ground, hold SHIFT for greater precision");
        this.setDisregardHeightsliders(true);
    }

    private void extendTrack(int n) {
        int n2 = n - (this.track.getOriginalHeightMap().getXsize() + this.track.getOriginalHeightMapStartsAt());
        if (n2 > 0) {
            int[] nArray = new int[n2];
            Arrays.fill(nArray, 0);
            this.appendData(nArray);
        }
    }

    private void extendTrackToSelection() {
        if (!this.selected.isEmpty()) {
            this.extendTrack(this.getSelectionEnd() + 2);
        }
    }

    private void toggleSelected(int n) {
        if (!this.inEdit) {
            return;
        }
        if (!this.isSelected(n)) {
            this.selectColumn(n);
        } else {
            this.unselectColumn(n);
        }
    }

    private boolean isSelected(int n) {
        return this.selected.contains(n);
    }

    private void unselectColumn(int n) {
        if (!this.inEdit) {
            return;
        }
        int n2 = this.selected.indexOf(n);
        if (n2 < 0) {
            return;
        }
        Highlight highlight = (Highlight)this.selectedHighlights.get(n2);
        highlight.getFader().fadeTo(noAlphaColor, fadeTime);
        highlight.getFader().add(this.fadeAndRemove);
        this.selectedHighlights.remove(n2);
        this.selected.remove(n2);
        if (this.isSelected(n - 1)) {
            this.latestSelected = n - 1;
        } else if (this.isSelected(n + 1)) {
            this.latestSelected = n + 1;
        }
    }

    private void selectColumn(int n) {
        if (!this.inEdit) {
            return;
        }
        if (this.selected.contains(n)) {
            return;
        }
        if (n < 0) {
            return;
        }
        double d = this.track.getHeightAt(n);
        this.tempVec = new Vector3f((float)this.track.getXPosition(n), (float)d + 0.1f, this.track.getActualWidth() * 0.5f);
        Highlight highlight = new Highlight(0.4f, this.track.getActualWidth() * 0.7f);
        highlight.getFader().fadeTo(selectedColor, fadeTime);
        highlight.getMover().setPosition(this.tempVec);
        this.selectedHighlights.add(highlight);
        this.selectedNode.attachChild(highlight);
        this.selected.add(n);
        this.latestSelected = n;
    }

    private void selectNext(boolean bl) {
        if (!this.inEdit) {
            return;
        }
        if (this.selected.isEmpty()) {
            if (this.latestSelected > 0) {
                this.selectColumn(this.latestSelected + 1);
            } else if (this.mouseOverColumn > 0) {
                this.selectColumn(this.mouseOverColumn + 1);
            }
        } else if (!bl) {
            int n = this.latestSelected;
            this.removeSelection();
            this.selectColumn(n + 1);
        } else if (this.isSelected(this.latestSelected + 1)) {
            this.toggleSelected(this.latestSelected);
        } else {
            this.selectColumn(this.latestSelected + 1);
        }
        this.setDisregardHeightsliders(true);
    }

    private void selectPrevious(boolean bl) {
        if (!this.inEdit) {
            return;
        }
        if (this.selected.isEmpty()) {
            if (this.latestSelected > 0) {
                this.selectColumn(this.latestSelected - 1);
            } else if (this.mouseOverColumn > 0) {
                this.selectColumn(this.mouseOverColumn - 1);
            }
        } else if (!bl) {
            int n = this.latestSelected;
            this.removeSelection();
            this.selectColumn(n - 1);
        } else if (this.isSelected(this.latestSelected - 1)) {
            this.toggleSelected(this.latestSelected);
        } else {
            this.selectColumn(this.latestSelected - 1);
        }
        this.setDisregardHeightsliders(true);
    }

    private void updateButtons() {
        if (this.selected.isEmpty()) {
            for (int i = 0; i < this.enabledWhenStripChosen.size(); ++i) {
                this.enabledWhenStripChosen.get(i).setEnabled(false);
            }
        } else {
            int n;
            if (this.selected.size() >= 3) {
                for (n = 0; n < this.enabledWhen3StripsChosen.size(); ++n) {
                    this.enabledWhen3StripsChosen.get(n).setEnabled(true);
                }
            } else {
                for (n = 0; n < this.enabledWhen3StripsChosen.size(); ++n) {
                    this.enabledWhen3StripsChosen.get(n).setEnabled(false);
                }
            }
            for (n = 0; n < this.enabledWhenStripChosen.size(); ++n) {
                this.enabledWhenStripChosen.get(n).setEnabled(true);
            }
        }
        if (this.undo.isEmpty()) {
            this.undoButton.setEnabled(false);
        } else {
            this.undoButton.setEnabled(true);
        }
        if (this.redo.isEmpty()) {
            this.redoButton.setEnabled(false);
        } else {
            this.redoButton.setEnabled(true);
        }
    }

    private void createHighlightNodes() {
        this.highlightNode = new Node("highlightNode");
        this.highlightNode.setTextureCombineMode(5);
        SpatialFadeController spatialFadeController = new SpatialFadeController(this.highlightNode);
        spatialFadeController.initRenderStates();
        this.highlightNode.updateRenderState();
        this.rootNode.attachChild(this.highlightNode);
        this.selectedNode = new Node("selectedNode");
        this.selectedNode.setTextureCombineMode(5);
        spatialFadeController = new SpatialFadeController(this.selectedNode);
        spatialFadeController.initRenderStates();
        this.selectedNode.updateRenderState();
        this.rootNode.attachChild(this.selectedNode);
        this.previewNode = new Node("previewNode");
        this.previewNode.setTextureCombineMode(5);
        spatialFadeController = new SpatialFadeController(this.previewNode);
        spatialFadeController.initRenderStates();
        this.previewNode.updateRenderState();
        this.rootNode.attachChild(this.previewNode);
    }

    private void scrollLeft() {
        if (!this.inEdit) {
            return;
        }
        this.scrolling = -scrollSpeed;
    }

    private void scrollRight() {
        if (!this.inEdit) {
            return;
        }
        this.scrolling = scrollSpeed;
    }

    private void stopScroll() {
        this.scrolling = 0.0f;
    }

    private void scrollToBeginning() {
        if (!this.inEdit) {
            return;
        }
        this.mouseCameraFollower.getLocalTranslation().x = 0.0;
    }

    private void scrollToEnd() {
        if (!this.inEdit) {
            return;
        }
        float f = this.track.getFinishPosition();
        if (f > 0.0f) {
            this.mouseCameraFollower.getLocalTranslation().x = f;
        }
    }

    public void setInEdit(boolean bl) {
        this.inEdit = bl;
        if (!bl) {
            BikeGameObject bikeGameObject;
            int n;
            this.gui.setHandleSpecialKeys(false);
            this.rootNode.detachChild(this.highlightNode);
            this.rootNode.detachChild(this.selectedNode);
            this.rootNode.detachChild(this.previewNode);
            if (this.gameStateCameraNode != null) {
                this.bikeCameraFollower = this.gameStateCameraNode.getTransformationProvider();
            }
            this.stopScroll();
            if (this.gameState != null) {
                this.gameState.getCameraNode().setTransformationProvider(this.gameState.getCameraFollowProvider());
                this.gameState.getCameraNode().setCameraSlackMin(this.cameraSlackMin);
                this.gameState.getCameraNode().setCameraSlackMax(this.cameraSlackMax);
                this.gameState.getCameraNode().setCameraSpeed(this.cameraSpeed);
                this.gameState.getEventManager().fireEvent("RaceStarted");
            }
            this.hideEditPanel();
            if (this.track != null) {
                this.track.reconstructCollisionStructure();
            }
            this.tempVec.set(this.playButtonPosition).addLocal(buttonHideVector);
            this.playButton.getMover().translateTo(this.tempVec, editPanelMoveTime, editPanelMoveTime);
            this.playPanel.getMover().translateTo(this.playPanelPosition, editPanelMoveTime, editPanelMoveTime);
            this.getGlobalEventManager().fireEvent("UnpauseState", new String[][]{{"stateName"}, {gameStateName}});
            ArrayList<BikeGameObject> arrayList = this.gameState.getBikes();
            this.tempVecd.set(this.bikeMarker.getSpatial().getLocalTranslation());
            this.tempVecd.x += (double)(this.miniMap.getWidth() * 0.5f);
            this.tempVecd.x = this.tempVecd.x / (double)this.miniMap.getWidth() * (double)this.track.getOriginalLength();
            this.tempVecd = this.track.findGoodResetSpot(this.tempVecd.x - 8.0, 8.0, 20.5, this.tempVecd);
            this.tempVecd.subtractLocal(16.0, 0.0, 0.0);
            if (this.tempVecd.x < 25.0) {
                this.gameState.resetBikePositions();
            } else {
                this.gameState.resetBikePositions();
                for (n = 0; n < arrayList.size(); ++n) {
                    bikeGameObject = arrayList.get(n);
                    if (bikeGameObject == null) continue;
                    bikeGameObject.getBikeParticleSystem().reset(this.tempVecd, true);
                }
            }
            this.gameState.setControlEnabled(true, true);
            this.track.reconstructChallenges();
            for (n = 0; n < arrayList.size(); ++n) {
                bikeGameObject = arrayList.get(n);
                if (bikeGameObject == null || bikeGameObject.getChallengeMonitorComponent() == null) continue;
                bikeGameObject.getChallengeMonitorComponent().startMonitoring();
                bikeGameObject.getChallengeMonitorComponent().setAchievedListener(this.challengeListener);
            }
        } else {
            this.gui.setHandleSpecialKeys(true);
            this.rootNode.attachChild(this.highlightNode);
            this.rootNode.attachChild(this.selectedNode);
            this.rootNode.attachChild(this.previewNode);
            if (this.mouseCameraFollower == null && this.gameState.getCameraFollowProvider() != null) {
                this.mouseCameraFollower = new TransformationCoupler();
                this.mouseCameraFollower.setLocalTranslation(this.gameState.getCameraFollowProvider().getLocalTranslation());
            }
            this.gameState.getCameraNode().setTransformationProvider(this.mouseCameraFollower);
            this.gameState.getCameraNode().setCameraSlackMax(new Vector3f(0.0f, 1.0f, 0.0f));
            this.gameState.getCameraNode().setCameraSlackMin(new Vector3f(0.0f, -12.0f, 0.0f));
            this.gameState.getCameraNode().setCameraSpeed(new Vector3f(18.0f, 9.599999f, 0.0f));
            this.showEditPanel();
            this.tempVec.set(this.playPanelPosition).addLocal(buttonHideVector);
            this.playPanel.getMover().translateTo(this.tempVec, editPanelMoveTime, editPanelMoveTime);
            this.playButton.getMover().translateTo(this.playButtonPosition, editPanelMoveTime, editPanelMoveTime);
            this.getGlobalEventManager().fireEvent("PauseState", new String[][]{{"stateName"}, {gameStateName}});
            this.reconstruct(this.track.getOriginalHeightMap());
        }
    }

    private void showEditPanel() {
        this.editPanel.enableFromTemporaryDisable();
        this.editPanel.getMover().clearListeners();
        this.editPanel.getMover().translateTo(this.editPanelPosition, editPanelMoveTime, editPanelMoveTime);
        this.gui.getNode().attachChild(this.editPanel.getSpatial());
        this.miniMap.setEnabled(true);
        this.miniMap.getMover().clearListeners();
        this.miniMap.getMover().translateTo(this.miniMapPosition, editPanelMoveTime, editPanelMoveTime);
        this.gui.getNode().attachChild(this.miniMap.getSpatial());
    }

    private void hideEditPanel() {
        this.editPanel.disableTemporarily();
        this.tempVec.set(this.editPanelPosition).addLocal(panelHideVector);
        this.editPanel.getMover().translateTo(this.tempVec, editPanelMoveTime, editPanelRemoveTime);
        this.editPanel.getMover().add(this.detachWhenDone);
    }

    private void updateAfterSelection() {
        this.updateButtons();
        this.updatePreview();
    }

    private void updateMiniMap() {
        this.miniMap.update(this.track.getOriginalHeightMap(), (int)((float)this.maxIntHeight * 1.2f), this.minIntHeight);
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        float f = (float)displaySystem.getWidth() / (float)displaySystem.getHeight();
        float f2 = 20.0f;
        float f3 = f * f2 * 2.0f / this.track.getOriginalLength();
        float f4 = this.miniMap.getWidth() * f3;
        this.cameraMarker.setWidth(f4);
    }

    private boolean isMultiSelect() {
        return this.gui.isKeyDown(42) || this.gui.isKeyDown(54) || this.gui.isKeyDown(29) || this.gui.isKeyDown(157);
    }

    private boolean isCtrlDown() {
        return this.gui.isKeyDown(29) || this.gui.isKeyDown(157);
    }

    private boolean isShiftDown() {
        return this.gui.isKeyDown(42) || this.gui.isKeyDown(54);
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    private void autoSaveToFile() {
        if (this.autoSaveFile == null) {
            return;
        }
        ++this.autoSaveCount;
        if (this.autoSaveCount >= this.autoSaveInterval) {
            this.autoSaveCount = 0;
            this.save(this.autoSaveFile);
        }
        this.lengthLabel.setText("Track length: " + this.track.getOriginalHeightMap().getXsize());
    }

    private void saveUndoData() {
        int[] nArray = this.getUndoData();
        this.undo.add(nArray);
        if (this.undo.size() > 80) {
            this.undo.removeElementAt(0);
        }
        this.redo.clear();
    }

    private int[] getUndoData() {
        int[] nArray = this.track.getOriginalHeightMap().getHeightMap();
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    public void cut() {
        int n = this.selected.size();
        if (n <= 0) {
            return;
        }
        int n2 = this.getSelectionStart() - this.track.getOriginalHeightMapStartsAt();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.track.getOriginalHeightMap().getXsize()) {
            n2 = this.track.getOriginalHeightMap().getXsize() - 1;
        }
        if (n2 + n > this.track.getOriginalHeightMap().getXsize()) {
            n = this.track.getOriginalHeightMap().getXsize() - n2;
        }
        this.clipboard = new int[n];
        System.arraycopy(this.track.getOriginalHeightMap().getHeightMap(), n2, this.clipboard, 0, n);
        int[] nArray = new int[this.track.getOriginalHeightMap().getHeightMap().length - n];
        if (n2 > 0) {
            System.arraycopy(this.track.getOriginalHeightMap().getHeightMap(), 0, nArray, 0, n2);
        }
        System.arraycopy(this.track.getOriginalHeightMap().getHeightMap(), n2 + n, nArray, n2, nArray.length - n2);
        ImageHeightMap imageHeightMap = new ImageHeightMap();
        imageHeightMap.setHeightData(nArray, nArray.length, this.track.getOriginalHeightMap().getYsize());
        this.prepareForChange();
        this.reconstruct(imageHeightMap);
        this.autoSaveToFile();
    }

    public void paste() {
        int n = this.getSelectionStart() - this.track.getOriginalHeightMapStartsAt();
        if (this.clipboard != null && this.clipboard.length > 0 && this.selected.size() > 0 && n >= 0) {
            this.extendTrack(this.getSelectionStart() + this.clipboard.length);
            this.prepareForChange();
            if (this.selected.size() > 1) {
                this.applyData(this.clipboard, n);
            } else {
                this.insertData(this.clipboard, n);
            }
            this.autoSaveToFile();
        }
    }

    public void copy() {
        int n = this.selected.size();
        if (n <= 0) {
            return;
        }
        int n2 = this.getSelectionStart() - this.track.getOriginalHeightMapStartsAt();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.track.getOriginalHeightMap().getXsize()) {
            n2 = this.track.getOriginalHeightMap().getXsize() - 1;
        }
        if (n2 + n > this.track.getOriginalHeightMap().getXsize()) {
            n = this.track.getOriginalHeightMap().getXsize() - n2;
        }
        this.clipboard = new int[n];
        System.arraycopy(this.track.getOriginalHeightMap().getHeightMap(), n2, this.clipboard, 0, n);
    }

    public void mirror() {
        int n = this.selected.size();
        if (n <= 0) {
            return;
        }
        int n2 = this.getSelectionStart() - this.track.getOriginalHeightMapStartsAt();
        if (n2 < 0) {
            n2 = 0;
        }
        this.prepareForChange();
        if (n2 >= this.track.getOriginalHeightMap().getXsize()) {
            n2 = this.track.getOriginalHeightMap().getXsize() - 1;
        }
        if (n2 + n > this.track.getOriginalHeightMap().getXsize()) {
            n = this.track.getOriginalHeightMap().getXsize() - n2;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.track.getOriginalHeightMap().getHeightMap()[n2 + (n - 1 - i)];
        }
        this.applyData(nArray, n2);
        this.autoSaveToFile();
        this.setDisregardHeightsliders(true);
    }

    public void redo() {
        if (this.redo.isEmpty()) {
            return;
        }
        this.undo.push(this.getUndoData());
        int[] nArray = this.redo.pop();
        if (nArray != null) {
            ImageHeightMap imageHeightMap = this.track.getOriginalHeightMap();
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            imageHeightMap.setHeightData(nArray2, nArray2.length, 1);
            this.reconstruct(imageHeightMap);
        }
    }

    public void undo() {
        if (this.undo.isEmpty()) {
            return;
        }
        this.redo.push(this.getUndoData());
        int[] nArray = this.undo.pop();
        if (nArray != null) {
            ImageHeightMap imageHeightMap = this.track.getOriginalHeightMap();
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            imageHeightMap.setHeightData(nArray2, nArray2.length, 1);
            this.reconstruct(imageHeightMap);
        }
    }

    private void applyData(int[] nArray, int n) {
        ImageHeightMap imageHeightMap = this.track.getOriginalHeightMap();
        System.arraycopy(nArray, 0, imageHeightMap.getHeightMap(), n, nArray.length);
        this.reconstruct(imageHeightMap);
    }

    private void appendData(int[] nArray) {
        int[] nArray2 = this.track.getOriginalHeightMap().getHeightMap();
        this.insertData(nArray, nArray2.length - 2);
    }

    private void insertData(int[] nArray, int n) {
        int[] nArray2 = this.track.getOriginalHeightMap().getHeightMap();
        if (n + 1 >= nArray2.length) {
            return;
        }
        int[] nArray3 = new int[nArray2.length + nArray.length];
        if (n > 0) {
            System.arraycopy(nArray2, 0, nArray3, 0, n + 1);
        }
        System.arraycopy(nArray, 0, nArray3, n + 1, nArray.length);
        System.arraycopy(nArray2, n + 1, nArray3, n + 1 + nArray.length, nArray3.length - (n + 1 + nArray.length));
        ImageHeightMap imageHeightMap = new ImageHeightMap();
        imageHeightMap.setHeightData(nArray3, this.track.getOriginalHeightMap().getXsize() + nArray.length, this.track.getOriginalHeightMap().getYsize());
        this.reconstruct(imageHeightMap);
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public boolean isInEdit() {
        return this.inEdit;
    }

    public void showText(String string) {
        Label label = new Label("label", string, DisplaySystem.getDisplaySystem().getWidth(), (float)DisplaySystem.getDisplaySystem().getHeight() * 0.03f, "normal_small_white", null);
        label.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        label.getFader().initRenderStates();
        label.setZOrder(-10000, true);
        label.setLocalTranslation(DisplaySystem.getDisplaySystem().getWidth() / 2, (float)DisplaySystem.getDisplaySystem().getHeight() * 0.3f, 0.0f);
        this.gui.getNode().attachChild(label);
        label.getFader().fadeTo(fullAlphaColor, 5.0f);
        label.getFader().addFadeToQueue(noAlphaColor, 5.0f);
        label.getFader().add(this.detachWhenDone);
    }

    static {
        noAlphaColor = new ColorRGBA(1.0f, 0.5f, 0.5f, 0.0f);
        fullAlphaColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        mouseOverColor = new ColorRGBA(1.0f, 0.5f, 0.5f, 0.9f);
        selectedColor = new ColorRGBA(1.0f, 0.2f, 0.2f, 0.9f);
        previewColor = new ColorRGBA(0.2f, 0.2f, 1.0f, 0.7f);
        previewNotValidColor = new ColorRGBA(0.7f, 0.7f, 0.8f, 0.7f);
        panelHideVector = new Vector3f(0.0f, DisplaySystem.getDisplaySystem().getHeight(), 0.0f);
        buttonHideVector = new Vector3f(DisplaySystem.getDisplaySystem().getWidth(), 0.0f, 0.0f);
        fadeTime = 0.2f;
        moveTime = -1.0f;
        moveDamping = 0.7f;
        scrollSpeed = 50.0f;
        editPanelMoveTime = 4.8f;
        editPanelRemoveTime = 0.2f;
        bikeMarkerMoveTime = 0.8f;
        bikeMarkerMoveDamping = 0.6f;
    }

    private class ChallengeListener
    implements IAchievedListener {
        private ChallengeListener() {
        }

        public void achievedChallenge(com.turborilla.msm.track.challenges.IChallenge iChallenge) {
            Label label = new Label("challenge label", "Achieved " + iChallenge.getName(), DisplaySystem.getDisplaySystem().getWidth(), (float)DisplaySystem.getDisplaySystem().getHeight() * 0.03f, "normal_small_white", null);
            label.setHorisontalAlignment(HorisontalAlignment.CENTERED);
            label.getFader().initRenderStates();
            label.setZOrder(-10000, true);
            label.setLocalTranslation(DisplaySystem.getDisplaySystem().getWidth() / 2, (float)DisplaySystem.getDisplaySystem().getHeight() * 0.2f, 0.0f);
            EditorState.this.gui.getNode().attachChild(label);
            label.getFader().fadeTo(fullAlphaColor, 5.0f);
            label.getFader().addFadeToQueue(noAlphaColor, 5.0f);
            label.getFader().add(EditorState.this.detachWhenDone);
        }
    }

    private class RemoveWidgetFromEditPanelWhenDone
    implements IControllerListener {
        private BaseWidget widget;

        public RemoveWidgetFromEditPanelWhenDone(BaseWidget baseWidget) {
            this.widget = baseWidget;
        }

        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            EditorState.this.editPanel.removeWidget(this.widget);
        }
    }

    private class DetachWhenDone
    implements IControllerListener {
        private DetachWhenDone() {
        }

        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            if (abstractSpatialController.getSpatial().getParent() != null) {
                abstractSpatialController.getSpatial().getParent().detachChild(abstractSpatialController.getSpatial());
            }
        }
    }

    private class FadeAndRemove
    implements IControllerListener {
        private FadeAndRemove() {
        }

        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            if (abstractSpatialController.getSpatial().getParent() != null) {
                abstractSpatialController.getSpatial().getParent().detachChild(abstractSpatialController.getSpatial());
            }
        }
    }

    private class Highlight
    extends Quad {
        SpatialFadeController fader;
        SpatialTranslationController mover;

        public Highlight(float f, float f2) {
            super("highlight", f, f2);
            this.setLocalRotation(new Quaternion(new float[]{-1.5707964f, 0.0f, 0.0f}));
            SpatialFadeController spatialFadeController = new SpatialFadeController(this);
            spatialFadeController.initRenderStates();
            spatialFadeController.setColor(noAlphaColor);
            SpatialTranslationController spatialTranslationController = new SpatialTranslationController(this);
            spatialTranslationController.setDamping(moveDamping);
            spatialTranslationController.setSnapToWholePixels(false);
            this.setModelBound(new BoundingBox());
            this.updateModelBound();
            this.fader = spatialFadeController;
            this.mover = spatialTranslationController;
        }

        public SpatialFadeController getFader() {
            return this.fader;
        }

        public SpatialTranslationController getMover() {
            return this.mover;
        }
    }

    private class PlayEditButtonListener
    implements IButtonClickedListener {
        MenuButton editButton;
        MenuButton playButton;

        PlayEditButtonListener(MenuButton menuButton, MenuButton menuButton2) {
            this.editButton = menuButton;
            this.playButton = menuButton2;
        }

        public void onClick(MenuButton menuButton, Vector3f vector3f) {
            if (menuButton == this.playButton) {
                EditorState.this.setInEdit(false);
            } else if (menuButton == this.editButton) {
                EditorState.this.setInEdit(true);
            }
        }
    }

    private class GlobalGuiListener
    implements IGuiListener {
        private TrianglePickResults pickResult = new TrianglePickResults();
        private Ray ray = new Ray();
        private EditorState editor;
        private Vector2f tempScreenPos = new Vector2f();
        private Vector3f tempWorldCoords = new Vector3f();

        public GlobalGuiListener(EditorState editorState2) {
            this.editor = editorState2;
        }

        public void onLeftMouseDown(Vector3f vector3f, boolean bl) {
            if (!EditorState.this.inEdit) {
                return;
            }
            if (!bl && EditorState.this.gameState != null && EditorState.this.gameState.getTrack() != null) {
                if (vector3f.y < (float)DisplaySystem.getDisplaySystem().getHeight() * 0.6f || this.editor.columnWhereSelectStarted >= 0) {
                    this.editor.startSelectAtWorldPos(this.getWorldCoordX(vector3f), EditorState.this.isMultiSelect());
                } else {
                    this.editor.removeSelection();
                }
                EditorState.this.updateAfterSelection();
            }
        }

        public void onRightMouseDown(Vector3f vector3f, boolean bl) {
        }

        public void onMiddleMouseDown(Vector3f vector3f, boolean bl) {
        }

        public void onLeftMouseUp(Vector3f vector3f, boolean bl) {
            if (!EditorState.this.inEdit) {
                return;
            }
            if (!bl && EditorState.this.gameState != null && EditorState.this.gameState.getTrack() != null) {
                this.editor.endSelectAtWorldPos(this.getWorldCoordX(vector3f), EditorState.this.isMultiSelect());
                EditorState.this.updateAfterSelection();
            }
        }

        public void onRightMouseUp(Vector3f vector3f, boolean bl) {
        }

        public void onMiddleMouseUp(Vector3f vector3f, boolean bl) {
        }

        public void onLeftMouseClicked(Vector3f vector3f, boolean bl) {
        }

        public void onRightMouseClicked(Vector3f vector3f, boolean bl) {
        }

        public void onMiddleMouseClicked(Vector3f vector3f, boolean bl) {
        }

        public boolean onKeyDown(int n, char c, boolean bl) {
            boolean bl2 = false;
            if (!EditorState.this.inEdit) {
                if (!bl && EditorState.this.gameState != null && EditorState.this.gameState.getTrack() != null) {
                    switch (n) {
                        case 19: {
                            EditorState.this.setInEdit(true);
                            EditorState.this.setInEdit(false);
                            bl2 = true;
                            break;
                        }
                        case 18: {
                            EditorState.this.setInEdit(true);
                            bl2 = true;
                        }
                    }
                }
                return bl2;
            }
            if (!bl && EditorState.this.gameState != null && EditorState.this.gameState.getTrack() != null) {
                switch (n) {
                    case 78: 
                    case 200: {
                        if (!EditorState.this.isShiftDown()) {
                            this.editor.changeTrackHeight(10);
                        } else {
                            this.editor.changeTrackHeight(2);
                        }
                        bl2 = true;
                        break;
                    }
                    case 74: 
                    case 208: {
                        if (!EditorState.this.isShiftDown()) {
                            this.editor.changeTrackHeight(-10);
                        } else {
                            this.editor.changeTrackHeight(-2);
                        }
                        bl2 = true;
                        break;
                    }
                    case 55: {
                        if (!EditorState.this.isShiftDown()) {
                            this.editor.changeTrackHeight(2.0f);
                        } else {
                            this.editor.changeTrackHeight(1.25f);
                        }
                        bl2 = true;
                        break;
                    }
                    case 181: {
                        if (!EditorState.this.isShiftDown()) {
                            this.editor.changeTrackHeight(0.5f);
                        } else {
                            this.editor.changeTrackHeight(0.8f);
                        }
                        bl2 = true;
                        break;
                    }
                    case 205: {
                        this.editor.selectNext(EditorState.this.isMultiSelect());
                        bl2 = true;
                        break;
                    }
                    case 203: {
                        this.editor.selectPrevious(EditorState.this.isMultiSelect());
                        bl2 = true;
                        break;
                    }
                    case 199: {
                        this.editor.scrollToBeginning();
                        bl2 = true;
                        break;
                    }
                    case 207: {
                        this.editor.scrollToEnd();
                        bl2 = true;
                        break;
                    }
                    case 44: {
                        if (!EditorState.this.isCtrlDown()) break;
                        this.editor.undo();
                        bl2 = true;
                        break;
                    }
                    case 21: {
                        if (!EditorState.this.isCtrlDown()) break;
                        this.editor.redo();
                        bl2 = true;
                        break;
                    }
                    case 46: {
                        if (!EditorState.this.isCtrlDown()) break;
                        this.editor.copy();
                        bl2 = true;
                        break;
                    }
                    case 47: {
                        if (!EditorState.this.isCtrlDown()) break;
                        this.editor.paste();
                        bl2 = true;
                        break;
                    }
                    case 45: {
                        if (!EditorState.this.isCtrlDown()) break;
                        this.editor.cut();
                        bl2 = true;
                        break;
                    }
                    case 50: {
                        if (!EditorState.this.isCtrlDown()) break;
                        this.editor.mirror();
                        bl2 = true;
                        break;
                    }
                    case 25: {
                        if (EditorState.this.filePanel.isEnabled()) break;
                        EditorState.this.setInEdit(false);
                        bl2 = true;
                    }
                }
            }
            if (bl2) {
                EditorState.this.updateAfterSelection();
            }
            return bl2;
        }

        public boolean onKeyUp(int n, char c, boolean bl) {
            return false;
        }

        public boolean onKeyTyped(int n, char c, boolean bl) {
            return false;
        }

        public void onMouseMove(Vector3f vector3f, boolean bl) {
            if (!EditorState.this.inEdit) {
                return;
            }
            if (!bl && EditorState.this.gameState != null && EditorState.this.gameState.getTrack() != null) {
                if (this.editor.columnWhereSelectStarted >= 0) {
                    EditorState.this.startSelectAtWorldPos(this.getWorldCoordX(vector3f), EditorState.this.isMultiSelect());
                    EditorState.this.updateAfterSelection();
                }
                if (vector3f.y < (float)DisplaySystem.getDisplaySystem().getHeight() * 0.6f) {
                    this.editor.mouseOverTrackAtWorldPos(this.getWorldCoordX(vector3f));
                    float f = this.editor.gui.getMouseLimit().x * 0.02f;
                    if (vector3f.x > this.editor.gui.getMouseLimit().x - f) {
                        this.editor.scrollRight();
                    } else if (vector3f.x < 0.0f + f) {
                        this.editor.scrollLeft();
                    } else {
                        this.editor.stopScroll();
                    }
                } else {
                    this.editor.removeMouseOver();
                    this.editor.stopScroll();
                }
            } else {
                this.editor.stopScroll();
            }
        }

        public void onFocus(IWidget iWidget) {
        }

        public void onBlur(IWidget iWidget) {
        }

        public void onActivate(IWidget iWidget) {
        }

        public void onDeactivate(IWidget iWidget) {
        }

        private float getWorldCoordX(Vector3f vector3f) {
            this.tempScreenPos.set(vector3f.x, vector3f.y);
            DisplaySystem.getDisplaySystem().getWorldCoordinates(this.tempScreenPos, 1.0f, this.tempWorldCoords);
            return this.tempWorldCoords.x;
        }

        public void onLeftMouseDoubleClicked(Vector3f vector3f, boolean bl) {
        }

        public void onMiddleMouseDoubleClicked(Vector3f vector3f, boolean bl) {
        }

        public void onRightMouseDoubleClicked(Vector3f vector3f, boolean bl) {
        }
    }
}

