/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.CameraNode;
import com.jme.scene.Node;
import com.jme.scene.Text;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.TextureManager;
import com.jmex.game.StandardGame;
import com.turborilla.Updatable;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.msm.states.BaseGameStateRootNode;
import java.io.IOException;
import java.net.URL;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;

public abstract class StandardState
extends BaseGameStateRootNode
implements IEventListener,
Updatable {
    private static final String FONT_LOCATION = "/com/jme/app/defaultfont.tga";
    private Node stateNode;
    private Text stateName;
    protected Camera cam;
    protected CameraNode camNode;
    private EventManager eventManager;
    private EventManager globalEventManager;
    private Queue<Runnable> executeNextFrameQueue = new ConcurrentLinkedQueue<Runnable>();
    protected GameSettings settings;
    private boolean paused = false;
    private float tpfFactor = 1.0f;

    public StandardState(String string, GameSettings gameSettings, URL uRL) {
        super(string);
        this.eventManager = uRL != null ? new EventManager(uRL) : null;
        this.settings = gameSettings;
        this.init();
    }

    protected void init() {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                StandardState.this.initCamera();
                return StandardState.this.initGL();
            }
        };
        try {
            GameTaskQueueManager.getManager().update(callable).get();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
    }

    protected abstract boolean initGL();

    protected void onActivate() throws IOException {
        this.cam.update();
        DisplaySystem.getDisplaySystem().getRenderer().setCamera(this.cam);
    }

    protected void onDeactivate() {
        super.onDeactivate();
    }

    public void initDebugStuff() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        AlphaState alphaState = displaySystem.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        TextureState textureState = displaySystem.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture(StandardGame.class.getResource(FONT_LOCATION), 2, 1));
        textureState.setEnabled(true);
        this.stateName = new Text();
        this.stateName = new Text("statename", this.name);
        this.stateName.setTextureCombineMode(5);
        this.stateNode = new Node("statename Node");
        this.stateNode.attachChild(this.stateName);
        this.stateNode.setRenderState(textureState);
        this.stateNode.setRenderState(alphaState);
        this.stateNode.setLocalTranslation(new Vector3f(200.0f, 0.0f, 0.0f));
        this.stateNode.updateGeometricState(0.0f, true);
        this.stateNode.updateRenderState();
        this.rootNode.attachChild(this.stateNode);
    }

    public Camera getCamera() {
        return this.cam;
    }

    public void setCamera(Camera camera) {
        this.cam = camera;
    }

    protected void initCamera() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.cam = displaySystem.getRenderer().createCamera(displaySystem.getWidth(), displaySystem.getHeight());
        this.cam.setFrustumPerspective(45.0f, (float)displaySystem.getWidth() / (float)displaySystem.getHeight(), 1.0f, 1000.0f);
        this.cam.update();
        this.camNode = new CameraNode("CameraNode", this.cam);
        this.camNode.setLocalRotation(new Quaternion());
        this.camNode.setLocalTranslation(new Vector3f());
        this.camNode.setLocalScale(1.0f);
        this.camNode.updateWorldData(0.0f);
        displaySystem.getRenderer().setCamera(this.cam);
        this.rootNode.attachChild(this.camNode);
    }

    public final void update(float f) {
        if (this.eventManager != null) {
            this.eventManager.handleEvents(this);
        }
        if (!this.paused) {
            this.executeQueuedTasks();
            super.update(f * this.tpfFactor);
        }
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public void render(float f) {
        super.render(f);
    }

    protected void stateRender(float f) {
    }

    protected void stateUpdate(float f) {
    }

    protected void executeNextFrame(Runnable runnable) {
        if (runnable != null) {
            this.executeNextFrameQueue.add(runnable);
        }
    }

    private void executeQueuedTasks() {
        Runnable runnable;
        while ((runnable = this.executeNextFrameQueue.poll()) != null) {
            runnable.run();
        }
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public EventManager getGlobalEventManager() {
        return this.globalEventManager;
    }

    public void setGlobalEventManager(EventManager eventManager) {
        this.globalEventManager = eventManager;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public GameSettings getSettings() {
        return this.settings;
    }

    public float getTpfFactor() {
        return this.tpfFactor;
    }

    public void setTpfFactor(float f) {
        this.tpfFactor = f;
    }

    public boolean isRemoveMeFromEventmanager() {
        return false;
    }
}

