/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states;

import com.jme.renderer.pass.BasicPassManager;
import com.jme.scene.Spatial;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jmex.game.state.GameState;
import com.jmex.game.state.GameStateNode;
import com.turborilla.Updatable;
import com.turborilla.msm.states.MsmGameStateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseGameState
extends GameStateNode<GameState> {
    private static final Logger logger = Logger.getLogger(BaseGameState.class.getName());
    protected BasicPassManager passManager = new BasicPassManager();
    private ArrayList<Updatable> updatables = new ArrayList();

    public BaseGameState(String string) {
        super(string);
    }

    public void addUpdatable(Updatable updatable) {
        if (!this.hasUpdatable(updatable)) {
            this.updatables.add(updatable);
        } else {
            logger.warning("Updatable is already present in this gamestate");
        }
    }

    public boolean hasUpdatable(Updatable updatable) {
        return this.updatables.contains(updatable);
    }

    public boolean removeUpdatable(Updatable updatable) {
        return this.updatables.remove(updatable);
    }

    protected abstract void stateUpdate(float var1);

    protected abstract void stateRender(float var1);

    protected abstract void onActivate() throws IOException;

    protected void onDeactivate() {
    }

    @Override
    public void setActive(boolean bl) {
        if (bl && !this.isActive()) {
            try {
                this.onActivate();
            }
            catch (IOException iOException) {
                throw new MsmGameStateException(iOException);
            }
        } else if (!bl && this.isActive()) {
            this.onDeactivate();
        }
        super.setActive(bl);
    }

    public void initZBuffer(Spatial spatial) {
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        spatial.setRenderState(zBufferState);
    }

    @Override
    public void cleanup() {
        if (this.passManager != null) {
            this.passManager.cleanUp();
        }
        super.cleanup();
    }

    @Override
    public void render(float f) {
        this.stateRender(f);
        if (this.passManager != null) {
            this.passManager.renderPasses(DisplaySystem.getDisplaySystem().getRenderer());
        }
        super.render(f);
    }

    @Override
    public void update(float f) {
        this.updateUpdatables(f);
        this.stateUpdate(f);
        if (this.passManager != null) {
            this.passManager.updatePasses(f);
        }
        super.update(f);
    }

    private void updateUpdatables(float f) {
        if (this.updatables != null) {
            for (int i = 0; i < this.updatables.size(); ++i) {
                this.updatables.get(i).update(f);
            }
        }
    }
}

