/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.Game;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.replay.ReplayAI;
import com.turborilla.msm.replay.ReplayMetaData;
import com.turborilla.msm.statemachine.AbstractState;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.statemachine.StateMachine;
import com.turborilla.utils.Utils;
import java.io.IOException;

public class Upsell1
extends AbstractState {
    private GameState gameState;
    protected String purchaseButtonTrackingName = "upsell1";
    protected String menuPanelName = "Upsell1";
    protected String replayFile = "Weeeeee";
    protected String specialAbility = "nitro";
    protected String trackFile = "Weeeeee";
    private float time = -1.0f;

    public Upsell1(GameState gameState) {
        this.setName("GameOver");
        this.gameState = gameState;
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("ButtonPressed", this);
    }

    public void onEnter(String string) {
        this.getStateMachine().getEventManager().fireEvent("TemporaryVolumeChanged", new String[][]{{"category", "volume", "time"}, {"GameMusicVolume", "1", "0.1"}});
        this.getStateMachine().getEventManager().fireEvent("PlayMusic", new String[][]{{"track"}, {"loader"}});
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {this.menuPanelName, "true"}});
        this.getStateMachine().getEventManager().fireEvent(new Event("ActivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
        if (this.getStateMachine().getSettings().get("demoVariant", "0").equals("7")) {
            this.replayFile = this.replayFile + "2";
        }
        try {
            ReplayAI replayAI = (ReplayAI)ResourceManager.getInstance().load("replayAI", this.replayFile, null);
            ReplayMetaData replayMetaData = new ReplayMetaData();
            replayMetaData.addParticipant(this.specialAbility, replayAI.getOpponentReplay().getBikeResult(), replayAI.getReplayData());
            this.prepareTimeAttackRace(0, 0, replayMetaData);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.gameState.setNNEnabled(false);
        this.gameState.resetBikePositions();
        this.gameState.setControlEnabled(true, true);
        this.gameState.startCountdown();
        this.gameState.startReplayComponent();
        this.gameState.waitForStabilizedFrameRate(true);
        this.time = Float.parseFloat(this.gameState.getSettings().get("time", "0"));
    }

    public void onLeave() {
        this.resetPlayTime();
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
        this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
    }

    protected void resetPlayTime() {
        if (this.time >= 0.0f) {
            this.gameState.getSettings().set("time", "" + this.time);
        }
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        this.resetPlayTime();
        if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "maybeLaterButton")) {
            this.getStateMachine().transitionToState("Menu");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "buyNowButton")) {
            Game.buy(this.purchaseButtonTrackingName);
            this.getStateMachine().getEventManager().fireEvent("Quit");
        }
    }

    private void prepareTimeAttackRace(int n, int n2, ReplayMetaData replayMetaData) throws IOException {
        this.gameState.prepareNewRace(Utils.getProperties(new String[][]{{"track", "numberOfLaps", "numberOfBikes", "bike0", "bike1", "cameraFollowBikeNumber", "startsequence", "finishline", "controlMode", "specialAbility", "timeAttack"}, {this.trackFile, "2", "2", "replay", "computer", "0", "true", "true", Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty().getName(), this.specialAbility, "true"}}), null, n, n2, replayMetaData);
        this.gameState.getRaceResults().setDivisionIndex(n);
        this.gameState.getRaceResults().setTrackIndex(n2);
    }
}

