/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.jme.math.Vector3f;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.statemachine.AbstractState;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.states.menus.special.BetweenRacesGUIState;
import com.turborilla.statemachine.StateMachine;

public class Results
extends AbstractState {
    GameState gameState;
    BetweenRacesGUIState guiState;
    private String previousState;

    public Results(GameState gameState, BetweenRacesGUIState betweenRacesGUIState) {
        this.setName("Results");
        this.gameState = gameState;
        this.guiState = betweenRacesGUIState;
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("ButtonPressed", this);
        stateMachine.registerForEvent("EscapePressed", this);
        stateMachine.registerForEvent("PassedFinishline", this);
        stateMachine.registerForEvent("Accomplished", this);
    }

    public void onEnter(String string) {
        this.previousState = string;
        if (!"IngameMenu".equals(string)) {
            if ("ReplayRace".equals(string) || "ReplayCountdown".equals(string)) {
                this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"RaceResults", "true"}});
                this.getStateMachine().getEventManager().fireEvent(new Event("ActivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            } else {
                this.updateResults(true);
                if (this.gameState != null) {
                    if (this.gameState.getAfterRaceText() == null || !this.gameState.isDisplayAfterRaceText()) {
                        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"RaceResults"}});
                        this.getStateMachine().getEventManager().fireEvent(new Event("ActivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
                    } else {
                        this.guiState.getMessagePanel().setText(this.gameState.getAfterRaceText());
                        this.guiState.getMessagePanel().setImage(this.gameState.getAfterRaceImage());
                        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"Message"}});
                        this.getStateMachine().getEventManager().fireEvent(new Event("ActivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
                        this.guiState.getMessagePanel().getOkButton().addListener(new IButtonClickedListener(){

                            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                                Results.this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"RaceResults"}});
                                Results.this.getStateMachine().getEventManager().fireEvent(new Event("ActivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
                            }
                        });
                    }
                }
            }
        }
    }

    public void onLeave() {
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("EscapePressed")) {
            this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"Empty"}});
            this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            this.getStateMachine().transitionToState("Menu");
        } else if (receivedEvent.is("PassedFinishline")) {
            if (!this.previousState.equals("ReplayRace") && !this.previousState.equals("ReplayCountdown")) {
                this.updateResults(false);
            }
        } else if (receivedEvent.is("ButtonPressed")) {
            if (receivedEvent.argumentIs("name", "continueButton")) {
                this.chooseTrack();
            } else if (receivedEvent.argumentIs("name", "retryButton")) {
                this.retry();
            } else if (receivedEvent.argumentIs("name", "replayButton")) {
                this.replay();
            } else if (receivedEvent.argumentIs("name", "backToMainMenuButton")) {
                this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"Empty"}});
                this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
                this.getStateMachine().transitionToState("Menu");
            }
        }
    }

    protected void retry() {
        this.getStateMachine().transitionToState("Countdown");
    }

    protected void chooseTrack() {
        this.getStateMachine().activateState("ChooseTrack");
    }

    protected void replay() {
        this.getStateMachine().activateState("ManageReplay");
    }

    private void updateResults(boolean bl) {
        if (this.gameState != null) {
            this.guiState.getRaceResultsPanel().updateResults(this.gameState.getRaceResults(), bl);
        } else {
            this.guiState.getRaceResultsPanel().updateResults(null, bl);
        }
    }
}

