/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.statemachine.AbstractState;
import com.turborilla.statemachine.StateMachine;

public class IngameMenu
extends AbstractState {
    private String previousState;
    private GameState gameState;

    public IngameMenu(GameState gameState) {
        this.setName("IngameMenu");
        this.gameState = gameState;
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("ButtonPressed", this);
        stateMachine.registerForEvent("EscapePressed", this);
    }

    public void onEnter(String string) {
        this.previousState = string;
        this.getStateMachine().getEventManager().fireEvent("PauseState", new String[][]{{"stateName"}, {"Game"}});
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"InGame", "true"}});
        this.getStateMachine().getEventManager().fireEvent("ActivateState", new String[][]{{"stateName"}, {"MenuState"}});
    }

    public void onLeave() {
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
        this.getStateMachine().getEventManager().fireEvent("DeactivateState", new String[][]{{"stateName"}, {"MenuState"}});
        this.getStateMachine().getEventManager().fireEvent("UnpauseState", new String[][]{{"stateName"}, {"Game"}});
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("EscapePressed")) {
            this.getStateMachine().getEventManager().fireEvent("EscapePressedInMenu");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "quitRaceButton")) {
            this.gameState.raceQuitted();
            if ("TimeAttackRace".equals(this.previousState) || "TimeAttackCountdown".equals(this.previousState)) {
                this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"TimeAttackInfo", "false"}});
                this.getStateMachine().transitionToState("TimeAttackResults");
            } else {
                this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
                this.getStateMachine().transitionToState("ChooseTrack");
            }
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "quitToMenuButton")) {
            this.gameState.raceQuitted();
            this.getStateMachine().transitionToState("Menu");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "restartButton")) {
            this.gameState.raceQuitted();
            this.restart();
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "resumeButton")) {
            if ("Countdown".equals(this.previousState) || "ReplayCountdown".equals(this.previousState) || "TimeAttackCountdown".equals(this.previousState)) {
                this.getStateMachine().transitionToState(this.previousState);
            } else {
                this.getStateMachine().activateState(this.previousState);
            }
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "quitButton")) {
            if ("Demo".equals(this.getStateMachine().getSettings().get("version", "Demo"))) {
                this.getStateMachine().transitionToState("QuitUpsell");
            } else {
                this.getStateMachine().getEventManager().fireEvent("Quit");
            }
        }
    }

    private void restart() {
        boolean bl;
        boolean bl2 = "Race".equals(this.previousState) || "Countdown".equals(this.previousState);
        boolean bl3 = "ReplayRace".equals(this.previousState) || "ReplayCountdown".equals(this.previousState);
        boolean bl4 = bl = "TimeAttackRace".equals(this.previousState) || "TimeAttackCountdown".equals(this.previousState);
        if (bl2) {
            this.getStateMachine().transitionToState("Countdown");
        }
        if (bl3) {
            this.getStateMachine().transitionToState("ReplayCountdown");
        }
        if (bl) {
            this.getStateMachine().transitionToState("TimeAttackCountdown");
        }
    }
}

