/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.statemachine.AbstractState;
import com.turborilla.msm.states.game.BikeResult;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.states.game.RaceResults;
import com.turborilla.sound.SFX;
import com.turborilla.statemachine.StateMachine;
import java.io.IOException;
import java.util.logging.Logger;

public class Finish
extends AbstractState {
    protected GameState gameState;
    private SFX raceWonSFX;

    public Finish(GameState gameState) {
        this.setName("Finish");
        this.gameState = gameState;
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("EscapePressed", this);
        try {
            this.raceWonSFX = (SFX)ResourceManager.getInstance().load("sfx", "racewon", null);
            this.raceWonSFX.setVolumeCategory("GameSFXVolume");
        }
        catch (IOException iOException) {
            Logger.getLogger(Finish.class.getCanonicalName()).severe("Could not load applause sfx due to " + iOException);
        }
    }

    public void onEnter(String string) {
        if (!"IngameMenu".equals(string)) {
            boolean bl;
            this.gameState.stopCollectingStats();
            this.gameState.stopMonitoringChallenges();
            this.gameState.stopAIRecording();
            boolean bl2 = this.gameState.constructRaceResults();
            if (this.gameState.getLapDisplayer() != null) {
                this.gameState.getLapDisplayer().setPaused(true);
            }
            boolean bl3 = false;
            RaceResults raceResults = this.gameState.getRaceResults();
            BikeResult bikeResult = null;
            if (raceResults != null) {
                bikeResult = raceResults.getInOrderOfFinish()[0];
            }
            if (raceResults != null && bikeResult != null && bikeResult.getProfile() != null && raceResults.isChallengesAchieved()) {
                bl3 = true;
                if (bl2 && !bikeResult.getProfile().getData().getProgressData().isFinishedGame()) {
                    if (!"Demo".equals(this.gameState.getSettings().get("version", "Demo"))) {
                        bikeResult.getProfile().getData().getProgressData().setFinishedGame(true);
                        bl = true;
                    } else {
                        int n = Integer.parseInt(this.gameState.getSettings().get("timesUntilUpsell", "0"));
                        if (n <= 0) {
                            bl = true;
                            n = 6;
                        } else {
                            bl = false;
                            --n;
                        }
                        this.gameState.getSettings().set("timesUntilUpsell", "" + n);
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl3) {
                this.raceWonSFX.play();
                this.getStateMachine().getTaskManager().add(new Runnable(){

                    public void run() {
                        Finish.this.gameState.startFireworks();
                    }
                }, 3.0f);
            }
            this.getStateMachine().getTaskManager().add(new Runnable(){

                public void run() {
                    Finish.this.showResults(bl);
                }
            }, bl ? 8.0f : (bl3 ? 5.0f : 2.0f));
        }
    }

    public void onLeave() {
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("EscapePressed")) {
            // empty if block
        }
    }

    protected void showResults(boolean bl) {
        this.gameState.stopReplayComponent();
        this.gameState.saveRaceResults();
        if (bl) {
            this.getStateMachine().transitionToState("GameOver");
        } else {
            this.getStateMachine().activateState("Results");
        }
    }
}

