/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.jme.input.InputHandler;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.Label;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.statemachine.FadingTransition;
import com.turborilla.msm.states.MsmGameStateException;
import com.turborilla.msm.states.RenderPass;
import com.turborilla.msm.states.RenderPassClearZ;
import com.turborilla.statemachine.Transition;
import com.turborilla.statemachine.TransitionGameState;
import com.turborilla.utils.Font;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import com.turborilla.utils.controllers.SpatialFadeController;
import java.io.IOException;
import java.util.concurrent.Callable;

public class FadingTransitionGameState
extends TransitionGameState {
    private RenderPass pass;
    private Node rootNode;
    private SpatialFadeController fader;
    private ColorRGBA fadeOutColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    private ColorRGBA fadeInColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private float fadeOutTime = 0.4f;
    private float fadeInTime = 1.8f;
    private Transition transition;
    private boolean fadingOut = true;
    private IControllerListener doneFadingListener;
    private Callable callWhenDone = null;
    private Quad screenQuad;
    private Label label;

    public FadingTransitionGameState(InputHandler inputHandler) {
        super("FadingGameState");
        this.transition = new FadingTransition(inputHandler);
        this.pass = new RenderPassClearZ("FadePass");
        this.passManager.add(this.pass);
        this.rootNode = new Node("FadePass:rootNode");
        this.rootNode.setRenderQueueMode(4);
        this.rootNode.setCullMode(3);
        this.pass.add(this.rootNode);
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.screenQuad = new Quad("screenQuad", displaySystem.getWidth(), displaySystem.getHeight());
        this.rootNode.attachChild(this.screenQuad);
        this.screenQuad.setLocalTranslation(displaySystem.getWidth() / 2, displaySystem.getHeight() / 2, 0.0f);
        try {
            Font font = (Font)ResourceManager.getInstance().load("font", "italic_small_white", null);
            this.label = new Label(font, 50);
            this.label.setText("Loading...");
            this.label.center();
            this.rootNode.attachChild(this.label);
            this.label.setLocalTranslation(displaySystem.getWidth() / 2, displaySystem.getHeight() / 2, 0.0f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fader = new SpatialFadeController(this.rootNode);
        this.fader.initRenderStates();
        this.fader.setColor(this.fadeInColor);
        this.doneFadingListener = new IControllerListener(){

            public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                FadingTransitionGameState.this.done();
            }
        };
    }

    public void before(Callable callable) {
        this.fadingOut = true;
        this.callWhenDone = callable;
        this.start();
    }

    public void after(Callable callable) {
        this.fadingOut = false;
        this.callWhenDone = callable;
        this.start();
    }

    protected void start() {
        if (!this.isActive()) {
            this.setActive(true);
        } else {
            try {
                this.onActivate();
            }
            catch (IOException iOException) {
                throw new MsmGameStateException(iOException);
            }
        }
    }

    protected void done() {
        if (!this.fadingOut) {
            this.setActive(false);
        }
        if (this.callWhenDone != null) {
            try {
                this.callWhenDone.call();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void onActivate() throws IOException {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.screenQuad.resize(displaySystem.getWidth(), displaySystem.getHeight());
        this.screenQuad.setLocalTranslation(displaySystem.getWidth() / 2, displaySystem.getHeight() / 2, 0.0f);
        this.label.setLocalTranslation(displaySystem.getWidth() / 2, displaySystem.getHeight() / 2, 0.0f);
        if (this.fadingOut) {
            this.label.setText("Loading...");
            this.fader.addFadeToQueue(this.fadeOutColor, this.fadeOutTime);
        } else {
            this.label.setText("");
            this.fader.addFadeToQueue(this.fadeInColor, this.fadeInTime);
        }
        this.fader.clearListeners();
        this.fader.add(this.doneFadingListener);
    }

    protected void onDeactivate() {
    }

    protected void stateRender(float f) {
    }

    protected void stateUpdate(float f) {
        this.fader.update(f);
    }

    ColorRGBA getFadeOutColor() {
        return this.fadeOutColor;
    }

    void setFadeOutColor(ColorRGBA colorRGBA) {
        this.fadeOutColor.set(colorRGBA);
    }

    ColorRGBA getFadeInColor() {
        return this.fadeInColor;
    }

    void setFadeInColor(ColorRGBA colorRGBA) {
        this.fadeInColor.set(colorRGBA);
    }

    float getFadeOutTime() {
        return this.fadeOutTime;
    }

    void setFadeOutTime(float f) {
        this.fadeOutTime = f;
    }

    float getFadeInTime() {
        return this.fadeInTime;
    }

    void setFadeInTime(float f) {
        this.fadeInTime = f;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public Node getRootNode() {
        return this.rootNode;
    }
}

