/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.RaceData;
import com.turborilla.msm.statemachine.AbstractState;
import com.turborilla.msm.statemachine.MsmStateMachineException;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.states.game.RaceResults;
import com.turborilla.msm.states.menus.special.BetweenRacesGUIState;
import com.turborilla.msm.states.menus.special.ChooseDivisionPanel;
import com.turborilla.msm.states.menus.special.ChooseTrackPanel;
import com.turborilla.statemachine.StateMachine;
import com.turborilla.statemachine.TransitionWork;
import com.turborilla.utils.Utils;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import java.io.IOException;
import java.util.ArrayList;

public class ChooseTrack
extends AbstractState {
    private GameState gameState;
    private BetweenRacesGUIState guiState;
    private GameSettings settings;
    private ArrayList<Integer> divisionsToAccomplish;
    private ArrayList<Integer> divisionsToUnlock;
    private ArrayList<Integer> tracksToAccomplish;
    private ArrayList<Integer> tracksToUnlock;
    private DivisionDescriptor divisionDescriptor;
    private int chosenArcadeDivisionIndex = 0;
    private int chosenSimulationDivisionIndex = 0;
    private Profile chosenDivisionTakenFrom = null;
    private ChooseTrackMode chooseTrackMode = ChooseTrackMode.Career;
    private TransitionWorkWithTrack fromChooseTrackToCountdown = new TransitionWorkWithTrack();
    private TransitionWorkWithTrack fromChooseTrackToTimeAttackCountdown = new TransitionWorkWithTrack(){

        public void before() {
        }

        public boolean during(float f) {
            ChooseTrack.this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
            ChooseTrack.this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            try {
                ChooseTrack.this.prepareTimeAttackRace(this.divisionIndex, this.trackIndex, this.getChosenReplayToAttack());
            }
            catch (IOException iOException) {
                throw new MsmStateMachineException(iOException);
            }
            return true;
        }

        public void after() {
        }
    };

    public ChooseTrack(GameState gameState, BetweenRacesGUIState betweenRacesGUIState, GameSettings gameSettings) {
        this.setName("ChooseTrack");
        this.gameState = gameState;
        this.guiState = betweenRacesGUIState;
        this.settings = gameSettings;
        this.divisionsToAccomplish = new ArrayList();
        this.divisionsToUnlock = new ArrayList();
        this.tracksToAccomplish = new ArrayList();
        this.tracksToUnlock = new ArrayList();
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("ButtonPressed", this);
        stateMachine.registerForEvent("EscapePressed", this);
        stateMachine.getEventManager().registerListener("Accomplished", this);
        stateMachine.getEventManager().registerListener("Unlocked", this);
        this.getStateMachine().addTransition(this.getName(), "Countdown", this.fromChooseTrackToCountdown);
        this.getStateMachine().addTransition(this.getName(), "TimeAttackCountdown", this.fromChooseTrackToTimeAttackCountdown);
        this.getStateMachine().addTransition("IngameMenu", "TimeAttackCountdown", this.fromChooseTrackToTimeAttackCountdown);
        this.chosenDivisionTakenFrom = Profile.getCurrentProfile(this.settings);
        this.chosenArcadeDivisionIndex = this.chosenDivisionTakenFrom.getData(Difficulty.Arcade).getProgressData().getCurrentDivision().getIndex();
        if (Boolean.parseBoolean(this.settings.get("simulationModeAvailable", "false"))) {
            this.chosenSimulationDivisionIndex = this.chosenDivisionTakenFrom.getData(Difficulty.Simulation).getProgressData().getCurrentDivision().getIndex();
        }
        this.setChooseTrackMode(this.chooseTrackMode);
        this.guiState.getChooseDivisionPanel().setChosenDivisionListener(new ChooseDivisionPanel.IChosenDivisionListener(){

            public void chosenDivision(int n) {
                ChooseTrack.this.setChosenDivisionIndex(n);
                Profile profile = Profile.getCurrentProfile(ChooseTrack.this.settings);
                ChooseTrack.this.guiState.getChooseTrackPanel().buildTrackButtons(n, ChooseTrack.this.getDivisionDescriptor(), profile, null, null, ChooseTrack.this.getChooseTrackMode());
            }
        });
    }

    public void onEnter(String string) {
        if ("TimeAttackMenu".equals(string) || "TimeAttackResults".equals(string)) {
            this.setChooseTrackMode(ChooseTrackMode.TimeAttack);
        } else {
            this.setChooseTrackMode(ChooseTrackMode.Career);
        }
        if ("TimeAttackResults".equals(string)) {
            this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"TimeAttackInfo"}});
            return;
        }
        RaceResults raceResults = this.gameState.getRaceResults();
        if (raceResults != null) {
            this.fromChooseTrackToCountdown.setTrack(raceResults.getDivisionIndex(), raceResults.getTrackIndex());
        }
        Profile profile = Profile.getCurrentProfile(this.settings);
        this.guiState.getChooseTrackPanel().buildTrackButtons(this.getChosenDivisionIndex(), this.getDivisionDescriptor(), profile, this.tracksToAccomplish, this.tracksToUnlock, this.getChooseTrackMode());
        this.guiState.getChooseDivisionPanel().buildDivisionButtons(this.getChosenDivisionIndex(), this.getDivisionDescriptor(), profile, this.divisionsToAccomplish, this.divisionsToUnlock);
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ChooseTrack"}});
        this.getStateMachine().getEventManager().fireEvent(new Event("ActivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
        final IControllerListener iControllerListener = new IControllerListener(){

            public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                ChooseTrack.this.guiState.getGui().setPaused(false);
            }
        };
        final IControllerListener iControllerListener2 = new IControllerListener(){

            public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                final MenuButton menuButton = ChooseTrack.this.guiState.getChooseDivisionPanel().getDivisionButton((Integer)ChooseTrack.this.divisionsToUnlock.get(ChooseTrack.this.divisionsToUnlock.size() - 1));
                if (menuButton != null) {
                    ChooseTrack.this.getStateMachine().getTaskManager().add(new Runnable(){

                        public void run() {
                            menuButton.onLeftMouseClicked(new Vector3f());
                        }
                    }, 0.5f);
                }
                iControllerListener.controllerTaskFinished(null);
            }
        };
        final IControllerListener iControllerListener3 = new IControllerListener(){

            public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                ChooseTrack.this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ChooseDivision"}});
                ChooseTrack.this.getStateMachine().getTaskManager().add(new Runnable(){

                    public void run() {
                        ChooseTrack.this.guiState.getChooseDivisionPanel().startEffects(iControllerListener2);
                    }
                }, 0.8f);
            }
        };
        if (this.divisionsToUnlock.size() > 0) {
            this.getStateMachine().getTaskManager().add(new Runnable(){

                public void run() {
                    ChooseTrack.this.guiState.getGui().setPaused(true);
                    ChooseTrack.this.guiState.getChooseTrackPanel().startEffects(iControllerListener3);
                }
            }, 0.8f);
        } else {
            this.getStateMachine().getTaskManager().add(new Runnable(){

                public void run() {
                    ChooseTrack.this.guiState.getGui().setPaused(true);
                    ChooseTrack.this.guiState.getChooseTrackPanel().startEffects(iControllerListener);
                }
            }, 0.8f);
        }
    }

    public void onLeave() {
        this.tracksToAccomplish.clear();
        this.tracksToUnlock.clear();
        this.divisionsToAccomplish.clear();
        this.divisionsToUnlock.clear();
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("EscapePressed")) {
            this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            this.getStateMachine().transitionToState("Menu");
        } else if (receivedEvent.is("Accomplished")) {
            if (receivedEvent.getArgumentValue("elementType").equals("division")) {
                this.divisionsToAccomplish.add(Integer.parseInt(receivedEvent.getArgumentValue("index")));
            } else if (receivedEvent.getArgumentValue("elementType").equals("track")) {
                this.tracksToAccomplish.add(Integer.parseInt(receivedEvent.getArgumentValue("index")));
            }
        } else if (receivedEvent.is("Unlocked")) {
            if (receivedEvent.getArgumentValue("elementType").equals("division")) {
                this.divisionsToUnlock.add(Integer.parseInt(receivedEvent.getArgumentValue("index")));
            } else if (receivedEvent.getArgumentValue("elementType").equals("track")) {
                this.tracksToUnlock.add(Integer.parseInt(receivedEvent.getArgumentValue("index")));
            }
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "backToMainMenuButton")) {
            this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            this.getStateMachine().transitionToState("Menu");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "attackButton")) {
            this.fromChooseTrackToTimeAttackCountdown.setChosenReplayToAttack(this.guiState.getTimeAttackInfoPanel().getChosenReplayRaceData());
            this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            this.getStateMachine().transitionToState("TimeAttackCountdown");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "backToChooseTrackButton")) {
            this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"ChooseTrack"}});
        }
    }

    private void prepareRace(int n, int n2) throws IOException {
        DivisionDescriptor divisionDescriptor = null;
        String string = null;
        divisionDescriptor = this.getDivisionDescriptor();
        string = divisionDescriptor.getTrack(n, n2);
        boolean bl = Boolean.parseBoolean(divisionDescriptor.getTrackProperty(n, n2, "challenge", "false"));
        if (!bl) {
            this.gameState.prepareNewRace(Utils.getProperties(new String[][]{{"environment", "track", "numberOfLaps", "numberOfBikes", "bike0", "bike1", "cameraFollowBikeNumber", "startsequence", "finishline", "controlMode", "specialAbility"}, {divisionDescriptor.getEnvironment(n, null), string, divisionDescriptor.getLaps(n, n2) + "", "2", "human", "computer", "0", "true", "true", Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty().getName(), divisionDescriptor.getTrackProperty(n, n2, "special", null)}}), divisionDescriptor, n, n2);
        } else {
            this.gameState.prepareNewRace(Utils.getProperties(new String[][]{{"environment", "track", "numberOfLaps", "numberOfBikes", "bike0", "cameraFollowBikeNumber", "startsequence", "finishline", "controlMode", "specialAbility"}, {divisionDescriptor.getEnvironment(n, null), string, divisionDescriptor.getLaps(n, n2) + "", "1", "human", "0", "true", "true", Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty().getName(), divisionDescriptor.getTrackProperty(n, n2, "special", null)}}), divisionDescriptor, n, n2);
        }
        this.gameState.getRaceResults().setDivisionIndex(n);
        this.gameState.getRaceResults().setTrackIndex(n2);
    }

    private void prepareTimeAttackRace(int n, int n2, RaceData raceData) throws IOException {
        DivisionDescriptor divisionDescriptor = null;
        String string = null;
        divisionDescriptor = this.getDivisionDescriptor();
        string = divisionDescriptor.getTrack(n, n2);
        this.gameState.prepareNewRace(Utils.getProperties(new String[][]{{"environment", "track", "numberOfLaps", "numberOfBikes", "bike0", "bike1", "cameraFollowBikeNumber", "startsequence", "finishline", "controlMode", "specialAbility", "timeAttack"}, {divisionDescriptor.getEnvironment(n, null), string, divisionDescriptor.getLaps(n, n2) + "", "2", "human", "replay", "0", "true", "true", Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty().getName(), divisionDescriptor.getTrackProperty(n, n2, "special", null), "true"}}), divisionDescriptor, n, n2, raceData != null ? raceData.loadReplay() : null);
        this.gameState.getRaceResults().setDivisionIndex(n);
        this.gameState.getRaceResults().setTrackIndex(n2);
    }

    private DivisionDescriptor getDivisionDescriptor() {
        try {
            this.divisionDescriptor = Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty() == Difficulty.Arcade ? (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "arcade_divisions", null) : (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "simulation_divisions", null);
        }
        catch (IOException iOException) {
            throw new MsmStateMachineException(iOException);
        }
        return this.divisionDescriptor;
    }

    public int getChosenDivisionIndex() {
        Profile profile = Profile.getCurrentProfile(this.settings);
        if (profile != this.chosenDivisionTakenFrom) {
            this.chosenDivisionTakenFrom = profile;
            this.chosenArcadeDivisionIndex = this.chosenDivisionTakenFrom.getData(Difficulty.Arcade).getProgressData().getCurrentDivision().getIndex();
            if (Boolean.parseBoolean(this.settings.get("simulationModeAvailable", "false"))) {
                this.chosenSimulationDivisionIndex = this.chosenDivisionTakenFrom.getData(Difficulty.Simulation).getProgressData().getCurrentDivision().getIndex();
            }
        }
        if (profile.getDifficulty() == Difficulty.Arcade) {
            return this.chosenArcadeDivisionIndex;
        }
        return this.chosenSimulationDivisionIndex;
    }

    public void setChosenDivisionIndex(int n) {
        Profile profile = Profile.getCurrentProfile(this.settings);
        if (profile.getDifficulty() == Difficulty.Arcade) {
            this.chosenArcadeDivisionIndex = n;
        } else {
            this.chosenSimulationDivisionIndex = n;
        }
    }

    public ChooseTrackMode getChooseTrackMode() {
        return this.chooseTrackMode;
    }

    public void setChooseTrackMode(ChooseTrackMode chooseTrackMode) {
        this.chooseTrackMode = chooseTrackMode;
        if (chooseTrackMode == ChooseTrackMode.Career) {
            this.guiState.getChooseTrackPanel().setChosenTrackListener(new ChooseTrackPanel.IChosenTrackListener(){

                public void chosenTrack(int n, int n2) {
                    boolean bl = false;
                    if ("Demo".equals(ChooseTrack.this.settings.get("version", "Demo"))) {
                        int n3 = 10;
                        if (n2 >= n3 || n > 0) {
                            bl = true;
                            ChooseTrack.this.settings.set("timesUntilUpsell2", "4");
                        } else {
                            int n4 = Integer.parseInt(ChooseTrack.this.gameState.getSettings().get("timesUntilUpsell2", "30"));
                            if (n4 <= 0) {
                                bl = true;
                                n4 = 4;
                            } else {
                                bl = false;
                                --n4;
                            }
                            ChooseTrack.this.settings.set("timesUntilUpsell2", "" + n4);
                        }
                    }
                    if (bl) {
                        ChooseTrack.this.getStateMachine().transitionToState("GameOver");
                    } else {
                        ChooseTrack.this.fromChooseTrackToCountdown.setTrack(n, n2);
                        ChooseTrack.this.getStateMachine().transitionToState("Countdown");
                    }
                }
            });
        } else if (chooseTrackMode == ChooseTrackMode.TimeAttack) {
            this.guiState.getChooseTrackPanel().setChosenTrackListener(new ChooseTrackPanel.IChosenTrackListener(){

                public void chosenTrack(int n, int n2) {
                    ChooseTrack.this.gotoTimeAttackInfo(n, n2);
                }
            });
        }
    }

    private void gotoTimeAttackInfo(int n, int n2) {
        this.fromChooseTrackToTimeAttackCountdown.setTrack(n, n2);
        this.guiState.getTimeAttackInfoPanel().setTrack(n, n2);
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"TimeAttackInfo", "false"}});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChooseTrackMode {
        Career,
        TimeAttack;

    }

    private class TransitionWorkWithTrack
    implements TransitionWork {
        protected int divisionIndex;
        protected int trackIndex;
        protected RaceData chosenReplayToAttack = null;

        private TransitionWorkWithTrack() {
        }

        public void setTrack(int n, int n2) {
            this.divisionIndex = n;
            this.trackIndex = n2;
        }

        public void before() {
        }

        public boolean during(float f) {
            ChooseTrack.this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
            ChooseTrack.this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            try {
                ChooseTrack.this.prepareRace(this.divisionIndex, this.trackIndex);
            }
            catch (IOException iOException) {
                throw new MsmStateMachineException(iOException);
            }
            return true;
        }

        public void after() {
        }

        public RaceData getChosenReplayToAttack() {
            return this.chosenReplayToAttack;
        }

        public void setChosenReplayToAttack(RaceData raceData) {
            this.chosenReplayToAttack = raceData;
        }
    }
}

