/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.skin;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.turborilla.TransformationCoupler;
import com.turborilla.TransformationProvider;
import com.turborilla.msm.components.ManySpatialsComponent;
import com.turborilla.physics.particle.ParticleSystem;
import com.turborilla.replay.nioreplay.NioReplay;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Skin {
    private ArrayList<SkinObject> skinObjects = new ArrayList();
    private String name;
    private String type;
    private ParticleSystem system;
    private NioReplay replay;
    private ManySpatialsComponent mspComp;

    public SkinObject newSkinObject(String string, Texture texture) {
        SkinObject skinObject = new SkinObject(string, texture);
        this.skinObjects.add(skinObject);
        return skinObject;
    }

    public void clear() {
        this.mspComp.removeAll();
        for (int i = 0; i < this.skinObjects.size(); ++i) {
            this.skinObjects.get(i).releaseTexture();
        }
        this.skinObjects.clear();
    }

    public void reApply() {
        if (this.replay == null && this.system == null || this.mspComp == null) {
            throw new RuntimeException("Cannot reapply skin as it hasn't been applied before");
        }
        if (this.replay != null) {
            this.apply(this.replay, this.mspComp);
        }
        if (this.system != null) {
            this.apply(this.system, this.mspComp);
        }
    }

    public String toString() {
        String string = "\nSkin: " + this.name;
        for (int i = 0; i < this.skinObjects.size(); ++i) {
            string = string + this.skinObjects.get(i).toString();
        }
        return string;
    }

    public void apply(ParticleSystem particleSystem, ManySpatialsComponent manySpatialsComponent) {
        this.system = particleSystem;
        this.mspComp = manySpatialsComponent;
        Node node = manySpatialsComponent.getNode();
        for (int i = 0; i < this.skinObjects.size(); ++i) {
            SkinObject skinObject = this.skinObjects.get(i);
            TransformationProvider transformationProvider = particleSystem.getTransformationProvider(skinObject.getName());
            if (transformationProvider == null) {
                Logger.getLogger(Skin.class.getName()).severe("Skin \"" + this.name + "\" incomplete. Could not find the TransformationProvider named \"" + skinObject.name + "\"");
                continue;
            }
            manySpatialsComponent.put(this.createQuad(skinObject), transformationProvider);
        }
        this.initRenderStates(node);
    }

    public void apply(NioReplay nioReplay, ManySpatialsComponent manySpatialsComponent) {
        this.replay = nioReplay;
        this.mspComp = manySpatialsComponent;
        Node node = manySpatialsComponent.getNode();
        for (int i = 0; i < this.skinObjects.size(); ++i) {
            SkinObject skinObject = this.skinObjects.get(i);
            String string = skinObject.getName();
            TransformationCoupler transformationCoupler = nioReplay.getTransformationCoupler(string);
            if (transformationCoupler == null) {
                Logger.getLogger(Skin.class.getName()).severe("Skin \"" + this.name + "\" incomplete. Could not find the TransformationProvider named \"" + skinObject.name + "\"");
                continue;
            }
            manySpatialsComponent.put(this.createQuad(skinObject), transformationCoupler);
        }
        this.initRenderStates(node);
    }

    private void initRenderStates(Node node) {
        node.setLightCombineMode(0);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        node.setRenderState(alphaState);
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        node.setRenderState(zBufferState);
        node.setModelBound(new BoundingBox());
        node.updateModelBound();
        node.updateWorldBound();
        node.updateRenderState();
    }

    private Quad createQuad(SkinObject skinObject) {
        Quad quad = new Quad(skinObject.name + ":SkinQuad", skinObject.width, skinObject.length);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleNormalAxis((float)(-Math.PI) / 180 * skinObject.degRotation, Vector3f.UNIT_Z);
        quad.setLocalRotation(quaternion);
        quad.setLocalTranslation(quaternion.mult(skinObject.translation));
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        skinObject.image.setWrap(5);
        textureState.setTexture(skinObject.image);
        quad.setRenderState(textureState);
        FloatBuffer floatBuffer = quad.getTextureBuffer(0, 0);
        floatBuffer.clear();
        floatBuffer.put(skinObject.seU).put(skinObject.seV);
        floatBuffer.put(skinObject.nwU).put(skinObject.nwV);
        floatBuffer.put(skinObject.neU).put(skinObject.neV);
        floatBuffer.put(skinObject.swU).put(skinObject.swV);
        floatBuffer.flip();
        quad.setModelBound(new BoundingBox());
        quad.updateModelBound();
        return quad;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public class SkinObject {
        private String name;
        private Texture image;
        private float width;
        private float length;
        private float degRotation;
        private float nwU;
        private float nwV;
        private float neU;
        private float neV;
        private float seU;
        private float seV;
        private float swU;
        private float swV;
        private Vector3f translation;

        SkinObject(String string, Texture texture) {
            this.name = string;
            this.image = texture;
            this.width = 1.0f;
            this.length = -1.0f;
            this.degRotation = 0.0f;
            this.nwU = 0.0f;
            this.nwV = 0.0f;
            this.neU = 1.0f;
            this.neV = 0.0f;
            this.seU = 0.0f;
            this.seV = 1.0f;
            this.swU = 1.0f;
            this.swV = 1.0f;
            this.translation = new Vector3f();
        }

        public String toString() {
            String string = "\nSkinObject: ";
            string = string + "\nname: " + this.name;
            string = string + "\nimage: " + this.image;
            string = string + "\nwidth: " + this.width;
            string = string + "\nlength: " + this.length;
            string = string + "\ndegRotation: " + this.degRotation;
            string = string + "\ntexcoords: ";
            string = string + " [" + this.nwU + "," + this.nwV + "] ";
            string = string + " [" + this.neU + "," + this.neV + "] ";
            string = string + " [" + this.seU + "," + this.seV + "] ";
            string = string + " [" + this.swU + "," + this.swV + "] ";
            string = string + "\ntranslation: " + this.translation;
            string = string + "\n";
            return string;
        }

        public float getDegRotation() {
            return this.degRotation;
        }

        public void setDegRotation(float f) {
            this.degRotation = f;
        }

        public Vector3f getTranslation() {
            return this.translation;
        }

        public void setTranslation(Vector3f vector3f) {
            this.translation = vector3f;
        }

        public float getWidth() {
            return this.width;
        }

        public void setWidth(float f) {
            this.width = f;
        }

        public Texture getImage() {
            return this.image;
        }

        public String getName() {
            return this.name;
        }

        public float getNeU() {
            return this.neU;
        }

        public void setNeU(float f) {
            this.neU = f;
        }

        public float getNeV() {
            return this.neV;
        }

        public void setNeV(float f) {
            this.neV = f;
        }

        public float getNwU() {
            return this.nwU;
        }

        public void setNwU(float f) {
            this.nwU = f;
        }

        public float getNwV() {
            return this.nwV;
        }

        public void setNwV(float f) {
            this.nwV = f;
        }

        public float getSeU() {
            return this.seU;
        }

        public void setSeU(float f) {
            this.seU = f;
        }

        public float getSeV() {
            return this.seV;
        }

        public void setSeV(float f) {
            this.seV = f;
        }

        public float getSwU() {
            return this.swU;
        }

        public void setSwU(float f) {
            this.swU = f;
        }

        public float getSwV() {
            return this.swV;
        }

        public void setSwV(float f) {
            this.swV = f;
        }

        public float getLength() {
            return this.length;
        }

        public void setLength(float f) {
            this.length = f;
        }

        public void releaseTexture() {
            TextureManager.releaseTexture(this.image);
        }
    }
}

